/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

class AdfConfigProperties
extends HashMap {
    private static final long serialVersionUID = 2386579836605707704L;
    static final String EL_NODE_NAME = "configuration";
    private static final String DEVICE_CONFIG_HANDLER_CLASSNAME = "oracle.adf.model.datacontrols.device.DeviceConfigPropertiesHandler";
    private static final String DEVICE_CONFIG_HANDLER_METHODNAME = "getDeviceConfigProperties";
    private static final AdfConfigProperties sInstance = new AdfConfigProperties();
    private static boolean sInitialized;

    static final AdfConfigProperties getInstance() {
        return sInstance;
    }

    public Object get(Object object) {
        if (!sInitialized) {
            this.putAll(AdfConfigProperties.readAdfConfigProperties());
            this.putAll(AdfConfigProperties.fetchDeviceConfigProperties());
            sInitialized = true;
        }
        return super.get(object);
    }

    private static final Map fetchDeviceConfigProperties() {
        try {
            JSONObject jSONObject = (JSONObject)AdfmfContainerUtilities.invokeContainerMethod(DEVICE_CONFIG_HANDLER_CLASSNAME, DEVICE_CONFIG_HANDLER_METHODNAME, new Object[0]);
            Map map = (Map)JSONBeanSerializationHelper.fromJSON(HashMap.class, jSONObject);
            return map;
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfConfigProperties.class, "populateMapWithDynamicPropertiesFromContainer", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11142", new Object[]{exception});
            }
            return new HashMap();
        }
    }

    private AdfConfigProperties() {
    }

    private static final Map readAdfConfigProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        XmlAnyDefinition xmlAnyDefinition = null;
        try {
            xmlAnyDefinition = Utility.getAdfConfigXml();
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfConfigProperties.class, "readAdfConfigProperties", (Object)"adf-config.xml could not be loaded, due to:");
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfConfigProperties.class, "readAdfConfigProperties", (Throwable)exception);
            }
            return hashMap;
        }
        if (xmlAnyDefinition == null) {
            return hashMap;
        }
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("adf:adf-properties-child");
        if (xmlAnyDefinition2 == null && (xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("adf-properties-child")) == null) {
            return hashMap;
        }
        List list = xmlAnyDefinition2.getChildren();
        if (list == null) {
            return hashMap;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            if (!"adf-property".equals(xmlAnyDefinition.getElementName())) continue;
            String string = (String)xmlAnyDefinition.getAttributeValue("name");
            String string2 = (String)xmlAnyDefinition.getAttributeValue("value");
            if (Utility.isEmpty(string)) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }
}

