/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws.rest;

import com.sun.util.logging.Level;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import oracle.adfmf.dc.ws.WebServiceTransportLayer;
import oracle.adfmf.dc.ws.rest.RestServiceAdapter;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationRuntimeException;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.CredentialStoreUtil;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;
import oracle.wsm.agent.httpconn.HTTPConnectionAgent;
import oracle.wsm.resource.subject.AbstractPolicyFeature;
import oracle.wsm.resource.subject.PolicyReferenceFeature;
import oracle.wsm.resource.subject.PolicySubjectDefinition;
import oracle.wsm.resource.subject.PropertyFeature;
import org.kobjects.base64.Base64;

public class RestTransportLayer
extends WebServiceTransportLayer {
    private static final String APPLICATION_XML_STR = "application/xml";
    private static final String APPLICATION_XML_MIME_TYPE = "application/xml; charset=UTF-8";
    private static final String ACCEPT_STR = "Accept";
    private static final String CONTENT_TYPE_STR = "Content-Type";
    private static final String COOKIE_HEADER_NAME = "Cookie";
    private static final String AUTH_HEADER_NAME = "Authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private static final String SET_COOKIE = "Set-Cookie";
    private HashMap m_responseHeaders = new HashMap();

    public RestTransportLayer(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    private void setCustomHeaders(HttpConnection httpConnection, Object object) throws IOException {
        Object object2;
        Object object3 = null;
        boolean bl = false;
        String string = this.getCredStoreKey();
        boolean bl2 = Utility.FrameworkLogger.isLoggable(Level.FINE);
        if (bl2) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "setCustomHeaders", (Object)("credStoreKey=[" + string + "]"));
        }
        if (CredentialStoreUtil.isCookieInjectionRequested(string) && CredentialStoreUtil.isDomainMatchesLoginDomain(string, httpConnection.getURL())) {
            object2 = CredentialStoreUtil.getCookieForCredentialStoreKey(string);
            if (bl2) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "setCustomHeaders", (Object)("CookieForCredentialStoreKey=[" + (String)object2 + "]"));
            }
            if (Utility.isNotEmpty((String)object2)) {
                bl = true;
                object3 = object2;
            }
            if (bl2) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "setCustomHeaders", (Object)("cookie injected is false (value returned from CredentialStoreUtil = " + (String)object2 + ")"));
            }
        }
        if (object == null && !bl) {
            if (bl2) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "setCustomHeaders", (Object)"no header values passed");
            }
            return;
        }
        if (object != null) {
            if (!(object instanceof Map)) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11054", new Object[]{Map.class.getName(), object.getClass().getName()});
            }
            object2 = (Map)object;
            Iterator iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = RestTransportLayer.headerKeyAsStringToString(entry.getKey());
                String string3 = RestTransportLayer.headerValueToString(entry.getValue());
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$dc$ws$rest$RestTransportLayer == null ? RestTransportLayer.class$("oracle.adfmf.dc.ws.rest.RestTransportLayer") : class$oracle$adfmf$dc$ws$rest$RestTransportLayer, "setCustomHeaders", (Object)("setting (" + string2 + "=" + string3 + ")"));
                }
                try {
                    httpConnection.setRequestProperty(string2, string3);
                }
                catch (Throwable throwable) {
                    if (!bl2) continue;
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$dc$ws$rest$RestTransportLayer == null ? RestTransportLayer.class$("oracle.adfmf.dc.ws.rest.RestTransportLayer") : class$oracle$adfmf$dc$ws$rest$RestTransportLayer, "setCustomHeaders", (Object)("Error when setting (" + string2 + "=" + string3 + ") = " + throwable));
                }
            }
        }
        if (bl) {
            if (bl2) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "setCustomHeaders", (Object)("Injecting the actual cookie [Cookie=" + (String)object3));
            }
            httpConnection.setRequestProperty(COOKIE_HEADER_NAME, object3);
        }
    }

    private static String headerValueAsListToString(Object object) {
        List list = (List)object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(RestTransportLayer.headerValueAsStringToString(e));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static String headerKeyAsStringToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11054", new Object[]{String.class.getName(), object.getClass().getName()});
    }

    private static String headerValueAsStringToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11054", new Object[]{"java.lang.String or java.util.List", object.getClass().getName()});
    }

    private static String headerValueToString(Object object) {
        if (object instanceof List) {
            return RestTransportLayer.headerValueAsListToString(object);
        }
        return RestTransportLayer.headerValueAsStringToString(object);
    }

    private static void setHeaderIfUnset(HttpConnection httpConnection, String string, String string2) throws Exception {
        if (httpConnection.getRequestProperty(string) == null) {
            httpConnection.setRequestProperty(string, string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readResponse(HttpConnection httpConnection, int n) throws Exception {
        byte[] byArray = null;
        InputStream inputStream = null;
        int n2 = 0;
        int n3 = 0;
        try {
            try {
                inputStream = httpConnection.openInputStream();
                n2 = (int)httpConnection.getLength();
                byArray = n2 > 0 ? new byte[n2] : new byte[1024];
                int n4 = 0;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n4 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n4);
                    n3 += n4;
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, RestTransportLayer.class, "readResponse", (Object)("ERROR: REST Transport - read - " + exception));
                throw exception;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Utility.closeSilently(inputStream);
            if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) throw throwable;
            String string = Utility.bytesToString(byArray);
            Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "readResponse", "Response:\n Code: {0};\n Message: {1};\n Number of bytes read: {2};\n Total bytes available: {3};\n", new Object[]{new Integer(n), string, new Integer(n3), new Integer(n2)});
            throw throwable;
        }
        Utility.closeSilently(inputStream);
        if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) return byArray;
        String string = Utility.bytesToString(byArray);
        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "readResponse", "Response:\n Code: {0};\n Message: {1};\n Number of bytes read: {2};\n Total bytes available: {3};\n", new Object[]{new Integer(n), string, new Integer(n3), new Integer(n2)});
        return byArray;
    }

    private HTTPConnectionAgent.HTTPEnforcementContext getHTTPEnforcementContext(String string, Properties properties) throws MalformedURLException {
        PolicyReferenceFeature[] policyReferenceFeatureArray = new PolicyReferenceFeature[]{string.startsWith("https:") ? new PolicyReferenceFeature("oracle/wss_http_token_over_ssl_client_policy") : new PolicyReferenceFeature("oracle/wss_http_token_client_policy")};
        PolicySubjectDefinition policySubjectDefinition = new PolicySubjectDefinition(HTTPConnectionAgent.createResourceIdentifier((String)"GenericPlatform", (String)"ADF", (String)string), (AbstractPolicyFeature[])policyReferenceFeatureArray);
        PropertyFeature[] propertyFeatureArray = new PropertyFeature[]{};
        HTTPConnectionAgent hTTPConnectionAgent = new HTTPConnectionAgent(policySubjectDefinition, properties);
        return hTTPConnectionAgent.createEnforcementContext(null == string ? null : new URL(string), propertyFeatureArray);
    }

    protected HttpConnection getConnection(HttpConnection httpConnection, String string, String string2) throws Exception {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, RestTransportLayer.class, "getConnection", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40010", new Object[]{this.operation, string});
        }
        if (httpConnection == null) {
            try {
                httpConnection = (HttpConnection)Connector.open((String)string2);
            }
            catch (Exception exception) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, RestTransportLayer.class, "getConnection", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11018", new Object[]{this.operation, exception});
                throw exception;
            }
        }
        return httpConnection;
    }

    protected HttpConnection getConnection(HttpConnection httpConnection, String string, String string2, Object object) throws Exception {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, RestTransportLayer.class, "getConnection", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40010", new Object[]{this.operation, string});
        }
        return httpConnection == null ? this.getConnection(httpConnection, string, string2) : httpConnection;
    }

    private void sendPayload(HttpConnection httpConnection, String string) throws Exception {
        OutputStream outputStream = null;
        boolean bl = Utility.FrameworkLogger.isLoggable(Level.FINE);
        try {
            block9: {
                try {
                    if (bl) {
                        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendPayload", (Object)("About to write the payload (" + (string != null ? string.length() : 0) + " bytes) to " + httpConnection.getURL().toString()));
                    }
                    if (!(this instanceof RestServiceAdapter)) {
                        RestTransportLayer.setHeaderIfUnset(httpConnection, CONTENT_TYPE_STR, APPLICATION_XML_MIME_TYPE);
                        Trace.log(Utility.FrameworkLogger, Level.FINER, RestTransportLayer.class, "sendPayload", (Object)"headers are set.");
                    }
                    if ((outputStream = httpConnection.openOutputStream()) != null) {
                        outputStream.write(Utility.stringToBytes(string));
                        outputStream.flush();
                        break block9;
                    }
                    if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) break block9;
                    Trace.log(Utility.FrameworkLogger, Level.SEVERE, RestTransportLayer.class, "sendPayload", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11019", new Object[]{this.operation});
                }
                catch (Exception exception) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, RestTransportLayer.class, "sendPayload", (Object)("ERROR: writting payload to " + httpConnection.getURL().toString()));
                    }
                    if (bl) {
                        Trace.log(Utility.FrameworkLogger, Level.FINE, this.getClass(), "sendReceive", (Object)("ERROR: REST Transport - write - " + exception));
                    }
                    throw exception;
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Utility.closeSilently(outputStream);
            throw throwable;
        }
        Utility.closeSilently(outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] sendReceive(String string, String string2, String string3, Object object, int n, HttpConnection httpConnection) throws Exception {
        byte[] byArray = null;
        HttpConnection httpConnection2 = null;
        String string4 = "http-transport:REST" + string2;
        MonitorFactory monitorFactory = MonitorFactory.getInstance();
        Monitor monitor = monitorFactory.getMonitor(string4 + "-wire", "invoke " + string4);
        int n2 = 503;
        boolean bl = httpConnection != null;
        boolean bl2 = Utility.FrameworkLogger.isLoggable(Level.FINE);
        this.clearResponseHeaders();
        try {
            try {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                monitor.start();
                                httpConnection2 = this.getConnection(httpConnection, string, string2, object);
                                if (bl2) {
                                    Trace.log(Utility.FrameworkLogger, Level.FINER, RestTransportLayer.class, "sendReceive", (Object)"Got a connection.");
                                }
                                if (httpConnection2 == null) {
                                    throw new AdfException(new IllegalStateException("connection"));
                                }
                                if (bl2) {
                                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Established the connection to " + httpConnection2.getURL()));
                                }
                                try {
                                    this.setCustomHeaders(httpConnection2, object);
                                    if (bl2) {
                                        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Setting custom headers complete");
                                    }
                                }
                                catch (IOException iOException) {
                                    if (!bl2) break block39;
                                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Setting custom header had an exception " + iOException));
                                }
                            }
                            try {
                                this.injectBasicAuthHeader(httpConnection2, string);
                                if (bl2) {
                                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Setting basic auth headers complete");
                                }
                            }
                            catch (IOException iOException) {
                                if (!bl2) break block40;
                                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Setting basic auth header had an exception " + iOException));
                            }
                        }
                        if (!bl) {
                            try {
                                httpConnection2.setRequestMethod(string);
                                if (bl2) {
                                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Setting request method complete");
                                }
                            }
                            catch (IOException iOException) {
                                if (!bl2) break block41;
                                Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Setting request method had an exception " + iOException));
                            }
                        }
                    }
                    try {
                        if (!(this instanceof RestServiceAdapter)) {
                            RestTransportLayer.setHeaderIfUnset(httpConnection2, ACCEPT_STR, APPLICATION_XML_STR);
                        }
                    }
                    catch (IOException iOException) {
                        if (!bl2) break block42;
                        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Setting the default header had an exception " + iOException));
                    }
                }
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Checking to see if we need to send any data to the server.");
                }
                if (Utility.isNotEmpty(string3)) {
                    if (bl2) {
                        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"About to send payload.");
                    }
                    this.sendPayload(httpConnection2, string3);
                    if (bl2) {
                        Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Sent payload.");
                    }
                }
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)"Process request response");
                }
                n2 = httpConnection2.getResponseCode();
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Response code is " + n2));
                }
                this.setStatus(n2);
                this.setResponseHeaders(httpConnection2);
                this.setResponseContentType(httpConnection2.getHeaderField(CONTENT_TYPE_STR));
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Request= [" + httpConnection2.getURL() + "] returned a status of " + n2));
                }
                byArray = this.readResponse(httpConnection2, n2);
                if (bl2) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("Read " + (byArray != null ? byArray.length : 0) + " bytes from " + httpConnection2.getURL()));
                }
                if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                    Trace.log(Utility.FrameworkLogger, Level.INFO, RestTransportLayer.class, "sendReceive", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40011", new Object[]{new Integer(n2)});
                }
                if (n2 == 200) {
                    String string5 = httpConnection2.getHeaderField(SET_COOKIE);
                    if (string5 != null) {
                        CredentialStoreUtil.updateCookiesForCredentialStoreKey(this.getCredStoreKey(), string5);
                    }
                } else if (n2 != 201 && n2 != 203 && n2 != 204 && n2 != 205) {
                    throw new AdfInvocationRuntimeException(RestTransportLayer.getCustomHttpStatusMessage(n2), "ERROR", "WEBSERVICE", n2);
                }
                Object var21_22 = null;
                monitor.addObservation();
                this.closeSilently(httpConnection2);
            }
            catch (SocketException socketException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    printWriter.println("SOCKET EXCEPTION for " + httpConnection2.getURL());
                    printWriter.println("  We encountered a socket exception, i.e. the underlying socket was closed");
                    printWriter.println("  by either the web service, VPN client, or anything in between.  Given that we");
                    printWriter.println("  should try one more time to see if this was because we are trying to reuse");
                    printWriter.println("  the existing connection incorrectly.  This could also be a byproduct of the");
                    printWriter.println("  application not configured correctly, i.e. incorrect values in connections.xml");
                    try {
                        printWriter.println(" Request Status: " + httpConnection2.getResponseCode());
                        printWriter.println(" Stack Trace:");
                        socketException.printStackTrace(printWriter);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, RestTransportLayer.class, "sendReceive", (Object)stringWriter.toString());
                    Utility.closeSilently(printWriter);
                    Utility.closeSilently(stringWriter);
                }
                this.closeSilently(httpConnection2);
                if (n < 3) {
                    byte[] byArray2 = this.sendReceive(string, string2, string3, object, ++n, this.getConnection(null, string, string2));
                    Object var21_23 = null;
                    monitor.addObservation();
                    this.closeSilently(httpConnection2);
                    return byArray2;
                }
                throw new AdfException(socketException);
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println("ERROR: REST Transport - " + exception);
                exception.printStackTrace(printWriter);
                printWriter.println("-------------------------");
                Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "sendReceive", (Object)stringWriter.toString());
                Utility.closeSilently(printWriter);
                Utility.closeSilently(stringWriter);
                throw new AdfException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            monitor.addObservation();
            this.closeSilently(httpConnection2);
            throw throwable;
        }
        if (bl2) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, RestTransportLayer.class, "sendReceive", (Object)("REST Transport complete for : " + string4 + "  with " + (byArray != null ? byArray.length : 0) + " bytes."));
        }
        return byArray;
    }

    private void injectBasicAuthHeader(HttpConnection httpConnection, String string) throws IOException {
        String string2 = null;
        if (this.isSecureConnection() && (string2 = this.getCredStoreKey()) != null) {
            String string3 = CredentialStoreUtil.getUsernameForAuthUrl(string2);
            String string4 = CredentialStoreUtil.getPasswordForAuthUrl(string2);
            if (Utility.isNotEmpty(string3) && Utility.isNotEmpty(string4)) {
                String string5 = BASIC_AUTH_PREFIX + Base64.encode((byte[])(string3 + ":" + string4).getBytes()).toString();
                httpConnection.setRequestProperty(AUTH_HEADER_NAME, string5);
            } else {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, RestTransportLayer.class, "injectBasicAuthHeader", "ADF-MF-11085", string);
            }
            string4 = "unknown";
            string3 = "unknown";
        }
    }

    protected void clearResponseHeaders() {
        this.m_responseHeaders.clear();
    }

    protected void setResponseHeaders(HttpConnection httpConnection) throws IOException {
        String string;
        this.clearResponseHeaders();
        int n = 0;
        while ((string = httpConnection.getHeaderFieldKey(n)) != null) {
            String string2 = httpConnection.getHeaderField(n);
            this.m_responseHeaders.put(string, string2);
            ++n;
        }
    }

    public String getResponseHeader(String string) {
        return (String)this.m_responseHeaders.get(string);
    }

    public HashMap getResponseHeaders() {
        return this.m_responseHeaders;
    }

    private HttpConnection closeSilently(HttpConnection httpConnection) {
        if (httpConnection != null) {
            try {
                httpConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

