/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import javax.el.ELContext;
import javax.el.ValueExpression;
import oracle.adfmf.dc.rules.ValidatorConstants;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.exception.ValidationException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

public abstract class Validator {
    protected boolean mbInverse = false;
    protected String mDescription;
    protected String mMsgId;
    protected String mValidatingAttrName;
    protected String mOnCondition;
    private int mSeverity = 0;

    public void setInverse(boolean bl) {
        this.mbInverse = bl;
    }

    public boolean getInverse() {
        return this.mbInverse;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    protected void setDefaultDescription(String string) {
    }

    public void setValidatingAttributeName(String string) {
        this.mValidatingAttrName = string;
    }

    public String getValidatingAttributeName() {
        return this.mValidatingAttrName;
    }

    public void initValidatorProperties(XmlAnyDefinition xmlAnyDefinition) {
        Object object;
        String string = (String)xmlAnyDefinition.getAttributeValue("OnAttribute");
        if (string != null) {
            this.setValidatingAttributeName(string);
        }
        if ((object = xmlAnyDefinition.getAttributeValue("Inverse")) != null) {
            boolean bl = xmlAnyDefinition.getAttributeBooleanValue("Inverse");
            this.setInverse(bl);
        }
        if ((string = (String)xmlAnyDefinition.getAttributeValue("ResId")) != null) {
            this.setErrorMsgId(string);
        }
        if ((string = (String)xmlAnyDefinition.getAttributeValue("OnCondition")) != null) {
            this.mOnCondition = string;
        }
        if ((string = (String)xmlAnyDefinition.getAttributeValue("Severity")) != null) {
            this.setSeverity(Validator.parseSeverityStr(string));
        }
    }

    public boolean hasCustomErrorMsgId() {
        return this.mMsgId != null;
    }

    public String getErrorMsgId() {
        return this.mMsgId;
    }

    public void setErrorMsgId(String string) {
        this.mMsgId = string;
    }

    private String createMessage(Object object) {
        String string = this.getErrorMsgId();
        if (string != null) {
            AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
            ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, String.class);
            string = (String)valueExpression.getValue((ELContext)adfELContext);
        } else {
            string = Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11031", new Object[]{this.getValidatingAttributeName(), object});
        }
        return string;
    }

    public void setSeverity(int n) {
        this.mSeverity = n;
    }

    public int getSeverity() {
        return this.mSeverity < 0 || this.mSeverity > 2 ? 0 : this.mSeverity;
    }

    public static int parseSeverityStr(String string) {
        if (string != null) {
            for (int i = 0; i < ValidatorConstants.mSeverityVals.length; ++i) {
                if (!ValidatorConstants.mSeverityVals[i].equals(string)) continue;
                return i;
            }
        }
        return 0;
    }

    public ValidationException createException(Object object) {
        String string = this.createMessage(object);
        ValidationException validationException = new ValidationException(string, this.getSeverity());
        return validationException;
    }

    protected final ValueExpression getValueExpression(String string, Class clazz) {
        if (string == null) {
            return this.getValueExpression("#{null}", Object.class);
        }
        AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
        ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, clazz);
        return valueExpression;
    }

    public abstract boolean validateValue(Object var1);
}

