/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc;

import com.sun.util.logging.Level;
import oracle.adfmf.dc.GenericJavaBeanDataControlManager;
import oracle.adfmf.dc.rules.ValidationManager;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public abstract class JavaBeanObject
implements GenericType {
    protected String id = null;
    protected JavaBeanDefinition jbd = null;
    protected MetaDataFrameworkManager mdfm = MetaDataFrameworkManager.getInstance();
    protected String type = JavaBeanObject.class.getName();

    public void setAttribute(String string, Object object) {
        String string2 = this.getType();
        ValidationManager.validate(string2, string, object);
    }

    public JavaBeanObject() {
        this.log(Level.INFO, "JavaBeanObject", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40028", new Object[]{this.getClass().getName()});
    }

    public abstract boolean isAttributeCollection(String var1);

    public boolean isDeferred() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public void setAttributeModified(String string) {
    }

    public void restoreDefaults() {
    }

    public Object getAttribute(int n, String string) {
        return this.getAttribute(n);
    }

    public String getId() {
        return this.id;
    }

    public JavaBeanDefinition getDefinition() {
        return this.jbd;
    }

    public String getType() {
        return this.type;
    }

    public Object getDataProvider() {
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getNamespace() + "." + this.getName() + "]";
    }

    public void dispose() {
    }

    protected void registerJavaBean(JavaBeanDefinition javaBeanDefinition) {
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "registerJavaBean", "Registering the Java Bean {0}", new Object[]{javaBeanDefinition.getBeanClass()});
        }
        this.jbd = javaBeanDefinition;
        GenericJavaBeanDataControlManager.addJavaBeanObject(javaBeanDefinition.getBeanClass(), this);
        this.registerAttributes();
        this.registerAccessorAttribute();
        this.registerMethodAccessors();
        this.registerAnyOperations();
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "registerJavaBean", "Registering the Java Bean now complete.");
        }
    }

    protected abstract void registerAttributes();

    protected abstract void registerAccessorAttribute();

    protected abstract void registerMethodAccessors();

    protected abstract void registerAnyOperations();

    protected void log(Level level, String string, String string2) {
        this.log(level, string, string2, null);
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, objectArray);
    }

    protected void log(Level level, String string, String string2, String string3, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, string3, objectArray);
    }
}

