/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.cache;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.adfmf.cache.CacheProvider;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class SimpleCache {
    private static final int DEBUG_CACHE = Level.OFF.intValue();
    public static final String UNTYPED = "untyped";
    public static final String MAX_COUNT = "cache.count.max";
    public static final String MAX_IDLE = "cache.time.idle";
    protected Map data = new HashMap();
    protected Map access;
    protected Properties config;
    protected CacheProvider provider;
    protected Object cddr;

    public SimpleCache(CacheProvider cacheProvider, Object object) {
        this.provider = cacheProvider;
        this.cddr = object;
        this.config = new Properties();
        this.config.put(MAX_COUNT, new Integer(100));
        this.config.put(MAX_IDLE, new Integer(-1));
    }

    public Object getConfiguration(String string) {
        return this.config.get(string);
    }

    public void setConfiguration(String string, String string2) {
        if (MAX_COUNT.equalsIgnoreCase(string)) {
            this.config.put(string, string2);
        }
        if (MAX_IDLE.equalsIgnoreCase(string)) {
            this.config.put(string, string2);
        }
    }

    public Object get(Object object, String string) {
        Object object2;
        SimpleCacheObject simpleCacheObject = (SimpleCacheObject)this.data.get(object);
        Object object3 = object2 = simpleCacheObject != null ? simpleCacheObject.getData() : null;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "Element " + object + " was " + (object2 == null ? "NOT " : "") + "in the cache.");
        }
        if (simpleCacheObject == null && this.provider != null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "Looks like we need to fetch " + object);
            }
            try {
                object2 = this.provider.fetch(object, this.cddr);
                this.put(object, string, object2);
            }
            catch (AdfException adfException) {
                throw adfException;
            }
            catch (Exception exception) {
                throw new AdfException(exception, "ERROR");
            }
        }
        return object2;
    }

    public void put(Object object, String string, Object object2) {
        if (object != null && object2 != null) {
            this.data.put(object, new SimpleCacheObject(string, object2));
        }
    }

    public Set keySet(String string) {
        Set set = this.data.entrySet();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            SimpleCacheObject simpleCacheObject = (SimpleCacheObject)entry.getValue();
            if (simpleCacheObject == null || !simpleCacheObject.getType().equalsIgnoreCase(string)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public void reset(String string) {
        Set set = this.keySet(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.data.remove((String)iterator.next());
        }
    }

    public void dumpCache(String string, String string2) {
        Set set = this.keySet(string2);
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "\n\n*** Dumping the " + string + " cache {\n");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            SimpleCacheObject simpleCacheObject = (SimpleCacheObject)this.data.get(string3);
            if (!Utility.FrameworkLogger.isLoggable(Level.FINER)) continue;
            this.log(Level.FINER, "\n==> " + string3 + " : " + simpleCacheObject.getData());
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "\n}");
        }
    }

    public int size(String string) {
        return this.keySet(string).size();
    }

    protected void log(Level level, String string) {
        this.log(level, string, null);
    }

    protected void log(Level level, String string, Object[] objectArray) {
        if (level.intValue() >= DEBUG_CACHE) {
            Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, (Object)objectArray);
        }
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        if (level.intValue() >= DEBUG_CACHE) {
            Trace.log(Utility.FrameworkLogger, level, this.getClass(), "log", string, string2, objectArray);
        }
    }

    class SimpleCacheObject {
        protected String type = null;
        protected Object data = null;
        protected Long timestamp = null;

        public SimpleCacheObject(String string, Object object) {
            this.type = string;
            this.data = object;
            this.timestamp = new Long(System.currentTimeMillis());
        }

        public String getType() {
            return this.type;
        }

        public Object getData() {
            this.timestamp = new Long(System.currentTimeMillis());
            return this.data;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setData(Object object) {
            this.data = object;
            this.timestamp = new Long(System.currentTimeMillis());
        }
    }
}

