/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ValueExpression;
import oracle.adfmf.bindings.Hints;
import oracle.adfmf.bindings.dbf.AmxIteratorBinding;
import oracle.adfmf.bindings.dbf.AmxTreeBinding;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.metadata.PersdefDefinition;
import oracle.adfmf.metadata.SchemaBasedPropertiesUtils;
import oracle.adfmf.metadata.page.HintsProvider;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.util.XmlAnyDefinition;

public class AmxTreeAttributeBinding
implements JSONSerializable,
HintsProvider {
    public static final String LABEL_KEY = "label";
    public static final String UPDATEABLE_KEY = "updateable";
    public static final String FORMAT_KEY = "format";
    public static final String INPUT_VALUE_KEY = "inputValue";
    protected String m_label = "DEFAULT_LABEL";
    protected String m_format = "DEFAULT_FORMAT";
    protected Object m_inputValue = "DEFAULT_INPUT_VALUE";
    protected String m_attributeName;
    protected boolean m_updateable;
    protected AmxTreeBinding m_parentTreeBinding;
    protected String m_DefName;
    protected Map hintsMap;

    public AmxTreeAttributeBinding(String string, AmxTreeBinding amxTreeBinding, String string2) {
        this.m_attributeName = string;
        this.m_parentTreeBinding = amxTreeBinding;
        this.m_DefName = string2;
    }

    public void setParentTreeBinding(AmxTreeBinding amxTreeBinding) {
        this.m_parentTreeBinding = amxTreeBinding;
    }

    public AmxTreeBinding getParentTreeBinding() {
        return this.m_parentTreeBinding;
    }

    public String getLabel() {
        return (String)this.getHintValue(LABEL_KEY);
    }

    public String getAutoSubmit() {
        return (String)this.getHintValue("autoSubmit");
    }

    public String getCategory() {
        return (String)this.getHintValue("category");
    }

    public String getControlType() {
        return (String)this.getHintValue("controlType");
    }

    public String getDisplayHeight() {
        return (String)this.getHintValue("displayHeight");
    }

    public String getDisplayWidth() {
        return (String)this.getHintValue("displayWidth");
    }

    public String getFieldorder() {
        return (String)this.getHintValue("fieldorder");
    }

    public String getFormat() {
        return (String)this.getHintValue(FORMAT_KEY);
    }

    public String getFormatter() {
        return (String)this.getHintValue("formatter");
    }

    public String getMandatory() {
        return (String)this.getHintValue("mandatory");
    }

    public String getPrecision() {
        return (String)this.getHintValue("precision");
    }

    public String getTooltip() {
        return (String)this.getHintValue("tooltip");
    }

    public boolean getUpdateable() {
        Object object = this.getHintValue(UPDATEABLE_KEY);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.getBoolean((String)object);
        }
        return true;
    }

    private Object getHintValue(Object object) {
        Map map = this.getHintsMap();
        Object object2 = map.get(object);
        if (object2 instanceof SchemaBasedPropertiesUtils.ResIdProperty) {
            object2 = ((SchemaBasedPropertiesUtils.ResIdProperty)object2).value;
            if (object2 != null) {
                String string = this.getStringFromResourceBundle(object2.toString());
                return string == null ? object2.toString() : string;
            }
            return "";
        }
        if (object2 != null) {
            return object2;
        }
        String string = (String)Hints.getDefaultsMap().get(object);
        return string == null ? "" : string;
    }

    private String getStringFromResourceBundle(String string) {
        if (string != null) {
            ResourceBundle resourceBundle = null;
            if (string.startsWith("${adfBundle")) {
                AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
                ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, String.class);
                return (String)valueExpression.getValue((ELContext)adfELContext);
            }
            if (this.m_parentTreeBinding != null) {
                resourceBundle = this.m_parentTreeBinding.getResourceBundle();
            }
            if (resourceBundle != null) {
                return resourceBundle.getString(string);
            }
        }
        return null;
    }

    public void setLabel(String string) {
        Map map = this.getHintsMap();
        map.put(LABEL_KEY, string);
    }

    public void setUpdateable(boolean bl) {
        Map map = this.getHintsMap();
        map.put(UPDATEABLE_KEY, new Boolean(bl));
    }

    public void setFormat(String string) {
        Map map = this.getHintsMap();
        map.put(FORMAT_KEY, string);
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public void setAttributeName(String string) {
        this.m_attributeName = string;
    }

    public Object getInputValue() {
        return this.m_inputValue;
    }

    public void setInputValue(Object object) {
        this.m_inputValue = object;
    }

    public List getItems() {
        return new ArrayList();
    }

    public AmxIteratorBinding getIteratorBinding() {
        return (AmxIteratorBinding)this.m_parentTreeBinding.getExecutable();
    }

    public Object toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(LABEL_KEY, this.getLabel());
            jSONObject.put(FORMAT_KEY, this.getFormat());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public Map getHintsMap() {
        if (this.hintsMap == null) {
            this.populateHintsMap();
        }
        return this.hintsMap;
    }

    private void populateHintsMap() {
        Object object;
        XmlAnyDefinition xmlAnyDefinition;
        XmlAnyDefinition xmlAnyDefinition2;
        this.hintsMap = new HashMap();
        PersdefDefinition persdefDefinition = null;
        if (this.m_DefName != null && !this.m_DefName.equals("")) {
            persdefDefinition = PersdefDefinition.loadPersdefFromClassname(this.m_DefName);
        } else if (this.m_parentTreeBinding != null) {
            String string;
            if (this.m_parentTreeBinding.getContainer() == null) {
                return;
            }
            xmlAnyDefinition2 = this.m_parentTreeBinding.getContainer().metaData;
            if (xmlAnyDefinition2 == null) {
                return;
            }
            xmlAnyDefinition = ((PageDefDefinition)xmlAnyDefinition2).getExecutablesDefinition().getIteratorById((String)this.m_parentTreeBinding.getMetadataDefinition().getAttributeValue("IterBinding"));
            if (xmlAnyDefinition != null && null != (object = xmlAnyDefinition.getElementName()) && (((String)object).equals("accessorIterator") || ((String)object).equals("methodIterator")) && (string = (String)xmlAnyDefinition.getAttributeValue("BeanClass")) != null) {
                persdefDefinition = PersdefDefinition.loadPersdefFromClassname(string);
            }
        }
        if (persdefDefinition != null && (xmlAnyDefinition2 = persdefDefinition.getPDefAttributeByName(this.m_attributeName)) != null) {
            xmlAnyDefinition = xmlAnyDefinition2.getChildDefinition("Properties");
            if (xmlAnyDefinition != null) {
                object = xmlAnyDefinition.getChildDefinition("SchemaBasedProperties");
                SchemaBasedPropertiesUtils.extractSchemaBasedProperties((XmlAnyDefinition)object, this.hintsMap);
            }
            if ((object = xmlAnyDefinition2.getAttributeValue("IsUpdateable")) != null) {
                this.hintsMap.put(UPDATEABLE_KEY, object);
            }
        }
        if (!this.hintsMap.containsKey(LABEL_KEY)) {
            this.hintsMap.put(LABEL_KEY, this.getAttributeName());
        }
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }
}

