/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings;

import com.sun.util.logging.Level;
import java.io.IOException;
import java.io.InputStream;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class AdfmLoader {
    private static final String DEFAULT_ADFM_PATH = "META-INF/adfm.xml";
    private static String m_dataBindingsCpxLocation;
    private static String m_dataControlDcxLocation;
    private static String m_businessComponentServiceXcfgLocation;
    private static String m_businessComponentProjectJpxLocation;
    private XmlPullParser xpp;
    private InputStream inputStream = Utility.getResourceAsStream("META-INF/adfm.xml");
    public static final Class CLASS_INSTANCE;

    public static String getDataBindingsCpxLocation() {
        if (m_dataBindingsCpxLocation != null) {
            return m_dataBindingsCpxLocation;
        }
        AdfmLoader.parseAdfmXml();
        return m_dataBindingsCpxLocation;
    }

    public static String getDataControlDcxLocation() {
        if (m_dataControlDcxLocation != null) {
            return m_dataControlDcxLocation;
        }
        AdfmLoader.parseAdfmXml();
        return m_dataControlDcxLocation;
    }

    public static String getBusinessComponentServiceXcfgLocation() {
        if (m_businessComponentServiceXcfgLocation != null) {
            return m_businessComponentServiceXcfgLocation;
        }
        AdfmLoader.parseAdfmXml();
        return m_businessComponentServiceXcfgLocation;
    }

    public static String getBusinessComponentProjectJpxLocation() {
        if (m_businessComponentProjectJpxLocation != null) {
            return m_businessComponentProjectJpxLocation;
        }
        AdfmLoader.parseAdfmXml();
        return m_businessComponentProjectJpxLocation;
    }

    private static void parseAdfmXml() {
        try {
            AdfmLoader adfmLoader = new AdfmLoader();
            adfmLoader.processDocument();
            adfmLoader.inputStream.close();
        }
        catch (IOException iOException) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, CLASS_INSTANCE, "parseAdfmXml", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11002");
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11002", new Object[]{DEFAULT_ADFM_PATH});
        }
        catch (XmlPullParserException xmlPullParserException) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, CLASS_INSTANCE, "parseAdfmXml", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11002");
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11002", new Object[]{DEFAULT_ADFM_PATH});
        }
    }

    private AdfmLoader() throws XmlPullParserException {
        if (this.inputStream == null && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, CLASS_INSTANCE, "AdfmLoader", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11002", new Object[]{DEFAULT_ADFM_PATH});
        }
        this.xpp = XmlPullParserFactory.newInstance().newPullParser();
        this.xpp.setInput(this.inputStream, null);
    }

    public void processDocument() throws XmlPullParserException, IOException {
        int n = this.xpp.getEventType();
        while (n != 1) {
            switch (n) {
                case 0: {
                    this.processStartDocument();
                    break;
                }
                case 1: {
                    this.processEndDocument();
                    break;
                }
                case 2: {
                    this.processStartElement();
                    break;
                }
                case 3: {
                    this.processEndElement();
                    break;
                }
                case 4: {
                    this.processText();
                }
            }
            n = this.xpp.next();
        }
    }

    private void processStartElement() {
        block5: {
            String string;
            block7: {
                block6: {
                    block4: {
                        string = this.xpp.getName();
                        if (!string.equalsIgnoreCase("DataBindingRegistry")) break block4;
                        int n = this.xpp.getAttributeCount();
                        while (--n > -1) {
                            String string2 = this.xpp.getAttributeName(n);
                            if (!string2.equalsIgnoreCase("path") || m_dataBindingsCpxLocation != null) continue;
                            m_dataBindingsCpxLocation = this.xpp.getAttributeValue(n);
                        }
                        break block5;
                    }
                    if (!string.equalsIgnoreCase("DataControlRegistry")) break block6;
                    int n = this.xpp.getAttributeCount();
                    while (--n > -1) {
                        String string3 = this.xpp.getAttributeName(n);
                        if (!string3.equalsIgnoreCase("path")) continue;
                        m_dataControlDcxLocation = this.xpp.getAttributeValue(n);
                    }
                    break block5;
                }
                if (!string.equalsIgnoreCase("BusinessComponentServiceRegistry")) break block7;
                int n = this.xpp.getAttributeCount();
                while (--n > -1) {
                    String string4 = this.xpp.getAttributeName(n);
                    if (!string4.equalsIgnoreCase("path")) continue;
                    m_businessComponentServiceXcfgLocation = this.xpp.getAttributeValue(n);
                }
                break block5;
            }
            if (!string.equalsIgnoreCase("BusinessComponentProjectRegistry")) break block5;
            int n = this.xpp.getAttributeCount();
            while (--n > -1) {
                String string5 = this.xpp.getAttributeName(n);
                if (!string5.equalsIgnoreCase("path")) continue;
                m_businessComponentProjectJpxLocation = this.xpp.getAttributeValue(n);
            }
        }
    }

    private void processEndElement() {
    }

    private void processEndDocument() {
    }

    private void processStartDocument() {
    }

    private void processText() {
    }

    static {
        CLASS_INSTANCE = AdfmLoader.class;
    }
}

