/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.beans;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.adfmf.beans.BeanInfo;
import oracle.adfmf.beans.BeanInfoImpl;
import oracle.adfmf.beans.IntrospectionException;
import oracle.adfmf.beans.PropertyDescriptor;

public class Introspector {
    private static HashMap s_beanInfoCache = new HashMap();

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)s_beanInfoCache.get(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        beanInfo = Introspector.introspectBean(clazz);
        return beanInfo;
    }

    private static BeanInfo introspectBean(Class clazz) {
        BeanInfoImpl beanInfoImpl = new BeanInfoImpl();
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        try {
            Serializable serializable;
            String string;
            Method[] methodArray = clazz.getMethods();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, Method> hashMap = new HashMap<String, Method>();
            HashMap hashMap2 = new HashMap();
            for (int i = 0; i < methodArray.length; ++i) {
                if (Introspector.isSimpleGetter(methodArray[i])) {
                    string = Introspector.getPropertyNameFromMethod(methodArray[i], 3);
                    hashSet.add(string);
                    hashMap.put(string, methodArray[i]);
                    continue;
                }
                if (Introspector.isBooleanGetter(methodArray[i])) {
                    string = Introspector.getPropertyNameFromMethod(methodArray[i], 2);
                    hashSet.add(string);
                    hashMap.put(string, methodArray[i]);
                    continue;
                }
                if (!Introspector.isSimpleSetter(methodArray[i])) continue;
                string = Introspector.getPropertyNameFromMethod(methodArray[i], 3);
                hashSet.add(string);
                serializable = (List)hashMap2.get(string);
                if (serializable == null) {
                    serializable = new ArrayList();
                }
                serializable.add((Method)methodArray[i]);
                hashMap2.put(string, (Class<?>)serializable);
            }
            PropertyDescriptor[] propertyDescriptorArray = hashSet.iterator();
            block3: while (propertyDescriptorArray.hasNext()) {
                Object object;
                Object object2;
                string = (String)propertyDescriptorArray.next();
                serializable = null;
                PropertyDescriptor propertyDescriptor = null;
                if (hashMap.containsKey(string) && hashMap2.containsKey(string)) {
                    object2 = (Method)hashMap.get(string);
                    object = (List)hashMap2.get(string);
                    serializable = ((Method)object2).getReturnType();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Method method = (Method)iterator.next();
                        Class<?>[] classArray = method.getParameterTypes();
                        if (!classArray[0].equals(serializable)) continue;
                        propertyDescriptor = new PropertyDescriptor();
                        propertyDescriptor.setName(string);
                        propertyDescriptor.setReadMethod((Method)object2);
                        propertyDescriptor.setWriteMethod(method);
                        vector.add(propertyDescriptor);
                        continue block3;
                    }
                    continue;
                }
                if (hashMap.containsKey(string)) {
                    object2 = (Method)hashMap.get(string);
                    propertyDescriptor = new PropertyDescriptor();
                    propertyDescriptor.setName(string);
                    propertyDescriptor.setReadMethod((Method)object2);
                    vector.add(propertyDescriptor);
                    continue;
                }
                if (!hashMap2.containsKey(string) || (object2 = (List)hashMap2.get(string)).size() != 1) continue;
                object = (Method)object2.get(0);
                propertyDescriptor = new PropertyDescriptor();
                propertyDescriptor.setName(string);
                propertyDescriptor.setWriteMethod((Method)object);
                vector.add(propertyDescriptor);
            }
            propertyDescriptorArray = new PropertyDescriptor[vector.size()];
            int n = 0;
            serializable = vector.iterator();
            while (serializable.hasNext()) {
                propertyDescriptorArray[n] = (PropertyDescriptor)serializable.next();
                ++n;
            }
            beanInfoImpl.setPropertyDescriptors(propertyDescriptorArray);
            return beanInfoImpl;
        }
        catch (SecurityException securityException) {
            return new BeanInfoImpl();
        }
    }

    private static boolean isSimpleGetter(Method method) {
        String string = method.getName();
        return string.length() > 3 && string.startsWith("get") && Character.isUpperCase(string.charAt(3)) && method.getParameterTypes().length == 0;
    }

    private static boolean isBooleanGetter(Method method) {
        String string;
        return method.getReturnType().equals(Boolean.TYPE) && (string = method.getName()).length() > 2 && string.startsWith("is") && Character.isUpperCase(string.charAt(2)) && method.getParameterTypes().length == 0;
    }

    private static boolean isSimpleSetter(Method method) {
        String string = method.getName();
        return string.length() > 3 && string.startsWith("set") && Character.isUpperCase(string.charAt(3)) && method.getParameterTypes().length == 1;
    }

    private static String getPropertyNameFromMethod(Method method, int n) {
        String string = method.getName().substring(n);
        if (!(string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1)) || Character.isLowerCase(string.charAt(0)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string = new String(cArray);
        }
        return string;
    }
}

