/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.reflect.Array;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class ArrayELResolver
extends ELResolver {
    private final boolean readOnly;

    public ArrayELResolver() {
        this(false);
    }

    public ArrayELResolver(boolean bl) {
        this.readOnly = bl;
    }

    public Class getCommonPropertyType(ELContext eLContext, Object object) {
        Class clazz = this.isResolvable(object) ? Integer.class : null;
        return clazz;
    }

    public Class getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        Class<?> clazz = null;
        if (this.isResolvable(object)) {
            this.toIndex(object, object2);
            clazz = object.getClass().getComponentType();
            eLContext.setPropertyResolved(true);
        }
        return clazz;
    }

    public Object getValue(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        Object object3 = null;
        if (this.isResolvable(object)) {
            int n = this.toIndex(null, object2);
            object3 = n < 0 || n >= Array.getLength(object) ? null : Array.get(object, n);
            eLContext.setPropertyResolved(true);
        }
        return object3;
    }

    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isResolvable(object)) {
            this.toIndex(object, object2);
            eLContext.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isResolvable(object)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            Array.set(object, this.toIndex(object, object2), object3);
            eLContext.setPropertyResolved(true);
        }
    }

    private final boolean isResolvable(Object object) {
        return object != null && object.getClass().isArray();
    }

    private final int toIndex(Object object, Object object2) {
        int n = 0;
        if (object2 instanceof Number) {
            n = ((Number)object2).intValue();
        } else if (object2 instanceof String) {
            try {
                n = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Cannot parse array index: " + object2);
            }
        } else if (object2 instanceof Character) {
            n = ((Character)object2).charValue();
        } else if (object2 instanceof Boolean) {
            n = (Boolean)object2 != false ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Cannot coerce property to array index: " + object2);
        }
        if (object != null && (n < 0 || n >= Array.getLength(object))) {
            throw new PropertyNotFoundException("Array index out of bounds: " + n);
        }
        return n;
    }
}

