/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ksoap2.SoapEnvelope;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class Transport {
    protected String url;
    public boolean debug;
    public String requestDump;
    public String responseDump;
    private String xmlVersionTag = "";

    public Transport() {
    }

    public Transport(String string) {
        this.url = string;
    }

    protected void parseResponse(SoapEnvelope soapEnvelope, InputStream inputStream) throws XmlPullParserException, IOException {
        KXmlParser kXmlParser = new KXmlParser();
        kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        kXmlParser.setInput(inputStream, null);
        soapEnvelope.parse((XmlPullParser)kXmlParser);
    }

    protected byte[] createRequestData(SoapEnvelope soapEnvelope) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.xmlVersionTag.getBytes());
        KXmlSerializer kXmlSerializer = new KXmlSerializer();
        kXmlSerializer.setOutput((OutputStream)byteArrayOutputStream, null);
        soapEnvelope.write((XmlSerializer)kXmlSerializer);
        kXmlSerializer.flush();
        byteArrayOutputStream.write(13);
        byteArrayOutputStream.write(10);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setXmlVersionTag(String string) {
        this.xmlVersionTag = string;
    }

    public void reset() {
    }

    public abstract void call(String var1, SoapEnvelope var2) throws IOException, XmlPullParserException;
}

