/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC0;

import SQLite.Database;
import SQLite.JDBC0.BatchArg;
import SQLite.JDBC0.JDBCConnection;
import SQLite.JDBC0.JDBCStatement;
import SQLite.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class JDBCPreparedStatement
extends JDBCStatement
implements PreparedStatement {
    private String sql;
    private String[] args = null;
    private boolean[] blobs = null;
    private ArrayList batch = null;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCPreparedStatement(JDBCConnection jDBCConnection, String string) {
        super(jDBCConnection);
        this.sql = this.fixup(string);
    }

    private String fixup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == '\'') {
                if (bl) {
                    c = '\u0000';
                    if (i + 1 < string.length()) {
                        c = string.charAt(i + 1);
                    }
                    if (c == '\'') {
                        stringBuffer.append(c2);
                        stringBuffer.append(c);
                        ++i;
                        continue;
                    }
                    bl = false;
                    stringBuffer.append(c2);
                    continue;
                }
                bl = true;
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '?') {
                if (bl) {
                    stringBuffer.append(c2);
                    continue;
                }
                ++n;
                stringBuffer.append(nullrepl ? "'%q'" : "%Q");
                continue;
            }
            if (c2 == ';') {
                if (!bl) {
                    if (n2 < 0) {
                        c = '\u0000';
                        while (stringBuffer.charAt(c) == ' ' || stringBuffer.charAt(c) == '\t' || stringBuffer.charAt(c) == '\n' || stringBuffer.charAt(c) == '\r') {
                            ++c;
                        }
                        String string2 = stringBuffer.substring(c, c + 6);
                        n2 = string2.compareToIgnoreCase("create") == 0 ? 1 : 0;
                    }
                    if (n2 == 0) break;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%%");
                continue;
            }
            stringBuffer.append(c2);
        }
        this.args = new String[n];
        this.blobs = new boolean[n];
        try {
            this.clearParameters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private String fixup2(String string) {
        if (!this.conn.db.is3()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 == 37) {
                stringBuffer.append((char)n2);
                n2 = string.charAt(++i);
                if (n2 == 81 && this.blobs[++n]) {
                    n2 = 115;
                }
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false);
    }

    public int executeUpdate() throws SQLException {
        this.executeQuery(this.fixup2(this.sql), this.args, true);
        return this.updcnt;
    }

    public void setNull(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = nullrepl ? "" : null;
        this.blobs[n - 1] = false;
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = bl ? "1" : "0";
        this.blobs[n - 1] = false;
    }

    public void setByte(int n, byte by) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + by;
        this.blobs[n - 1] = false;
    }

    public void setShort(int n, short s) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + s;
        this.blobs[n - 1] = false;
    }

    public void setInt(int n, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + n2;
        this.blobs[n - 1] = false;
    }

    public void setLong(int n, long l) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + l;
        this.blobs[n - 1] = false;
    }

    public void setFloat(int n, float f) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + f;
        this.blobs[n - 1] = false;
    }

    public void setDouble(int n, double d) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = "" + d;
        this.blobs[n - 1] = false;
    }

    public void setString(int n, String string) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = string == null ? (nullrepl ? "" : null) : string;
        this.blobs[n - 1] = false;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.blobs[n - 1] = false;
        if (byArray == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (this.conn.db.is3()) {
            this.args[n - 1] = StringEncoder.encodeX(byArray);
            this.blobs[n - 1] = true;
        } else {
            this.args[n - 1] = StringEncoder.encode(byArray);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = date == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(date.getTime())) : date.toString());
        this.blobs[n - 1] = false;
    }

    public void setTime(int n, Time time) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = time == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(time.getTime())) : time.toString());
        this.blobs[n - 1] = false;
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[n - 1] = timestamp == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(timestamp.getTime())) : timestamp.toString());
        this.blobs[n - 1] = false;
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.setBytes(n, byArray);
        }
        catch (IOException iOException) {
            throw new SQLException("I/O failed");
        }
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = nullrepl ? "" : null;
            this.blobs[i] = false;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    public void setObject(int n, Object object) throws SQLException {
        if (n < 1 || n > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (object == null) {
            this.args[n - 1] = nullrepl ? "" : null;
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.conn.db.is3()) {
                this.args[n - 1] = StringEncoder.encodeX(byArray);
                this.blobs[n - 1] = true;
                return;
            }
            this.args[n - 1] = StringEncoder.encode(byArray);
        } else {
            this.args[n - 1] = object.toString();
        }
        this.blobs[n - 1] = false;
    }

    public boolean execute() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false) != null;
    }

    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(this.args.length);
        }
        if (this.args.length == 0) {
            this.batch.add(new BatchArg(null, false));
        } else {
            for (int i = 0; i < this.args.length; ++i) {
                this.batch.add(new BatchArg(this.args[i], this.blobs[i]));
            }
        }
    }

    public int[] executeBatch() throws SQLException {
        int n;
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = this.args.length == 0 ? new int[this.batch.size()] : new int[this.batch.size() / this.args.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -3;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.args.length; ++j) {
                BatchArg batchArg = (BatchArg)this.batch.get(n2++);
                this.args[j] = batchArg.arg;
                this.blobs[j] = batchArg.blob;
            }
            try {
                nArray[i] = this.executeUpdate();
                continue;
            }
            catch (SQLException sQLException) {
                ++n;
            }
        }
        if (n > 0) {
            throw new BatchUpdateException("batch failed", nArray);
        }
        return nArray;
    }

    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.clear();
            this.batch = null;
        }
    }

    public void close() throws SQLException {
        this.clearBatch();
        super.close();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2];
            reader.read(cArray);
            this.setString(n, new String(cArray));
        }
        catch (IOException iOException) {
            throw new SQLException("I/O failed");
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void registerOutputParameter(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLException("not supported");
    }

    public String getString(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("not supported");
    }
}

