/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.BaseSSLSocketImpl;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RenegotiationInfoExtension;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SessionId;
import com.sun.net.ssl.internal.ssl.SunJSSE_a3;
import com.sun.net.ssl.internal.ssl.SunJSSE_a4;
import com.sun.net.ssl.internal.ssl.SunJSSE_a5;
import com.sun.net.ssl.internal.ssl.SunJSSE_a7;
import com.sun.net.ssl.internal.ssl.SunJSSE_a9;
import com.sun.net.ssl.internal.ssl.SunJSSE_ax;
import com.sun.net.ssl.internal.ssl.SunJSSE_ba;
import com.sun.net.ssl.internal.ssl.SunJSSE_bb;
import com.sun.net.ssl.internal.ssl.SunJSSE_bc;
import com.sun.net.ssl.internal.ssl.SunJSSE_bd;
import com.sun.net.ssl.internal.ssl.SunJSSE_be;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509TrustManager;

final class SunJSSE_az
extends SunJSSE_ax {
    private PublicKey a;
    private BigInteger b;
    private SunJSSE_bd c;
    private SunJSSE_a9 d;
    private boolean e;
    ProtocolVersion f;

    SunJSSE_az(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, true, true, protocolVersion, bl, bl2, byArray, byArray2);
    }

    void a(byte by, int n) throws IOException {
        if (this.m > by && by != 0 && this.m != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        switch (by) {
            case 0: {
                this.a(new SunJSSE_a3(this.k));
                break;
            }
            case 2: {
                this.a(new SunJSSE_a5(this.k, n));
                break;
            }
            case 11: {
                if (this.v == SunJSSE_g.K_DH_ANON) {
                    this.i.a((byte)10, "unexpected server cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(this.k));
                this.a = this.q.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.e = true;
                if (this.v == SunJSSE_g.K_RSA || this.v == SunJSSE_g.K_RSA_EXPORT) {
                    try {
                        this.a(new SunJSSE_a7(this.k, n));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        SunJSSE_ax.a("Server key", generalSecurityException);
                    }
                    break;
                }
                if (this.v == SunJSSE_g.K_DH_ANON) {
                    this.a(new HandshakeMessage.DH_ServerKeyExchange(this.k));
                    break;
                }
                if (this.v == SunJSSE_g.K_DHE_DSS || this.v == SunJSSE_g.K_DHE_RSA) {
                    try {
                        this.a(new HandshakeMessage.DH_ServerKeyExchange(this.k, this.a, this.o.a, this.p.a, n));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        SunJSSE_ax.a("Server key", generalSecurityException);
                    }
                    break;
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + this.v);
            }
            case 13: {
                if (this.v == SunJSSE_g.K_DH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                this.d = new SunJSSE_a9(this.k);
                if (SunJSSE_ax.ae == null || !Debug.isOn("handshake")) break;
                this.d.a(System.out);
                break;
            }
            case 14: {
                this.a(new SunJSSE_ba(this.k));
                break;
            }
            case 20: {
                this.b(new SunJSSE_bc(((SunJSSE_ax)this).a, this.k));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (this.m < by) {
            this.m = by;
        }
    }

    private void a(SunJSSE_a3 sunJSSE_a3) throws IOException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_a3.a(System.out);
        }
        if (this.m < 1) {
            if (!((SunJSSE_ax)this).c && !SunJSSE_ax.af) {
                if (((SunJSSE_ax)this).b.i >= ProtocolVersion.d.i) {
                    this.i.a((byte)100);
                    this.ah = true;
                } else {
                    this.i.a((byte)40, "renegotiation is not allowed");
                }
            } else {
                if (!((SunJSSE_ax)this).c && SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: continue with insecure renegotiation");
                }
                this.l();
            }
        }
    }

    private void a(SunJSSE_a5 sunJSSE_a5) throws IOException {
        Object object;
        ProtocolVersion protocolVersion;
        this.e = false;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_a5.a(System.out);
        }
        if (!this.g.a(protocolVersion = sunJSSE_a5.a)) {
            throw new SSLHandshakeException("Server chose unsupported or disabled protocol: " + protocolVersion);
        }
        this.a(protocolVersion);
        RenegotiationInfoExtension renegotiationInfoExtension = (RenegotiationInfoExtension)sunJSSE_a5.f.a(ExtensionType.p);
        if (renegotiationInfoExtension != null) {
            if (((SunJSSE_ax)this).f) {
                if (!renegotiationInfoExtension.b()) {
                    this.i.a((byte)40, "The renegotiation_info field is not empty");
                }
                ((SunJSSE_ax)this).c = true;
            } else {
                if (!((SunJSSE_ax)this).c) {
                    this.i.a((byte)40, "Unexpected renegotiation indication extension");
                }
                object = new byte[((SunJSSE_ax)this).d.length + ((SunJSSE_ax)this).e.length];
                System.arraycopy(((SunJSSE_ax)this).d, 0, object, 0, ((SunJSSE_ax)this).d.length);
                System.arraycopy(((SunJSSE_ax)this).e, 0, object, ((SunJSSE_ax)this).d.length, ((SunJSSE_ax)this).e.length);
                if (!Arrays.equals((byte[])object, renegotiationInfoExtension.c())) {
                    this.i.a((byte)40, "Incorrect verify data in ServerHello renegotiation_info message");
                }
            }
        } else if (((SunJSSE_ax)this).f) {
            if (!SunJSSE_ax.ag) {
                this.i.a((byte)40, "Failed to negotiate the use of secure renegotiation");
            }
            ((SunJSSE_ax)this).c = false;
            if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                System.out.println("Warning: No renegotiation indication extension in ServerHello");
            }
        } else if (((SunJSSE_ax)this).c) {
            this.i.a((byte)40, "No renegotiation indication extension");
        }
        this.p = sunJSSE_a5.b;
        if (!this.c(sunJSSE_a5.d)) {
            this.i.a((byte)47, "Server selected improper ciphersuite " + this.u);
        }
        this.b(sunJSSE_a5.d);
        if (sunJSSE_a5.e != 0) {
            this.i.a((byte)47, "compression type not supported, " + sunJSSE_a5.e);
        }
        if (this.q != null) {
            if (this.q.d().equals(sunJSSE_a5.c)) {
                object = this.q.e();
                if (this.u != object) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion protocolVersion2 = this.q.f();
                if (((SunJSSE_ax)this).a != protocolVersion2) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                this.w = true;
                this.m = 19;
                this.b(this.q.a());
                if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.q);
                }
                return;
            }
            this.q = null;
            if (!this.x) {
                throw new SSLException("New session creation is disabled");
            }
        }
        object = sunJSSE_a5.f.a().iterator();
        while (object.hasNext()) {
            HelloExtension helloExtension = (HelloExtension)object.next();
            ExtensionType extensionType = helloExtension.a;
            if (extensionType == ExtensionType.p) continue;
            this.i.a((byte)110, "Server sent an unsupported extension: " + extensionType);
        }
        this.q = new SSLSessionImpl(((SunJSSE_ax)this).a, this.u, sunJSSE_a5.c, this.i.g(), this.i.getPort());
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.u);
        }
    }

    private void a(SunJSSE_a7 sunJSSE_a7) throws IOException, GeneralSecurityException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_a7.a(System.out);
        }
        if (!sunJSSE_a7.a(this.a, this.o, this.p)) {
            this.i.a((byte)40, "server key exchange invalid");
        }
        this.a = sunJSSE_a7.a();
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.c = new SunJSSE_bd(bigInteger, bigInteger2);
        int n = 768;
        this.c.a(this.n.a(), n);
    }

    private void a(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException {
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.a(System.out);
        }
        this.a(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.b = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void a(SunJSSE_ba sunJSSE_ba) throws IOException {
        HandshakeMessage handshakeMessage;
        Object object;
        Object object2;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_ba.a(System.out);
        }
        this.k.a();
        PrivateKey privateKey = null;
        if (this.d != null) {
            String[] stringArray;
            int n;
            object2 = this.n.b();
            object = null;
            handshakeMessage = null;
            X509Certificate[] x509CertificateArray = null;
            ArrayList<String[]> arrayList = new ArrayList<String[]>(4);
            for (n = 0; n < this.d.h.length; ++n) {
                switch (this.d.h[n]) {
                    case 1: {
                        stringArray = "RSA";
                        break;
                    }
                    case 2: {
                        stringArray = "DSA";
                        break;
                    }
                    case 3: {
                        stringArray = "DH_RSA";
                        break;
                    }
                    case 4: {
                        stringArray = "DH_DSA";
                        break;
                    }
                    default: {
                        stringArray = null;
                    }
                }
                if (stringArray == null || arrayList.contains(stringArray)) continue;
                arrayList.add(stringArray);
            }
            n = arrayList.size();
            if (n != 0) {
                stringArray = arrayList.toArray(new String[n]);
                object = object2.chooseClientAlias(stringArray, this.d.a(), this.i);
            }
            if (object != null) {
                x509CertificateArray = object2.getCertificateChain((String)object);
                handshakeMessage = new HandshakeMessage.CertificateMsg(x509CertificateArray);
                privateKey = object2.getPrivateKey((String)object);
                this.q.a(true);
            } else if (((SunJSSE_ax)this).a.i >= ProtocolVersion.d.i) {
                handshakeMessage = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                this.i.a((byte)41);
            }
            if (handshakeMessage != null) {
                this.q.b(x509CertificateArray);
                if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)handshakeMessage).a(System.out);
                }
                handshakeMessage.write(this.l);
            }
        }
        if (this.v == SunJSSE_g.K_RSA || this.v == SunJSSE_g.K_RSA_EXPORT) {
            object2 = new SunJSSE_be(((SunJSSE_ax)this).a, this.f, this.n.a(), this.a);
        } else if (this.v == SunJSSE_g.K_DH_RSA || this.v == SunJSSE_g.K_DH_DSS) {
            object2 = new ClientDiffieHellmanPublic();
        } else if (this.v == SunJSSE_g.K_DHE_RSA || this.v == SunJSSE_g.K_DHE_DSS || this.v == SunJSSE_g.K_DH_ANON) {
            object2 = new ClientDiffieHellmanPublic(this.c.c());
        } else {
            throw new RuntimeException("Unsupported key exchange: " + this.v);
        }
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object2).a(System.out);
        }
        ((HandshakeMessage)object2).write(this.l);
        this.l.a();
        this.l.flush();
        object = this.v == SunJSSE_g.K_RSA || this.v == SunJSSE_g.K_RSA_EXPORT ? ((SunJSSE_be)object2).d : this.c.a(this.b);
        this.a((byte[])object);
        Arrays.fill(object, (byte)0);
        if (privateKey != null) {
            try {
                handshakeMessage = new SunJSSE_bb(((SunJSSE_ax)this).a, this.j, privateKey, this.q.a(), this.n.a());
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.i.a((byte)40, "Error signing certificate verify", generalSecurityException);
                handshakeMessage = null;
            }
            if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
                ((SunJSSE_bb)handshakeMessage).a(System.out);
            }
            handshakeMessage.write(this.l);
            this.l.a();
        }
        this.m();
    }

    private void b(SunJSSE_bc sunJSSE_bc) throws IOException {
        boolean bl;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            sunJSSE_bc.a(System.out);
        }
        if (!(bl = sunJSSE_bc.a(((SunJSSE_ax)this).a, this.j, 2, this.q.a()))) {
            this.i.a((byte)47, "server 'finished' message doesn't verify");
        }
        if (((SunJSSE_ax)this).c) {
            ((SunJSSE_ax)this).e = sunJSSE_bc.a();
        }
        if (this.w) {
            this.k.a();
            this.m();
        }
        this.q.a(System.currentTimeMillis());
        if (!this.w) {
            if (this.q.b()) {
                ((SSLSessionContextImpl)this.n.engineGetClientSessionContext()).a(this.q);
                if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.q);
                }
            } else if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.q);
            }
        }
    }

    private void m() throws IOException {
        SunJSSE_bc sunJSSE_bc = new SunJSSE_bc(((SunJSSE_ax)this).a, this.j, 1, this.q.a());
        this.a(sunJSSE_bc);
        if (((SunJSSE_ax)this).c) {
            ((SunJSSE_ax)this).d = sunJSSE_bc.a();
        }
        this.m = 19;
    }

    HandshakeMessage a() throws SSLException {
        Object object;
        Object object2;
        Object object3;
        SessionId sessionId = SSLSessionImpl.a.d();
        CipherSuiteList cipherSuiteList = this.t;
        this.f = ((SunJSSE_ax)this).a;
        this.q = ((SSLSessionContextImpl)this.n.engineGetClientSessionContext()).a(this.i.g(), this.i.getPort());
        if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
            if (this.q != null) {
                System.out.println("%% Client cached " + this.q + (this.q.b() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.q != null) {
            object3 = this.q.e();
            object2 = this.q.f();
            if (!this.c((CipherSuite)object3)) {
                if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, unavailable cipher");
                }
                this.q = null;
            }
            if (this.q != null && !this.g.a((ProtocolVersion)object2)) {
                if (SunJSSE_ax.ae != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.q = null;
            }
            if (this.q != null) {
                if (SunJSSE_ax.ae != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.q + " from port " + this.i.getLocalPort());
                }
                sessionId = this.q.d();
                this.f = object2;
                this.a((ProtocolVersion)object2);
            }
            if (!this.x) {
                if (this.q == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                object = new ArrayList(2);
                object.add(object3);
                if (!((SunJSSE_ax)this).c && cipherSuiteList.a(CipherSuite.p)) {
                    object.add(CipherSuite.p);
                }
                cipherSuiteList = new CipherSuiteList((Collection)object);
            }
        }
        if (this.q == null && !this.x) {
            throw new SSLException("No existing session to resume");
        }
        if (((SunJSSE_ax)this).c && cipherSuiteList.a(CipherSuite.p)) {
            object3 = new ArrayList(cipherSuiteList.b() - 1);
            object2 = cipherSuiteList.a();
            while (object2.hasNext()) {
                object = (CipherSuite)object2.next();
                if (object == CipherSuite.p) continue;
                object3.add(object);
            }
            cipherSuiteList = new CipherSuiteList((Collection)object3);
        }
        boolean bl = false;
        object2 = cipherSuiteList.a();
        while (object2.hasNext()) {
            object = (CipherSuite)object2.next();
            if (!this.c((CipherSuite)object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new SSLException("No negotiable cipher suite");
        }
        object2 = new SunJSSE_a4(this.n.a(), this.f, sessionId, cipherSuiteList);
        this.o = ((SunJSSE_a4)object2).b;
        if (((SunJSSE_ax)this).c || !cipherSuiteList.a(CipherSuite.p)) {
            ((SunJSSE_a4)object2).a(((SunJSSE_ax)this).d);
        }
        return object2;
    }

    void b(byte by) throws SSLProtocolException {
        String string = BaseSSLSocketImpl.b(by);
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (SunJSSE_ax.ae != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            this.i.a((byte)42, "empty certificate chain");
        }
        X509TrustManager x509TrustManager = this.n.c();
        try {
            String string = this.v == SunJSSE_g.K_RSA_EXPORT && !this.e ? SunJSSE_g.K_RSA.a : this.v.a;
            x509TrustManager.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            this.i.a((byte)46, certificateException);
        }
        this.q.a(x509CertificateArray);
    }
}

