/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_ab;
import COM.rsa.jsafe.SunJSSE_b7;
import COM.rsa.jsafe.SunJSSE_bj;
import COM.rsa.jsafe.SunJSSE_j;
import com.sun.net.ssl.internal.ssl.MacData;
import com.sun.net.ssl.internal.ssl.SunJSSE_bt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int a = 20;
    private static final int[] b;
    private static final int[] c;
    private static final int[] d;
    private static final int[] e;
    private static final int[] f;
    private static final int[] g;
    private static final int[] h;
    private static ObjectIdentifier i;
    private static ObjectIdentifier j;
    private static ObjectIdentifier k;
    private static ObjectIdentifier l;
    private static ObjectIdentifier m;
    private static ObjectIdentifier n;
    private static ObjectIdentifier o;
    private static volatile int p;
    private static final int q = 1024;
    private static final int r = 20;
    private SecureRandom s;
    private Hashtable t = new Hashtable();
    private ArrayList u = new ArrayList();
    private LinkedHashMap v = new LinkedHashMap();

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray;
        byte[] byArray2;
        Object v = this.t.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v == null || !(v instanceof SunJSSE_bt)) {
            return null;
        }
        byte[] byArray3 = ((SunJSSE_bt)v).b;
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray3);
            byArray2 = encryptedPrivateKeyInfo.getEncryptedData();
            byArray = encryptedPrivateKeyInfo.getAlgorithm().encode();
        }
        catch (IOException iOException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException);
            unrecoverableKeyException.initCause(iOException);
            throw unrecoverableKeyException;
        }
        try {
            SunJSSE_ab sunJSSE_ab = SunJSSE_ab.a(byArray, 0, "Java");
            SunJSSE_j sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(cArray, 0, cArray.length);
            sunJSSE_ab.a(sunJSSE_j);
            if (!"3DES_EDE".equals(sunJSSE_ab.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray4 = PKCS12KeyStore.a(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.q()[1] * sunJSSE_ab.h());
            byte[] byArray5 = PKCS12KeyStore.b(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.h());
            String string2 = sunJSSE_ab.m() + "/" + sunJSSE_ab.n() + "/" + sunJSSE_ab.s();
            sunJSSE_ab = SunJSSE_ab.a(string2, "Java");
            sunJSSE_ab.c(byArray5, 0, byArray5.length);
            sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(byArray4, 0, byArray4.length);
            sunJSSE_ab.a(sunJSSE_j);
            byte[] byArray6 = PKCS12KeyStore.a(sunJSSE_ab, byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray6);
            SunJSSE_bj sunJSSE_bj = SunJSSE_bj.a(byArray6, 0, "Java");
            KeyFactory keyFactory = KeyFactory.getInstance(sunJSSE_bj.d());
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException(exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return privateKey;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.t.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_bt) {
            if (((SunJSSE_bt)v).c == null) {
                return null;
            }
            return (Certificate[])((SunJSSE_bt)v).c.clone();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.t.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_bt) {
            if (((SunJSSE_bt)v).c == null) {
                return null;
            }
            return ((SunJSSE_bt)v).c[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.t.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_bt) {
            return new Date(((SunJSSE_bt)v).a.getTime());
        }
        return null;
    }

    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            SunJSSE_bt sunJSSE_bt = new SunJSSE_bt(null);
            sunJSSE_bt.a = new Date();
            if (key instanceof PrivateKey) {
                if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
            } else {
                throw new KeyStoreException("Key is not a PrivateKey");
            }
            sunJSSE_bt.b = this.a(key.getEncoded(), cArray);
            if (certificateArray != null) {
                if (certificateArray.length > 1 && !this.a(certificateArray)) {
                    throw new KeyStoreException("Certificate chain is not validate");
                }
                sunJSSE_bt.c = (Certificate[])certificateArray.clone();
            }
            sunJSSE_bt.d = ("Time " + sunJSSE_bt.a.getTime()).getBytes("UTF8");
            sunJSSE_bt.e = string.toLowerCase();
            this.t.put(string.toLowerCase(), sunJSSE_bt);
        }
        catch (Exception exception) {
            KeyStoreException keyStoreException = new KeyStoreException("Key protection  algorithm not found" + exception);
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    public synchronized void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            KeyStoreException keyStoreException = new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException);
            keyStoreException.initCause(iOException);
            throw keyStoreException;
        }
        SunJSSE_bt sunJSSE_bt = new SunJSSE_bt(null);
        sunJSSE_bt.a = new Date();
        sunJSSE_bt.b = (byte[])byArray.clone();
        if (certificateArray != null) {
            sunJSSE_bt.c = (Certificate[])certificateArray.clone();
        }
        this.t.put(string.toLowerCase(), sunJSSE_bt);
    }

    private byte[] a() {
        byte[] byArray = new byte[20];
        if (this.s == null) {
            this.s = new SecureRandom();
        }
        byArray = this.s.generateSeed(20);
        return byArray;
    }

    private AlgorithmParameters b() throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.a(), 1024);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PBE");
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getAlgorithmParameters failed" + exception);
        }
        return algorithmParameters;
    }

    private byte[] a(byte[] byArray, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray2 = null;
        AlgorithmParameters algorithmParameters = this.b();
        DerOutputStream derOutputStream = new DerOutputStream();
        AlgorithmId algorithmId = new AlgorithmId(o, algorithmParameters);
        algorithmId.encode(derOutputStream);
        byte[] byArray3 = derOutputStream.toByteArray();
        try {
            SunJSSE_ab sunJSSE_ab = SunJSSE_ab.a(byArray3, 0, "Java");
            SunJSSE_j sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(cArray, 0, cArray.length);
            sunJSSE_ab.b(sunJSSE_j);
            if (!"3DES_EDE".equals(sunJSSE_ab.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray4 = PKCS12KeyStore.a(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.q()[1] * sunJSSE_ab.h());
            byte[] byArray5 = PKCS12KeyStore.b(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.h());
            String string = sunJSSE_ab.m() + "/" + sunJSSE_ab.n() + "/" + sunJSSE_ab.s();
            sunJSSE_ab = SunJSSE_ab.a(string, "Java");
            sunJSSE_ab.c(byArray5, 0, byArray5.length);
            sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(byArray4, 0, byArray4.length);
            sunJSSE_ab.b(sunJSSE_j);
            byte[] byArray6 = PKCS12KeyStore.b(sunJSSE_ab, byArray);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray6);
            byArray2 = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Encrypt Private Key failed " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return byArray2;
    }

    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Object v = this.t.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_bt) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        throw new KeyStoreException("TrustedCertEntry not supported");
    }

    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        this.t.remove(string.toLowerCase());
    }

    public Enumeration engineAliases() {
        return this.t.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.t.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.t.size();
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.t.get(string.toLowerCase());
        return v != null && v instanceof SunJSSE_bt;
    }

    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Certificate certificate2 = null;
        Enumeration enumeration = this.t.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.t.get(string);
            if (!(v instanceof SunJSSE_bt)) continue;
            if (((SunJSSE_bt)v).c != null) {
                certificate2 = ((SunJSSE_bt)v).c[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (cArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(3);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream.write(byArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        byte[] byArray2 = this.c();
        ContentInfo contentInfo = new ContentInfo(byArray2);
        contentInfo.encode(derOutputStream4);
        byte[] byArray3 = this.a(cArray);
        ContentInfo contentInfo2 = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue(byArray3));
        contentInfo2.encode(derOutputStream4);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.write((byte)48, derOutputStream4);
        byte[] byArray4 = derOutputStream5.toByteArray();
        ContentInfo contentInfo3 = new ContentInfo(byArray4);
        contentInfo3.encode(derOutputStream3);
        byte[] byArray5 = derOutputStream3.toByteArray();
        derOutputStream.write(byArray5);
        byte[] byArray6 = this.a(cArray, byArray4);
        derOutputStream.write(byArray6);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        derOutputStream6.write((byte)48, derOutputStream);
        byte[] byArray7 = derOutputStream6.toByteArray();
        outputStream.write(byArray7);
        outputStream.flush();
    }

    private byte[] a(char[] cArray, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        try {
            String string = "SHA1";
            byte[] byArray3 = this.a();
            SunJSSE_b7 sunJSSE_b7 = SunJSSE_b7.a("HMAC/SHA1", "Java");
            byte[] byArray4 = PKCS12KeyStore.c(cArray, byArray3, 1024, 20);
            SunJSSE_j sunJSSE_j = sunJSSE_b7.c();
            sunJSSE_j.a(byArray4, 0, byArray4.length);
            sunJSSE_b7.a(sunJSSE_j, this.s);
            sunJSSE_b7.a(byArray, 0, byArray.length);
            byte[] byArray5 = sunJSSE_b7.i();
            MacData macData = new MacData(string, byArray5, byArray3, 1024);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.write(macData.getEncoded());
            byArray2 = derOutputStream.toByteArray();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("calculateMac failed " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        return byArray2;
    }

    private boolean a(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    private byte[] a(String string, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream;
        Object object;
        DerOutputStream derOutputStream2;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (string == null && byArray == null) {
            return null;
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (string != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(k);
            object = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            object.putBMPString(string);
            derOutputStream2.write((byte)49, (DerOutputStream)object);
            derOutputStream.write((byte)48, derOutputStream2);
            byArray3 = derOutputStream.toByteArray();
        }
        if (byArray != null) {
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(l);
            object = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            object.putOctetString(byArray);
            derOutputStream2.write((byte)49, (DerOutputStream)object);
            derOutputStream.write((byte)48, derOutputStream2);
            byArray2 = derOutputStream.toByteArray();
        }
        derOutputStream2 = new DerOutputStream();
        if (byArray3 != null) {
            derOutputStream2.write(byArray3);
        }
        if (byArray2 != null) {
            derOutputStream2.write(byArray2);
        }
        derOutputStream3.write((byte)49, derOutputStream2);
        object = derOutputStream3.toByteArray();
        return (byte[])object;
    }

    private byte[] a(char[] cArray) throws CertificateException, IOException {
        Object object;
        Object object2;
        Object object3;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object4 = this.t.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = this.t.get(object3);
            if (!(object2 instanceof SunJSSE_bt)) continue;
            int n = ((SunJSSE_bt)object2).c == null ? 0 : ((SunJSSE_bt)object2).c.length;
            for (int i = 0; i < n; ++i) {
                object = new DerOutputStream();
                object.putOID(j);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(m);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                X509Certificate x509Certificate = (X509Certificate)((SunJSSE_bt)object2).c[i];
                derOutputStream3.putOctetString(x509Certificate.getEncoded());
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream2);
                byte[] byArray = derOutputStream4.toByteArray();
                DerOutputStream derOutputStream5 = new DerOutputStream();
                derOutputStream5.write(byArray);
                object.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream5);
                byte[] byArray2 = null;
                String string = x509Certificate.getSubjectX500Principal().getName();
                byArray2 = i == 0 ? this.a(string, ((SunJSSE_bt)object2).d) : this.a(string, null);
                if (byArray2 != null) {
                    ((OutputStream)object).write(byArray2);
                }
                derOutputStream.write((byte)48, (DerOutputStream)object);
            }
        }
        object4 = new DerOutputStream();
        object4.write((byte)48, derOutputStream);
        object3 = ((ByteArrayOutputStream)object4).toByteArray();
        object2 = this.b((byte[])object3, cArray);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        DerOutputStream derOutputStream7 = new DerOutputStream();
        derOutputStream6.putInteger(0);
        derOutputStream6.write((byte[])object2);
        derOutputStream7.write((byte)48, derOutputStream6);
        object = derOutputStream7.toByteArray();
        return (byte[])object;
    }

    private byte[] c() throws CertificateException, IOException {
        Object object;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object2 = this.t.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            Object v = this.t.get(object);
            if (!(v instanceof SunJSSE_bt)) continue;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(i);
            byte[] byArray = ((SunJSSE_bt)v).b;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException.getMessage());
            }
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write(encryptedPrivateKeyInfo.getEncoded());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            byte[] byArray2 = this.a((String)object, ((SunJSSE_bt)v).d);
            derOutputStream2.write(byArray2);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        object2 = new DerOutputStream();
        object2.write((byte)48, derOutputStream);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        return (byte[])object;
    }

    private byte[] b(byte[] byArray, char[] cArray) throws IOException {
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        byte[] byArray3 = null;
        AlgorithmParameters algorithmParameters = this.b();
        DerOutputStream derOutputStream = new DerOutputStream();
        AlgorithmId algorithmId = new AlgorithmId(n, algorithmParameters);
        algorithmId.encode(derOutputStream);
        byte[] byArray4 = derOutputStream.toByteArray();
        try {
            object3 = SunJSSE_ab.a(byArray4, 0, "Java");
            object2 = ((SunJSSE_ab)object3).g();
            ((SunJSSE_j)object2).a(cArray, 0, cArray.length);
            ((SunJSSE_ab)object3).b((SunJSSE_j)object2);
            if (!"RC2".equals(((SunJSSE_ab)object3).m())) {
                throw new NoSuchAlgorithmException("RC2 Only for safeContents");
            }
            object = ((SunJSSE_j)object2).l();
            byArray2 = ((SunJSSE_ab)object3).p();
            int[] nArray = ((SunJSSE_ab)object3).q();
            String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
            object3 = SunJSSE_ab.a(string, "Java");
            ((SunJSSE_ab)object3).c(byArray2, 0, byArray2.length);
            object2 = ((SunJSSE_ab)object3).g();
            ((SunJSSE_j)object2).a((byte[])object, 0, ((byte[])object).length);
            ((SunJSSE_ab)object3).b((SunJSSE_j)object2);
            byArray3 = PKCS12KeyStore.b((SunJSSE_ab)object3, byArray);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failed to encrypt safe contents entry" + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        object3 = new DerOutputStream();
        object3.putOID(ContentInfo.DATA_OID);
        ((OutputStream)object3).write(byArray4);
        object2 = new DerOutputStream();
        object2.putOctetString(byArray3);
        object3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), (DerOutputStream)object2);
        object = new DerOutputStream();
        object.write((byte)48, (DerOutputStream)object3);
        byArray2 = ((ByteArrayOutputStream)object).toByteArray();
        return byArray2;
    }

    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        if (inputStream == null) {
            return;
        }
        DerValue derValue = new DerValue(inputStream);
        DerInputStream derInputStream = derValue.toDerInputStream();
        int n = derInputStream.getInteger();
        if (n != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.t.clear();
        ContentInfo contentInfo = new ContentInfo(derInputStream);
        ObjectIdentifier objectIdentifier = contentInfo.getContentType();
        if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] byArray = contentInfo.getData();
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        int n2 = derValueArray.length;
        for (int i = 0; i < n2; ++i) {
            object5 = null;
            object4 = new DerInputStream(derValueArray[i].toByteArray());
            object3 = new ContentInfo((DerInputStream)object4);
            objectIdentifier = ((ContentInfo)object3).getContentType();
            object2 = null;
            if (objectIdentifier.equals(ContentInfo.DATA_OID)) {
                object2 = ((ContentInfo)object3).getData();
            } else if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                Serializable serializable;
                if (cArray == null) continue;
                object = ((ContentInfo)object3).getContent().toDerInputStream();
                int n3 = ((DerInputStream)object).getInteger();
                DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                object5 = derValueArray2[1].toByteArray();
                if (!derValueArray2[2].isContextSpecific((byte)0)) {
                    throw new IOException("encrypted content not present!");
                }
                byte by = 4;
                if (derValueArray2[2].isConstructed()) {
                    by = (byte)(by | 0x20);
                }
                derValueArray2[2].resetTag(by);
                object2 = derValueArray2[2].getOctetString();
                try {
                    SunJSSE_ab sunJSSE_ab = SunJSSE_ab.a((byte[])object5, 0, "Java");
                    serializable = sunJSSE_ab.g();
                    ((SunJSSE_j)serializable).a(cArray, 0, cArray.length);
                    sunJSSE_ab.a((SunJSSE_j)serializable);
                    if (!"RC2".equals(sunJSSE_ab.m())) {
                        throw new NoSuchAlgorithmException("RC2 Only for safeContents");
                    }
                    byte[] byArray2 = ((SunJSSE_j)serializable).l();
                    byte[] byArray3 = sunJSSE_ab.p();
                    int[] nArray = sunJSSE_ab.q();
                    String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
                    sunJSSE_ab = SunJSSE_ab.a(string, "Java");
                    sunJSSE_ab.c(byArray3, 0, byArray3.length);
                    serializable = sunJSSE_ab.g();
                    ((SunJSSE_j)serializable).a(byArray2, 0, byArray2.length);
                    sunJSSE_ab.a((SunJSSE_j)serializable);
                    object2 = PKCS12KeyStore.a(sunJSSE_ab, (byte[])object2);
                }
                catch (Exception exception) {
                    serializable = new IOException("failed to decrypt safe contents entry" + exception);
                    ((Throwable)serializable).initCause(exception);
                    throw serializable;
                }
            } else {
                throw new IOException("public key protected PKCS12 not supported");
            }
            object = new DerInputStream((byte[])object2);
            this.a((DerInputStream)object, cArray);
        }
        if (cArray != null && derInputStream.available() > 0) {
            MacData macData = new MacData(derInputStream);
            try {
                object2 = macData.a().toUpperCase();
                if (((String)object2).equals("SHA") || ((String)object2).equals("SHA1") || ((String)object2).equals("SHA-1")) {
                    object2 = "SHA1";
                }
                object3 = SunJSSE_b7.a("HMAC/" + (String)object2, "Java");
                object4 = PKCS12KeyStore.c(cArray, macData.b(), macData.c(), 20);
                object5 = ((SunJSSE_b7)object3).c();
                ((SunJSSE_j)object5).a((byte[])object4, 0, ((Object)object4).length);
                if (this.s == null) {
                    this.s = new SecureRandom();
                }
                ((SunJSSE_b7)object3).a((SunJSSE_j)object5, this.s);
                ((SunJSSE_b7)object3).a(byArray, 0, byArray.length);
                object = ((SunJSSE_b7)object3).i();
                if (!Arrays.equals(macData.d(), (byte[])object)) {
                    throw new SecurityException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception exception) {
                object3 = new IOException("Integrity check failed " + exception);
                ((Throwable)object3).initCause(exception);
                throw object3;
            }
        }
        Object[] objectArray = this.u.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            object3 = (SunJSSE_bt)objectArray[i];
            if (((SunJSSE_bt)object3).d == null) continue;
            object4 = new ArrayList();
            object5 = (X509Certificate)this.v.get(new KeyId(((SunJSSE_bt)object3).d));
            while (object5 != null) {
                ((ArrayList)object4).add(object5);
                object = ((X509Certificate)object5).getIssuerX500Principal();
                if (((X500Principal)object).equals(((X509Certificate)object5).getSubjectX500Principal())) break;
                object5 = (X509Certificate)this.v.get(object);
            }
            if (((ArrayList)object4).size() <= 0) continue;
            ((SunJSSE_bt)object3).c = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
        }
        this.v.clear();
        this.u.clear();
    }

    private static byte[] a(SunJSSE_ab sunJSSE_ab, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n = sunJSSE_ab.a(byArray.length);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        n2 = sunJSSE_ab.a(byArray, 0, byArray.length, byArray3, 0);
        if ((n2 += sunJSSE_ab.a(byArray3, n2)) < byArray3.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private static byte[] b(SunJSSE_ab sunJSSE_ab, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n = sunJSSE_ab.a(byArray.length);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        n2 = sunJSSE_ab.b(byArray, 0, byArray.length, byArray3, 0);
        if ((n2 += sunJSSE_ab.b(byArray3, n2)) < byArray3.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private void a(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(PKCS12KeyStore.i)) {
                object5 = new SunJSSE_bt(null);
                ((SunJSSE_bt)object5).b = derValue.toByteArray();
                ((SunJSSE_bt)object5).a = new Date();
                object6 = object5;
            } else if (objectIdentifier.equals(j)) {
                object5 = new DerInputStream(derValue.toByteArray());
                object4 = ((DerInputStream)object5).getSequence(2);
                object3 = object4[0].getOID();
                if (!object4[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object4[1].tag);
                }
                DerValue derValue2 = object4[1].data.getDerValue();
                object2 = CertificateFactory.getInstance("X509");
                object6 = object = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
            }
            try {
                object5 = derInputStream2.getSet(2);
            }
            catch (IOException iOException) {
                object5 = null;
            }
            object4 = null;
            object3 = null;
            if (object5 != null) {
                for (int j = 0; j < ((Object)object5).length; ++j) {
                    DerValue[] derValueArray2;
                    object2 = new DerInputStream(((DerValue)object5[j]).toByteArray());
                    object = ((DerInputStream)object2).getSequence(2);
                    ObjectIdentifier objectIdentifier2 = object[0].getOID();
                    DerInputStream derInputStream3 = new DerInputStream(object[1].toByteArray());
                    try {
                        derValueArray2 = derInputStream3.getSet(1);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Attribute " + objectIdentifier2 + " should have a value " + iOException.getMessage());
                    }
                    if (objectIdentifier2.equals(k)) {
                        object4 = derValueArray2[0].getBMPString();
                        continue;
                    }
                    if (!objectIdentifier2.equals(l)) continue;
                    object3 = derValueArray2[0].getOctetString();
                }
            }
            if (object6 instanceof SunJSSE_bt) {
                SunJSSE_bt sunJSSE_bt = (SunJSSE_bt)object6;
                if (object3 == null) continue;
                sunJSSE_bt.d = (byte[])object3;
                object2 = new String((byte[])object3, "UTF8");
                object = null;
                if (((String)object2).startsWith("Time ")) {
                    try {
                        object = new Date(Long.parseLong(((String)object2).substring(5)));
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                if (object == null) {
                    object = new Date();
                }
                sunJSSE_bt.a = object;
                this.u.add(sunJSSE_bt);
                if (object4 == null) {
                    object4 = this.d();
                }
                sunJSSE_bt.e = object4;
                this.t.put(((String)object4).toLowerCase(), sunJSSE_bt);
                continue;
            }
            if (!(object6 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)object6;
            if (object3 != null && !this.v.containsKey(object2 = new KeyId((byte[])object3))) {
                this.v.put(object2, object6);
            }
            if (object4 != null && !this.v.containsKey(object4)) {
                this.v.put(object4, object6);
            }
            if ((object2 = x509Certificate.getSubjectX500Principal()) == null || this.v.containsKey(object2)) continue;
            this.v.put(object2, object6);
        }
    }

    private String d() {
        return String.valueOf(++p);
    }

    static byte[] a(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 1);
    }

    static byte[] b(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 2);
    }

    static byte[] c(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 3);
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = cArray.length;
        if ((n4 *= 2) > 0) {
            n4 += 2;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < cArray.length) {
            byArray2[n6] = (byte)(cArray[n5] >>> 8 & 0xFF);
            byArray2[n6 + 1] = (byte)(cArray[n5] & 0xFF);
            ++n5;
            n6 += 2;
        }
        n5 = 64;
        n6 = 20;
        int n7 = PKCS12KeyStore.a(n2, n6) / n6;
        byte[] byArray3 = new byte[n5];
        int n8 = PKCS12KeyStore.a(byArray.length, n5);
        int n9 = PKCS12KeyStore.a(byArray2.length, n5);
        byte[] byArray4 = new byte[n8 + n9];
        byte[] byArray5 = new byte[n2];
        Arrays.fill(byArray3, (byte)n3);
        PKCS12KeyStore.a(byArray, byArray4, 0, n8);
        PKCS12KeyStore.a(byArray2, byArray4, n8, n9);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n5];
            byte[] byArray7 = new byte[n5];
            int n10 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                for (int i = 1; i < n; ++i) {
                    byArray8 = messageDigest.digest(byArray8);
                }
                System.arraycopy(byArray8, 0, byArray5, n6 * n10, Math.min(n2, n6));
                if (n10 + 1 != n7) {
                    PKCS12KeyStore.a(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    for (int i = 0; i < byArray4.length; i += n5) {
                        if (byArray7.length != n5) {
                            byArray7 = new byte[n5];
                        }
                        System.arraycopy(byArray4, i, byArray7, 0, n5);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n11 = byArray7.length - n5;
                        if (n11 >= 0) {
                            System.arraycopy(byArray7, n11, byArray4, i, n5);
                            continue;
                        }
                        if (n11 >= 0) continue;
                        Arrays.fill(byArray4, i, i + -n11, (byte)0);
                        System.arraycopy(byArray7, 0, byArray4, i + -n11, byArray7.length);
                    }
                    ++n10;
                    n2 -= n6;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray5;
    }

    private static int a(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void a(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / byArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
    }

    static {
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 840;
        nArray[3] = 113549;
        nArray[4] = 1;
        nArray[5] = 12;
        nArray[6] = 10;
        nArray[7] = 1;
        nArray[8] = 2;
        b = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 840;
        nArray2[3] = 113549;
        nArray2[4] = 1;
        nArray2[5] = 12;
        nArray2[6] = 10;
        nArray2[7] = 1;
        nArray2[8] = 3;
        c = nArray2;
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[1] = 2;
        nArray3[2] = 840;
        nArray3[3] = 113549;
        nArray3[4] = 1;
        nArray3[5] = 9;
        nArray3[6] = 20;
        d = nArray3;
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[1] = 2;
        nArray4[2] = 840;
        nArray4[3] = 113549;
        nArray4[4] = 1;
        nArray4[5] = 9;
        nArray4[6] = 21;
        e = nArray4;
        int[] nArray5 = new int[8];
        nArray5[0] = 1;
        nArray5[1] = 2;
        nArray5[2] = 840;
        nArray5[3] = 113549;
        nArray5[4] = 1;
        nArray5[5] = 9;
        nArray5[6] = 22;
        nArray5[7] = 1;
        f = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 1;
        nArray6[1] = 2;
        nArray6[2] = 840;
        nArray6[3] = 113549;
        nArray6[4] = 1;
        nArray6[5] = 12;
        nArray6[6] = 1;
        nArray6[7] = 6;
        g = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 1;
        nArray7[1] = 2;
        nArray7[2] = 840;
        nArray7[3] = 113549;
        nArray7[4] = 1;
        nArray7[5] = 12;
        nArray7[6] = 1;
        nArray7[7] = 3;
        h = nArray7;
        p = 0;
        try {
            i = new ObjectIdentifier(b);
            j = new ObjectIdentifier(c);
            k = new ObjectIdentifier(d);
            l = new ObjectIdentifier(e);
            m = new ObjectIdentifier(f);
            n = new ObjectIdentifier(g);
            o = new ObjectIdentifier(h);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class KeyId {
        byte[] a;

        KeyId(byte[] byArray) {
            this.a = byArray;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.a.length; ++i) {
                n += this.a[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            return Arrays.equals(this.a, keyId.a);
        }
    }
}

