/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SunJSSE_a1;
import com.sun.net.ssl.internal.ssl.SunJSSE_g;
import com.sun.net.ssl.internal.ssl.SunJSSE_h;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class CipherSuite
implements Comparable,
SunJSSE_g {
    static final int a = 1;
    static final int b = 300;
    static final boolean c = false;
    private static final Map d = new HashMap();
    private static final Map e = new HashMap();
    private static final Map f = new HashMap();
    private static final Map g = new HashMap();
    final String h;
    final int i;
    final int j;
    final KeyExchange k;
    final BulkCipher l;
    final MacAlg m;
    final boolean n;
    final boolean o;
    static final CipherSuite p;

    private CipherSuite(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl) {
        this.h = string;
        this.i = n;
        this.j = n2;
        this.k = keyExchange;
        this.l = bulkCipher;
        this.n = bulkCipher.g;
        if (string.endsWith("_MD5")) {
            this.m = SunJSSE_g.M_MD5;
        } else if (string.endsWith("_SHA")) {
            this.m = SunJSSE_g.M_SHA;
        } else if (string.endsWith("_NULL")) {
            this.m = SunJSSE_g.M_NULL;
        } else if (string.endsWith("_SCSV")) {
            this.m = SunJSSE_g.M_NULL;
        } else {
            throw new IllegalArgumentException("Unknown MAC algorithm for ciphersuite " + string);
        }
        bl &= keyExchange.b;
        this.o = bl &= bulkCipher.c;
    }

    private CipherSuite(String string, int n) {
        this.h = string;
        this.i = n;
        this.o = false;
        this.j = 0;
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = false;
    }

    boolean a() {
        return this.o && this.l.a();
    }

    boolean b() {
        return this != p && this.a();
    }

    public int compareTo(Object object) {
        return ((CipherSuite)object).j - this.j;
    }

    public String toString() {
        return this.h;
    }

    static CipherSuite a(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        CipherSuite cipherSuite = (CipherSuite)e.get(string);
        if (cipherSuite == null) {
            cipherSuite = (CipherSuite)g.get(string);
        }
        if (cipherSuite == null || !cipherSuite.o) {
            throw new IllegalArgumentException("Unsupported ciphersuite " + string);
        }
        return cipherSuite;
    }

    static CipherSuite a(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        CipherSuite cipherSuite = (CipherSuite)d.get(new Integer(n3));
        if (cipherSuite == null) {
            String string = Integer.toString(n, 16);
            String string2 = Integer.toString(n2, 16);
            cipherSuite = new CipherSuite("Unknown 0x" + string + ":0x" + string2, n3);
        }
        return cipherSuite;
    }

    static CipherSuite a(CipherSuite cipherSuite) {
        CipherSuite cipherSuite2 = d.containsValue(cipherSuite) ? (CipherSuite)f.get(new Integer(cipherSuite.i)) : (CipherSuite)d.get(new Integer(cipherSuite.i));
        if (cipherSuite2 == null) {
            cipherSuite2 = cipherSuite;
        }
        return cipherSuite2;
    }

    static Collection c() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(e.values());
        arrayList.remove(p);
        return arrayList;
    }

    private static void a(String string, int n, int n2, KeyExchange keyExchange, BulkCipher bulkCipher, boolean bl) {
        CipherSuite cipherSuite = new CipherSuite(string, n, n2, keyExchange, bulkCipher, bl);
        if (d.put(new Integer(n), cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
        if (cipherSuite.o && e.put(string, cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    private static void a(String string, int n) {
        CipherSuite cipherSuite = new CipherSuite(string, n);
        if (d.put(new Integer(n), cipherSuite) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + n + ", " + string);
        }
    }

    private static void a(String string, String string2, int n) {
        CipherSuite cipherSuite = (CipherSuite)e.get(string);
        if (cipherSuite == null) {
            throw new RuntimeException("Invalid ciphersuite name: " + string);
        }
        CipherSuite cipherSuite2 = new CipherSuite(string2, cipherSuite.i, n, cipherSuite.k, cipherSuite.l, cipherSuite.o);
        if (f.put(new Integer(cipherSuite2.i), cipherSuite2) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + cipherSuite2.i + ", " + cipherSuite2.h);
        }
        if (cipherSuite2.o && g.put(cipherSuite2.h, cipherSuite2) != null) {
            throw new RuntimeException("Duplicate ciphersuite definition: " + cipherSuite2.i + ", " + cipherSuite2.h);
        }
    }

    static {
        CipherSuite.a("SSL_NULL_WITH_NULL_NULL", 0, 1, SunJSSE_g.K_NULL, SunJSSE_g.B_NULL, false);
        CipherSuite.a("SSL_RSA_WITH_RC4_128_MD5", 4, 950, SunJSSE_g.K_RSA, SunJSSE_g.B_RC4_128, true);
        CipherSuite.a("SSL_RSA_WITH_RC4_128_SHA", 5, 940, SunJSSE_g.K_RSA, SunJSSE_g.B_RC4_128, true);
        CipherSuite.a("TLS_RSA_WITH_AES_128_CBC_SHA", 47, 830, SunJSSE_g.K_RSA, SunJSSE_g.B_AES_128, true);
        CipherSuite.a("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51, 825, SunJSSE_g.K_DHE_RSA, SunJSSE_g.B_AES_128, true);
        CipherSuite.a("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50, 820, SunJSSE_g.K_DHE_DSS, SunJSSE_g.B_AES_128, true);
        CipherSuite.a("SSL_RSA_WITH_3DES_EDE_CBC_SHA", 10, 650, SunJSSE_g.K_RSA, SunJSSE_g.B_3DES, true);
        CipherSuite.a("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22, 640, SunJSSE_g.K_DHE_RSA, SunJSSE_g.B_3DES, true);
        CipherSuite.a("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19, 630, SunJSSE_g.K_DHE_DSS, SunJSSE_g.B_3DES, true);
        CipherSuite.a("SSL_RSA_WITH_DES_CBC_SHA", 9, 550, SunJSSE_g.K_RSA, SunJSSE_g.B_DES, true);
        CipherSuite.a("SSL_DHE_RSA_WITH_DES_CBC_SHA", 21, 540, SunJSSE_g.K_DHE_RSA, SunJSSE_g.B_DES, true);
        CipherSuite.a("SSL_DHE_DSS_WITH_DES_CBC_SHA", 18, 530, SunJSSE_g.K_DHE_DSS, SunJSSE_g.B_DES, true);
        CipherSuite.a("SSL_RSA_EXPORT_WITH_RC4_40_MD5", 3, 350, SunJSSE_g.K_RSA_EXPORT, SunJSSE_g.B_RC4_40, true);
        CipherSuite.a("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", 8, 340, SunJSSE_g.K_RSA_EXPORT, SunJSSE_g.B_DES_40, true);
        CipherSuite.a("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", 20, 335, SunJSSE_g.K_DHE_RSA, SunJSSE_g.B_DES_40, true);
        CipherSuite.a("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", 17, 330, SunJSSE_g.K_DHE_DSS, SunJSSE_g.B_DES_40, true);
        CipherSuite.a("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", 255, 301, SunJSSE_g.K_SCSV, SunJSSE_g.B_NULL, true);
        CipherSuite.a("TLS_RSA_WITH_AES_256_CBC_SHA", 53, 290, SunJSSE_g.K_RSA, SunJSSE_g.B_AES_256, true);
        CipherSuite.a("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57, 285, SunJSSE_g.K_DHE_RSA, SunJSSE_g.B_AES_256, true);
        CipherSuite.a("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56, 280, SunJSSE_g.K_DHE_DSS, SunJSSE_g.B_AES_256, true);
        CipherSuite.a("SSL_RSA_WITH_NULL_MD5", 1, 250, SunJSSE_g.K_RSA, SunJSSE_g.B_NULL, true);
        CipherSuite.a("SSL_RSA_WITH_NULL_SHA", 2, 240, SunJSSE_g.K_RSA, SunJSSE_g.B_NULL, true);
        CipherSuite.a("SSL_DH_anon_WITH_RC4_128_MD5", 24, 190, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_RC4_128, true);
        CipherSuite.a("TLS_DH_anon_WITH_AES_128_CBC_SHA", 52, 185, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_AES_128, true);
        CipherSuite.a("TLS_DH_anon_WITH_AES_256_CBC_SHA", 58, 182, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_AES_256, true);
        CipherSuite.a("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", 27, 180, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_3DES, true);
        CipherSuite.a("SSL_DH_anon_WITH_DES_CBC_SHA", 26, 150, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_DES, true);
        CipherSuite.a("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", 23, 130, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_RC4_40, true);
        CipherSuite.a("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", 25, 120, SunJSSE_g.K_DH_ANON, SunJSSE_g.B_DES_40, true);
        CipherSuite.a("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", 6);
        CipherSuite.a("SSL_RSA_WITH_IDEA_CBC_SHA", 7);
        CipherSuite.a("SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", 11);
        CipherSuite.a("SSL_DH_DSS_WITH_DES_CBC_SHA", 12);
        CipherSuite.a("SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", 13);
        CipherSuite.a("SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", 14);
        CipherSuite.a("SSL_DH_RSA_WITH_DES_CBC_SHA", 15);
        CipherSuite.a("SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", 16);
        CipherSuite.a("SSL_FORTEZZA_DMS_WITH_NULL_SHA", 28);
        CipherSuite.a("SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA", 29);
        CipherSuite.a("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", 98);
        CipherSuite.a("SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA", 99);
        CipherSuite.a("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", 100);
        CipherSuite.a("SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA", 101);
        CipherSuite.a("SSL_DHE_DSS_WITH_RC4_128_SHA", 102);
        CipherSuite.a("TLS_KRB5_WITH_DES_CBC_SHA", 30);
        CipherSuite.a("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", 31);
        CipherSuite.a("TLS_KRB5_WITH_RC4_128_SHA", 32);
        CipherSuite.a("TLS_KRB5_WITH_IDEA_CBC_SHA", 33);
        CipherSuite.a("TLS_KRB5_WITH_DES_CBC_MD5", 34);
        CipherSuite.a("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", 35);
        CipherSuite.a("TLS_KRB5_WITH_RC4_128_MD5", 36);
        CipherSuite.a("TLS_KRB5_WITH_IDEA_CBC_MD5", 37);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", 38);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", 39);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", 40);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", 41);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", 42);
        CipherSuite.a("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", 43);
        CipherSuite.a("NETSCAPE_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65504);
        CipherSuite.a("NETSCAPE_RSA_FIPS_WITH_DES_CBC_SHA", 65505);
        CipherSuite.a("SSL_RSA_FIPS_WITH_DES_CBC_SHA", 65278);
        CipherSuite.a("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", 65279);
        CipherSuite.a("TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", 100);
        CipherSuite.a("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", 99);
        CipherSuite.a("SSL_RSA_WITH_DES_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA", 98);
        CipherSuite.a("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", 97);
        CipherSuite.a("SSL_RSA_WITH_NULL_MD5", "TLS_RSA_WITH_NULL_MD5", 96);
        CipherSuite.a("SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_NULL_SHA", 95);
        p = CipherSuite.a(0, 255);
    }

    static final class MacAlg {
        final String a;
        final int b;

        MacAlg(String string, int n) {
            this.a = string;
            this.b = n;
        }

        SunJSSE_a1 a(ProtocolVersion protocolVersion, byte[] byArray) throws NoSuchAlgorithmException {
            return new SunJSSE_a1(this, protocolVersion, byArray);
        }

        public String toString() {
            return this.a;
        }
    }

    static final class BulkCipher {
        private static final Map a = new HashMap(8);
        final String b;
        final boolean c;
        final int d;
        final int e;
        final int f;
        final boolean g;

        BulkCipher(String string, int n, int n2, int n3, boolean bl) {
            this.b = string;
            this.d = n;
            this.f = n3;
            this.c = bl;
            this.e = n2;
            this.g = true;
        }

        BulkCipher(String string, int n, int n2, boolean bl) {
            this.b = string;
            this.d = n;
            this.f = n2;
            this.c = bl;
            this.e = n;
            this.g = false;
        }

        SunJSSE_h a(ProtocolVersion protocolVersion, byte[] byArray, byte[] byArray2, boolean bl) throws NoSuchAlgorithmException {
            return SunJSSE_h.a(protocolVersion, this, byArray, byArray2, bl);
        }

        boolean a() {
            if (!this.c) {
                return false;
            }
            if (this == SunJSSE_g.B_AES_256) {
                return BulkCipher.a(this);
            }
            return true;
        }

        static synchronized void b() {
        }

        private static synchronized boolean a(BulkCipher bulkCipher) {
            Boolean bl = (Boolean)a.get(bulkCipher);
            if (bl == null) {
                try {
                    byte[] byArray = new byte[bulkCipher.e];
                    byte[] byArray2 = new byte[bulkCipher.f];
                    bulkCipher.a(ProtocolVersion.g, byArray, byArray2, true);
                    bl = Boolean.TRUE;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    bl = Boolean.FALSE;
                }
                a.put(bulkCipher, bl);
            }
            return bl;
        }

        public String toString() {
            return this.b;
        }
    }

    static final class KeyExchange {
        final String a;
        final boolean b;

        KeyExchange(String string, boolean bl) {
            this.a = string;
            this.b = bl;
        }

        public String toString() {
            return this.a;
        }
    }
}

