/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import com.sun.security.cert.CertPathValidatorException;
import com.sun.security.cert.PKIXCertPathChecker;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import sun.security.x509.AlgorithmId;

public final class AlgorithmChecker
extends PKIXCertPathChecker {
    private static final String[] disabledAlgorithms = new String[]{"md2"};
    static final AlgorithmChecker INSTANCE = new AlgorithmChecker();

    private AlgorithmChecker() {
    }

    static AlgorithmChecker getInstance() {
        return INSTANCE;
    }

    public void init(boolean bl) throws CertPathValidatorException {
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        AlgorithmChecker.check(certificate);
    }

    public static void check(Certificate certificate) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        AlgorithmChecker.check(x509Certificate.getSigAlgName());
    }

    static void check(AlgorithmId algorithmId) throws CertPathValidatorException {
        AlgorithmChecker.check(algorithmId.getName());
    }

    static void check(X509CRL x509CRL) throws CertPathValidatorException {
        AlgorithmChecker.check(x509CRL.getSigAlgName());
    }

    private static void check(String string) throws CertPathValidatorException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = "";
        for (int i = 0; i < disabledAlgorithms.length; ++i) {
            string3 = disabledAlgorithms[i];
            if (string2.indexOf(string3) == -1) continue;
            throw new CertPathValidatorException("algorithm check failed: " + string + " is disabled");
        }
    }
}

