/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.cert;

import com.sun.security.cert.CertPathBuilderException;
import com.sun.security.cert.CertPathBuilderResult;
import com.sun.security.cert.CertPathBuilderSpi;
import com.sun.security.cert.CertPathParameters;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import sun.security.util.Debug;

public class CertPathBuilder {
    private static final String CPB_TYPE = "certpathbuilder.type";
    private static final Debug debug = Debug.getInstance("certpath");
    private CertPathBuilderSpi builderSpi;
    private Provider provider;
    private String algorithm;
    private static final Class cl = Security.class;
    private static final Class[] GET_IMPL_PARAMS = new Class[]{String.class, String.class, String.class};
    private static final Class[] GET_IMPL_PARAMS2 = new Class[]{String.class, String.class, Provider.class};
    private static Method implMethod;
    private static Method implMethod2;
    private static Boolean implMethod2Set;

    protected CertPathBuilder(CertPathBuilderSpi certPathBuilderSpi, Provider provider, String string) {
        this.builderSpi = certPathBuilderSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (implMethod == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, string, "CertPathBuilder", null);
            return new CertPathBuilder((CertPathBuilderSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            if (implMethod == null) {
                throw new NoSuchAlgorithmException(string + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, string, "CertPathBuilder", string2);
            return new CertPathBuilder((CertPathBuilderSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable != null) {
                if (throwable instanceof NoSuchProviderException) {
                    throw (NoSuchProviderException)throwable;
                }
                if (throwable instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)throwable;
                }
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Object[] objectArray;
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        if (!implMethod2Set.booleanValue()) {
            objectArray = implMethod2Set;
            // MONITORENTER : implMethod2Set
            if (!implMethod2Set.booleanValue()) {
                implMethod2 = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Method method;
                        block3: {
                            method = null;
                            try {
                                method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS2);
                                if (method != null) {
                                    method.setAccessible(true);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                if (debug == null) break block3;
                                debug.println("CertPathBuilder.getInstance(): Cannot find Security.getImpl(String, String, Provider)");
                            }
                        }
                        return method;
                    }
                });
                implMethod2Set = new Boolean(true);
            }
            // MONITOREXIT : objectArray
        }
        if (implMethod2 == null) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        try {
            objectArray = (Object[])implMethod2.invoke(null, string, "CertPathBuilder", provider);
            return new CertPathBuilder((CertPathBuilderSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(illegalAccessException);
            throw noSuchAlgorithmException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string + " not found");
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.builderSpi.engineBuild(certPathParameters);
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(CertPathBuilder.CPB_TYPE);
            }
        });
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }

    static {
        implMethod2Set = new Boolean(false);
        implMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS);
                    if (method != null) {
                        method.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }
}

