/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.CtrlHierTypeBinding;
import oracle.adfdt.model.objects.ElementInterface;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.transaction.Task;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.BasePanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXGraphBindingPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.layout.GraphAttributeList;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.DvtCtrlHierEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.GraphEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.resource.DvtBindingResources;
import oracle.adfdtinternal.model.ide.jdev.JdevUtils;
import oracle.binding.meta.StructureDefinition;
import org.w3c.dom.Element;

public class AMXGraphEditor
extends GraphEditor {
    protected static final Map m_rowsetTextMap = new HashMap();

    public AMXGraphEditor(ControlBinding def) {
        super(def);
        this.setEditorType(DvtCtrlHierEditor.EditorType.GRAPH);
    }

    protected BasePanel getRowsetEditPanel() {
        AMXGraphBindingPanel basePanel = new AMXGraphBindingPanel(this.getControlDef());
        this.setHelpUrl(this.getHelpTopicID());
        return basePanel;
    }

    public void commit() {
        AMXGraphBindingPanel panel = (AMXGraphBindingPanel)this.getBindingUiPanel();
        panel.commit();
    }

    protected void panelCanceled() {
        AMXGraphBindingPanel panel = (AMXGraphBindingPanel)this.getBindingUiPanel();
        panel.getBindPanel().cancel();
    }

    protected String getInstructionText() {
        if (this.m_isHierPanel) {
            return DvtBindingResources.getResource((String)"GRAPH_CREATE_HIER_BINDING_DESC");
        }
        if (this.getBindingUiContext().getGraphCategory() != BindingUiContext.GraphCategory.GRAPH) {
            String key;
            String graphTypeName = this.getBindingUiContext().getGraphTypeName();
            BindingUiContext.GraphCategory graphCategoryName = this.getBindingUiContext().getGraphCategory();
            if (graphTypeName != null && graphTypeName.length() > 0 && (key = graphCategoryName != BindingUiContext.GraphCategory.SPARKCHART ? (String)m_rowsetTextMap.get(graphTypeName + "_instText") : (String)m_rowsetTextMap.get(graphTypeName + "_SPARKCHART_instText")) != null && key.length() > 0) {
                return DvtBindingResources.getResource((String)key);
            }
        }
        return "";
    }

    public void saveToDef() {
        try {
            CtrlHier def = (CtrlHier)this.getControlDef();
            Task task1 = new Task(){

                public void run() {
                    CtrlHier def = (CtrlHier)AMXGraphEditor.this.getControlDef();
                    def.removeChildNodes();
                    CtrlHierTypeBinding[] ctrlBnd = AMXGraphEditor.this.getAllRules();
                    for (int i = 0; ctrlBnd != null && i < ctrlBnd.length; ++i) {
                        try {
                            def.appendChild((ElementInterface)ctrlBnd[i]);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            };
            def.getTransactionManager().runTaskUnderTransaction("init1", task1);
            PageDefinition pageDef = this.getControlDef().getBindingContainer();
            Element elem = pageDef.findChild("ResourceBundle");
            if (elem == null && JdevUtils.getPageDefinitionNodeObject((PageDefinition)pageDef) != null) {
                JdevUtils.getPageDefinitionNodeObject((PageDefinition)pageDef).updateNodeJavaFilesGenerated();
                JdevUtils.getPageDefinitionNodeObject((PageDefinition)pageDef).saveBean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isPreviewAvailable() {
        return false;
    }

    protected String getHelpTopicID() {
        String strHelpTopicID = "f1_adfmf_dvt_graph_overview_html";
        if (this.isSparkchart()) {
            strHelpTopicID = "f1_adfmf_dvt_graph_spark_chart_html";
        }
        return strHelpTopicID;
    }

    public CtrlHierTypeBinding[] getAllRules() {
        CtrlHierTypeBinding newRule = ((CtrlHier)this.getControlDef()).createJUDTCtrlHierTypeBindingClass();
        Element element = this.getControlDef().getOwnerDocument().createElementNS("http://xmlns.oracle.com/adfm/uimodel", "nodeDefinition");
        newRule.initializeFromElement(this.getControlDef().getTransactionManager(), element);
        String ctrlBindingId = this.getControlDef().getId();
        StructureDefinition sd = this.getControlDef().getIteratorBinding().getDefinition();
        newRule.setViewDefName(sd.getFullName());
        newRule.setTypebindingName(ctrlBindingId + "0");
        AMXGraphBindingPanel bindingPanel = (AMXGraphBindingPanel)this.getBindingUiPanel();
        List allAttrDefs = bindingPanel.getAttributeList().getAttributeDefinitions();
        ArrayList<String> allAttrNames = new ArrayList<String>();
        for (GraphAttributeList.LayoutAttributeDefinition attr : allAttrDefs) {
            allAttrNames.add(attr.getName());
        }
        List usedAttributes = bindingPanel.getBindPanel().getAllCurrentlyUsedAttributeNames(allAttrNames);
        if (bindingPanel.getBindPanel().isNameValuePair()) {
            AMXGraphPanel graphPanel = (AMXGraphPanel)bindingPanel.getBindPanel();
            String qualifier = graphPanel.getQualifier();
            String value = graphPanel.getValue();
            if (qualifier != null && qualifier.length() > 0) {
                usedAttributes.add(qualifier);
            }
            if (value != null && qualifier.length() > 0) {
                usedAttributes.add(value);
            }
        }
        String[] attrNames = new String[usedAttributes.size()];
        usedAttributes.toArray(attrNames);
        newRule.setAttrNames(attrNames);
        return new CtrlHierTypeBinding[]{newRule};
    }

    static {
        m_rowsetTextMap.put("AREA_VERT_ABS_instText", "CHART_AREA_DIALOG_DESC");
        m_rowsetTextMap.put("BAR_VERT_CLUST_instText", "CHART_BAR_DIALOG_DESC");
        m_rowsetTextMap.put("BAR_HORIZ_CLUST_instText", "CHART_HORZ_BAR_DIALOG_DESC");
        m_rowsetTextMap.put("LINE_VERT_ABS_instText", "CHART_LINE_DIALOG_DESC");
        m_rowsetTextMap.put("COMBINATION_VERT_ABS_instText", "CHART_COMBO_DIALOG_DESC");
        m_rowsetTextMap.put("PIE_instText", "CHART_PIE_DIALOG_DESC");
        m_rowsetTextMap.put("SCATTER_instText", "CHART_SCATTER_DIALOG_DESC");
        m_rowsetTextMap.put("BUBBLE_instText", "CHART_BUBBLE_DIALOG_DESC");
    }
}

