/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.editors;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlAttrs;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.CtrlValue;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.view.rich.binding.util.JSFExpressionUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.AMXGaugeBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.DvtDataBindingDtUtilsTrinidad;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtilsBindings;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.AMXGaugeBindPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.BasePanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.DataSourcePickerPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.RowsetRow;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.Threshold;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.CubicHierEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.DvtCtrlHierEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.resource.DvtBindingResources;
import oracle.adfdtinternal.model.dvt.ide.objects.utils.ADFmUtilsTrinidad;
import oracle.adfdtinternal.model.dvt.objects.DvtBaseElementObject;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMXGaugeEditor
extends CubicHierEditor {
    public static final String RATING_GAUGE_STAR = "star";
    public static final String RATING_GAUGE_CIRCLE = "circle";
    public static final String RATING_GAUGE_RECTANGLE = "rectangle";
    public static final String RATING_GAUGE_DIAMOND = "diamond";
    AMXGaugeProperties m_gaugeProperties = new AMXGaugeProperties();
    List<Threshold> m_thresholds = new ArrayList<Threshold>();
    protected String m_selectedShapeProp;
    protected Element m_gauge;
    protected JEWTDialog m_dialog = null;
    protected String LOW = DvtBindingResources.getResource((String)"GAUGE_DEFAULT_THRESHOLD_LABEL_LOW");
    protected String MEDIUM = DvtBindingResources.getResource((String)"GAUGE_DEFAULT_THRESHOLD_LABEL_MEDIUM");
    protected String HIGH = DvtBindingResources.getResource((String)"GAUGE_DEFAULT_THRESHOLD_LABEL_HIGH");
    public static final String LP_NONE = "LP_NONE";
    public static final String FACES_NS = "http://xmlns.oracle.com/adf/faces/rich";
    protected CtrlAttrs m_metricBinding = null;
    protected CtrlAttrs m_minValBinding = null;
    protected CtrlAttrs m_maxValBinding = null;
    HashMap<Threshold, CtrlAttrs> m_thresholdsBindings = new HashMap();
    static Logger _logger = Logger.getLogger("AMXGaugeEditor");
    public static final String DIAL_BACKGROUND_CIRCLE_ANTIQUE = "circleAntique";
    public static final String DIAL_BACKGROUND_CIRCLE_ANTIQUE_CUSTOM = "circleAntiqueCustom";
    public static final String DIAL_BACKGROUND_CIRCLE_DARK = "circleDark";
    public static final String DIAL_BACKGROUND_CIRCLE_DARK_CUSTOM = "circleDarkCustom";
    public static final String DIAL_BACKGROUND_CIRCLE_LIGHT = "circleLight";
    public static final String DIAL_BACKGROUND_CIRCLE_LIGHT_CUSTOM = "circleLightCustom";
    public static final String DIAL_BACKGROUND_RECTANGLE_ANTIQUE = "rectangleAntique";
    public static final String DIAL_BACKGROUND_RECTANGLE_ANTIQUE_CUSTOM = "rectangleAntiqueCustom";
    public static final String DIAL_BACKGROUND_RECTANGLE_DARK = "rectangleDark";
    public static final String DIAL_BACKGROUND_RECTANGLE_DARK_CUSTOM = "rectangleDarkCustom";
    public static final String DIAL_BACKGROUND_RECTANGLE_LIGHT = "rectangleLight";
    public static final String DIAL_BACKGROUND_RECTANGLE_LIGHT_CUSTOM = "rectangleLightCustom";
    public static final String DIAL_BACKGROUND_DOME_ANTIQUE = "domeAntique";
    public static final String DIAL_BACKGROUND_DOME_ANTIQUE_CUSTOM = "domeAntiqueCustom";
    public static final String DIAL_BACKGROUND_DOME_DARK = "domeDark";
    public static final String DIAL_BACKGROUND_DOME_DARK_CUSTOM = "domeDarkCustom";
    public static final String DIAL_BACKGROUND_DOME_LIGHT = "domeLight";
    public static final String DIAL_BACKGROUND_DOME_LIGHT_CUSTOM = "domeLightCustom";
    public static final String DIAL_INDICATOR_NEEDLE_ANTIQUE = "needleAntique";
    public static final String DIAL_INDICATOR_NEEDLE_DARK = "needleDark";
    public static final String DIAL_INDICATOR_NEEDLE_LIGHT = "needleLight";
    protected String m_dialBackgroundProp;
    protected String m_dialIndicatorProp;

    public AMXGaugeEditor(ControlBinding def) {
        super(def);
        this.setHelpUrl(this.getHelpTopicID());
        this.setEditorType(DvtCtrlHierEditor.EditorType.GAUGE);
    }

    public String getCurrentSelectedShapeName() {
        return this.getGauge().getAttribute("shape");
    }

    public String getSelectedShapeName() {
        return this.m_selectedShapeProp;
    }

    public void setSelectedShapeName(String property) {
        this.m_selectedShapeProp = property;
    }

    public List<String> getSelectedShapeNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(RATING_GAUGE_STAR);
        names.add(RATING_GAUGE_CIRCLE);
        names.add(RATING_GAUGE_RECTANGLE);
        names.add(RATING_GAUGE_DIAMOND);
        return names;
    }

    protected String getHelpTopicID() {
        String strHelpTopicID = "f1_adfmf_dvt_gauge_row_set_html";
        return strHelpTopicID;
    }

    protected BasePanel createBindingUiPanel() {
        this.m_gauge = this.getGaugeNode();
        AMXGaugeBindPanel panel = new AMXGaugeBindPanel(this.getControlDef(), this);
        if (panel != null) {
            panel.setBindingUiContext(this.getBindingUiContext());
            panel.setEditor(this);
            panel.initialize();
        }
        return panel;
    }

    public boolean isPreviewAvailable() {
        return false;
    }

    protected void validateNumericValue(String value, StructureDefinition sDef) throws PropertyVetoException {
        if (value != null && !ADFmUtilsTrinidad.isNumericAttribute((String)value, (StructureDefinition)sDef)) {
            String error = MessageFormat.format(DvtBindingResources.getResource((String)"VALUE_MUST_BE_NUMERIC"), value);
            DvtDataBindingDtUtilsTrinidad.showErrorDialog((CubicHierEditor)this, (String)error);
        }
    }

    boolean validateNumericLiteral(CubicHierEditor editor, String value) throws PropertyVetoException {
        boolean bRetVal = true;
        if (value != null) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e1) {
                try {
                    Double.parseDouble(value);
                }
                catch (Exception e2) {
                    String error = MessageFormat.format(DvtBindingResources.getResource((String)"VALUE_MUST_BE_NUMERIC"), value);
                    DvtDataBindingDtUtilsTrinidad.showErrorDialog((CubicHierEditor)editor, (String)error);
                    bRetVal = false;
                }
            }
        } else {
            bRetVal = false;
        }
        return bRetVal;
    }

    public void validateEditPanel() throws PropertyVetoException {
        String resourceID;
        boolean _isliteral;
        StructureDefinition sDef = this.getControlDef().getIteratorBinding().getDefinition();
        String value = null;
        value = this.getGaugeTagProperties().getValue();
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        if (value == null) {
            String error = DvtBindingResources.getResource((String)"GAUGE_METRIC_CANNOT_EMPTY");
            DvtDataBindingDtUtilsTrinidad.showErrorDialog((CubicHierEditor)this, (String)error);
        }
        this.validateNumericValue(value, sDef);
        value = this.getGaugeTagProperties().getMinValue();
        String string = value = value == null ? "" : value;
        if (value.equals("")) {
            value = "0";
        }
        if (!(_isliteral = this.isLiteral(value))) {
            this.validateNumericValue(value, sDef);
        } else {
            this.validateNumericLiteral(this, value);
        }
        value = this.getGaugeTagProperties().getMaxValue();
        String string2 = value = value == null ? "" : value;
        if (value.equals("")) {
            value = "100";
        }
        if (!(_isliteral = this.isLiteral(value))) {
            this.validateNumericValue(value, sDef);
        } else {
            this.validateNumericLiteral(this, value);
        }
        boolean tresholdsFound = false;
        String dup = null;
        StringBuffer errorFld = new StringBuffer();
        List<Threshold> thresholds = this.m_thresholds;
        if (thresholds != null && thresholds.size() > 0) {
            tresholdsFound = true;
            Threshold _th = null;
            ArrayList<String> inUsedAttrs = new ArrayList<String>();
            int index = 0;
            for (int i = 0; i < thresholds.size() - 1; ++i) {
                ++index;
                _th = thresholds.get(i);
                String _thVal = _th.getMaxValue();
                if (_thVal == null || _thVal.trim().length() == 0) {
                    if (errorFld.length() == 0) {
                        errorFld.append(index);
                        continue;
                    }
                    errorFld.append(", " + index);
                    continue;
                }
                if (inUsedAttrs.contains(_thVal)) {
                    dup = _thVal;
                    continue;
                }
                inUsedAttrs.add(_thVal);
                if (!this.isLiteral(_thVal)) {
                    this.validateNumericValue(_thVal, sDef);
                    continue;
                }
                this.validateNumericLiteral(this, _thVal);
            }
        }
        String error = null;
        BindingUiContext hBindingUIContext = this.getBindingUiContext();
        boolean requireTresholds = true;
        Object _o = hBindingUIContext.get((Object)"Gauge Threshold");
        requireTresholds = _o == null ? false : (_o instanceof Boolean ? (Boolean)_o : false);
        if (!tresholdsFound && requireTresholds) {
            resourceID = "GAUGE_THRESHOLDS_MISSING";
            error = DvtBindingResources.getResource((String)resourceID);
        } else if (errorFld.length() != 0) {
            resourceID = "GAUGE_THRESHOLD_CANNOT_EMPTY";
            error = MessageFormat.format(DvtBindingResources.getResource((String)resourceID), errorFld.toString());
        } else if (dup != null) {
            resourceID = "DUPLICATE_ATTRIBUTE_NAME";
            error = MessageFormat.format(DvtBindingResources.getResource((String)resourceID), dup);
        }
        if (error != null && error.length() > 0) {
            DvtDataBindingDtUtilsTrinidad.showErrorDialog((CubicHierEditor)this, (String)error);
        }
    }

    public void saveToDef() {
        Task task = new Task(){
            ADFDesignTimeContext dtContext;
            {
                this.dtContext = AMXGaugeEditor.this.getBindingUiContext().getADFDesignTimeContext();
            }

            public void run() {
                ControlBinding binding = AMXGaugeEditor.this.getControlDef();
                if (binding instanceof CtrlAttrs) {
                    List<Threshold> thresholds;
                    NodeList nodes;
                    String expression;
                    HashMap<String, String> properties;
                    String bindingId;
                    boolean isLiteral;
                    String strLabelDisplay;
                    ControlBinding _control;
                    String value;
                    AMXGaugeEditor.this.setMetricControlBinding((CtrlAttrs)binding);
                    PageDefinition container = binding.getBindingContainer();
                    String iteratorBindingId = binding.getIteratorBinding().getId();
                    if (AMXGaugeEditor.this.isAccessorDefinition()) {
                        value = AMXGaugeEditor.this.getGaugeTagProperties().getValue();
                        try {
                            String[] attributes = AMXGaugeEditor.this.getMetricControlBinding().getAttrNames();
                            if (attributes != null) {
                                String bindingId2;
                                if (attributes.length != 1) {
                                    AMXGaugeEditor.this.getMetricControlBinding().removeChildNodes();
                                    AMXGaugeEditor.this.getMetricControlBinding().addAttrName(value);
                                    bindingId2 = value;
                                    ControlBinding _control2 = container.findControlBinding(bindingId2);
                                    if (_control2 != null) {
                                        bindingId2 = AMXGaugeEditor.this.getUniqueBindingId(container, bindingId2, 1);
                                    }
                                    AMXGaugeEditor.this.getMetricControlBinding().setId(bindingId2);
                                } else {
                                    String attrValue = AMXGaugeEditor.this.getMetricControlBinding().getFirstAttribute();
                                    if (!attrValue.equals(value)) {
                                        bindingId2 = value;
                                        AMXGaugeEditor.this.getMetricControlBinding().removeChildNodes();
                                        AMXGaugeEditor.this.getMetricControlBinding().addAttrName(value);
                                        _control = container.findControlBinding(bindingId2);
                                        if (_control != null) {
                                            bindingId2 = AMXGaugeEditor.this.getUniqueBindingId(container, bindingId2, 1);
                                        }
                                        AMXGaugeEditor.this.getMetricControlBinding().setId(bindingId2);
                                    }
                                    bindingId2 = AMXGaugeEditor.this.getMetricControlBinding().getId();
                                }
                                String expression2 = JSFExpressionUtils.createBaseExpression((String)bindingId2, (String)"inputValue");
                                if (AMXGaugeEditor.this.getGaugeNode() != null) {
                                    AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "value", expression2);
                                }
                            }
                        }
                        catch (Exception e) {
                            _logger.log(Level.INFO, "Changing the binding id was not successful.");
                        }
                    }
                    String string = strLabelDisplay = AMXGaugeEditor.this.getGaugeTagProperties() != null ? AMXGaugeEditor.this.getGaugeTagProperties().getLabelDisplay() : null;
                    if (strLabelDisplay != null && strLabelDisplay.equalsIgnoreCase("on")) {
                        AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "labelDisplay", strLabelDisplay);
                    } else {
                        AMXGaugeEditor.this.getGaugeNode().removeAttributeNS(null, "labelDisplay");
                    }
                    value = AMXGaugeEditor.this.getGaugeTagProperties().getMinValue();
                    if (value == null) {
                        value = "";
                    }
                    if (isLiteral = AMXGaugeEditor.this.isLiteral(value)) {
                        if (AMXGaugeEditor.this.getGaugeNode() != null) {
                            if (value.length() > 0) {
                                AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "minValue", value);
                            } else {
                                AMXGaugeEditor.this.getGaugeNode().removeAttributeNS(null, "minValue");
                            }
                        }
                    } else {
                        bindingId = value;
                        if (AMXGaugeEditor.this.getMinValueControlBinding() == null) {
                            _control = container.findControlBinding(bindingId);
                            if (_control != null) {
                                bindingId = AMXGaugeEditor.this.getUniqueBindingId(container, bindingId, 1);
                            }
                            properties = new HashMap<String, String>();
                            properties.put("IterBinding", iteratorBindingId);
                            properties.put("id", bindingId);
                            _control = container.createControlBinding("DCTextField", properties);
                            container.addControlBinding(_control);
                            if (_control instanceof CtrlAttrs) {
                                AMXGaugeEditor.this.setMinValueControlBinding((CtrlAttrs)_control);
                                AMXGaugeEditor.this.getMinValueControlBinding().addAttrName(value);
                            }
                        } else {
                            AMXGaugeEditor.this.getMinValueControlBinding().removeChildNodes();
                            AMXGaugeEditor.this.getMinValueControlBinding().addAttrName(value);
                        }
                        expression = JSFExpressionUtils.createBaseExpression((String)bindingId, (String)"inputValue");
                        AMXGaugeEditor.this.getGaugeTagProperties().setMinValue(expression);
                        if (AMXGaugeEditor.this.getGaugeNode() != null) {
                            AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "minValue", expression);
                        }
                    }
                    if ((value = AMXGaugeEditor.this.getGaugeTagProperties().getMaxValue()) == null) {
                        value = "";
                    }
                    if (isLiteral = AMXGaugeEditor.this.isLiteral(value)) {
                        if (AMXGaugeEditor.this.getGaugeNode() != null) {
                            if (value.length() > 0) {
                                AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "maxValue", value);
                            } else {
                                AMXGaugeEditor.this.getGaugeNode().removeAttributeNS(null, "maxValue");
                            }
                        }
                    } else {
                        bindingId = value;
                        if (AMXGaugeEditor.this.getMaxValueControlBinding() == null) {
                            _control = container.findControlBinding(bindingId);
                            if (_control != null) {
                                bindingId = AMXGaugeEditor.this.getUniqueBindingId(container, bindingId, 1);
                            }
                            properties = new HashMap();
                            properties.put("IterBinding", iteratorBindingId);
                            properties.put("id", bindingId);
                            _control = container.createControlBinding("DCTextField", properties);
                            container.addControlBinding(_control);
                            if (_control instanceof CtrlAttrs) {
                                AMXGaugeEditor.this.setMaxValueControlBinding((CtrlAttrs)_control);
                                AMXGaugeEditor.this.getMaxValueControlBinding().addAttrName(value);
                            }
                        } else {
                            AMXGaugeEditor.this.getMaxValueControlBinding().removeChildNodes();
                            AMXGaugeEditor.this.getMaxValueControlBinding().addAttrName(value);
                        }
                        expression = JSFExpressionUtils.createBaseExpression((String)bindingId, (String)"inputValue");
                        AMXGaugeEditor.this.getGaugeTagProperties().setMinValue(expression);
                        if (AMXGaugeEditor.this.getGaugeNode() != null) {
                            AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "maxValue", expression);
                        }
                    }
                    if (AMXGaugeEditor.this.isDialGauge() && AMXGaugeEditor.this.getGaugeNode() != null) {
                        if (AMXGaugeEditor.this.getDialBackgroundName() != null && AMXGaugeEditor.this.getDialBackgroundName().length() > 0) {
                            AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "background", AMXGaugeEditor.this.getDialBackgroundName());
                        } else {
                            AMXGaugeEditor.this.getGaugeNode().removeAttributeNS(null, "background");
                        }
                        if (AMXGaugeEditor.this.getDialIndicatorName() != null && AMXGaugeEditor.this.getDialIndicatorName().length() > 0) {
                            AMXGaugeEditor.this.getGaugeNode().setAttributeNS(null, "indicator", AMXGaugeEditor.this.getDialIndicatorName());
                        } else {
                            AMXGaugeEditor.this.getGaugeNode().removeAttributeNS(null, "indicator");
                        }
                    }
                    if (AMXGaugeEditor.this.isRatingGauge() && AMXGaugeEditor.this.getGauge() != null) {
                        if (AMXGaugeEditor.this.getSelectedShapeName() != null && AMXGaugeEditor.this.getSelectedShapeName().length() > 0) {
                            AMXGaugeEditor.this.getGauge().setAttributeNS(null, "shape", AMXGaugeEditor.this.getSelectedShapeName());
                        } else {
                            AMXGaugeEditor.this.getGauge().removeAttributeNS(null, "shape");
                        }
                    }
                    if ((nodes = AMXGaugeEditor.this.getGaugeNode().getElementsByTagName("threshold")) != null && nodes.getLength() > 0) {
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            AMXGaugeEditor.this.getGaugeNode().removeChild(nodes.item(i));
                        }
                    }
                    if ((thresholds = AMXGaugeEditor.this.getThresholds()) != null && thresholds.size() > 0) {
                        for (Threshold _threshold : thresholds) {
                            Element thresholdElement = AMXGaugeEditor.this.getGaugeNode().getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "threshold");
                            thresholdElement.setPrefix("dvtm");
                            thresholdElement.setAttributeNS(null, "color", _threshold.getColor());
                            if (_threshold.getText() != null) {
                                thresholdElement.setAttributeNS(null, "text", _threshold.getText());
                            }
                            if (_threshold.getMaxValue() != null && _threshold.getMaxValue().length() > 0) {
                                String _thvalue = _threshold.getMaxValue();
                                isLiteral = AMXGaugeEditor.this.isLiteral(_thvalue);
                                if (isLiteral) {
                                    thresholdElement.setAttributeNS(null, "maxValue", _thvalue);
                                } else {
                                    String bindingId3 = _thvalue;
                                    if (AMXGaugeEditor.this.getThresholdsControlBinding().get(_threshold) == null) {
                                        ControlBinding _control3 = container.findControlBinding(bindingId3);
                                        if (_control3 != null) {
                                            bindingId3 = AMXGaugeEditor.this.getUniqueBindingId(container, bindingId3, 1);
                                        }
                                        HashMap<String, String> properties2 = new HashMap<String, String>();
                                        properties2.put("IterBinding", iteratorBindingId);
                                        properties2.put("id", bindingId3);
                                        _control3 = container.createControlBinding("DCTextField", properties2);
                                        container.addControlBinding(_control3);
                                        if (_control3 instanceof CtrlAttrs) {
                                            AMXGaugeEditor.this.getThresholdsControlBinding().put(_threshold, (CtrlAttrs)_control3);
                                            ((CtrlAttrs)_control3).addAttrName(_thvalue);
                                        }
                                    } else {
                                        AMXGaugeEditor.this.getThresholdsControlBinding().get(_threshold).removeChildNodes();
                                        AMXGaugeEditor.this.getThresholdsControlBinding().get(_threshold).addAttrName(_thvalue);
                                    }
                                    String expression3 = JSFExpressionUtils.createBaseExpression((String)bindingId3, (String)"inputValue");
                                    thresholdElement.setAttributeNS(null, "maxValue", expression3);
                                }
                            }
                            AMXGaugeEditor.this.getGaugeNode().appendChild(thresholdElement);
                        }
                    }
                }
            }
        };
        this.getControlDef().getTransactionManager().runTaskUnderTransaction("saveToDef", task);
    }

    protected void removeThresholdSetNode(Node node) {
        this.getGaugeNode().getOwnerDocument().removeChild(node);
    }

    public boolean isLiteral(String value) {
        boolean bRetVal = true;
        Object[] attrs = this.getAttributeNames();
        if (attrs != null && attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                if (!((String)attrs[i]).equalsIgnoreCase(value)) continue;
                bRetVal = false;
                break;
            }
        }
        return bRetVal;
    }

    public String getSelectedBackgroundName() {
        return this.getGaugeNode().getAttribute("background");
    }

    public String getSelectedIndicator() {
        return this.getGaugeNode().getAttribute("indicator");
    }

    public String getDialBackgroundName() {
        return this.m_dialBackgroundProp;
    }

    public void setDialBackgroundName(String property) {
        this.m_dialBackgroundProp = property;
    }

    public String getDialIndicatorName() {
        return this.m_dialIndicatorProp;
    }

    public void setDialIndicatorName(String property) {
        this.m_dialIndicatorProp = property;
    }

    public void initializeGaugeArtifacts() {
        ControlBinding binding = this.getControlDef();
        if (this.isEditMode()) {
            if (this.getBindingUiContext().get((Object)"RootNode") != null) {
                NodeList _thresholdNodes;
                String metricLabel;
                String maxValue;
                String minValue;
                Element gauge = (Element)this.getBindingUiContext().get((Object)"RootNode");
                if (binding instanceof CtrlValue) {
                    this.m_metricBinding = (CtrlAttrs)binding;
                    String metric = gauge.getAttribute("value");
                    if (ResourceUtilsBindings.isELExpression((String)metric)) {
                        metric = this.getAttributeNameFromEL(metric);
                    }
                    this.getGaugeTagProperties().setValue(metric);
                }
                if ((minValue = gauge.getAttribute("minValue")) != null) {
                    if (ResourceUtilsBindings.isELExpression((String)minValue)) {
                        this.m_minValBinding = this.getCtrlAttrBindingFromEL(minValue);
                        minValue = this.getAttributeNameFromEL(minValue);
                    }
                    this.getGaugeTagProperties().setMinValue(minValue);
                }
                if ((maxValue = gauge.getAttribute("maxValue")) != null) {
                    if (ResourceUtilsBindings.isELExpression((String)maxValue)) {
                        this.m_maxValBinding = this.getCtrlAttrBindingFromEL(maxValue);
                        maxValue = this.getAttributeNameFromEL(maxValue);
                    }
                    this.getGaugeTagProperties().setMaxValue(maxValue);
                }
                if ((metricLabel = gauge.getAttribute("labelDisplay")) != null) {
                    this.m_gaugeProperties.setLabelDisplay(metricLabel);
                }
                if (this.isDialGauge()) {
                    if (this.getGaugeNode() != null && this.getGaugeNode().getAttributeNS(null, "background").length() > 0) {
                        this.setDialBackgroundName(this.getGaugeNode().getAttributeNS(null, "background"));
                    }
                    if (this.getGaugeNode() != null && this.getGaugeNode().getAttributeNS(null, "indicator").length() > 0) {
                        this.setDialIndicatorName(this.getGaugeNode().getAttributeNS(null, "indicator"));
                    }
                }
                if ((_thresholdNodes = this.getGaugeNode().getElementsByTagName("threshold")) != null && _thresholdNodes.getLength() > 0) {
                    Object[] _arrthresholds = this.m_thresholds.toArray();
                    boolean thresholdsAlreadyInUse = this.m_thresholds.size() > 0;
                    int sizeOfThAlreadyInUse = _arrthresholds.length;
                    boolean isNew = true;
                    for (int i = 0; i < _thresholdNodes.getLength(); ++i) {
                        Threshold threshold;
                        if (_thresholdNodes.item(i) == null || _thresholdNodes.item(i).getNodeType() != 1) continue;
                        Element thresholdNode = (Element)_thresholdNodes.item(i);
                        if (thresholdsAlreadyInUse && i < sizeOfThAlreadyInUse && _arrthresholds[i] != null) {
                            threshold = (Threshold)_arrthresholds[i];
                            isNew = false;
                        } else {
                            threshold = new Threshold();
                            isNew = true;
                        }
                        if (thresholdNode.getAttribute("color") != null) {
                            String fillColor = thresholdNode.getAttribute("color");
                            threshold.setColor(fillColor);
                        }
                        if (thresholdNode.getAttribute("maxValue") != null && isNew) {
                            String maxvalue = thresholdNode.getAttribute("maxValue");
                            if (ResourceUtilsBindings.isELExpression((String)maxvalue)) {
                                this.m_thresholdsBindings.put(threshold, this.getCtrlAttrBindingFromEL(maxvalue));
                                maxvalue = this.getAttributeNameFromEL(maxvalue);
                            }
                            threshold.setMaxValue(maxvalue);
                        }
                        if (thresholdNode.getAttribute("text") != null) {
                            String text = thresholdNode.getAttribute("text");
                            threshold.setText(text);
                        }
                        if (!isNew) continue;
                        this.m_thresholds.add(threshold);
                    }
                }
            }
        } else {
            String value;
            BindingUiContext context = this.getBindingUiContext();
            if (context.get((Object)"Gauge Value") != null && ResourceUtilsBindings.isELExpression((String)(value = (String)context.get((Object)"Gauge Value"))) && binding instanceof CtrlAttrs) {
                int definitionType;
                this.m_metricBinding = (CtrlAttrs)binding;
                NamedDefinition definition = (NamedDefinition)context.get((Object)"Definition");
                if (definition != null && (80 == (definitionType = definition.getDefinitionType()) || 30 == definitionType)) {
                    value = definition.getName();
                    this.m_gaugeProperties.setValue(value);
                }
            }
            Element gauge = this.getGaugeNode();
            String value2 = this.getGaugeTagProperties().getMinValue();
            if (value2 == null || value2.length() == 0) {
                value2 = "0";
            }
            if ((value2 = this.getGaugeTagProperties().getMaxValue()) == null || value2.length() == 0) {
                value2 = "100";
            }
            if (context.get((Object)"Gauge Threshold") != null) {
                Threshold threshold = new Threshold();
                threshold.setColor("#d62800");
                this.m_thresholds.add(threshold);
                threshold = new Threshold();
                threshold.setColor("#ffcf21");
                this.m_thresholds.add(threshold);
                threshold = new Threshold();
                threshold.setColor("#84ae31");
                this.m_thresholds.add(threshold);
            }
        }
    }

    public Element getGaugeNode() {
        if (this.m_gauge != null) {
            return this.m_gauge;
        }
        Element gauge = null;
        Element root = (Element)this.getBindingUiContext().get((Object)"RootNode");
        if (AMXGaugeBinder.isGauge(this.getBindingUiContext())) {
            gauge = root;
        }
        return gauge;
    }

    public List<String> getBackgroundNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DIAL_BACKGROUND_CIRCLE_ANTIQUE);
        names.add(DIAL_BACKGROUND_CIRCLE_ANTIQUE_CUSTOM);
        names.add(DIAL_BACKGROUND_CIRCLE_DARK);
        names.add(DIAL_BACKGROUND_CIRCLE_DARK_CUSTOM);
        names.add(DIAL_BACKGROUND_CIRCLE_LIGHT);
        names.add(DIAL_BACKGROUND_CIRCLE_LIGHT_CUSTOM);
        names.add(DIAL_BACKGROUND_RECTANGLE_ANTIQUE);
        names.add(DIAL_BACKGROUND_RECTANGLE_ANTIQUE_CUSTOM);
        names.add(DIAL_BACKGROUND_RECTANGLE_DARK);
        names.add(DIAL_BACKGROUND_RECTANGLE_DARK_CUSTOM);
        names.add(DIAL_BACKGROUND_RECTANGLE_LIGHT);
        names.add(DIAL_BACKGROUND_RECTANGLE_LIGHT_CUSTOM);
        names.add(DIAL_BACKGROUND_DOME_ANTIQUE);
        names.add(DIAL_BACKGROUND_DOME_ANTIQUE_CUSTOM);
        names.add(DIAL_BACKGROUND_DOME_DARK);
        names.add(DIAL_BACKGROUND_DOME_DARK_CUSTOM);
        names.add(DIAL_BACKGROUND_DOME_LIGHT);
        names.add(DIAL_BACKGROUND_DOME_LIGHT_CUSTOM);
        return names;
    }

    public List<String> getIndicatorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DIAL_INDICATOR_NEEDLE_ANTIQUE);
        names.add(DIAL_INDICATOR_NEEDLE_DARK);
        names.add(DIAL_INDICATOR_NEEDLE_LIGHT);
        return names;
    }

    public boolean isDialGauge() {
        String localName = this.getGaugeNode().getLocalName();
        if (localName == null) {
            return false;
        }
        return "dialGauge".equals(localName);
    }

    public String resolveResourceExpression(String value) {
        try {
            XmlModel xmlModel = this.getXmlModel();
            String resolved = null;
            resolved = xmlModel != null ? ResourceUtilsBindings.resolveResourceExpressionJSF((String)value, (BindingUiContext)this.getBindingUiContext(), (XmlModel)xmlModel) : ResourceUtilsBindings.resolveResourceExpression((String)value, (BindingUiContext)this.getBindingUiContext());
            if (resolved != null && !resolved.isEmpty()) {
                value = resolved;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public XmlModel getXmlModel() {
        BindingUiContext bindingUiContext = this.getBindingUiContext();
        XmlContext xmlContext = (XmlContext)bindingUiContext.get((Object)"XmlContext");
        if (xmlContext == null) {
            JDevDesignTimeContext dtContext = (JDevDesignTimeContext)bindingUiContext.getADFDesignTimeContext();
            xmlContext = dtContext.getXmlContext();
        }
        if (xmlContext != null) {
            return xmlContext.getModel();
        }
        return null;
    }

    Node findChildNode(Node parent, String childName) {
        if (childName != null && parent != null) {
            DvtBaseElementObject.logMessageDebug((String)("Parent: " + parent.getNodeName()));
            NodeList childNodes = parent.getChildNodes();
            if (childNodes != null) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    DvtBaseElementObject.logMessageDebug((String)("Child: " + child.getNodeName()));
                    if (child == null || !childName.equals(child.getLocalName())) continue;
                    DvtBaseElementObject.logMessageDebug((String)"\n");
                    return child;
                }
            }
        }
        DvtBaseElementObject.logMessageDebug((String)"\n");
        return null;
    }

    public String getAttributeNameFromEL(String EL) {
        ControlBinding binding = this.getControlDef();
        if (binding != null && binding instanceof CtrlValue && EL != null && ResourceUtilsBindings.isELExpression((String)EL)) {
            PageDefinition container = binding.getBindingContainer();
            EL = EL.substring(EL.indexOf("bindings"));
            int begin = EL.indexOf(".");
            int end = EL.indexOf(".", begin + 1);
            String bindingId = EL.substring(begin + 1, end);
            if (binding instanceof CtrlHier) {
                return bindingId;
            }
            CtrlAttrs elBinding = (CtrlAttrs)this.getControlBinding(container, bindingId);
            String attrValue = elBinding.getFirstAttribute();
            return attrValue;
        }
        return null;
    }

    public CtrlAttrs getCtrlAttrBindingFromEL(String EL) {
        ControlBinding binding = this.getControlDef();
        if (binding != null && binding instanceof CtrlValue && EL != null && ResourceUtilsBindings.isELExpression((String)EL)) {
            PageDefinition container = binding.getBindingContainer();
            EL = EL.substring(EL.indexOf("bindings"));
            int begin = EL.indexOf(".");
            int end = EL.indexOf(".", begin + 1);
            String bindingId = EL.substring(begin + 1, end);
            CtrlAttrs elBinding = (CtrlAttrs)this.getControlBinding(container, bindingId);
            return elBinding;
        }
        return null;
    }

    public String getUniqueBindingId(PageDefinition container, String bindingId, int counter) {
        String retBindingId = null;
        String newId = bindingId + counter;
        ControlBinding binding = container.findControlBinding(newId);
        retBindingId = binding != null ? this.getUniqueBindingId(container, newId, counter++) : newId;
        return retBindingId;
    }

    public ControlBinding getControlBinding(PageDefinition container, String bindingId) {
        ControlBinding binding = container.findControlBinding(bindingId);
        if (binding == null) {
            binding = container.findExecutable(bindingId);
        }
        return binding;
    }

    protected Element findFirstElement(Element root, String name) {
        if (root == null) {
            return null;
        }
        Node _node = root.getElementsByTagName(name).item(0);
        if (_node != null && _node.getNodeType() == 1) {
            return (Element)_node;
        }
        return null;
    }

    public AMXGaugeProperties getGaugeTagProperties() {
        return this.m_gaugeProperties;
    }

    protected Element findThresholdSet() {
        return this.getGaugeNode();
    }

    public boolean isEditMode() {
        switch (this.getInvokeMode()) {
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean isAccessorDefinition() {
        int definitionType;
        boolean bRetVal = true;
        BindingUiContext context = this.getBindingUiContext();
        NamedDefinition definition = (NamedDefinition)context.get((Object)"Definition");
        if (definition != null && (30 == (definitionType = definition.getDefinitionType()) || 80 == definitionType)) {
            bRetVal = false;
        }
        return bRetVal;
    }

    public String getInitialMinValue() {
        String strMinVal = null;
        strMinVal = this.getGaugeTagProperties().getMinValue();
        strMinVal = strMinVal == null ? "0" : strMinVal;
        return strMinVal;
    }

    public String getInitialMaxValue() {
        String strMaxVal = null;
        strMaxVal = this.getGaugeTagProperties().getMaxValue();
        strMaxVal = strMaxVal == null ? "100" : strMaxVal;
        return strMaxVal;
    }

    public List getApplicableMetricValues() {
        List<AttributeDefinition> metrics = this.getAttributeDefinitionList();
        return metrics;
    }

    public void setMinValueControlBinding(CtrlAttrs binding) {
        this.m_minValBinding = binding;
    }

    public void setMaxValueControlBinding(CtrlAttrs binding) {
        this.m_maxValBinding = binding;
    }

    public CtrlAttrs getMinValueControlBinding() {
        return this.m_minValBinding;
    }

    public CtrlAttrs getMaxValueControlBinding() {
        return this.m_maxValBinding;
    }

    public void setMetricControlBinding(CtrlAttrs binding) {
        this.m_metricBinding = binding;
    }

    public CtrlAttrs getMetricControlBinding() {
        return this.m_metricBinding;
    }

    public HashMap<Threshold, CtrlAttrs> getThresholdsControlBinding() {
        return this.m_thresholdsBindings;
    }

    public void setThresholds(List<Threshold> thresholds) {
        this.m_thresholds = thresholds;
    }

    public List<Threshold> getThresholds() {
        return this.m_thresholds;
    }

    public Object[] getAttributeNames() {
        List<Object> attrDefs = this.getAttributeDefinitionList();
        if (attrDefs == null) {
            attrDefs = Collections.emptyList();
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        for (int i = 0; i < attrDefs.size(); ++i) {
            AttributeDefinition attr = (AttributeDefinition)attrDefs.get(i);
            attrNames.add(attr.getName());
        }
        return attrNames.toArray();
    }

    public List getAttributesWithResources() {
        List<AttributeDefinition> attrDefs = this.getAttributeDefinitionList();
        if (attrDefs == null) {
            return Collections.emptyList();
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(DvtBindingResources.getResource((String)"GAUGE_METRIC_ATTRIBUTE_LABEL"));
        attributes.add(RowsetRow.SELECT_TEXT_RESOURCE);
        attributes.add(RowsetRow.EXPRESSION_BUILDER);
        attributes.add(RowsetRow.SEPARATOR);
        attributes.addAll(attrDefs);
        return attributes;
    }

    public List getTopLabelAttributes() {
        if (this.getGaugeNode() == null) {
            return this.getAttributeDefinitionList();
        }
        return this.getAttributesWithResources();
    }

    public List getBottomLabelAttributes() {
        return this.getTopLabelAttributes();
    }

    public Object[] getNumericAttributeNames() {
        List<Object> attrDefs = this.getAttributeDefinitionList();
        if (attrDefs == null) {
            attrDefs = Collections.emptyList();
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        for (int i = 0; i < attrDefs.size(); ++i) {
            AttributeDefinition attr = (AttributeDefinition)attrDefs.get(i);
            if (!ADFmUtilsTrinidad.isNumericAttribute((AttributeDefinition)attr)) continue;
            attrNames.add(attr.getName());
        }
        return attrNames.toArray();
    }

    public List<AttributeDefinition> getAttributeDefinitionList() {
        List attributes = null;
        attributes = ADFmUtilsTrinidad.getAttributeDefinitions((StructureDefinition)BasePanel.getDefinition((IteratorBinding)this.getControlDef().getIteratorBinding()), (boolean)true);
        return attributes;
    }

    protected BasePanel getDataSourcePickerPanel(BasePanel bindingUiPanel) {
        if (this.hideDataSourcePicker()) {
            return null;
        }
        DataSourcePickerPanel dataSourcePickerPanel = null;
        if (this.fromPageDef()) {
            dataSourcePickerPanel = new DataSourcePickerPanel(bindingUiPanel, this.getControlDef());
            dataSourcePickerPanel.setInvokeMode(this.getInvokeMode());
            dataSourcePickerPanel.setEditor((CubicHierEditor)this);
            dataSourcePickerPanel.initialize();
        }
        return dataSourcePickerPanel;
    }

    protected List<String> getThresholdHexColors() {
        ArrayList<String> colors = new ArrayList<String>();
        List<Threshold> thresholds = this.m_thresholds;
        if (thresholds != null) {
            for (Threshold _threshold : thresholds) {
                colors.add(_threshold.getColor());
            }
        }
        return colors;
    }

    protected List<String> getThresholdLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        List<Threshold> thresholds = this.m_thresholds;
        if (thresholds != null) {
            for (Threshold _threshold : thresholds) {
                labels.add(_threshold.getText());
            }
        }
        return labels;
    }

    protected String getThresholdFillColorAttribute() {
        return "fillColor";
    }

    protected String getThresholdMaxValueAttribute() {
        return "thresholdMaxValue";
    }

    protected JEWTDialog findOrCreateEditDialog(Component parent, String title) {
        JEWTDialog dialog = super.findOrCreateEditDialog(parent, title);
        dialog.setResizable(true);
        this.m_dialog = dialog;
        return dialog;
    }

    public JEWTDialog getBindingDialog() {
        return this.m_dialog;
    }

    public boolean isRatingGauge() {
        if (this.getGauge() != null) {
            return "ratingGauge".equals(this.getGauge().getLocalName());
        }
        return false;
    }

    public Element getGauge() {
        return this.m_gauge;
    }

    public class AMXGaugeProperties {
        String _minValue;
        String _maxValue;
        String value;
        String labelDisplay;

        public String getMinValue() {
            return this._minValue;
        }

        public void setMinValue(String minValue) {
            this._minValue = minValue;
        }

        public String getMaxValue() {
            return this._maxValue;
        }

        public void setMaxValue(String maxValue) {
            this._maxValue = maxValue;
        }

        public void setLabelDisplay(String labelDisplay) {
            this.labelDisplay = labelDisplay;
        }

        public String getLabelDisplay() {
            return this.labelDisplay;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

