/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.adfdt.common.ui.collection.Item;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.resource.DVTMobileResourceBundleUtils;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtilsBindings;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.AMXGaugeBindPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.RowsetRow;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.Threshold;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.ColumnDefinition;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtCollection;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtRow;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.AMXGaugeEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.resource.DvtBindingResources;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.binding.meta.AttributeDefinition;
import oracle.jdevimpl.webapp.common.html.ColorUtils;

public class AMXGaugeThresholdCollection
extends DvtCollection {
    List<ColumnDefinition> m_columns;
    List<Threshold> m_thresholdProperties;
    BindingUiContext m_hBindingUiContext = null;
    Object[] m_attrDefs;
    AMXGaugeBindPanel m_container;
    private boolean m_initingRowsetRows = false;
    private String m_conflictItem = null;
    protected static final int THRESHOLD_IDX_COLUMN = 0;
    protected static final int ATTRIBUTE_COLUMN = 1;
    protected static final int LABEL_COLUMN = 2;
    protected static final int THRESHOLD_COLOR_COLUMN = 3;
    public static final String NO_VALUE = "";
    public static final String THRESHOLD_INDEX_BASE = "threshold";
    protected static final String PICK_THRESHOLD_LABEL = DvtBindingResources.getResource((String)"DEFAULT_GAUGE_THRESHOLD_LABEL");

    public AMXGaugeThresholdCollection(List<ColumnDefinition> columns, List<Threshold> thresholds, AMXGaugeBindPanel container) {
        super(columns);
        this.m_columns = columns;
        this.m_thresholdProperties = thresholds == null ? new ArrayList<Threshold>() : thresholds;
        this.m_container = container;
        if (this.m_container != null) {
            this.m_attrDefs = this.m_container.getAttributeDefinitions();
        }
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.m_columns;
    }

    public List<Threshold> getThresholdProperties() {
        return this.m_thresholdProperties;
    }

    public void commit() throws Exception {
        for (ThresholdRow curRow : this.getItems()) {
            curRow.commit();
        }
    }

    public Item createItem() {
        Object rowObject;
        boolean _haveAllColumns = this.getColumnDefinitions().size() == 4;
        ArrayList<Object> arCurItems = new ArrayList<Object>(this.getItems());
        if (!_haveAllColumns) {
            Object rowObject2 = this.createRowObject();
            arCurItems.add(rowObject2);
            this.setItems(arCurItems);
            this.updateThresholdIndexes();
            return (ThresholdRow)((Object)rowObject2);
        }
        if (arCurItems != null && arCurItems.size() == 0) {
            Object lastRow = this.createRowObjectNoAppend(2);
            if (null == lastRow) {
                return null;
            }
            rowObject = this.createRowObject();
            if (null == rowObject) {
                return null;
            }
            arCurItems.add(rowObject);
            arCurItems.add(lastRow);
        } else {
            rowObject = this.createRowObject();
            arCurItems.add(arCurItems.size() - 1, rowObject);
        }
        this.setItems(arCurItems);
        this.updateThresholdIndexes();
        return (ThresholdRow)((Object)rowObject);
    }

    public void delete(Item[] items) {
        boolean _haveAllColumns;
        int allRows = this.getItems().size();
        int selectedRows = items.length;
        boolean bl = _haveAllColumns = this.getColumnDefinitions().size() == 4;
        if (_haveAllColumns && allRows != selectedRows) {
            if (this.isLastRowInSelection(items)) {
                items = this.removeLastRowFromList(items);
            } else if (selectedRows == allRows - 1) {
                items = this.addlastRowToList(items);
            }
        }
        super.delete(items);
        this.removeThresholdFromList(items);
        this.updateThresholdIndexes();
        this.m_container.updateWarningPanel();
    }

    private Object createRowObjectNoAppend(int lastRowIndex) {
        boolean _haveAllColumns;
        Threshold threshold = new Threshold();
        ThresholdRow newRow = this.createThresholdRow(this.getColumnDefinitions(), threshold);
        this.m_thresholdProperties.add(threshold);
        boolean bl = _haveAllColumns = this.getColumnDefinitions().size() == 4;
        if (_haveAllColumns) {
            newRow.setValue(0, THRESHOLD_INDEX_BASE + lastRowIndex);
            newRow.setValue(2, PICK_THRESHOLD_LABEL);
            newRow.setValue(3, ColorUtils.hexStringToColor((String)"#d62800"));
        } else {
            newRow.setValue(0, THRESHOLD_INDEX_BASE + lastRowIndex);
        }
        return newRow;
    }

    private void removeThresholdFromList(Item[] items) {
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ThresholdRow row = (ThresholdRow)items[i];
                if (!this.m_thresholdProperties.contains(row.getThreshold())) continue;
                this.m_thresholdProperties.remove(row.getThreshold());
            }
        }
    }

    private void updateThresholdIndexes() {
        List rows = this.getItems();
        if (rows != null) {
            ThresholdRow row = null;
            for (int i = 0; i < rows.size(); ++i) {
                row = (ThresholdRow)((Object)rows.get(i));
                row.setValue(0, THRESHOLD_INDEX_BASE + (i + 1));
            }
        }
        ((AMXGaugeEditor)this.m_container.getEditor()).setThresholds(this.m_thresholdProperties);
    }

    private boolean isLastRowInSelection(Item[] items) {
        boolean bRetVal = false;
        ThresholdRow lastRow = (ThresholdRow)((Object)this.getItems().get(this.getItems().size() - 1));
        if (items != null) {
            Object lastThIdx = lastRow.getValue(0);
            for (int i = 0; i < items.length; ++i) {
                ThresholdRow row = (ThresholdRow)items[i];
                if (!row.getValue(0).equals(lastThIdx)) continue;
                bRetVal = true;
                break;
            }
        }
        return bRetVal;
    }

    private Item[] removeLastRowFromList(Item[] items) {
        ThresholdRow lastRow = (ThresholdRow)((Object)this.getItems().get(this.getItems().size() - 1));
        Item[] newList = null;
        if (items != null) {
            newList = new Item[items.length - 1];
            Object lastThIdx = lastRow.getValue(0);
            for (int i = 0; i < items.length - 1; ++i) {
                ThresholdRow row = (ThresholdRow)items[i];
                if (row.getValue(0).equals(lastThIdx)) continue;
                newList[i] = row;
            }
        }
        return newList;
    }

    private Item[] addlastRowToList(Item[] items) {
        ThresholdRow lastRow = (ThresholdRow)((Object)this.getItems().get(this.getItems().size() - 1));
        Item[] newList = null;
        if (items != null) {
            int newSize = items.length + 1;
            newList = new Item[newSize];
            for (int i = 0; i < items.length; ++i) {
                ThresholdRow row = (ThresholdRow)items[i];
                newList[i] = row;
            }
            newList[newSize - 1] = lastRow;
        }
        return newList;
    }

    public ThresholdRow getRow(int nRow) {
        Object rowObject = null;
        if (this.getItems() != null) {
            rowObject = this.getItems().get(nRow);
        }
        return rowObject;
    }

    public boolean isEmpty() {
        return this.getItems() != null ? this.getItems().isEmpty() : true;
    }

    public void setConflictItem(String item) {
        this.m_conflictItem = item;
    }

    public String getConflictItem() {
        return this.m_conflictItem;
    }

    protected Object createRowObject() {
        boolean _haveAllColumns;
        Threshold newThreshold = new Threshold();
        ThresholdRow newRow = this.createThresholdRow(this.getColumnDefinitions(), newThreshold);
        boolean bl = _haveAllColumns = this.getColumnDefinitions().size() == 4;
        if (_haveAllColumns) {
            newRow.setValue(0, THRESHOLD_INDEX_BASE + (this.getItems() != null && this.getItems().size() > 0 ? this.getItems().size() - 1 : 1));
            newRow.setValue(2, PICK_THRESHOLD_LABEL);
            newRow.setValue(3, ColorUtils.hexStringToColor((String)"#d62800"));
            int idx = this.m_thresholdProperties.size();
            if (idx > 0) {
                this.m_thresholdProperties.add(idx - 1, newThreshold);
            }
        } else {
            newRow.setValue(0, THRESHOLD_INDEX_BASE + (this.getItems() == null ? 0 : this.getItems().size()));
            this.m_thresholdProperties.add(newThreshold);
        }
        return newRow;
    }

    public void setItemList(List<Threshold> thresholds, List<String> labels, List<Color> colors) {
        ArrayList<ThresholdRow> list = new ArrayList<ThresholdRow>();
        if (thresholds != null) {
            for (int i = 0; i < thresholds.size(); ++i) {
                Threshold _threshold = thresholds.get(i);
                ThresholdRow newRow = this.createThresholdRow(this.getColumnDefinitions(), _threshold);
                list.add(newRow);
            }
            this.setItems(list);
            this.initializeThresholdRow(list, labels, colors);
        }
    }

    public ThresholdRow createThresholdRow(List<ColumnDefinition> columns, Threshold thresholdProperties) {
        return new ThresholdRow(columns, thresholdProperties);
    }

    public void setItems(List list) {
        super.setItems(list);
        if (this.m_container != null) {
            this.m_container.updateWarningPanel();
        }
    }

    private void initializeThresholdRow(List<ThresholdRow> rows, List<String> labels, List<Color> colors) {
        if (rows != null) {
            this.m_initingRowsetRows = true;
            boolean _haveAllColumns = this.getColumnDefinitions().size() == 4;
            for (int i = 0; i < rows.size(); ++i) {
                ThresholdRow newRow = rows.get(i);
                newRow.setValue(0, THRESHOLD_INDEX_BASE + (i + 1));
                if (!_haveAllColumns) continue;
                if (labels != null && labels.size() > 0 && !labels.get(i).equals(NO_VALUE)) {
                    newRow.setValue(2, labels.get(i));
                } else {
                    newRow.setValue(2, PICK_THRESHOLD_LABEL);
                }
                if (colors != null && colors.size() > 0 && colors.get(i) != null) {
                    newRow.setValue(3, colors.get(i));
                    continue;
                }
                newRow.setValue(3, ColorUtils.hexStringToColor((String)"#d62800"));
            }
            this.m_initingRowsetRows = false;
        }
    }

    public Item group(Item[] item) {
        return null;
    }

    public void ungroup(Item item) {
    }

    public void removeAllItems() {
        List items = this.getItems();
        if (items != null && items.size() > 0) {
            this.delete(items.toArray(new Item[items.size()]));
        }
    }

    public void setBindingUiContext(BindingUiContext hBindingUiContext) {
        this.m_hBindingUiContext = hBindingUiContext;
    }

    public BindingUiContext getBindingUiContext() {
        return this.m_hBindingUiContext;
    }

    ColumnDefinition getColumnDefinition(int index) {
        return index < this.m_columns.size() ? this.m_columns.get(index) : null;
    }

    public class ThresholdRow
    extends DvtRow {
        List<ColumnDefinition> columns;
        Threshold threshold;
        protected Object[] m_localStorage;
        private boolean m_init;

        public ThresholdRow(List<ColumnDefinition> columns, Threshold threshold) {
            super(columns, null);
            this.m_localStorage = null;
            this.m_init = false;
            this.columns = columns;
            this.threshold = threshold;
            int size = columns.size();
            this.m_localStorage = new Object[size];
            this.setInitialized(true);
            for (int i = 0; i < size; ++i) {
                ColumnDefinition col = columns.get(i);
                if (col.getDefaultValue() == null) continue;
                this.setValue(i, col.getDefaultValue());
            }
            this.setInitialized(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(int column, Object value) {
            ColumnDefinition colDef = this.getColumnDefinition(column);
            if (null == colDef.getAttributeName()) {
                return;
            }
            if (colDef.isDisplayOnly()) {
                this.m_localStorage[column] = value;
            }
            if (column == 1) {
                if (value != null && value.toString().length() != 0) {
                    this.threshold.setMaxValue(value.toString());
                } else {
                    this.threshold.setMaxValue(null);
                }
            } else if (column == 2) {
                if (AMXGaugeThresholdCollection.this.m_container != null && value != null && value.toString().length() > 0 && !value.toString().equalsIgnoreCase(PICK_THRESHOLD_LABEL)) {
                    String strValue;
                    if (!AMXGaugeThresholdCollection.this.m_initingRowsetRows) {
                        Object oldValue;
                        String sValue;
                        BindingUiContext bindingContext = AMXGaugeThresholdCollection.this.getBindingUiContext();
                        XmlContext xmlContext = (XmlContext)bindingContext.get((Object)"XmlContext");
                        if (xmlContext == null) {
                            JDevDesignTimeContext dtContext = (JDevDesignTimeContext)bindingContext.getADFDesignTimeContext();
                            xmlContext = dtContext.getXmlContext();
                        }
                        XmlModel xmlModel = xmlContext.getModel();
                        if (RowsetRow.SELECT_TEXT_RESOURCE.equals(value)) {
                            String resource = DVTMobileResourceBundleUtils.selectAMXResource(bindingContext);
                            if (resource == null) return;
                            value = resource;
                        } else if (RowsetRow.EXPRESSION_BUILDER.equals(value)) {
                            Object location = new Object();
                            String expression = ResourceUtilsBindings.buildExpression((BindingUiContext)AMXGaugeThresholdCollection.this.getBindingUiContext(), (Object)location);
                            if (expression == null) return;
                            value = expression;
                        } else if (value != null && (sValue = value.toString()).length() > 0 && !ResourceUtilsBindings.isELExpression((String)sValue) && !value.equals(oldValue = this.getValue(column))) {
                            value = ResourceUtilsBindings.syncResourceIfNecessaryForJSF((String)sValue, (String)(oldValue == null ? null : oldValue.toString()), (BindingUiContext)AMXGaugeThresholdCollection.this.getBindingUiContext(), (AbstractModel)xmlModel);
                        }
                    }
                    String string = strValue = value == null ? null : value.toString();
                    if (ResourceUtilsBindings.isELExpression((String)strValue)) {
                        value = ResourceUtilsBindings.getTagELExpression((String)strValue);
                    }
                    this.threshold.setText(value.toString());
                }
            } else if (column == 3 && AMXGaugeThresholdCollection.this.m_container != null) {
                if (value != null) {
                    this.threshold.setColor(ColorUtils.colorToHexString((Color)((Color)value)));
                } else {
                    this.threshold.setColor(null);
                }
            }
            AMXGaugeThresholdCollection.this.m_container.updateWarningPanel();
        }

        public Object getValue(int column) {
            try {
                XmlModelUtils.throwIfAccessibilityThreadAccessDisallowed();
            }
            catch (Exception e) {
                return this.m_localStorage[column];
            }
            ColumnDefinition colDef = this.getColumnDefinition(column);
            if (colDef == null || null == colDef.getAttributeName()) {
                return null;
            }
            Object obj = null;
            if (colDef.isDisplayOnly()) {
                obj = this.m_localStorage[column];
            } else {
                String displayValue;
                String sValue;
                if (column == 1) {
                    sValue = this.threshold.getMaxValue();
                    if (ResourceUtilsBindings.isELExpression((String)sValue)) {
                        sValue = ((AMXGaugeEditor)AMXGaugeThresholdCollection.this.m_container.getEditor()).getAttributeNameFromEL(sValue);
                    }
                    obj = sValue;
                } else if (column == 2) {
                    obj = this.threshold.getText();
                    if (AMXGaugeThresholdCollection.NO_VALUE.equals(obj)) {
                        return PICK_THRESHOLD_LABEL;
                    }
                    if (obj != null) {
                        sValue = obj.toString();
                        if (DVTMobileResourceBundleUtils.isResourceBundleExpression((String)sValue)) {
                            BindingUiContext bindingContext = AMXGaugeThresholdCollection.this.getBindingUiContext();
                            String resolved = DVTMobileResourceBundleUtils.resolveAMXResourceExpression(sValue, bindingContext);
                            return resolved;
                        }
                        if (ResourceUtilsBindings.isELExpression((String)sValue)) {
                            try {
                                BindingUiContext bindingUiContext = AMXGaugeThresholdCollection.this.getBindingUiContext();
                                XmlContext xmlContext = (XmlContext)bindingUiContext.get((Object)"XmlContext");
                                if (xmlContext == null) {
                                    JDevDesignTimeContext dtContext = (JDevDesignTimeContext)bindingUiContext.getADFDesignTimeContext();
                                    xmlContext = dtContext.getXmlContext();
                                }
                                XmlModel xmlModel = xmlContext.getModel();
                                String resolved = ResourceUtilsBindings.resolveResourceExpressionJSF((String)sValue, (BindingUiContext)AMXGaugeThresholdCollection.this.getBindingUiContext(), (XmlModel)xmlModel);
                                return resolved;
                            }
                            catch (Exception e) {}
                        }
                    }
                } else if (column == 3) {
                    obj = this.threshold.getColor();
                }
                if (obj == null && (displayValue = this.getNullDisplayValue(column)) != null) {
                    return displayValue;
                }
            }
            this.m_localStorage[column] = obj;
            return obj;
        }

        public String getNullDisplayValue(int column) {
            String _strRetVal = null;
            if (column == 2) {
                _strRetVal = PICK_THRESHOLD_LABEL;
            } else if (column == 0) {
                _strRetVal = AMXGaugeThresholdCollection.THRESHOLD_INDEX_BASE + (this.getItems() != null ? this.getItems().size() : 0);
            }
            return _strRetVal;
        }

        public Item cloneItem() {
            return null;
        }

        public void sync(Item source) {
        }

        public Item group(Item[] item) {
            return null;
        }

        public void ungroup(Item item) {
        }

        public void commit() {
        }

        void setInitialized(boolean init) {
            this.m_init = init;
        }

        boolean isInitialized() {
            return this.m_init;
        }

        boolean isLiteral(String value) {
            boolean bRetVal = true;
            if (value == null || value.length() == 0) {
                return false;
            }
            if (AMXGaugeThresholdCollection.this.m_attrDefs != null && AMXGaugeThresholdCollection.this.m_attrDefs.length > 0) {
                for (int i = 0; i < AMXGaugeThresholdCollection.this.m_attrDefs.length; ++i) {
                    if (!((AttributeDefinition)AMXGaugeThresholdCollection.this.m_attrDefs[i]).getName().equalsIgnoreCase(value)) continue;
                    bRetVal = false;
                    break;
                }
            }
            return bRetVal;
        }

        public void setThreshold(Threshold threshold) {
            this.threshold = threshold;
        }

        public Threshold getThreshold() {
            return this.threshold;
        }
    }
}

