/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset;

import java.util.List;
import javax.swing.Icon;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.resource.DVTMobileResourceBundleUtils;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtilsBindings;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.ItemContext;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.AttributeLabelCollection;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.ItemContextRow;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.RowsetRow;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.ColumnDefinition;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtCollection;
import oracle.adfdtinternal.model.dvt.objects.Item;
import oracle.javatools.icons.OracleIcons;

public class AMXAttributeLabelRow
extends ItemContextRow {
    protected static final int ATTR_COLUMN = 0;
    protected static final int LABEL_COLUMN = 1;

    public AMXAttributeLabelRow(List<ColumnDefinition> columns, Item curItem, AttributeLabelCollection collection, ItemContext context) {
        super(columns, (BaseElementObject)curItem, curItem, (DvtCollection)collection, context);
    }

    public Object getValue(int column) {
        Object value = super.getValue(column);
        if (column == 1 && value != null) {
            String sValue = value.toString();
            if (sValue.length() == 0 || sValue.equals("__NO_LABEL")) {
                return ItemContext.NO_LABEL;
            }
            if (DVTMobileResourceBundleUtils.isResourceBundleExpression((String)sValue)) {
                value = DVTMobileResourceBundleUtils.resolveAMXResourceExpression(sValue, this.getCollection().getBindingUiContext());
            }
        }
        return value;
    }

    public Icon getLabelIcon() {
        if (this._itemContext != null) {
            if (this._itemContext.isDataValue()) {
                return OracleIcons.getIcon((String)"edit.png");
            }
            if (this._itemContext.isNumeric()) {
                return OracleIcons.getIcon((String)"field.png");
            }
            return OracleIcons.getIcon((String)"label.png");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(int column, Object value) {
        if (column == 1) {
            if (value == null || value.toString().length() == 0 || ItemContext.NO_LABEL.equals(value.toString())) {
                value = "__NO_LABEL";
            } else if (RowsetRow.SELECT_TEXT_RESOURCE.equals(value)) {
                String resource = DVTMobileResourceBundleUtils.selectAMXResource(this.getCollection().getBindingUiContext());
                if (resource == null) return;
                value = resource;
            } else if (RowsetRow.EXPRESSION_BUILDER.equals(value)) {
                String expression = ResourceUtilsBindings.buildExpression((BindingUiContext)this.getCollection().getBindingUiContext(), (Object)this.getItem().getElement());
                if (expression == null) return;
                value = expression;
            } else {
                if (RowsetRow.SEPARATOR.equals(value)) {
                    return;
                }
                if (this._itemContext.getLabelOption() != 2 && !value.equals(this.getNullDisplayValue(column)) && !DVTMobileResourceBundleUtils.isELExpression((String)value.toString())) {
                    Object oldValue = super.getValue(column);
                    value = DVTMobileResourceBundleUtils.syncResourceIfNecessary((String)value.toString(), (String)(oldValue == null ? null : oldValue.toString()), (BindingUiContext)this.getCollection().getBindingUiContext());
                }
            }
        }
        super.setValue(column, value);
    }

    protected String getNullDisplayValue(int column) {
        if (column == 1) {
            return this._itemContext.getNullDisplayString();
        }
        return null;
    }
}

