/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtilsAMX;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXGraphBindingPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.ItemContext;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.PieRingGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.MembersCombo;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.AMXAttributeLabelTable;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.AttributeLabelTable;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.ItemAccess;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanelItem;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanelModel;
import oracle.adfdtinternal.model.dvt.objects.DataMap;
import oracle.adfdtinternal.model.dvt.objects.DvtBaseElementObject;
import oracle.adfdtinternal.model.dvt.objects.Edge;
import oracle.adfdtinternal.model.dvt.objects.Item;
import oracle.binding.meta.AttributeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AMXPieGraphPanel
extends PieRingGraphPanel
implements AMXGraphBindingPanel.AMXGraphInnerPanel {
    public AMXPieGraphPanel(ControlBinding binding) {
        super(binding);
    }

    protected void initBindingXML() {
        String selectedValue;
        ControlBinding ctrlBinding = this.getControlBinding();
        this._dataMap = new AMXDataMap("foo");
        this._dataMap.setControlBinding(ctrlBinding);
        Element elem = ctrlBinding.getDocument().createElementNS("dvtx", "foo2");
        this._dataMap.initializeFromElement(ctrlBinding.getTransactionManager(), elem);
        this.setSeriesEdge(this.findOrCreateEdge(this._dataMap, "series"));
        this.setGroupEdge(this.findOrCreateEdge(this._dataMap, "groups"));
        this.setSeriesItems(new ArrayList());
        this.setGroupItems(new ArrayList());
        if (this.isEditMode()) {
            this.updateFakeItemsFromElement();
        }
        this.addExistingItems(this.getSeriesItems(), this.getSeriesEdge());
        this.addExistingItems(this.getGroupItems(), this.getGroupEdge());
        this.initDataPointEdge();
        this.setNameValuePair(false);
        if (this.getDataItem() == null) {
            this.setDataItem(this.findOrCreateDataItem(this.getDataPointEdge()));
        }
        if (this.getDataItem() != null && (selectedValue = this.getDataItem().getAttribute("value")) != null) {
            this.setNameValuePair(true);
        }
    }

    protected AttributeLabelTable addAttributesTable(GridBagConstraints c) {
        AMXAttributeLabelTable attrTable = new AMXAttributeLabelTable(this.getControlBinding().getIteratorBinding());
        attrTable.setBindingUiContext(this.getBindingUiContext());
        this.updateAttributeTable(attrTable);
        this.add((Component)((Object)attrTable), c);
        return attrTable;
    }

    protected void updateAttributeTable(AttributeLabelTable attrTable) {
        List allItems = this.getAllItems();
        Edge _edge = this.getDataPointEdge();
        List _ic = this.getEdgeItemList(_edge);
        if (_ic != null && !_ic.isEmpty()) {
            ((ItemContext)_ic.get(0)).updateLabelOption(true, true);
        }
        if (attrTable == null) {
            attrTable = this.getAttributeLabelTable();
        }
        if (attrTable != null) {
            attrTable.setContext(allItems, this.getAttributeDefinitions());
        }
    }

    @Override
    public void updateFakeItemsFromElement() {
        String varString;
        Element pieGraph = this.getBindingUiContext().getRootElement();
        NodeList pieSlices = pieGraph.getElementsByTagName(this.getChartDataItemLocalName());
        Element pieSlice = null;
        if (pieSlices.getLength() > 0) {
            pieSlice = (Element)pieSlices.item(0);
        }
        if ((varString = pieGraph.getAttribute("var")) == null) {
            varString = "row";
        }
        if (pieSlice != null) {
            String valueString = pieSlice.getAttribute("value");
            if (valueString != null) {
                String value = GraphBindingUtilsAMX.getAttrNameFromEL((String)valueString, (String)varString);
                this.getGroupEdge().setDataItem(this.getGroupEdge().createDefaultDataItem());
                this.addItem((DvtBaseElementObject)this.getGroupEdge().getDataItem(), value, null);
            }
            String sliceIds = pieSlice.getAttribute("sliceId");
            String sliceLabels = pieSlice.getAttribute("label");
            boolean haveLabels = false;
            if (sliceIds == null || sliceIds.length() == 0) {
                sliceIds = sliceLabels;
            } else if (sliceLabels != null && sliceLabels.startsWith("#{")) {
                haveLabels = true;
            }
            if (sliceIds != null) {
                List<String> idValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(sliceIds, varString);
                List<String> labelValues = null;
                if (haveLabels) {
                    labelValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(sliceLabels, varString);
                }
                String _label = null;
                for (int j = 0; j < idValues.size(); ++j) {
                    String _id = idValues.get(j);
                    if (haveLabels) {
                        _label = labelValues.get(j);
                    }
                    Item _newitem = this.addItem((DvtBaseElementObject)this.getSeriesEdge(), _id, null);
                    if (_label == null || _label.equals(_id)) continue;
                    _newitem.setLabel(_label);
                }
            }
        }
    }

    protected void addPanelContent(GridBagConstraints c) {
        super.addPanelContent(c);
        JButton dataShape = this.getNameValueAttributesPanel().getAttributesPanel().getButtonDataShape();
        dataShape.getParent().remove(dataShape);
    }

    protected int getGraphType() {
        if (this._graphType == -1) {
            this._graphType = GraphBindingUtilsAMX.getGraphType(this.getBindingUiContext());
        }
        return this._graphType;
    }

    protected MembersCombo createNameCombo() {
        return this.createMembersCombo(null, "qualifier", true, false);
    }

    protected MembersCombo createValueCombo() {
        return this.createDataCombo(null, "value", true, false);
    }

    public ItemContext handleNewItem(Object objSource, PickValuesRowPanel rowPanel, int index, AttributeDefinition attrDef, String itemName, boolean isItemNumeric) {
        ItemContext itemContext = null;
        if (rowPanel != null) {
            List rowPanelItems;
            PickValuesRowPanelModel rowPanelModel = rowPanel.getPickValuesRowPanelModel();
            Edge edge = (Edge)rowPanelModel.getEdge();
            itemContext = this.handleNewItem(objSource, edge, index, attrDef, itemName, isItemNumeric, rowPanelItems = rowPanelModel.getPickValuesRowPanelItems());
            if (itemContext != null) {
                if (index == -1) {
                    rowPanelItems.add(new PickValuesRowPanelItem((ItemAccess)itemContext, rowPanel));
                } else {
                    rowPanelItems.add(index, new PickValuesRowPanelItem((ItemAccess)itemContext, rowPanel));
                }
                rowPanel.update(0);
            }
            this.validateSeriesAndGroupsPanels();
        }
        return itemContext;
    }

    protected ItemContext handleNewItem(Object objSource, Edge edge, int index, AttributeDefinition attrDef, String itemName, boolean isItemNumeric, List listItems, boolean bReplace, boolean bAddItemList, boolean bForceTreatAsText) {
        ItemContext itemContext = null;
        if (listItems != null) {
            boolean treatAsText = true;
            boolean isDataPoint = this.isDataPointEdge(edge);
            Edge parent = edge;
            if (!(!isDataPoint || !isItemNumeric || bForceTreatAsText || this.alwaysForceTreatAsText() || this.isNameValuePair() && attrDef != null)) {
                parent = this.getDataItem();
                treatAsText = false;
            }
            List itemList = this.getEdgeItemList(edge);
            Item item = bReplace ? this.replaceItem((DvtBaseElementObject)parent, itemName, index, itemList) : this.addItem((DvtBaseElementObject)parent, itemName, index, itemList);
            if (bAddItemList && item != null) {
                itemContext = new ItemContext(itemName, item, (BaseElementObject)parent, attrDef, isItemNumeric, treatAsText, isDataPoint, false, bForceTreatAsText);
                if (index == -1) {
                    itemList.add(itemContext);
                } else {
                    itemList.add(index, itemContext);
                }
            }
            this.updateAttributeTable();
        }
        return itemContext;
    }

    @Override
    public void commit(Element root, Element facetDataStamp) {
        NodeList pieDataItems = facetDataStamp.getElementsByTagName(this.getChartDataItemLocalName());
        for (int i = 0; i < pieDataItems.getLength(); ++i) {
            facetDataStamp.removeChild(pieDataItems.item(i));
        }
        Element pieDataItem = GraphBindingUtilsAMX.getOnlyChildFromParent(facetDataStamp, this.getChartDataItemLocalName());
        String var = root.getAttribute("var");
        String sliceIds = GraphBindingUtilsAMX.getIdsFromItemList(this.getSeriesItems(), var);
        String sliceLabels = GraphBindingUtilsAMX.getLabelsFromItemList(this.getSeriesItems(), var);
        pieDataItem.setAttributeNS(null, "sliceId", sliceIds);
        if (sliceLabels != null) {
            pieDataItem.setAttributeNS(null, "label", sliceLabels);
        }
        if (!this.getGroupItems().isEmpty()) {
            String valueName = ((ItemContext)this.getGroupItems().get(0)).getName();
            String value = "#{" + var + "." + valueName + "}";
            pieDataItem.setAttributeNS(null, "value", value);
        }
    }

    @Override
    public String getChartDataItemLocalName() {
        return "pieDataItem";
    }

    public class AMXDataMap
    extends DataMap {
        public AMXDataMap(String strDatamapName) {
            super(strDatamapName);
        }
    }
}

