/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset;

import java.awt.GridBagConstraints;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXAreaGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXBarGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXBubbleGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXComboGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXLineGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXPieGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXScatterGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.BaseGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.CombinationGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.GraphBindingPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.HorizontalBarGraphPanel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AMXGraphBindingPanel
extends GraphBindingPanel {
    AMXGraphInnerPanel _graphPanel = null;

    public AMXGraphBindingPanel(ControlBinding controlBinding) {
        super(controlBinding);
    }

    protected BaseGraphPanel createBindingPanel(GridBagConstraints c) {
        AMXGraphInnerPanel graphPanel = null;
        if (this.isLineGraph()) {
            graphPanel = new AMXLineGraphPanel(this.getControlBinding());
        } else if (this.isCombinationGraph()) {
            AMXBarGraphPanel amxPanel = new AMXBarGraphPanel(this.getControlBinding());
            amxPanel._delegate = new CombinationGraphPanel(this.getControlBinding());
            graphPanel = amxPanel;
        } else if (this.isHorizontalBarGraph()) {
            AMXBarGraphPanel amxPanel = new AMXBarGraphPanel(this.getControlBinding());
            amxPanel._delegate = new HorizontalBarGraphPanel(this.getControlBinding());
            graphPanel = amxPanel;
        } else {
            graphPanel = this.isPieGraph() ? new AMXPieGraphPanel(this.getControlBinding()) : (this.isScatterGraph() ? new AMXScatterGraphPanel(this.getControlBinding()) : (this.isBubbleGraph() ? new AMXBubbleGraphPanel(this.getControlBinding()) : (this.isAreaGraph() ? new AMXAreaGraphPanel(this.getControlBinding()) : (this.isCombinationGraph() ? new AMXComboGraphPanel(this.getControlBinding()) : (this.isAxisGraph() ? new AMXBarGraphPanel(this.getControlBinding()) : new AMXBarGraphPanel(this.getControlBinding()))))));
        }
        if (graphPanel != null) {
            graphPanel.setGraphBindingPanel(this);
            graphPanel.setBindingUiContext(this.getBindingUiContext());
            graphPanel.setEditor(this.getEditor());
            graphPanel.initialize();
            if (graphPanel.getEdgesPanel() != null) {
                this.registerRowPanelListener(graphPanel.getSeriesEdgePanel());
                this.registerRowPanelListener(graphPanel.getGroupEdgePanel());
            }
        }
        if (graphPanel instanceof AMXGraphInnerPanel) {
            this._graphPanel = graphPanel;
        }
        return graphPanel;
    }

    public void commit() {
        Element root = this.getBindingUiContext().getRootElement();
        String var = "row";
        if (root.hasAttribute("var")) {
            var = root.getAttribute("var");
        } else {
            root.setAttributeNS(null, "var", var);
        }
        String dataStampAttribute = "dataStamp";
        Element facetDataStamp = null;
        NodeList facets = root.getElementsByTagName("facet");
        for (int i = 0; i < facets.getLength(); ++i) {
            Element facet = (Element)facets.item(i);
            if (!dataStampAttribute.equals(facet.getAttribute("name"))) continue;
            facetDataStamp = facet;
        }
        if (facetDataStamp == null) {
            facetDataStamp = root.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx", "facet");
            facetDataStamp.setAttributeNS(null, "name", dataStampAttribute);
            root.appendChild(facetDataStamp);
        }
        if (this._graphPanel != null) {
            this._graphPanel.commit(root, facetDataStamp);
        }
    }

    public static interface AMXGraphInnerPanel {
        public String getChartDataItemLocalName();

        public void commit(Element var1, Element var2);

        public void updateFakeItemsFromElement();
    }
}

