/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import oracle.adfdt.model.objects.BaseElementObject;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtilsAMX;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXGraphBindingPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.BubbleGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.ItemContext;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.MembersCombo;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.AMXAttributeLabelTable;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.AttributeLabelTable;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.AttributesPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.ItemAccess;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.NameValueAttributesPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanelItem;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.PickValuesRowPanelModel;
import oracle.adfdtinternal.model.dvt.objects.DataItem;
import oracle.adfdtinternal.model.dvt.objects.DataMap;
import oracle.adfdtinternal.model.dvt.objects.DvtBaseElementObject;
import oracle.adfdtinternal.model.dvt.objects.Edge;
import oracle.adfdtinternal.model.dvt.objects.Item;
import oracle.binding.meta.AttributeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMXBubbleGraphPanel
extends BubbleGraphPanel
implements AMXGraphBindingPanel.AMXGraphInnerPanel {
    public AMXBubbleGraphPanel(ControlBinding binding) {
        super(binding);
    }

    protected void initBindingXML() {
        String selectedValue;
        ControlBinding ctrlBinding = this.getControlBinding();
        this._dataMap = new AMXDataMap("foo");
        this._dataMap.setControlBinding(ctrlBinding);
        Element elem = ctrlBinding.getDocument().createElementNS("dvtx", "foo2");
        this._dataMap.initializeFromElement(ctrlBinding.getTransactionManager(), elem);
        this.setSeriesEdge(this.findOrCreateEdge(this._dataMap, "series"));
        this.setGroupEdge(this.findOrCreateEdge(this._dataMap, "groups"));
        this.setSeriesItems(new ArrayList());
        this.setGroupItems(new ArrayList());
        if (this.isEditMode()) {
            this.updateFakeItemsFromElement();
        }
        this.addExistingItems(this.getSeriesItems(), this.getSeriesEdge());
        this.addExistingItems(this.getGroupItems(), this.getGroupEdge());
        this.initDataPointEdge();
        this.setNameValuePair(false);
        if (this.getDataItem() == null) {
            this.setDataItem(this.findOrCreateDataItem(this.getDataPointEdge()));
        }
        if (this.getDataItem() != null && (selectedValue = this.getDataItem().getAttribute("value")) != null) {
            this.setNameValuePair(true);
        }
    }

    protected void addPanelContent(GridBagConstraints c) {
        super.addPanelContent(c);
        JButton dataShape = this.getNameValueAttributesPanel().getAttributesPanel().getButtonDataShape();
        dataShape.getParent().remove(dataShape);
    }

    public void cancel() {
        Element bubbleGraph = this.getBindingUiContext().getRootElement();
        bubbleGraph.removeAttributeNS(null, "markerShapeAttribute");
        bubbleGraph.removeAttributeNS(null, "markerColorAttribute");
    }

    protected AttributeLabelTable addAttributesTable(GridBagConstraints c) {
        AMXAttributeLabelTable attrTable = new AMXAttributeLabelTable(this.getControlBinding().getIteratorBinding());
        attrTable.setBindingUiContext(this.getBindingUiContext());
        this.updateAttributeTable(attrTable);
        this.add((Component)((Object)attrTable), c);
        return attrTable;
    }

    protected void updateAttributeTable(AttributeLabelTable attrTable) {
        List allItems = this.getAllItems();
        Edge _edge = this.getDataPointEdge();
        List _ic = this.getEdgeItemList(_edge);
        DataItem dataItem = this.getDataItem();
        if (dataItem != null) {
            List dataItems = dataItem.getItems();
            ArrayList<String> dataItemsNames = new ArrayList<String>();
            if (dataItems != null && dataItems.size() > 0) {
                for (Item item : dataItems) {
                    dataItemsNames.add(item.getValue());
                }
                if (_ic != null && !_ic.isEmpty()) {
                    for (int i = 0; i < _ic.size(); ++i) {
                        Item _item = ((ItemContext)_ic.get(i)).getItem();
                        if (!dataItemsNames.contains(_item.getValue())) continue;
                        ((ItemContext)_ic.get(i)).updateLabelOption(true, true);
                    }
                }
            }
        }
        if (attrTable == null) {
            attrTable = this.getAttributeLabelTable();
        }
        if (attrTable != null) {
            attrTable.setContext(allItems, this.getAttributeDefinitions());
        }
    }

    @Override
    public void updateFakeItemsFromElement() {
        String varString;
        Element bubbleGraph = this.getBindingUiContext().getRootElement();
        NodeList markers = bubbleGraph.getElementsByTagName(this.getChartDataItemLocalName());
        Element marker = null;
        if (markers.getLength() > 0) {
            marker = (Element)markers.item(0);
        }
        if ((varString = bubbleGraph.getAttribute("var")) == null) {
            varString = "row";
        }
        if (marker != null) {
            Element attributeGroups;
            int i;
            String sizeString;
            String yString;
            String groupIDs = marker.getAttribute("groupId");
            String groupLabels = null;
            if (groupIDs == null || groupIDs.length() == 0) {
                groupIDs = marker.getAttribute("group");
            } else {
                groupLabels = marker.getAttribute("group");
            }
            if (groupIDs != null && groupIDs.length() > 0) {
                List<String> attrNames = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groupIDs, varString);
                List<String> labelAttrNames = null;
                Item _item = null;
                if (groupLabels != null && groupLabels.length() > 0) {
                    labelAttrNames = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groupLabels, varString);
                }
                for (int i2 = 0; i2 < attrNames.size(); ++i2) {
                    _item = this.addItem((DvtBaseElementObject)this.getGroupEdge(), attrNames.get(i2), null);
                    if (labelAttrNames == null || labelAttrNames.size() != attrNames.size() || labelAttrNames.get(i2).equals(attrNames.get(i2))) continue;
                    _item.setLabel(labelAttrNames.get(i2));
                }
            }
            this.getGroupEdge().setDataItem(this.getGroupEdge().createDefaultDataItem());
            String xString = marker.getAttribute("x");
            if (xString != null) {
                String x = GraphBindingUtilsAMX.getAttrNameFromEL((String)xString, (String)varString);
                this.addItem((DvtBaseElementObject)this.getGroupEdge().getDataItem(), x, null);
            }
            if ((yString = marker.getAttribute("y")) != null) {
                String y = GraphBindingUtilsAMX.getAttrNameFromEL((String)yString, (String)varString);
                this.addItem((DvtBaseElementObject)this.getGroupEdge().getDataItem(), y, null);
            }
            if ((sizeString = marker.getAttribute("z")) != null) {
                String size = GraphBindingUtilsAMX.getAttrNameFromEL((String)sizeString, (String)varString);
                this.addItem((DvtBaseElementObject)this.getGroupEdge().getDataItem(), size, null);
            }
            NodeList attributeGroupsList = marker.getElementsByTagName("attributeGroups");
            boolean separated = true;
            for (i = 0; i < attributeGroupsList.getLength(); ++i) {
                String type;
                attributeGroups = (Element)attributeGroupsList.item(i);
                String string = type = attributeGroups.hasAttributeNS(null, "type") ? attributeGroups.getAttributeNS(null, "type") : "";
                if (type.equals("color") || type.equals("shape")) continue;
                separated = false;
                break;
            }
            if (separated) {
                String colorAttr = "";
                String shapeAttr = "";
                String colorLabel = null;
                String shapeLabel = null;
                for (int i3 = 0; i3 < attributeGroupsList.getLength(); ++i3) {
                    Element element = (Element)attributeGroupsList.item(i3);
                    String value = element.getAttribute("value");
                    if (element.hasAttributeNS(null, "type") && element.getAttributeNS(null, "type").equals("color")) {
                        colorAttr = value;
                        colorLabel = element.getAttribute("label");
                        continue;
                    }
                    shapeAttr = value;
                    shapeLabel = element.getAttribute("label");
                }
                List<String> colorNames = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(colorAttr, varString);
                String color = colorNames.get(0);
                bubbleGraph.setAttributeNS(null, "markerColorAttribute", color);
                Item _item = this.addItem((DvtBaseElementObject)this.getSeriesEdge(), color, null);
                if (colorLabel != null && colorLabel.length() > 0 && colorLabel.startsWith("#{" + varString)) {
                    String _label = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(colorLabel, varString).get(0);
                    _item.setLabel(_label);
                }
                List<String> shapeNames = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(shapeAttr, varString);
                String shape = shapeNames.get(0);
                bubbleGraph.setAttributeNS(null, "markerShapeAttribute", shape);
                _item = this.addItem((DvtBaseElementObject)this.getSeriesEdge(), shape, null);
                if (shapeLabel != null && shapeLabel.length() > 0 && shapeLabel.startsWith("#{" + varString)) {
                    String _label = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(shapeLabel, varString).get(0);
                    _item.setLabel(_label);
                }
            } else {
                for (i = 0; i < attributeGroupsList.getLength(); ++i) {
                    attributeGroups = (Element)attributeGroupsList.item(i);
                    String seriesString = attributeGroups.getAttribute("value");
                    String seriesLabel = attributeGroups.getAttribute("label");
                    if (seriesString == null) continue;
                    List<String> seriesNames = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(seriesString, varString);
                    List<String> seriesLabels = null;
                    if (seriesLabel != null && seriesLabel.length() > 0) {
                        seriesLabels = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(seriesLabel, varString);
                    }
                    for (int j = 0; j < seriesNames.size(); ++j) {
                        String _label;
                        String series = seriesNames.get(j);
                        Item _item = this.addItem((DvtBaseElementObject)this.getSeriesEdge(), series, null);
                        if (seriesLabels == null || seriesLabels.size() != seriesNames.size() || (_label = seriesLabels.get(j)).equals(series)) continue;
                        _item.setLabel(_label);
                    }
                }
            }
        }
    }

    protected MembersCombo createNameCombo() {
        return this.createMembersCombo(null, "qualifier", true, false);
    }

    protected MembersCombo createValueCombo() {
        return this.createDataCombo(null, "value", true, false);
    }

    public ItemContext handleNewItem(Object objSource, PickValuesRowPanel rowPanel, int index, AttributeDefinition attrDef, String itemName, boolean isItemNumeric) {
        ItemContext itemContext = null;
        if (rowPanel != null) {
            List rowPanelItems;
            PickValuesRowPanelModel rowPanelModel = rowPanel.getPickValuesRowPanelModel();
            Edge edge = (Edge)rowPanelModel.getEdge();
            itemContext = this.handleNewItem(objSource, edge, index, attrDef, itemName, isItemNumeric, rowPanelItems = rowPanelModel.getPickValuesRowPanelItems());
            if (itemContext != null) {
                if (index == -1) {
                    rowPanelItems.add(new PickValuesRowPanelItem((ItemAccess)itemContext, rowPanel));
                } else {
                    rowPanelItems.add(index, new PickValuesRowPanelItem((ItemAccess)itemContext, rowPanel));
                }
                rowPanel.update(0);
            }
            this.validateSeriesAndGroupsPanels();
        }
        return itemContext;
    }

    protected ItemContext handleNewItem(Object objSource, Edge edge, int index, AttributeDefinition attrDef, String itemName, boolean isItemNumeric, List listItems, boolean bReplace, boolean bAddItemList, boolean bForceTreatAsText) {
        ItemContext itemContext = null;
        if (listItems != null) {
            boolean treatAsText = true;
            boolean isDataPoint = this.isDataPointEdge(edge);
            Edge parent = edge;
            if (!(!isDataPoint || !isItemNumeric || bForceTreatAsText || this.alwaysForceTreatAsText() || this.isNameValuePair() && attrDef != null)) {
                parent = this.getDataItem();
                treatAsText = false;
            }
            List itemList = this.getEdgeItemList(edge);
            Item item = bReplace ? this.replaceItem((DvtBaseElementObject)parent, itemName, index, itemList) : this.addItem((DvtBaseElementObject)parent, itemName, index, itemList);
            if (bAddItemList && item != null) {
                itemContext = new ItemContext(itemName, item, (BaseElementObject)parent, attrDef, isItemNumeric, treatAsText, isDataPoint, false, bForceTreatAsText);
                if (index == -1) {
                    itemList.add(itemContext);
                } else {
                    itemList.add(index, itemContext);
                }
            }
            this.updateAttributeTable();
        }
        return itemContext;
    }

    @Override
    public void commit(Element root, Element facetDataStamp) {
        this.updateEdges();
        Element chartDataItem = GraphBindingUtilsAMX.getOnlyChildFromParent(facetDataStamp, this.getChartDataItemLocalName());
        String var = root.getAttribute("var");
        if (!this.getSeriesItems().isEmpty()) {
            String shapeAttribute = "";
            if (root.hasAttributeNS(null, "markerShapeAttribute")) {
                shapeAttribute = root.getAttributeNS(null, "markerShapeAttribute");
                root.removeAttributeNS(null, "markerShapeAttribute");
            }
            String colorAttribute = "";
            if (root.hasAttributeNS(null, "markerColorAttribute")) {
                colorAttribute = root.getAttributeNS(null, "markerColorAttribute");
                root.removeAttributeNS(null, "markerColorAttribute");
            }
            NodeList attributeGroupsList = root.getElementsByTagName("attributeGroups");
            for (int i = 0; i < attributeGroupsList.getLength(); ++i) {
                Node attributeGroups = attributeGroupsList.item(i);
                attributeGroups.getParentNode().removeChild(attributeGroupsList.item(i));
            }
            if (shapeAttribute.length() == 0 && colorAttribute.length() == 0) {
                Element attributeGroups = GraphBindingUtilsAMX.getOnlyChildFromParent(chartDataItem, "attributeGroups");
                String seriesName = GraphBindingUtilsAMX.getLabelStringAttributeFromList(this.getSeriesItems(), var);
                attributeGroups.setAttributeNS(null, "type", "color shape");
                attributeGroups.setAttributeNS(null, "value", seriesName);
                String seriesLabel = GraphBindingUtilsAMX.getLabelsFromItemList(this.getSeriesItems(), var);
                if (seriesLabel != null && seriesLabel.length() > 0) {
                    attributeGroups.setAttributeNS(null, "label", seriesLabel);
                }
            } else {
                String seriesLabel;
                if (shapeAttribute.length() > 0) {
                    Element attributeGroups = chartDataItem.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "attributeGroups");
                    attributeGroups.setAttributeNS(null, "type", "shape");
                    attributeGroups.setAttributeNS(null, "value", "#{" + var + "." + shapeAttribute + "}");
                    seriesLabel = ((ItemContext)this.getSeriesItems().get(1)).getItem().getLabel();
                    if (seriesLabel != null && seriesLabel.length() > 0) {
                        attributeGroups.setAttributeNS(null, "label", "#{" + var + "." + seriesLabel + "}");
                    }
                    chartDataItem.appendChild(attributeGroups);
                }
                if (colorAttribute.length() > 0) {
                    Element attributeGroups = chartDataItem.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "attributeGroups");
                    attributeGroups.setAttributeNS(null, "type", "color");
                    attributeGroups.setAttributeNS(null, "value", "#{" + var + "." + colorAttribute + "}");
                    seriesLabel = ((ItemContext)this.getSeriesItems().get(0)).getItem().getLabel();
                    if (seriesLabel != null && seriesLabel.length() > 0) {
                        attributeGroups.setAttributeNS(null, "label", "#{" + var + "." + seriesLabel + "}");
                    }
                    chartDataItem.appendChild(attributeGroups);
                }
            }
        }
        if (this.getGroupItems().size() >= 3) {
            int n = this.getGroupItems().size();
            ArrayList<ItemContext> groupItemCopy = new ArrayList<ItemContext>();
            groupItemCopy.addAll(this.getGroupItems());
            groupItemCopy.remove(n - 1);
            groupItemCopy.remove(n - 2);
            groupItemCopy.remove(n - 3);
            if (groupItemCopy.size() > 0) {
                String groupIds = GraphBindingUtilsAMX.getLabelStringAttributeFromList(groupItemCopy, var);
                String groupLabels = GraphBindingUtilsAMX.getLabelsFromItemList(groupItemCopy, var);
                if (groupLabels != null && !groupLabels.isEmpty()) {
                    chartDataItem.setAttributeNS(null, "groupId", groupIds);
                    chartDataItem.setAttributeNS(null, "group", groupLabels);
                } else {
                    chartDataItem.setAttributeNS(null, "group", groupIds);
                    chartDataItem.removeAttributeNS(null, "groupId");
                }
            } else {
                chartDataItem.removeAttributeNS(null, "group");
                chartDataItem.removeAttributeNS(null, "groupId");
            }
            String xName = ((ItemContext)this.getGroupItems().get(n - 3)).getName();
            String x = "#{" + var + "." + xName + "}";
            chartDataItem.setAttributeNS(null, "x", x);
            String yName = ((ItemContext)this.getGroupItems().get(n - 2)).getName();
            String y = "#{" + var + "." + yName + "}";
            chartDataItem.setAttributeNS(null, "y", y);
            String sizeName = ((ItemContext)this.getGroupItems().get(n - 1)).getName();
            String size = "#{" + var + "." + sizeName + "}";
            chartDataItem.setAttributeNS(null, "z", size);
        }
    }

    public Element getGraphNode() {
        Element root;
        if (this.m_graphNode == null && (root = (Element)this.getBindingUiContext().get((Object)"RootNode")) != null) {
            this.m_parentNode = null;
            this.m_graphNode = root;
        }
        return this.m_graphNode;
    }

    protected boolean useScatterAttributesPanel() {
        return true;
    }

    protected List getLabelList(boolean isNameValuePair) {
        List labelList = super.getLabelList(isNameValuePair);
        NameValueAttributesPanel panel = this.getNameValueAttributesPanel();
        if (panel != null) {
            AttributesPanel ap = panel.getAttributesPanel();
            labelList.addAll(ap.getLabels());
        }
        return labelList;
    }

    @Override
    public String getChartDataItemLocalName() {
        return "chartDataItem";
    }

    public class AMXDataMap
    extends DataMap {
        public AMXDataMap(String strDatamapName) {
            super(strDatamapName);
        }
    }
}

