/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset;

import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtilsAMX;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.AMXGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.BarGraphPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.ItemContext;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.MembersCombo;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.panels.NameValueAttributesPanel;
import oracle.adfdtinternal.model.dvt.objects.DataItem;
import oracle.adfdtinternal.model.dvt.objects.DvtBaseElementObject;
import oracle.adfdtinternal.model.dvt.objects.Item;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AMXBarGraphPanel
extends AMXGraphPanel {
    public AMXBarGraphPanel(ControlBinding controlBinding) {
        super(controlBinding);
        this.createDelegate(controlBinding);
    }

    protected void createDelegate(ControlBinding controlBinding) {
        this._delegate = new BarGraphPanel(controlBinding);
    }

    protected void addPanelContent(GridBagConstraints c) {
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        NameValueAttributesPanel nameValueAttributePanel = this.addNameValuePairsPanel(c, this.getPickValuesRowPanelsOrder());
        this.setNameValueAttributesPanel(nameValueAttributePanel);
        nameValueAttributePanel.getAttributesPanel().setChangeDataShapeDialogHelpTopicID("f1_adfmf_dvt_change_chart_data_shape_html");
        c.fill = 1;
        c.weighty = 1.0;
        ++c.gridy;
        this.setAttributeLabelTable(this.addAttributesTable(c));
        ++c.gridy;
        c.weighty = 0.0;
        c.insets.top = 10;
        this.addMasterDetailCheckbox(c);
        if (this.isNameValuePair()) {
            this.getNameValueAttributesPanel().getAttributesPanel().setBarsPanelVisible(!this.isNameValuePair());
            this.m_nameCombo.setSelectedItem((Object)this.m_qualifier);
            this.m_valueCombo.setSelectedItem((Object)this.m_value);
        }
        JButton swapButton = this.getNameValueAttributesPanel().getAttributesPanel().getButtonSwap();
        swapButton.getParent().remove(swapButton);
    }

    public void itemStateChanged(ItemEvent e) {
        Object _o;
        super.itemStateChanged(e);
        if (this.isNameValuePair() && (_o = e.getSource()) instanceof MembersCombo && e.getStateChange() == 1) {
            if (_o == this.m_nameCombo) {
                this.m_qualifier = (String)this.m_nameCombo.getSelectedItem();
            } else {
                this.m_value = (String)this.m_valueCombo.getSelectedItem();
            }
        }
    }

    protected void handleDataShape() {
        super.handleDataShape();
        this.getNameValueAttributesPanel().getAttributesPanel().setBarsPanelVisible(!this.isNameValuePair());
    }

    private boolean isNameValuePair(String var, NodeList chartDataItems) {
        if (chartDataItems.getLength() != 1) {
            return false;
        }
        Element chartDataItem = (Element)chartDataItems.item(0);
        if (!chartDataItem.hasAttribute("series")) {
            return false;
        }
        String series = chartDataItem.getAttribute("series");
        return series.startsWith("#{" + var + ".");
    }

    @Override
    public void updateFakeItemsFromElement() {
        Element barChart = this.getBindingUiContext().getRootElement();
        String varString = barChart.getAttribute("var");
        if (varString == null) {
            varString = "row";
        }
        NodeList chartDataItems = barChart.getElementsByTagName(this.getChartDataItemLocalName());
        Element chartDataItem = null;
        if (chartDataItems.getLength() == 0) {
            return;
        }
        LinkedList<String> groupValues = new LinkedList<String>();
        if (this.isNameValuePair(varString, chartDataItems)) {
            chartDataItem = (Element)chartDataItems.item(0);
            String groupIds = chartDataItem.getAttribute("groupId");
            String groups = chartDataItem.getAttribute("group");
            boolean haveLabels = false;
            if (groupIds == null || groupIds.length() == 0) {
                groupIds = groups;
            } else if (groups != null && groups.startsWith("#{")) {
                haveLabels = true;
            }
            List<String> idValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groupIds, varString);
            List<String> labelValues = null;
            if (haveLabels) {
                labelValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groups, varString);
            }
            String _label = null;
            for (int j = 0; j < idValues.size(); ++j) {
                String _id = idValues.get(j);
                if (haveLabels) {
                    _label = labelValues.get(j);
                }
                if (groupValues.contains(_id)) continue;
                Item _newitem = this.addItem((DvtBaseElementObject)this.getGroupEdge(), _id, null);
                if (_label != null && !_label.equals(_id)) {
                    _newitem.setLabel(_label);
                }
                groupValues.add(_id);
            }
            String series = GraphBindingUtilsAMX.getAttrNameFromEL((String)chartDataItem.getAttribute("series"), (String)varString);
            String y = GraphBindingUtilsAMX.getAttrNameFromEL((String)chartDataItem.getAttribute("value"), (String)varString);
            this.m_qualifier = series;
            this.m_value = y;
            DataItem dataItem = this.getSeriesEdge().createDefaultDataItem();
            this.getSeriesEdge().setDataItem(dataItem);
            this.setDataItem(dataItem);
            dataItem.setAttribute("qualifier", series);
            dataItem.setAttribute("value", y);
        } else {
            String value = null;
            for (int i = 0; i < chartDataItems.getLength(); ++i) {
                chartDataItem = (Element)chartDataItems.item(i);
                String groupYValue = chartDataItem.getAttribute("value");
                if (groupYValue != null) {
                    value = GraphBindingUtilsAMX.getAttrNameFromEL((String)groupYValue, (String)varString);
                    DataItem dataItem = this.getSeriesEdge().getDataItem();
                    if (dataItem == null) {
                        dataItem = this.getSeriesEdge().createDefaultDataItem();
                        this.getSeriesEdge().setDataItem(dataItem);
                    }
                    if (dataItem.getItemByValue(value) == null) {
                        this.addItem((DvtBaseElementObject)dataItem, value, null);
                    }
                }
                String groupIds = chartDataItem.getAttribute("groupId");
                String groups = chartDataItem.getAttribute("group");
                boolean haveLabels = false;
                if (groupIds == null || groupIds.length() == 0) {
                    groupIds = groups;
                } else if (groups != null && groups.startsWith("#{")) {
                    haveLabels = true;
                }
                List<String> idValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groupIds, varString);
                List<String> labelValues = null;
                if (haveLabels) {
                    labelValues = GraphBindingUtilsAMX.getAttrNamesFromLabelEL(groups, varString);
                }
                String _label = null;
                for (int j = 0; j < idValues.size(); ++j) {
                    String _id = idValues.get(j);
                    if (haveLabels) {
                        _label = labelValues.get(j);
                    }
                    if (groupValues.contains(_id)) continue;
                    Item _newitem = this.addItem((DvtBaseElementObject)this.getGroupEdge(), _id, null);
                    if (_label != null && !_label.equals(_id)) {
                        _newitem.setLabel(_label);
                    }
                    groupValues.add(_id);
                }
                String seriesString = chartDataItem.getAttribute("series");
                Item _item = this.getSeriesEdge().getDataItem().getItemByValue(value);
                if (_item == null) continue;
                ControlBinding binding = this.getControlBinding();
                String bindingName = binding.getId();
                String defLabel = "#{bindings." + bindingName + ".hints." + value + ".label}";
                if (seriesString != null && seriesString.length() > 0) {
                    if (!seriesString.equals(defLabel)) {
                        _item.setLabel(seriesString);
                        continue;
                    }
                    _item.setLabel(ItemContext.USE_ATTRIBUTE_NAME);
                    continue;
                }
                _item.setLabel("__NO_LABEL");
            }
        }
    }

    @Override
    public void commit(Element root, Element facetDataStamp) {
        NodeList chartDataItems = facetDataStamp.getElementsByTagName(this.getChartDataItemLocalName());
        for (int i = 0; i < chartDataItems.getLength(); ++i) {
            facetDataStamp.removeChild(chartDataItems.item(i));
        }
        String var = root.getAttribute("var");
        String groupIds = GraphBindingUtilsAMX.getIdsFromItemList(this.getGroupItems(), var);
        String groupLabels = GraphBindingUtilsAMX.getLabelsFromItemList(this.getGroupItems(), var);
        if (this.isNameValuePair()) {
            String qualifier = this.m_nameCombo.getSelectedAttributeDefinition().getName();
            String value = this.m_valueCombo.getSelectedAttributeDefinition().getName();
            Element chartDataItem = GraphBindingUtilsAMX.getOnlyChildFromParent(facetDataStamp, this.getChartDataItemLocalName());
            facetDataStamp.appendChild(chartDataItem);
            if (groupLabels != null && !groupLabels.isEmpty()) {
                chartDataItem.setAttributeNS(null, "groupId", groupIds);
                chartDataItem.setAttributeNS(null, "group", groupLabels);
            } else {
                chartDataItem.setAttributeNS(null, "group", groupIds);
            }
            this.commitToDataItem(root, chartDataItem, var, value);
            chartDataItem.setAttributeNS(null, "series", "#{" + var + "." + qualifier + "}");
        } else {
            for (ItemContext seriesItem : this.getSeriesItems()) {
                if (!seriesItem.isNumeric()) continue;
                Element chartDataItem = root.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", this.getChartDataItemLocalName());
                facetDataStamp.appendChild(chartDataItem);
                if (groupLabels != null && !groupLabels.isEmpty()) {
                    chartDataItem.setAttributeNS(null, "groupId", groupIds);
                    chartDataItem.setAttributeNS(null, "group", groupLabels);
                } else {
                    chartDataItem.setAttributeNS(null, "group", groupIds);
                }
                this.commitToDataItem(root, chartDataItem, var, seriesItem.getName());
                ControlBinding binding = this.getControlBinding();
                String bindingName = binding.getId();
                String label = seriesItem.getItem().getLabel();
                if (label == null || label.equals("") || label == ItemContext.USE_ATTRIBUTE_NAME) {
                    label = "#{bindings." + bindingName + ".hints." + seriesItem.getName() + ".label}";
                } else if (label.equals("__NO_LABEL")) {
                    label = "";
                }
                chartDataItem.setAttributeNS(null, "series", label);
            }
        }
    }

    @Override
    public String getChartDataItemLocalName() {
        return "chartDataItem";
    }

    protected void commitToDataItem(Element root, Element dataStamp, String var, String seriesItem) {
        dataStamp.setAttributeNS(null, "value", "#{" + var + "." + seriesItem + "}");
    }
}

