/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlHier;
import oracle.adfdt.model.objects.CtrlHierTypeBinding;
import oracle.adfdt.model.objects.IteratorBinding;
import oracle.adfdt.view.ui.editor.ExpressionOrDefinitionPicker;
import oracle.adfdtinternal.dvt.datapresdt.dnd.AMXGeoMapModelProvider;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtils;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.BasePanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.MembersCombo;
import oracle.adfdtinternal.model.dvt.ide.objects.resource.DvtBindingResources;
import oracle.adfdtinternal.model.dvt.ide.objects.utils.ADFmUtils;
import oracle.adfdtinternal.model.dvt.ide.objects.utils.GuiUtilsBindings;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.ide.Context;
import oracle.javatools.ui.Colors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMXGeoMapPointThemeBindPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    protected JTextField _idField;
    protected transient Element _dataLayer;
    protected transient Element _pointLocation;
    protected JCheckBox _rowSelectionCheckBox;
    protected MembersCombo _pointLocationCombo;
    protected MembersCombo _latitudeCombo;
    protected MembersCombo _longitudeCombo;
    protected JEWTDialog _dialog = null;
    private boolean _city = false;
    private static final String POINT_LOCATION_NAME = "pointLocation";
    private static final String POINT_DATA_LAYER_NAME = "pointDataLayer";
    private static final String MARKER_NAME = "marker";
    private static final String ADDRESS = "address";
    private static final String POINT_XY = "pointXY";
    private static final String POINT_X = "pointX";
    private static final String POINT_Y = "pointY";

    public AMXGeoMapPointThemeBindPanel(ControlBinding controlBinding) {
        super(controlBinding);
    }

    public void cleanUp() {
    }

    public void initialize() {
        Element root = this.getBindingUiContext().getRootElement();
        if (root == null) {
            return;
        }
        this._dataLayer = this.findOrCreateElement(root, POINT_DATA_LAYER_NAME);
        JPanel pointOrAreaMainPanel = this.createDataLayerPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        MultiLineLabel ml = new MultiLineLabel();
        ml.setTextWrapper(WordWrapper.getTextWrapper());
        String strDescString = DvtBindingResources.getResource((String)"MAP_POINT_THEME_BINDING_DESC");
        ml.setText(StringUtils.stripMnemonic((String)strDescString));
        ml.setForeground(Colors.HINT_TEXT);
        ml.setPreferredSize(new Dimension(450, 45));
        this.add((Component)ml, c);
        ++c.gridy;
        JPanel layerIdPanel = new JPanel();
        layerIdPanel.setLayout(new BoxLayout(layerIdPanel, 2));
        layerIdPanel.setPreferredSize(new Dimension(450, this._pointLocationCombo.getPreferredSize().height));
        ADFDesignTimeContext dtContext = this.getBindingUiContext().getADFDesignTimeContext();
        this._idField = new JTextField(dtContext.generateUniqueIdForView("pdl"));
        JLabel idLabel = GuiUtilsBindings.createLabelFor((String)"TM_LAYER_ID", (JComponent)this._idField);
        layerIdPanel.add(idLabel);
        layerIdPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        layerIdPanel.add(this._idField);
        if (this.getEditor().isEditBinding() && this._dataLayer != null) {
            if (this._dataLayer.hasAttribute("id")) {
                this._idField.setText(this._dataLayer.getAttribute("id"));
            }
            this._rowSelectionCheckBox.setSelected(this._dataLayer.hasAttribute("selectionListener") && this._dataLayer.hasAttribute("selectedRowKeys") && this._dataLayer.hasAttribute("dataSelection") && this._dataLayer.getAttribute("dataSelection").equals("single"));
        }
        GuiUtilsBindings.makeCompactGrid((Container)layerIdPanel, (int)1, (int)2, (int)0, (int)0, (int)0, (int)0);
        c.insets.bottom = 10;
        this.add(layerIdPanel, c);
        ++c.gridy;
        c.insets.bottom = 0;
        this.add(pointOrAreaMainPanel, c);
    }

    private JPanel createDataLayerPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 21;
        JPanel pointDataLayerPanel = this.createPointDataLayerPanel();
        result.add((Component)pointDataLayerPanel, c);
        ++c.gridy;
        String rowSelectionLabel = DvtBindingResources.getResource((String)"GRAPH_MASTER_DETAIL");
        this._rowSelectionCheckBox = new JCheckBox(DvtBindingResources.stripMnemonicFromResource((String)rowSelectionLabel));
        result.add((Component)this._rowSelectionCheckBox, c);
        return result;
    }

    private JPanel createPointDataLayerPanel() {
        NodeList pointLocations;
        JPanel pointDataLayerPanel = new JPanel(new SpringLayout());
        pointDataLayerPanel.add(new JLabel(DvtBindingResources.getResource((String)"TM_DATA_TYPE")));
        String cityLabel = DvtBindingResources.getResource((String)"AMX_GEOMAP_POINT_THEME_DIALOG_ADDRESS");
        cityLabel = cityLabel.substring(0, cityLabel.lastIndexOf(":"));
        JRadioButton cityButton = new JRadioButton(DvtBindingResources.stripMnemonicFromResource((String)cityLabel), true);
        String coordinateLabel = DvtBindingResources.getResource((String)"TM_COORDINATE");
        JRadioButton coordButton = new JRadioButton(DvtBindingResources.stripMnemonicFromResource((String)coordinateLabel), false);
        ButtonGroup group = new ButtonGroup();
        group.add(cityButton);
        group.add(coordButton);
        JPanel buttonPanel = new JPanel(new SpringLayout());
        buttonPanel.add(cityButton);
        buttonPanel.add(coordButton);
        GuiUtilsBindings.makeCompactGrid((Container)buttonPanel, (int)1, (int)2, (int)0, (int)0, (int)3, (int)3);
        pointDataLayerPanel.add(buttonPanel);
        this._pointLocationCombo = this.createMembersCombo(1, ADDRESS);
        pointDataLayerPanel.add(GuiUtilsBindings.createLabelFor((String)"AMX_GEOMAP_POINT_THEME_DIALOG_ADDRESS", (JComponent)this._pointLocationCombo));
        pointDataLayerPanel.add((Component)this._pointLocationCombo);
        this._longitudeCombo = this.createMembersCombo(2, POINT_X);
        pointDataLayerPanel.add(GuiUtilsBindings.createLabelFor((String)"AMX_GEOMAP_POINT_THEME_DIALOG_POINT_X", (JComponent)this._longitudeCombo));
        pointDataLayerPanel.add((Component)this._longitudeCombo);
        this._latitudeCombo = this.createMembersCombo(2, POINT_Y);
        pointDataLayerPanel.add(GuiUtilsBindings.createLabelFor((String)"AMX_GEOMAP_POINT_THEME_DIALOG_POINT_Y", (JComponent)this._latitudeCombo));
        pointDataLayerPanel.add((Component)this._latitudeCombo);
        cityButton.addActionListener(new ComponentEnablerListener(true));
        coordButton.addActionListener(new ComponentEnablerListener(false));
        cityButton.doClick();
        if (this.getEditor().isEditBinding() && this._dataLayer != null && (pointLocations = this._dataLayer.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/amx/dvt", POINT_LOCATION_NAME)).getLength() > 0) {
            String pointXY = POINT_XY;
            Element pointLocation = (Element)pointLocations.item(0);
            if (pointXY.equals(pointLocation.getAttribute("type"))) {
                coordButton.doClick();
                this.setMembersComboSelection(this._longitudeCombo, this._dataLayer.getAttribute("var"), pointLocation.getAttribute(POINT_X));
                this.setMembersComboSelection(this._latitudeCombo, this._dataLayer.getAttribute("var"), pointLocation.getAttribute(POINT_Y));
            } else {
                this.setMembersComboSelection(this._pointLocationCombo, this._dataLayer.getAttribute("var"), pointLocation.getAttribute(ADDRESS));
            }
        }
        JPanel fillerPanel = new JPanel();
        JPanel finalPanel = new JPanel(new SpringLayout());
        finalPanel.add(pointDataLayerPanel);
        finalPanel.add(fillerPanel);
        fillerPanel.setPreferredSize(new Dimension(450, 15));
        GuiUtilsBindings.makeCompactGrid((Container)finalPanel, (int)2, (int)1, (int)0, (int)0, (int)0, (int)0);
        GuiUtilsBindings.makeCompactGrid((Container)pointDataLayerPanel, (int)4, (int)2, (int)0, (int)0, (int)0, (int)5);
        return finalPanel;
    }

    private void setMembersComboSelection(MembersCombo combo, String var, String expression) {
        boolean _found = false;
        if (ResourceUtils.isELExpression((String)expression)) {
            int start = expression.indexOf(".");
            String _attribute = expression.substring(start + 1, expression.lastIndexOf("}"));
            if (_attribute.indexOf("#") > 0 || _attribute.indexOf(".") > 0 || _attribute.indexOf("{") > 0) {
                combo.setSelectedItem((Object)expression);
                return;
            }
            for (int i = 0; i < combo.getItemCount(); ++i) {
                String _comboAttr = (String)combo.getItemAt(i);
                if (!_comboAttr.equals(_attribute)) continue;
                combo.setSelectedIndex(i);
                _found = true;
                break;
            }
        }
        if (!_found) {
            combo.setSelectedItem((Object)expression);
        }
    }

    private String getExpressionFromMembersCombo(MembersCombo combo, String var) {
        String strRetVal = "";
        if (combo == null) {
            return "";
        }
        Object selected = combo.getSelectedItem();
        if (selected == null) {
            return "";
        }
        String value = selected.toString();
        if (ResourceUtils.isELExpression((String)value)) {
            return value;
        }
        AttributeDefinition attr = combo.getSelectedAttributeDefinition();
        if (attr != null) {
            value = attr.getName();
            strRetVal = "#{" + var + "." + value + "}";
        } else {
            strRetVal = value;
        }
        return strRetVal;
    }

    protected List<AttributeDefinition> getAttributeDefinitionList() {
        return ADFmUtils.getAttributeDefinitions((StructureDefinition)AMXGeoMapPointThemeBindPanel.getDefinition((IteratorBinding)this.getIteratorBinding()), (boolean)true);
    }

    private MembersCombo createMembersCombo(int type, String attributeName) {
        List<AttributeDefinition> attrDefs = this.getAttributeDefinitionList();
        MembersCombo membersCombo = new MembersCombo(attrDefs, null, attributeName, type, false, false);
        DefaultComboBoxModel model = (DefaultComboBoxModel)membersCombo.getModel();
        model.addElement(DvtBindingResources.getResource((String)"EXPRESSION_BUILDER"));
        membersCombo.setEditable(true);
        membersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MembersCombo mc = (MembersCombo)e.getSource();
                if (mc.getSelectedItem().equals(DvtBindingResources.getResource((String)"EXPRESSION_BUILDER"))) {
                    mc.setPopupVisible(false);
                    Context ideContext = null;
                    XmlContext xmlContext = (XmlContext)AMXGeoMapPointThemeBindPanel.this.getBindingUiContext().get((Object)"XmlContext");
                    ideContext = xmlContext instanceof JDevXmlContext ? ((JDevXmlContext)xmlContext).createContext() : Context.newIdeContext();
                    Element parent = (Element)AMXGeoMapPointThemeBindPanel.this.getBindingUiContext().get((Object)"InsertionSubtreeRoot");
                    ExpressionOrDefinitionPicker picker = new ExpressionOrDefinitionPicker(DvtBindingResources.getResource((String)"TM_PICKER"), ideContext, (Node)parent, null, null, ExpressionOrDefinitionPicker.Mode.EL_ONLY);
                    boolean flag = picker.launch();
                    if (flag) {
                        Object value = picker.getValue();
                        String valueString = value != null ? value.toString() : "";
                        mc.setSelectedItem((Object)valueString);
                    } else {
                        mc.setSelectedItem((Object)"");
                    }
                }
                AMXGeoMapPointThemeBindPanel.this.validateEditPanel();
            }
        });
        ListCellRenderer currentRenderer = membersCombo.getRenderer();
        membersCombo.setRenderer((ListCellRenderer)new MembersComboRenderer(currentRenderer));
        return membersCombo;
    }

    private boolean isEditPanelValid() {
        boolean valid = true;
        return valid &= this.validatePointDataLayerCreation();
    }

    public boolean validatePointDataLayerCreation() {
        boolean valid = true;
        if (this._pointLocationCombo != null && this._pointLocationCombo.isEnabled()) {
            valid &= !AMXGeoMapPointThemeBindPanel.isComboEmpty((JComboBox)this._pointLocationCombo);
        }
        if (this._latitudeCombo != null && this._latitudeCombo.isEnabled()) {
            valid &= !AMXGeoMapPointThemeBindPanel.isComboEmpty((JComboBox)this._latitudeCombo);
        }
        if (this._longitudeCombo != null && this._longitudeCombo.isEnabled()) {
            valid &= !AMXGeoMapPointThemeBindPanel.isComboEmpty((JComboBox)this._longitudeCombo);
        }
        return valid;
    }

    public void validateEditPanel() {
        boolean valid = this.isEditPanelValid();
        if (this._dialog != null) {
            this._dialog.setOKButtonEnabled(valid);
        }
    }

    public void setDialogSize(JEWTDialog dialog) {
        dialog.pack();
        dialog.setResizable(true);
        this._dialog = dialog;
        this.validateEditPanel();
    }

    public void reset() {
    }

    public void commit() {
        String type;
        String var;
        AMXGeoMapModelProvider _modelProvider = (AMXGeoMapModelProvider)((Object)this.getBindingUiContext().get((Object)"Model_Provider"));
        this._dataLayer.setAttributeNS(null, "id", this._idField.getText());
        if (this._rowSelectionCheckBox != null && this._rowSelectionCheckBox.isSelected()) {
            if (_modelProvider != null) {
                this._dataLayer.setAttributeNS(null, "selectedRowKeys", _modelProvider.getSelectedRowKeysExpression());
                this._dataLayer.setAttributeNS(null, "selectionListener", _modelProvider.getSelectionListenerExpression());
                this._dataLayer.setAttributeNS(null, "dataSelection", "single");
            }
        } else {
            this._dataLayer.removeAttributeNS(null, "dataSelection");
            this._dataLayer.removeAttributeNS(null, "selectedRowKeys");
            this._dataLayer.removeAttributeNS(null, "selectionListener");
        }
        if (_modelProvider != null) {
            this._dataLayer.setAttributeNS(null, "value", _modelProvider.getValueExpression());
        }
        if ((var = this._dataLayer.getAttribute("var")) == null || var.length() == 0) {
            var = "row";
            this._dataLayer.setAttributeNS(null, "var", var);
        }
        ADFDesignTimeContext dtContext = this.getBindingUiContext().getADFDesignTimeContext();
        this._pointLocation = this.findOrCreateElement(this._dataLayer, POINT_LOCATION_NAME);
        Element marker = this.findOrCreateElement(this._pointLocation, MARKER_NAME);
        if (marker != null && !marker.hasAttributeNS(null, "id")) {
            String id = dtContext.generateUniqueIdForView("mrk");
            marker.setAttributeNS(null, "id", id);
        }
        if (this._city) {
            type = ADDRESS;
            this._pointLocation.removeAttributeNS(null, POINT_X);
            this._pointLocation.removeAttributeNS(null, POINT_Y);
            this._pointLocation.setAttributeNS(null, ADDRESS, this.getExpressionFromMembersCombo(this._pointLocationCombo, var));
        } else {
            type = POINT_XY;
            this._pointLocation.removeAttributeNS(null, ADDRESS);
            this._pointLocation.setAttributeNS(null, POINT_X, this.getExpressionFromMembersCombo(this._longitudeCombo, var));
            this._pointLocation.setAttributeNS(null, POINT_Y, this.getExpressionFromMembersCombo(this._latitudeCombo, var));
        }
        String id = dtContext.generateUniqueIdForView("ptl");
        this._pointLocation.setAttributeNS(null, "id", id);
        this._pointLocation.setAttributeNS(null, "type", type);
    }

    private Element findOrCreateElement(Element parent, String elementName) {
        Element elementToFind = null;
        NodeList nodes = parent.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/amx/dvt", elementName);
        if (nodes.getLength() > 0) {
            elementToFind = (Element)nodes.item(0);
        } else {
            elementToFind = parent.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", elementName);
            elementToFind.setPrefix("dvtm");
            parent.appendChild(elementToFind);
        }
        return elementToFind;
    }

    private String[] getAttributeNames() {
        List<AttributeDefinition> list = this.getAttributeDefinitionList();
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).getName();
        }
        return result;
    }

    public CtrlHierTypeBinding[] getAllRules() {
        CtrlHierTypeBinding newRule = ((CtrlHier)this.getControlBinding()).createJUDTCtrlHierTypeBindingClass();
        Element element = this.getControlBinding().getOwnerDocument().createElementNS("http://xmlns.oracle.com/adfm/uimodel", "nodeDefinition");
        newRule.initializeFromElement(this.getControlBinding().getTransactionManager(), element);
        if (!this.getControlBinding().getNameSpaceUrl().equals(this.getControlBinding().getNameSpaceUrl())) {
            newRule.saveNameSpace();
        }
        String ctrlBindingId = this.getControlBinding().getId();
        StructureDefinition sd = this.getControlBinding().getIteratorBinding().getDefinition();
        newRule.setViewDefName(sd.getFullName());
        newRule.setAttrNames(this.getAttributeNames());
        newRule.setTypebindingName(ctrlBindingId + "0");
        return new CtrlHierTypeBinding[]{newRule};
    }

    private class ComponentEnablerListener
    implements ActionListener {
        private boolean _isCity;

        public ComponentEnablerListener(boolean isCity) {
            this._isCity = isCity;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AMXGeoMapPointThemeBindPanel.this._city = this._isCity;
            AMXGeoMapPointThemeBindPanel.this._pointLocationCombo.setEnabled(AMXGeoMapPointThemeBindPanel.this._city);
            AMXGeoMapPointThemeBindPanel.this._latitudeCombo.setEnabled(!AMXGeoMapPointThemeBindPanel.this._city);
            AMXGeoMapPointThemeBindPanel.this._longitudeCombo.setEnabled(!AMXGeoMapPointThemeBindPanel.this._city);
            AMXGeoMapPointThemeBindPanel.this.validateEditPanel();
        }
    }

    public class MembersComboRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;
        private JPanel separatorPanel = new JPanel(new BorderLayout());
        private JSeparator separator = new JSeparator();

        public MembersComboRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index != -1 && this.addSeparatorAfter(list, value, index)) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                return this.separatorPanel;
            }
            return comp;
        }

        protected boolean addSeparatorAfter(JList list, Object value, int index) {
            return index == list.getModel().getSize() - 2;
        }
    }

    public static enum Mode {
        DATA_FIRST,
        UI_FIRST,
        EDIT,
        EDIT_BOUND,
        EDIT_UNBOUND;

    }
}

