/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.ide.objects.bindPanels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.adfdt.common.ui.collection.Collection;
import oracle.adfdt.common.ui.collection.CollectionPanelDecorator;
import oracle.adfdt.common.ui.collection.Item;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtilsBindings;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.BasePanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.MembersCombo;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.PropertyEditorComboWithResourceSupport;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.PropertyUpdater;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.AMXGaugeThresholdCollection;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.SimpleResourceEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.rowset.Threshold;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.ColumnDefinition;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.ComboColumnDefinition;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtCollection;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtCollectionSummaryPanel;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.DvtTableDecorator;
import oracle.adfdtinternal.model.dvt.ide.objects.controls.table.EditableComboColumnDefinition;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.AMXGaugeEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.resource.DvtBindingResources;
import oracle.adfdtinternal.model.dvt.ide.objects.utils.GuiUtilsBindings;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.validate.Validator;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.jdevimpl.webapp.common.html.ColorUtils;
import org.w3c.dom.Element;

public class AMXGaugeBindPanel
extends BasePanel {
    boolean m_initialized = false;
    AMXGaugeEditor m_editor;
    private ValidationMessagePane _pane = new ValidationMessagePane();
    private Set<ValidationComponent> m_validationComponents = new HashSet<ValidationComponent>();
    protected AMXGaugeThresholdCollection m_thresholdCollection;
    protected boolean m_keyNavigation = false;
    protected int m_navigationKey = -1;
    public static final String EMPTY_VALUE = "";
    protected static final String PICK_THRESHOLD_LABEL = DvtBindingResources.getResource((String)"DEFAULT_GAUGE_THRESHOLD_LABEL");

    public AMXGaugeBindPanel(ControlBinding controlBinding, AMXGaugeEditor editor) {
        super(controlBinding);
        this.m_editor = editor;
    }

    public void cleanUp() {
    }

    public void reset() {
    }

    public void initialize() {
        this.m_editor.initializeGaugeArtifacts();
        this.addPanelContent();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.isRatingGauge() ? 500 : 600, this.isRatingGauge() ? 200 : 300);
    }

    void addPanelContent() {
        int row;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, this.getIndent(), 5, this.getIndent()));
        MultiLineLabel desc = new MultiLineLabel();
        desc.setTextWrapper(WordWrapper.getTextWrapper());
        desc.setText(this.getBindingPanelDescription());
        desc.setForeground(Colors.HINT_TEXT);
        desc.setPreferredRows(2);
        desc.setMinimumRows(2);
        desc.setMaximumRows(2);
        this.add((Component)desc);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel metricsPane = new JPanel(new SpringLayout());
        MembersCombo combo = this.createMetricCombo();
        combo.setEditable(false);
        this.prepareForWarning((JComboBox)combo);
        JLabel label = GuiUtilsBindings.createLabelFor((String)(this.isRatingGauge() ? "AMX_GAUGE_RATING_ATTR" : "GAUGE_METRIC_ATTR"), (JComponent)combo);
        metricsPane.add(label);
        metricsPane.add((Component)combo);
        String metricValue = this.m_editor.getGaugeTagProperties().getValue();
        if (metricValue != null) {
            combo.setSelectedItem((Object)metricValue);
        }
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MembersCombo _combo = (MembersCombo)e.getSource();
                String newGaugeValue = (String)_combo.getSelectedItem();
                AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setValue(newGaugeValue);
            }
        });
        if (this.m_editor.isAccessorDefinition()) {
            String selected = this.m_editor.getGaugeTagProperties().getMinValue();
            MembersCombo minCombo = this.createMinimumCombo();
            minCombo.setEditable(true);
            if (selected != null) {
                if (!this.m_editor.isLiteral(selected)) {
                    minCombo.setSelectedItem((Object)selected);
                } else {
                    ((JTextField)minCombo.getEditor().getEditorComponent()).setText(selected);
                }
            }
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_MINIMUM_ATTR", (JComponent)minCombo);
            metricsPane.add(label);
            metricsPane.add((Component)minCombo);
            minCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MembersCombo _combo = (MembersCombo)e.getSource();
                    String newValue = (String)_combo.getSelectedItem();
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMinValue(newValue);
                }
            });
            selected = this.m_editor.getGaugeTagProperties().getMaxValue();
            MembersCombo maxCombo = this.createMaximumCombo();
            maxCombo.setEditable(true);
            if (selected != null) {
                if (!this.m_editor.isLiteral(selected)) {
                    maxCombo.setSelectedItem((Object)selected);
                } else {
                    ((JTextField)maxCombo.getEditor().getEditorComponent()).setText(selected);
                }
            }
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_MAXIMUM_ATTR", (JComponent)maxCombo);
            metricsPane.add(label);
            metricsPane.add((Component)maxCombo);
            maxCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MembersCombo _combo = (MembersCombo)e.getSource();
                    String newValue = (String)_combo.getSelectedItem();
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMaxValue(newValue);
                }
            });
        } else {
            IntegerTextField textField = new IntegerTextField();
            textField.setText(this.m_editor.getGaugeTagProperties().getMinValue());
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keycode = e.getKeyCode();
                    IntegerTextField tf = (IntegerTextField)e.getSource();
                    if (keycode == 27) {
                        String oldText = String.valueOf(tf.getText());
                        tf.setText(oldText);
                        return;
                    }
                    if (keycode == 10) {
                        AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMinValue(tf.getText());
                        return;
                    }
                    if (keycode == 0) {
                        return;
                    }
                }
            });
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    IntegerTextField tf = (IntegerTextField)e.getSource();
                    if (e.isTemporary()) {
                        return;
                    }
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMinValue(tf.getText());
                }
            });
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_MINIMUM_ATTR", (JComponent)textField);
            metricsPane.add(label);
            metricsPane.add(textField);
            textField = new IntegerTextField();
            textField.setText(this.m_editor.getGaugeTagProperties().getMaxValue());
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keycode = e.getKeyCode();
                    IntegerTextField tf = (IntegerTextField)e.getSource();
                    if (keycode == 27) {
                        String oldText = String.valueOf(tf.getText());
                        tf.setText(oldText);
                        return;
                    }
                    if (keycode == 10) {
                        AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMaxValue(tf.getText());
                        return;
                    }
                    if (keycode == 0) {
                        return;
                    }
                }
            });
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    IntegerTextField tf = (IntegerTextField)e.getSource();
                    if (e.isTemporary()) {
                        return;
                    }
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setMaxValue(tf.getText());
                }
            });
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_MAXIMUM_ATTR", (JComponent)textField);
            metricsPane.add(label);
            metricsPane.add(textField);
        }
        if (this.useBackgroundPanel()) {
            List<String> values = this.m_editor.getBackgroundNames();
            String selected = this.m_editor.getSelectedBackgroundName();
            if (this.m_editor.getGaugeNode() != null && selected != null && ResourceUtilsBindings.isELExpression((String)selected.toString())) {
                selected = this.m_editor.resolveResourceExpression(selected.toString());
            }
            Object local = new Object();
            BindingUiContext context = this.getBindingUiContext();
            BackgroundUpdater backgroundUpdater = new BackgroundUpdater();
            AbstractModel model = null;
            PropertyEditorComboWithResourceSupport backgroundCombo = this.createBackgroundCombo(values, selected, local, context, backgroundUpdater, model);
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_BACKGROUND", (JComponent)backgroundCombo);
            metricsPane.add(label);
            metricsPane.add((Component)backgroundCombo);
            values = this.m_editor.getIndicatorNames();
            selected = this.m_editor.getSelectedIndicator();
            if (this.m_editor.getGaugeNode() != null && selected != null && ResourceUtilsBindings.isELExpression((String)selected.toString())) {
                selected = this.m_editor.resolveResourceExpression(selected.toString());
            }
            IndicatorUpdater indicatorUpdater = new IndicatorUpdater();
            PropertyEditorComboWithResourceSupport indicatorCombo = this.createIndicatorCombo(values, selected, local, context, indicatorUpdater, model);
            label = GuiUtilsBindings.createLabelFor((String)"GAUGE_INDICATOR", (JComponent)indicatorCombo);
            metricsPane.add(label);
            metricsPane.add((Component)indicatorCombo);
        }
        int n = row = this.useBackgroundPanel() ? 5 : 3;
        if (this.useShapePanel()) {
            this.addSelectedShapePanel(metricsPane);
            ++row;
        }
        GuiUtilsBindings.makeCompactGrid((Container)metricsPane, (int)row, (int)2, (int)0, (int)5, (int)5, (int)10);
        this.add(metricsPane);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel metricLabelPane = new JPanel();
        metricLabelPane.setLayout(new BoxLayout(metricLabelPane, 2));
        final JCheckBox metricLabelCB = new JCheckBox();
        metricLabelCB.setText(StringUtils.stripMnemonic((String)DvtBindingResources.getResource((String)"AMX_GAUGE_METRIC_LABEL")));
        metricLabelCB.setMnemonic(StringUtils.getMnemonicKeyCode((String)DvtBindingResources.getResource((String)"AMX_GAUGE_METRIC_LABEL")));
        String value = this.m_editor.getGaugeTagProperties().getLabelDisplay();
        if (value != null && value.equals("on")) {
            metricLabelCB.setSelected(true);
        } else {
            metricLabelCB.setSelected(false);
        }
        metricLabelCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = metricLabelCB.isSelected();
                if (enabled) {
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setLabelDisplay("on");
                } else {
                    AMXGaugeBindPanel.this.m_editor.getGaugeTagProperties().setLabelDisplay("off");
                }
            }
        });
        metricLabelPane.add(metricLabelCB);
        metricLabelPane.add(Box.createRigidArea(new Dimension(500, 4)));
        if (!this.isRatingGauge()) {
            this.add(metricLabelPane);
            this.add(Box.createRigidArea(new Dimension(1, 10)));
        }
        JPanel tresholdsTable = this.getThresholdTable();
        if (this.useTresholdsTable()) {
            this.add(tresholdsTable);
        } else {
            this.add(Box.createVerticalGlue());
            this.add(Box.createVerticalStrut(200));
        }
    }

    protected void addSelectedShapePanel(JPanel contentPane) {
        List<String> values = this.m_editor.getSelectedShapeNames();
        String selected = this.m_editor.getCurrentSelectedShapeName();
        if (this.m_editor.getGauge() != null && selected != null && ResourceUtilsBindings.isELExpression((String)selected.toString())) {
            selected = this.m_editor.resolveResourceExpression(selected.toString());
        }
        BindingUiContext context = this.getBindingUiContext();
        AbstractModel model = null;
        SelectedShapeUpdater propertyUpdater = new SelectedShapeUpdater();
        Object local = new Object();
        PropertyEditorComboWithResourceSupport selectedShapeCombo = new PropertyEditorComboWithResourceSupport(values, (Object)selected, (Object)selected, 7, local, context, (PropertyUpdater)propertyUpdater, model);
        JLabel label = GuiUtilsBindings.createLabelFor((String)"GAUGE_SELECTED_SHAPE", (JComponent)selectedShapeCombo);
        contentPane.add(label);
        contentPane.add((Component)selectedShapeCombo);
    }

    protected boolean useShapePanel() {
        return this.isRatingGauge();
    }

    protected boolean useTresholdsTable() {
        return !((AMXGaugeEditor)this.getEditor()).isDialGauge() && !this.isRatingGauge();
    }

    protected boolean useBackgroundPanel() {
        return ((AMXGaugeEditor)this.getEditor()).isDialGauge();
    }

    protected String getBindingPanelDescription() {
        BindingUiContext context = this.getEditor().getBindingUiContext();
        if (context.getGaugeTypeName() != null && context.getGaugeTypeName().equals("DIAL")) {
            return DvtBindingResources.getResource((String)"AMX_GAUGE_DIAL_CREATE_BINDING_DESC");
        }
        if (this.isRatingGauge()) {
            return DvtBindingResources.getResource((String)"AMX_GAUGE_RATING_CREATE_BINDING_DESC");
        }
        return DvtBindingResources.getResource((String)"AMX_GAUGE_OTHERS_CREATE_BINDING_DESC");
    }

    protected boolean isRatingGauge() {
        return this.getEditor() instanceof AMXGaugeEditor ? ((AMXGaugeEditor)this.getEditor()).isRatingGauge() : false;
    }

    public void iteratorBindingChanged(PropertyChangeEvent dataSourceChangeEvent) {
        super.iteratorBindingChanged(dataSourceChangeEvent);
        if (this.getControlBinding().getIteratorBinding() != null) {
            GuiUtilsBindings.setEnabled((JComponent)((Object)this), (boolean)true);
        }
        this.getControlBinding().removeChildNodes();
        this.removeAll();
        this.initialize();
        this.m_thresholdCollection.removeAllItems();
        this.validate();
    }

    protected MembersCombo createMetricCombo() {
        return new MembersCombo(this.m_editor.getApplicableMetricValues(), null, "value", 2, false, false, null);
    }

    protected MembersCombo createMinimumCombo() {
        return new MembersCombo(this.m_editor.getApplicableMetricValues(), null, "minValue", 2, false, false, null);
    }

    protected MembersCombo createMaximumCombo() {
        return new MembersCombo(this.m_editor.getApplicableMetricValues(), null, "maxValue", 2, false, false, null);
    }

    protected PropertyEditorComboWithResourceSupport createBackgroundCombo(List values, Object selected, Object local, BindingUiContext context, BackgroundUpdater propertyValueUpdater, AbstractModel model) {
        return new PropertyEditorComboWithResourceSupport(values, selected, selected, 7, local, context, (PropertyUpdater)propertyValueUpdater, model);
    }

    protected PropertyEditorComboWithResourceSupport createIndicatorCombo(List values, Object selected, Object local, BindingUiContext context, IndicatorUpdater propertyValueUpdater, AbstractModel model) {
        return new PropertyEditorComboWithResourceSupport(values, selected, selected, 7, local, context, (PropertyUpdater)propertyValueUpdater, model);
    }

    public void updateWarningPanel() {
        if (this.getEditor() != null && ((AMXGaugeEditor)this.getEditor()).getBindingDialog() != null && ((AMXGaugeEditor)this.getEditor()).getBindingDialog().getValidationMessagePane() == null) {
            this._pane = new ValidationMessagePane();
            ((AMXGaugeEditor)this.getEditor()).getBindingDialog().setValidationMessagePane(this._pane);
            for (ValidationComponent vc : this.m_validationComponents) {
                this._pane.addValidationComponent(vc);
            }
        }
        for (ValidationComponent vc : this.m_validationComponents) {
            vc.validateComponent(ValidationComponent.DEFAULT_VALIDATOR);
        }
    }

    private JPanel getThresholdTable() {
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        ColumnDefinition tresholdIndex = new ColumnDefinition(){

            public TableCellEditor getTableCellEditor() {
                return null;
            }

            public TableCellRenderer getTableCellRenderer() {
                return new TresholdLabelColumnCellRenderer();
            }
        };
        tresholdIndex.setColumnName(DvtBindingResources.getResource((String)"GAUGE_THRESHOLD_NUMBER"));
        tresholdIndex.setAttributeName("display");
        tresholdIndex.setDisplayOnly(true);
        columns.add(tresholdIndex);
        EditableComboColumnDefinition thresholds = new EditableComboColumnDefinition(this.getComboModel(), this.getAttributeDefinitions());
        thresholds.setColumnName(DvtBindingResources.getResource((String)"GAUGE_THRESHOLD"));
        thresholds.setAttributeName("maxValue");
        thresholds.setDisplayOnly(false);
        columns.add((ColumnDefinition)thresholds);
        Element gaugeNode = this.m_editor.getGaugeNode();
        boolean _isEditFromPageDef = false;
        if (gaugeNode == null) {
            _isEditFromPageDef = true;
        } else {
            ComboColumnDefinition thresholdLabels = new ComboColumnDefinition(null){

                public TableCellEditor getTableCellEditor() {
                    return new SimpleResourceEditor();
                }
            };
            thresholdLabels.setColumnName(DvtBindingResources.getResource((String)"ATTRIBUTE_LABEL_TABLE_LABEL"));
            thresholdLabels.setAttributeName("text");
            thresholdLabels.setDefaultValue((Object)PICK_THRESHOLD_LABEL);
            thresholdLabels.setDisplayOnly(false);
            columns.add((ColumnDefinition)thresholdLabels);
            ColorColumnDefinition thresholdColor = new ColorColumnDefinition();
            thresholdColor.setColumnName(DvtBindingResources.getResource((String)"GAUGE_THRESHOLD_COLOR_LABEL"));
            thresholdColor.setAttributeName("color");
            thresholdColor.setDisplayOnly(false);
            columns.add(thresholdColor);
        }
        List<Threshold> thresholdProperties = this.m_editor.getThresholds();
        List<String> labels = null;
        List<Color> colors = null;
        if (thresholdProperties != null) {
            colors = this.getThresholdColors(thresholdProperties);
            labels = this.getThresholdLabels(thresholdProperties);
        } else {
            thresholdProperties = new ArrayList<Threshold>();
            this.m_editor.setThresholds(thresholdProperties);
        }
        this.m_thresholdCollection = new AMXGaugeThresholdCollection(columns, thresholdProperties, this);
        this.m_thresholdCollection.setBindingUiContext(this.getBindingUiContext());
        thresholds.setCollection((DvtCollection)this.m_thresholdCollection);
        this.m_thresholdCollection.setItemList(thresholdProperties, labels, colors);
        DvtTableDecorator decor = new DvtTableDecorator(columns){

            public String getSummaryDescription() {
                String description = StringUtils.stripMnemonic((String)DvtBindingResources.getResource((String)"GAUGE_THRESHOLD_ATTR_LABEL"));
                return description;
            }

            public boolean isReorderingSupported() {
                return false;
            }

            public boolean isColumnEditable(int column) {
                return column != 0;
            }

            public Object getDisplayValue(Item item, int column) {
                if (item instanceof AMXGaugeThresholdCollection.ThresholdRow) {
                    AMXGaugeThresholdCollection.ThresholdRow row = (AMXGaugeThresholdCollection.ThresholdRow)item;
                    return row.getValue(column);
                }
                return null;
            }

            public void setItemValue(Item item, int column, Object aValue) {
                if (item instanceof AMXGaugeThresholdCollection.ThresholdRow) {
                    AMXGaugeThresholdCollection.ThresholdRow row = (AMXGaugeThresholdCollection.ThresholdRow)item;
                    row.setValue(column, aValue);
                }
            }
        };
        DvtCollectionSummaryPanel panel = new DvtCollectionSummaryPanel((Collection)this.m_thresholdCollection, (CollectionPanelDecorator)decor);
        ComponentWithTitlebar componentWithTitlebar = panel.getComponentWithTitlebar();
        JLabel _labelFromTitleBar = panel.makeFocusableLabel();
        String description = StringUtils.stripMnemonic((String)DvtBindingResources.getResource((String)"GAUGE_THRESHOLD_ATTR_LABEL"));
        _labelFromTitleBar.setText(description);
        _labelFromTitleBar.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DvtBindingResources.getResource((String)"GAUGE_THRESHOLD_ATTR_LABEL")));
        _labelFromTitleBar.setLabelFor((Component)panel);
        componentWithTitlebar.setLabel(_labelFromTitleBar);
        return panel;
    }

    private List<Color> getThresholdColors(List<Threshold> thresholdProperties) {
        if (thresholdProperties == null) {
            return new ArrayList<Color>();
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (Threshold _threshold : thresholdProperties) {
            String _color = _threshold.getColor();
            if (_color != null && _color.startsWith("#")) {
                colors.add(ColorUtils.hexStringToColor((String)_color));
                continue;
            }
            colors.add(ColorUtils.hexStringToColor((String)"#d62800"));
        }
        return colors;
    }

    private List<String> getThresholdLabels(List<Threshold> thresholdProperties) {
        if (thresholdProperties == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Threshold _threshold : thresholdProperties) {
            String _text = _threshold.getText();
            if (_text != null) {
                labels.add(_text);
                continue;
            }
            labels.add(EMPTY_VALUE);
        }
        return labels;
    }

    private void enableLabelPanelComponents(JPanel panel, boolean enabled) {
        Component[] comp = panel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            comp[i].setEnabled(enabled);
        }
    }

    private void prepareForWarning(final JComboBox combo) {
        AbstractValidationComponent vc = new AbstractValidationComponent(combo){

            public Object getData() {
                return combo.getSelectedItem();
            }
        };
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AMXGaugeBindPanel.this.updateWarningPanel();
            }
        });
        this.m_validationComponents.add((ValidationComponent)vc);
        vc.addValidator(ValidationComponent.DEFAULT_VALIDATOR, new Validator(){

            public ValidationMessage[] validate(Component comp, Object data) {
                if (data == null) {
                    return null;
                }
                String dataString = data.toString();
                if (dataString.length() == 0) {
                    return null;
                }
                if (AMXGaugeBindPanel.this.m_editor.getThresholds() == null) {
                    return null;
                }
                if (AMXGaugeBindPanel.this.m_thresholdCollection == null) {
                    return null;
                }
                for (Object o : AMXGaugeBindPanel.this.m_thresholdCollection.getItems()) {
                    String valueString;
                    AMXGaugeThresholdCollection.ThresholdRow row = (AMXGaugeThresholdCollection.ThresholdRow)((Object)o);
                    Object value = row.getValue(1);
                    if (value == null || (valueString = value.toString()).length() == 0 || !valueString.equals(dataString)) continue;
                    return new ValidationMessage[]{new ValidationMessage(2, DvtBindingResources.getResource((String)"GAUGE_METRIC_WARNING_DESC"))};
                }
                return null;
            }
        });
    }

    private ComboBoxModel getComboModel() {
        String[] members = this.getMembers();
        DefaultComboBoxModel<Object> _comboModel = null == members ? new DefaultComboBoxModel() : new DefaultComboBoxModel<String>(members);
        return _comboModel;
    }

    protected class IndicatorUpdater
    implements PropertyUpdater {
        protected IndicatorUpdater() {
        }

        public void updateProperty(Object newValue) {
            newValue = newValue == null ? AMXGaugeBindPanel.EMPTY_VALUE : newValue;
            AMXGaugeBindPanel.this.m_editor.setDialIndicatorName(newValue.toString());
        }
    }

    protected class BackgroundUpdater
    implements PropertyUpdater {
        protected BackgroundUpdater() {
        }

        public void updateProperty(Object newValue) {
            newValue = newValue == null ? AMXGaugeBindPanel.EMPTY_VALUE : newValue;
            AMXGaugeBindPanel.this.m_editor.setDialBackgroundName(newValue.toString());
        }
    }

    class ColorColumnDefinition
    extends ColumnDefinition {
        ColorPickerCellRenderer m_renderer = new ColorPickerCellRenderer(true);
        ColorPickerCellEditor m_editor = new ColorPickerCellEditor();

        public TableCellEditor getTableCellEditor() {
            return this.m_editor;
        }

        public TableCellRenderer getTableCellRenderer() {
            return this.m_renderer;
        }

        class ColorPickerCellRenderer
        extends JButton
        implements TableCellRenderer {
            Border unselectedBorder = null;
            Border selectedBorder = null;
            boolean isBordered = true;

            public ColorPickerCellRenderer(boolean isBordered) {
                this.isBordered = isBordered;
                this.setOpaque(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
                Color newColor = ColorUtils.hexStringToColor((String)color.toString());
                this.setBackground(newColor);
                if (this.isBordered) {
                    if (isSelected) {
                        if (this.selectedBorder == null) {
                            this.selectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getSelectionBackground());
                        }
                        this.setBorder(this.selectedBorder);
                    } else {
                        if (this.unselectedBorder == null) {
                            this.unselectedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getBackground());
                        }
                        this.setBorder(this.unselectedBorder);
                    }
                }
                return this;
            }
        }

        class ColorPickerCellEditor
        extends AbstractCellEditor
        implements TableCellEditor,
        PropertyChangeListener {
            Color currentColor;
            JButton button;
            JLabel label;
            JColorChooser colorChooser;
            JDialog dialog;
            protected static final String EDIT = "edit";
            ColorChoice picker = new ColorChoice();
            GridBagConstraints gbc = new GridBagConstraints();

            public ColorPickerCellEditor() {
                this.label = new JLabel();
                this.picker.addPropertyChangeListener((PropertyChangeListener)this);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof ColorChoice && evt.getPropertyName().equals("selectedColor")) {
                    this.fireEditingStopped();
                }
            }

            @Override
            public Object getCellEditorValue() {
                return this.picker.getSelectedColor();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.currentColor = ColorUtils.hexStringToColor((String)value.toString());
                this.picker.setDefaultAllowed(true);
                this.picker.setSelectedColor(this.currentColor);
                this.label.setOpaque(true);
                this.label.setBackground(this.currentColor);
                this.label.setPreferredSize(new Dimension(this.label.getPreferredSize().width, table.getRowHeight()));
                this.label.setText("Color");
                this.label.setForeground(this.currentColor);
                JPanel colorPanel = new JPanel(new GridBagLayout());
                this.gbc.gridx = 0;
                this.gbc.gridy = 0;
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 1.0;
                this.gbc.gridwidth = 1;
                this.gbc.fill = 2;
                this.gbc.anchor = 23;
                this.gbc.insets = new Insets(1, 1, 1, 1);
                colorPanel.add((Component)this.label, this.gbc);
                this.picker.setPreferredSize(new Dimension(this.picker.getPreferredSize().width, table.getRowHeight()));
                this.gbc.gridx = 1;
                this.gbc.weightx = 0.0;
                this.gbc.anchor = 22;
                this.gbc.insets = new Insets(1, 3, 1, 1);
                colorPanel.add((Component)this.picker, this.gbc);
                return colorPanel;
            }
        }
    }

    class TresholdLabelColumnCellRenderer
    extends DefaultTableCellRenderer {
        TresholdLabelColumnCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    class IntegerTextField
    extends JTextField {
        @Override
        protected void processComponentKeyEvent(KeyEvent ke) {
            if (ke.getKeyCode() == 127 || ke.getKeyCode() == 8 || ke.getKeyCode() == 38 || ke.getKeyCode() == 40 || ke.getKeyCode() == 37 || ke.getKeyCode() == 39) {
                super.processComponentKeyEvent(ke);
            } else {
                char c = ke.getKeyChar();
                if ((c < '0' || c > '9') && c != '-') {
                    ke.consume();
                } else {
                    super.processComponentKeyEvent(ke);
                }
            }
        }

        public IntegerTextField() {
        }

        public IntegerTextField(int cols) {
            super(cols);
        }
    }

    public class SelectedShapeUpdater
    implements PropertyUpdater {
        public void updateProperty(Object newValue) {
            newValue = newValue == null ? AMXGaugeBindPanel.EMPTY_VALUE : newValue;
            AMXGaugeBindPanel.this.m_editor.setSelectedShapeName(newValue.toString());
        }
    }
}

