/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.resource;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.resource.ResourceUtilsBindings;
import oracle.adfmf.amx.dt.editor.databinding.AMXDesignTimeContext;
import oracle.adfmf.common.util.ADFMobileResourceBundleUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.ide.model.Project;
import oracle.ide.resourcebundle.ResourceBundleKey;
import oracle.ide.resourcebundle.ResourceBundleManagerDT;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.resourcebundle.ResourceBundleManager;
import oracle.javatools.resourcebundle.ResourceBundleWrapper;
import oracle.jdeveloper.webapp.utils.WebDocumentUtil;
import org.w3c.dom.Node;

public class DVTMobileResourceBundleUtils
extends ResourceUtilsBindings {
    private static final Logger _slogger = Logger.getLogger(DVTMobileResourceBundleUtils.class.getName());

    public static String selectAMXResource(BindingUiContext bindingContext) {
        XmlContext xmlContext = (XmlContext)bindingContext.get((Object)"XmlContext");
        if (xmlContext == null) {
            AMXDesignTimeContext _context = (AMXDesignTimeContext)bindingContext.getADFDesignTimeContext();
            xmlContext = _context.getXmlContext();
        }
        if (xmlContext != null) {
            ResourceBundleKey rbk;
            AbstractModel model = xmlContext.getActiveAbstractModel();
            Project project = DVTMobileResourceBundleUtils.getProject((BindingUiContext)bindingContext);
            if (project != null && (rbk = DVTMobileResourceBundleUtils.getResourceBundleKey((Project)project, (String)"")) != null && rbk.getBundleId() != null && rbk.getKey() != null) {
                return DVTMobileResourceBundleUtils.buildAMXStyleResourceBundle(rbk, model);
            }
        }
        return null;
    }

    protected static String buildAMXStyleResourceBundle(ResourceBundleKey rbk, AbstractModel model) {
        String newValue = null;
        try {
            String bundleVar = ADFMobileResourceBundleUtils.checkAddBundleEntry((AbstractModel)model, (String)rbk.getBundleId());
            newValue = rbk.getKey().contains(".") ? "#{" + bundleVar + "[" + "'" + rbk.getKey() + "'" + "]" + "}" : "#{" + bundleVar + "." + rbk.getKey() + "}";
        }
        catch (Throwable throwable) {
            _slogger.log(Level.WARNING, "Could not resolve resource bundle");
        }
        return newValue;
    }

    public static String resolveAMXResourceExpression(String value, BindingUiContext bindingContext) {
        try {
            Project project = DVTMobileResourceBundleUtils.getProject((BindingUiContext)bindingContext);
            XmlContext xmlContext = (XmlContext)bindingContext.get((Object)"XmlContext");
            if (xmlContext == null) {
                AMXDesignTimeContext _context = (AMXDesignTimeContext)bindingContext.getADFDesignTimeContext();
                xmlContext = _context.getXmlContext();
            }
            if (xmlContext != null) {
                String rValue;
                ResourceBundleWrapper rb;
                AbstractModel model = xmlContext.getActiveAbstractModel();
                String bundleName = DVTMobileResourceBundleUtils._getBundleName(value, model);
                String bundleKey = DVTMobileResourceBundleUtils._getBundleKey(value);
                ResourceBundleManagerDT dtMgr = (ResourceBundleManagerDT)ResourceBundleManager.getResourceBundleManager();
                if (dtMgr != null && project != null && (rb = dtMgr.findBundle((PropertyStorage)project, bundleName)) != null && (rValue = rb.getString(bundleKey)) != null) {
                    return rValue;
                }
            }
            return value;
        }
        catch (StringIndexOutOfBoundsException e) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String _getBundleName(String expression, AbstractModel model) {
        String bundleName = null;
        if (expression != null) {
            String varName = expression.substring("#{".length(), expression.indexOf("."));
            model.acquireReadLock();
            try {
                String namespace = model.getDocument().getDocumentElement().getNamespaceURI();
                Iterator nIt = WebDocumentUtil.findNodes((AbstractModel)model, (String)"loadBundle", (String)namespace);
                Node loadBundleNode = null;
                Node loadBundleNodeAtt = null;
                while (nIt.hasNext()) {
                    loadBundleNode = (Node)nIt.next();
                    if (loadBundleNode.getAttributes() == null || (loadBundleNodeAtt = loadBundleNode.getAttributes().getNamedItem("var")) == null || !loadBundleNodeAtt.getNodeValue().equals(varName)) continue;
                    bundleName = loadBundleNode.getAttributes().getNamedItem("basename").getNodeValue();
                    break;
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return bundleName;
    }

    protected static String _getBundleKey(String expression) {
        String keyName = null;
        if (expression != null) {
            keyName = expression.substring(expression.indexOf(".") + 1, expression.lastIndexOf("}"));
        }
        return keyName;
    }
}

