/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.metadata.creators;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adfdt.jdev.transaction.JDevTransactionManager;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.view.common.binding.creator.CancelCreationException;
import oracle.adfdt.view.rich.binding.context.AdfFacesDesignTimeContext;
import oracle.adfdt.view.rich.binding.util.ADFDatabindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.DataPresConstants;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.AMXGeoMapUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.NodeCreator;
import oracle.ide.model.Workspace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMXGeoMapNodeCreator
implements NodeCreator {
    private static final Logger _LOGGER = Logger.getLogger(AMXGeoMapNodeCreator.class.getName());
    protected Element m_rootNode = null;

    public Node createNode(XmlContext xmlContext, XmlKey key, DomPosition insertPosition, Node prototypeNode) {
        if (xmlContext instanceof JDevXmlContext) {
            Workspace _ws = ((JDevXmlContext)xmlContext).getWorkspace();
            AMXGeoMapUtils.setupADFConfigForGeoMap(_ws);
        }
        Node geoMap = this._createGeoMapNodeStructure(key, prototypeNode, xmlContext);
        return geoMap;
    }

    protected Node _createGeoMapNodeStructure(final XmlKey key, final Node prototypeNode, final XmlContext xmlContext) {
        JDevTransactionManager transactionManager = new JDevTransactionManager(xmlContext);
        Task newNode = new Task(){

            public void run() {
                if (key.equals((Object)DataPresConstants.AMX_DVT_FACES_GEOMAP_KEY)) {
                    AdfFacesDesignTimeContext dtContext = ADFDatabindingUtils.createFacesDesignTimeContext((XmlContext)xmlContext);
                    AMXGeoMapNodeCreator.this.m_rootNode = prototypeNode.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "geographicMap");
                    String id = dtContext.generateUniqueIdForView("geomp");
                    AMXGeoMapNodeCreator.this.m_rootNode.setAttributeNS(null, "id", id);
                    Element pointDataLayer = AMXGeoMapNodeCreator.this.m_rootNode.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "pointDataLayer");
                    id = dtContext.generateUniqueIdForView("pdl");
                    pointDataLayer.setAttributeNS(null, "id", id);
                    AMXGeoMapNodeCreator.this.m_rootNode.appendChild(pointDataLayer);
                }
            }
        };
        try {
            transactionManager.runTaskUnderTransaction(this.getTransactionName(), newNode);
        }
        catch (CancelCreationException e1) {
            _LOGGER.log(Level.SEVERE, "creating dvtm:geographicMap element failed");
        }
        return this.m_rootNode;
    }

    protected String getTransactionName() {
        return "Create geographicMap";
    }
}

