/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.metadata.creators;

import java.util.HashMap;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.jdev.JDevDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.CtrlValue;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.creator.BindingReference;
import oracle.adfdt.view.common.binding.creator.CancelCreationException;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdt.view.common.binding.utils.ReferenceUtils;
import oracle.adfdtinternal.dvt.datapresdt.DataPresConstants;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.AMXDvtBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.AMXGaugeBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.AMXGeoMapBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.AMXGraphBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.dnd.AMXGeoMapModelProvider;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.CubicHierEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMXDvtBaseComponentCustomizer
implements NodeCustomizer {
    static final HashMap<String, String> supportedGraphCharts = new HashMap();
    static final HashMap<String, String> supportedGauges = new HashMap();

    public boolean customizeNode(XmlContext context, Node n, XmlKey key) {
        ControlBinding binding;
        BindingReference bindingReference = this.getBindingReference(context, (Element)n);
        ControlBinding controlBinding = binding = bindingReference != null ? (ControlBinding)bindingReference.getBinding() : null;
        if (binding != null) {
            AMXDvtBinder binder;
            JDevDesignTimeContext adfDesignTimeContext = new JDevDesignTimeContext(context){};
            final BindingUiContext hBindingUIContext = BindingUiContext.createBindingUiContext((ADFDesignTimeContext)adfDesignTimeContext, (ControlBinding)binding, (int)3, (int)this.getBindingType((Element)n));
            hBindingUIContext.put((Object)"RootNode", (Object)n);
            hBindingUIContext.put((Object)"HideDataSource", (Object)Boolean.TRUE);
            hBindingUIContext.put((Object)"XmlContext", (Object)context);
            String localName = n.getLocalName();
            if (supportedGraphCharts.containsKey(localName)) {
                this.setGraphType(hBindingUIContext, localName);
                if ("sparkChart".equals(localName)) {
                    localName = ((Element)n).getAttribute("type");
                    supportedGraphCharts.put("sparkChart", localName);
                    hBindingUIContext.setGraphTypeName(localName);
                }
                binder = new AMXGraphBinder();
                hBindingUIContext.setBindingType(100);
            } else if (supportedGauges.containsKey(localName)) {
                binder = new AMXGaugeBinder();
                hBindingUIContext.setBindingType(101);
                if (localName.equals("ledGauge")) {
                    String type = ((Element)n).getAttribute("type");
                    if (type != null && type.length() > 0) {
                        if (type.equals("circle")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED");
                        }
                        if (type.equals("rectangle")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED_RECTANGLE");
                        }
                        if (type.equals("arrow")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED_ARROW");
                        }
                        if (type.equals("triangle")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED_TRIANGLE");
                        }
                        if (type.equals("diamond")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED_DIAMOND");
                        }
                        if (type.equals("star")) {
                            hBindingUIContext.put((Object)"GaugeTypeName", (Object)"LED_STAR");
                        }
                    }
                } else if (localName.equals("dialGauge")) {
                    hBindingUIContext.setGaugeTypeName("DIAL");
                } else if (localName.equals("statusMeterGauge")) {
                    NodeList thresholds = ((Element)n).getElementsByTagNameNS(null, "threshold");
                    if (thresholds.getLength() > 0) {
                        hBindingUIContext.setGaugeTypeName("STATUSMETER_THRESHOLDS");
                    } else {
                        hBindingUIContext.setGaugeTypeName("STATUSMETER");
                    }
                } else if (localName.equals("ratingGauge")) {
                    hBindingUIContext.setGaugeTypeName("RATING");
                }
            } else if ("pointDataLayer".equals(localName)) {
                Node parent = n.getParentNode();
                if (parent != null && parent instanceof Element && parent.getLocalName().equals("geographicMap")) {
                    binder = new AMXGeoMapBinder();
                    hBindingUIContext.setBindingType(103);
                    if (binding != null && binding.getIteratorBinding() != null) {
                        StructureDefinition defn = binding.getIteratorBinding().getDefinition();
                        DataControl dc = binding.getDataControl();
                        AMXGeoMapModelProvider modelProvider = new AMXGeoMapModelProvider((ADFDesignTimeContext)adfDesignTimeContext, dc, (NamedDefinition)defn, (CtrlValue)binding);
                        hBindingUIContext.put((Object)"Model_Provider", (Object)modelProvider);
                    }
                } else {
                    binder = null;
                }
            } else if ("geographicMap".equals(localName)) {
                binder = new AMXGeoMapBinder();
                hBindingUIContext.setBindingType(103);
                if (binding != null && binding.getIteratorBinding() != null) {
                    StructureDefinition defn = binding.getIteratorBinding().getDefinition();
                    DataControl dc = binding.getDataControl();
                    AMXGeoMapModelProvider modelProvider = new AMXGeoMapModelProvider((ADFDesignTimeContext)adfDesignTimeContext, dc, (NamedDefinition)defn, (CtrlValue)binding);
                    hBindingUIContext.put((Object)"Model_Provider", (Object)modelProvider);
                }
            } else {
                binder = null;
            }
            if (binder == null) {
                return false;
            }
            new FixedNameTransactionTask("Edit AMX Component"){

                protected void performTask(AbstractModel model) throws XmlCommitException {
                    try {
                        boolean ok = binder.launchBindingEditor(hBindingUIContext);
                        if (!ok) {
                            ADFBindingUtils.cancelCreateOrBind();
                        } else {
                            CubicHierEditor editor = (CubicHierEditor)hBindingUIContext.get((Object)"Editor");
                            editor.commit();
                        }
                    }
                    catch (CancelCreationException cce) {
                        this.cancelTask();
                    }
                }
            }.run((AbstractModel)context.getModel());
        }
        return true;
    }

    int getBindingType(Element root) {
        String localName;
        if (root != null && supportedGauges.containsKey(localName = root.getLocalName())) {
            return 101;
        }
        return 100;
    }

    private void setGraphType(BindingUiContext context, String localName) {
        String graphType = localName;
        if (localName.equals("pieChart")) {
            graphType = "PIE";
        } else if (localName.equals("bubbleChart")) {
            graphType = "BUBBLE";
        } else if (localName.equals("scatterChart")) {
            graphType = "SCATTER";
        } else if (localName.equals("barChart")) {
            graphType = "BAR_VERT_CLUST";
        } else if (localName.equals("lineChart")) {
            graphType = "LINE_VERT_ABS";
        } else if (localName.equals("areaChart")) {
            graphType = "AREA_VERT_ABS";
        } else if (localName.equals("comboChart")) {
            graphType = "COMBINATION_VERT_ABS";
        } else if (localName.equals("horizontalBarChart")) {
            graphType = "BAR_HORIZ_CLUST";
        }
        context.setGraphTypeName(graphType);
    }

    public boolean isGaugeType(String localName) {
        return supportedGauges.containsKey(localName);
    }

    public boolean isGraphType(String localName) {
        return localName.equals("pieChart") || localName.equals("bubbleChart") || localName.equals("scatterChart") || localName.equals("barChart") || localName.equals("lineChart") || localName.equals("areaChart") || localName.equals("comboChart") || localName.equals("horizontalBarChart") || localName.equals("sparkChart");
    }

    public boolean isNodeCustomizable(XmlContext context, Node n, XmlKey key) {
        if (n instanceof Element && ((Element)n).getNamespaceURI().equals("http://xmlns.oracle.com/adf/mf/amx/dvt")) {
            if (DataPresConstants.AMX_DVT_FACES_GEOMAP_KEY.equals((Object)key)) {
                NodeList nodes;
                if (n.getNodeType() == 1 && (nodes = ((Element)n).getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "pointDataLayer")).getLength() > 0) {
                    Node pointDataLayer = nodes.item(0);
                    return this.getBindingReference(context, (Element)pointDataLayer) != null;
                }
            } else {
                return this.getBindingReference(context, (Element)n) != null;
            }
        }
        return false;
    }

    protected BindingReference getBindingReference(XmlContext context, Element element) {
        NodeList nodes;
        JDevDesignTimeContext dtContext = new JDevDesignTimeContext(context){};
        if (element.getLocalName().equals("geographicMap") && (nodes = element.getElementsByTagNameNS("http://xmlns.oracle.com/adf/mf/amx/dvt", "pointDataLayer")).getLength() > 0) {
            element = (Element)nodes.item(0);
        }
        return ReferenceUtils.getBindingReference((ADFDesignTimeContext)dtContext, (Node)element);
    }

    static {
        supportedGraphCharts.put("pieChart", "PIE");
        supportedGraphCharts.put("bubbleChart", "BUBBLE");
        supportedGraphCharts.put("scatterChart", "SCATTER");
        supportedGraphCharts.put("barChart", "BAR");
        supportedGraphCharts.put("lineChart", "LINE");
        supportedGraphCharts.put("areaChart", "AREA");
        supportedGraphCharts.put("comboChart", "COMBO");
        supportedGraphCharts.put("horizontalBarChart", "BAR");
        supportedGraphCharts.put("sparkChart", "BAR");
        supportedGauges.put("ledGauge", "LED");
        supportedGauges.put("statusMeterGauge", "STATUSMETER");
        supportedGauges.put("dialGauge", "DIAL");
        supportedGauges.put("ratingGauge", "RATING");
    }
}

