/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.binding.utils;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.resource.DataPresResourceBundle;
import oracle.adfdtinternal.model.dvt.ide.objects.bindPanels.rowset.ItemContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphBindingUtilsAMX
extends GraphBindingUtils {
    public static String BUBBLE_LOCAL_NAME = "bubbleChart";
    public static String PIE_LOCAL_NAME = "pieChart";
    public static String SCATTER_LOCAL_NAME = "scatterChart";
    public static String BAR_LOCAL_NAME = "barChart";
    public static String HORIZONTAL_BAR_LOCAL_NAME = "horizontalBarChart";
    public static String LINE_LOCAL_NAME = "lineChart";
    public static String AREA_LOCAL_NAME = "areaChart";
    public static String COMBO_LOCAL_NAME = "comboChart";
    public static String SPARKCHART_LOCAL_NAME = "sparkChart";

    public static String getLabelStringAttributeFromList(List<ItemContext> labelItems, String var) {
        return GraphBindingUtilsAMX.getIdsFromItemList(labelItems, var);
    }

    public static String getIdsFromItemList(List<ItemContext> labelItems, String var) {
        StringBuffer labelString = new StringBuffer();
        for (ItemContext itemContext : labelItems) {
            String token = var + "." + itemContext.getName();
            String concat = labelString.length() == 0 ? "" : "} #{";
            labelString.append(concat + token);
        }
        String groupStringAttribute = "#{" + labelString.toString() + "}";
        return groupStringAttribute;
    }

    public static String getLabelsFromItemList(List<ItemContext> labelItems, String var) {
        StringBuffer labelString = new StringBuffer();
        boolean haveLabel = false;
        for (ItemContext itemContext : labelItems) {
            String token;
            if (itemContext.getItem().getLabel() != null) {
                token = var + "." + itemContext.getItem().getLabel();
                haveLabel = true;
            } else {
                token = var + "." + itemContext.getName();
            }
            String concat = labelString.length() == 0 ? "" : "} #{";
            labelString.append(concat + token);
        }
        if (!haveLabel) {
            return null;
        }
        String groupStringAttribute = "#{" + labelString.toString() + "}";
        return groupStringAttribute;
    }

    public static List<String> getAttrNamesFromLabelEL(String el, String var) {
        LinkedList<String> result = new LinkedList<String>();
        String elPrefix = "#{";
        if (el.startsWith(elPrefix)) {
            StringTokenizer tokenizer = new StringTokenizer(el);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String attr = GraphBindingUtilsAMX.getAttrNameFromEL((String)token, (String)var);
                if (attr.length() <= 0) continue;
                result.add(attr);
            }
        }
        return result;
    }

    public static Element getOnlyChildFromParent(Element parent, String childLocalName) {
        NodeList children = parent.getElementsByTagName(childLocalName);
        if (children.getLength() == 0) {
            Element child = parent.getOwnerDocument().createElementNS("http://xmlns.oracle.com/adf/mf/amx/dvt", childLocalName);
            parent.appendChild(child);
            return child;
        }
        return (Element)children.item(0);
    }

    public static String getGraphDialogTitle(ControlBinding binding, boolean bEditBinding, BindingUiContext hBindingUiContext) {
        GraphBindingUtilsAMX.determineGraphType(binding, bEditBinding, hBindingUiContext);
        String graphTypeKey = null;
        graphTypeKey = hBindingUiContext.getGraphCategory() == BindingUiContext.GraphCategory.MIXED_FREQUENCY ? "LINE_MIXED_FREQUENCY" : hBindingUiContext.getGraphTypeName();
        BindingUiContext.GraphCategory graphCategoryName = hBindingUiContext.getGraphCategory();
        if (graphCategoryName != BindingUiContext.GraphCategory.SPARKCHART) {
            return GraphBindingUtilsAMX.getGraphDialogTitle(bEditBinding, graphTypeKey);
        }
        return GraphBindingUtilsAMX.getSparkchartDialogTitle(bEditBinding, graphTypeKey);
    }

    public static String getChartType(String localName) {
        String chartType = "AREA_VERT_ABS";
        if (localName.equals(BUBBLE_LOCAL_NAME)) {
            chartType = "BUBBLE";
        } else if (localName.equals(PIE_LOCAL_NAME)) {
            chartType = "PIE";
        } else if (localName.equals(SCATTER_LOCAL_NAME)) {
            chartType = "SCATTER";
        } else if (localName.equals(BAR_LOCAL_NAME)) {
            chartType = "BAR_VERT_CLUST";
        } else if (localName.equals(HORIZONTAL_BAR_LOCAL_NAME)) {
            chartType = "BAR_HORIZ_CLUST";
        } else if (localName.equals(LINE_LOCAL_NAME)) {
            chartType = "LINE_VERT_ABS";
        } else if (localName.equals(AREA_LOCAL_NAME)) {
            chartType = "AREA_VERT_ABS";
        } else if (localName.equals(COMBO_LOCAL_NAME)) {
            chartType = "COMBINATION_VERT_ABS";
        } else if (localName.equals(SPARKCHART_LOCAL_NAME)) {
            chartType = "SPARKCHART";
        }
        return chartType;
    }

    protected static void determineGraphType(ControlBinding binding, boolean bIsEditBinding, BindingUiContext hBindingUiContext) {
        Element root = hBindingUiContext.getRootElement();
        if (root == null) {
            return;
        }
        String localName = root.getLocalName();
        BindingUiContext.GraphCategory category = null;
        String graphTypeName = null;
        if (localName.equals(BUBBLE_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.BUBBLE;
            graphTypeName = "BUBBLE";
        } else if (localName.equals(PIE_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.PIE;
            graphTypeName = "PIE";
        } else if (localName.equals(SCATTER_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.SCATTER;
            graphTypeName = "SCATTER";
        } else if (localName.equals(BAR_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.BAR;
            graphTypeName = "BAR_VERT_CLUST";
        } else if (localName.equals(HORIZONTAL_BAR_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.HORIZONTAL_BAR;
            graphTypeName = "BAR_HORIZ_CLUST";
        } else if (localName.equals(LINE_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.LINE;
            graphTypeName = "LINE_VERT_ABS";
        } else if (localName.equals(AREA_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.AREA;
            graphTypeName = "AREA_VERT_ABS";
        } else if (localName.equals(COMBO_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.COMBINATION;
            graphTypeName = "COMBINATION_VERT_ABS";
        } else if (localName.equals(SPARKCHART_LOCAL_NAME)) {
            category = BindingUiContext.GraphCategory.SPARKCHART;
            graphTypeName = root.getAttributeNS(null, "type");
            if (graphTypeName == null || graphTypeName.length() == 0) {
                graphTypeName = "line";
            }
        }
        if (category != null) {
            hBindingUiContext.setGraphCategory(category);
            if (hBindingUiContext.getGraphTypeName() == null) {
                hBindingUiContext.setGraphTypeName(graphTypeName);
            }
            hBindingUiContext.put((Object)"iGraphType", (Object)new Integer(GraphBindingUtilsAMX.getGraphType(hBindingUiContext)));
        }
    }

    public static String getComponentGalleryDialogTitle(String chartType) {
        if (chartType == null || chartType.length() == 0) {
            return DataPresResourceBundle.get((String)"CREATE_CHART_TITLE_AMX_NO_PARAM");
        }
        if (chartType.equals("SPARKCHART")) {
            return DataPresResourceBundle.get((String)"CREATE_SPARKCHART_TITLE_AMX_NO_PARAM");
        }
        String chartTypeKey = DataPresResourceBundle.get((String)(chartType + "_title"));
        String title = "CREATE_GRAPH_TITLE_AMX";
        if (chartTypeKey == null || chartTypeKey.length() == 0) {
            chartTypeKey = "";
        }
        String stringFormat = DataPresResourceBundle.get((String)title);
        return MessageFormat.format(stringFormat, chartTypeKey);
    }

    public static String getGraphDialogTitle(boolean bEditBinding, String graphTypeKey) {
        String title;
        String graphType;
        if (graphTypeKey == null || graphTypeKey.length() == 0) {
            return DataPresResourceBundle.get((String)(bEditBinding ? "EDIT_GRAPH_TITLE_AMX" : "CREATE_GRAPH_TITLE_AMX"));
        }
        if (GraphBindingUtilsAMX.isSparkchartFlavor((String)graphTypeKey)) {
            graphType = DataPresResourceBundle.get((String)(GraphBindingUtilsAMX.convertSparktype2Graphtype((String)graphTypeKey) + "_title"));
            title = bEditBinding ? "EDIT_SPARKCHART_TITLE" : "CREATE_SPARKCHART_TITLE";
        } else {
            graphType = DataPresResourceBundle.get((String)(graphTypeKey + "_title"));
            String string = title = bEditBinding ? "EDIT_GRAPH_TITLE_AMX" : "CREATE_GRAPH_TITLE_AMX";
        }
        if (graphType == null || graphType.length() == 0) {
            graphType = "";
        }
        String stringFormat = DataPresResourceBundle.get((String)title);
        return MessageFormat.format(stringFormat, graphType);
    }

    protected static String getSparkchartDialogTitle(boolean bEditBinding, String graphTypeKey) {
        String graphType = null;
        if (graphTypeKey != null) {
            String subType = "LINE_VERT_ABS";
            if (graphTypeKey.equals("bar")) {
                subType = "BAR_VERT_CLUST";
            } else if (graphTypeKey.equals("area")) {
                subType = "AREA_VERT_ABS";
            } else if (graphTypeKey.equals("floatingBar")) {
                subType = "BAR_VERT_FLOAT_STACK";
            }
            graphType = DataPresResourceBundle.get((String)(subType + "_title"));
        }
        if (graphType == null || graphType.length() == 0) {
            graphType = "";
        }
        String title = bEditBinding ? "EDIT_SPARKCHART_TITLE_AMX" : "CREATE_SPARKCHART_TITLE_AMX";
        return MessageFormat.format(DataPresResourceBundle.get((String)title), graphType);
    }

    public static String generateGraphTags(ADFDesignTimeContext dtContext, String localName, String value, String graphType, String quickLayout) {
        if (dtContext == null || localName == null || graphType == null || graphType.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<dvtm:" + localName);
        buffer.append(" id=\"" + dtContext.generateUniqueIdForView("graph") + "\"");
        if (value != null && value.length() > 0) {
            buffer.append(" value=\"" + value + "\"");
        }
        buffer.append(GraphBindingUtilsAMX.getStringForAttribute("var", "row"));
        buffer.append(">");
        buffer.append("<amx:facet name=\"dataStamp\" />");
        if (PIE_LOCAL_NAME.equals(localName)) {
            return GraphBindingUtilsAMX.generatePieGraphTags(dtContext, localName, buffer, graphType, quickLayout);
        }
        if (BUBBLE_LOCAL_NAME.equals(localName)) {
            return GraphBindingUtilsAMX.generateBubbleGraphTags(dtContext, localName, buffer, graphType, quickLayout);
        }
        if (SCATTER_LOCAL_NAME.equals(localName)) {
            return GraphBindingUtilsAMX.generateScatterGraphTags(dtContext, localName, buffer, graphType, quickLayout);
        }
        return GraphBindingUtilsAMX.generateAxisGraphTags(dtContext, localName, buffer, graphType, quickLayout);
    }

    public static String generateSparkchartAmxTags(ADFDesignTimeContext dtContext, String localName, String value, String graphType, String quickLayout) {
        if (dtContext == null || localName == null || graphType == null || graphType.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<dvtm:" + localName);
        buffer.append(" id=\"" + dtContext.generateUniqueIdForView("sparkchart") + "\"");
        if (value != null && value.length() > 0) {
            buffer.append(" value=\"" + value + "\"");
        }
        buffer.append(GraphBindingUtilsAMX.getStringForAttribute("var", "row"));
        buffer.append(GraphBindingUtilsAMX.getStringForAttribute("type", graphType));
        buffer.append(">");
        buffer.append("<amx:facet name=\"dataStamp\" />");
        buffer.append("</dvtm:" + localName + ">");
        return buffer.toString();
    }

    public static String generateAxisGraphTags(ADFDesignTimeContext dtContext, String localName, StringBuffer buffer, String graphType, String quickLayout) {
        if (quickLayout.equals("QL_no_legend")) {
            buffer.append("<dvtm:legend rendered=\"false\" />");
        } else {
            buffer.append("<dvtm:legend position=\"end\" />");
        }
        buffer.append("</dvtm:" + localName + ">");
        return buffer.toString();
    }

    public static String generateBubbleGraphTags(ADFDesignTimeContext dtContext, String localName, StringBuffer buffer, String graphType, String quickLayout) {
        if (quickLayout.equals("QL_no_legend")) {
            buffer.append("<dvtm:legend rendered=\"false\" />");
        } else {
            buffer.append("<dvtm:legend position=\"end\" />");
        }
        buffer.append("</dvtm:" + localName + ">");
        return buffer.toString();
    }

    public static String generatePieGraphTags(ADFDesignTimeContext dtContext, String localName, StringBuffer buffer, String graphType, String quickLayout) {
        buffer.append("<dvtm:legend position=\"end\" />");
        buffer.append("</dvtm:" + localName + ">");
        return buffer.toString();
    }

    public static String generateScatterGraphTags(ADFDesignTimeContext dtContext, String localName, StringBuffer buffer, String graphType, String quickLayout) {
        if (quickLayout.equals("QL_no_legend")) {
            buffer.append("<dvtm:legend rendered=\"false\" />");
        } else {
            buffer.append("<dvtm:legend position=\"end\" />");
        }
        buffer.append("</dvtm:" + localName + ">");
        return buffer.toString();
    }

    private static void addAxisTags(StringBuffer buffer) {
        buffer.append("<dvtm:xAxis title=\"xAxis Title\" />");
        buffer.append("<dvtm:yAxis title=\"yAxis Title\" />");
    }

    private static String getStringForAttribute(String name, String value) {
        return " " + name + "=\"" + value + "\" ";
    }

    public static int getGraphType(BindingUiContext bindingContext) {
        String sGraphType = bindingContext.getGraphTypeName();
        if (sGraphType == null) {
            return -1;
        }
        if ((sGraphType = sGraphType.toUpperCase()).equals("BUBBLE")) {
            return 89;
        }
        if (sGraphType.equals("PIE")) {
            return 55;
        }
        if (sGraphType.equals("SCATTER")) {
            return 61;
        }
        if (sGraphType.equals("BAR_HORIZ_CLUST")) {
            return 24;
        }
        if (sGraphType.equals("BAR_VERT_CLUST") || sGraphType.equals("BAR")) {
            return 17;
        }
        if (sGraphType.equals("LINE_VERT_ABS") || sGraphType.equals("LINE")) {
            return 41;
        }
        if (sGraphType.equals("AREA_VERT_ABS") || sGraphType.equals("AREA")) {
            return 31;
        }
        if (sGraphType.equals("COMBINATION_VERT_ABS")) {
            return 97;
        }
        if (sGraphType.equals("FLOATINGBAR")) {
            return 95;
        }
        return -1;
    }
}

