/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.binding.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.adf.share.dt.config.ADFConfigNode;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.MapProviderInfo;
import oracle.adfmf.common.util.MobileResourceUtils;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.model.ApplicationContent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AMXGeoMapUtils {
    private static final String _ADF_CONFIG_FILE = "adf-config.xml";
    private static final Logger _sLogger = Logger.getLogger(AMXGeoMapUtils.class.getName());

    public static void setupADFConfigForGeoMap(Workspace workspace) {
        ADFConfigNode configNode;
        URL adfConfigURL = AMXGeoMapUtils._getAdfConfigURL(workspace);
        if (adfConfigURL != null && (configNode = (ADFConfigNode)NodeFactory.find((URL)adfConfigURL)) != null) {
            try {
                Document doc = AMXGeoMapUtils._parseADFConfig(adfConfigURL);
                MapProviderInfo mpi = AMXGeoMapUtils._getMapProviderInfo(doc);
                if (mpi.getProviderName() == null) {
                    configNode.addADFProperty("mapProvider", "googleMaps");
                    configNode.addADFProperty("geoMapKey", "");
                    configNode.addADFProperty("mapViewerUrl", "http://elocation.oracle.com/mapviewer");
                    configNode.addADFProperty("baseMap", "ELOCATION_MERCATOR.WORLD_MAP");
                    try {
                        configNode.save();
                    }
                    catch (IOException ioe) {
                        _sLogger.log(Level.SEVERE, MobileResourceUtils.getMsg((String)"ADF-MBL-00011", (Object[])new Object[]{configNode.getLongLabel(), ioe}));
                    }
                }
            }
            catch (Exception e) {
                _sLogger.log(Level.SEVERE, MobileResourceUtils.getMsg((String)"ADF-MBL-01505"));
            }
        }
    }

    private static Document _parseADFConfig(URL url) throws ParserConfigurationException, IOException, SAXException, URISyntaxException {
        Document dom = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        dom = parser.parse(url.toURI().toString());
        return dom;
    }

    private static URL _getAdfConfigURL(Workspace workspace) {
        ApplicationContent appContent = ApplicationContent.getInstance((Workspace)workspace);
        return URLFactory.newURL((URL)appContent.getADFMetaInfURL(), (String)_ADF_CONFIG_FILE);
    }

    private static Element getAdfProperty(NodeList properties, String name) {
        for (int i = 0; i < properties.getLength(); ++i) {
            Element _property;
            String _propertyName;
            if (properties.item(i).getNodeType() != 1 || (_propertyName = (_property = (Element)properties.item(i)).getAttributeNS(null, "name")) == null || !_propertyName.equals(name)) continue;
            return _property;
        }
        return null;
    }

    private static MapProviderInfo _getMapProviderInfo(Document domDoc) {
        Element docElem;
        NodeList nodeList;
        Element _elem;
        MapProviderInfo mpi = new MapProviderInfo(false);
        if (domDoc != null && (_elem = AMXGeoMapUtils.getAdfProperty(nodeList = (docElem = domDoc.getDocumentElement()).getElementsByTagNameNS("http://xmlns.oracle.com/adf/config/properties", "adf-property"), "mapProvider")) != null) {
            String _propertyValue = _elem.getAttributeNS(null, "value");
            if (_propertyValue != null && _propertyValue.length() > 0) {
                mpi.setProviderName(_propertyValue);
            } else {
                mpi.setProviderName(null);
            }
        }
        return mpi;
    }
}

