/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.binding.utils;

import java.awt.Component;
import java.util.Map;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.ControlBinding;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GaugeBindingUtilsAMX;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtilsAMX;
import oracle.adfdtinternal.dvt.datapresdt.dnd.AMXGraphModelProvider;
import oracle.adfdtinternal.dvt.datapresdt.dnd.DvtBaseProvider;
import oracle.adfdtinternal.dvt.datapresdt.dnd.DvtCoreProvider;
import oracle.adfdtinternal.dvt.datapresdt.dnd.GaugeModelProvider;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.AMXGaugeEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.AMXGraphEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.AMXSparkchartEditor;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.CubicHierEditor;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.NamedDefinition;
import oracle.ide.Ide;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMXDvtBinderUtils {
    public static void populateBinding(ADFDesignTimeContext dtContext, CreationContext creationContext, ModelProvider modelProvider, Node insertionSubtreeRoot, Element root, Map properties) {
        if (!AMXDvtBinderUtils.validate((DvtCoreProvider)modelProvider)) {
            return;
        }
        DvtBaseProvider baseProvider = (DvtBaseProvider)modelProvider;
        BindingUiContext hBindingUIContext = AMXDvtBinderUtils.createBindingUiContext(dtContext, modelProvider, insertionSubtreeRoot, root, properties);
        if (GraphBindingUtils.isMixedFrequencyGraph((Element)root)) {
            hBindingUIContext.setBindingType(3);
        }
        AMXDvtBinderUtils.displayBindingUI(hBindingUIContext);
        baseProvider.applyElementProperties(dtContext, creationContext, modelProvider, insertionSubtreeRoot, root, properties);
    }

    protected static BindingUiContext createBindingUiContext(ADFDesignTimeContext dtContext, ModelProvider modelProvider, Node insertionSubtreeRoot, Element root, Map properties) {
        DvtBaseProvider baseProvider = (DvtBaseProvider)modelProvider;
        NamedDefinition dataControlDefinition = baseProvider.getDefinition();
        BindingUiContext bindingContext = BindingUiContext.createBindingUiContext((ADFDesignTimeContext)dtContext, (ControlBinding)baseProvider.getCtrlObject(), (int)1, (int)baseProvider.getBindingType());
        if (root != null) {
            bindingContext.put((Object)"RootNode", (Object)root);
        }
        if (insertionSubtreeRoot != null) {
            bindingContext.put((Object)"InsertionSubtreeRoot", (Object)insertionSubtreeRoot);
        }
        if (dataControlDefinition instanceof AccessorDefinition) {
            bindingContext.put((Object)"Definition", (Object)((AccessorDefinition)dataControlDefinition).getStructure());
        }
        if (properties.containsKey("graphType")) {
            bindingContext.put((Object)"GraphTypeName", properties.get("graphType"));
        }
        if (properties.containsKey("gaugeType")) {
            bindingContext.put((Object)"GaugeTypeName", properties.get("gaugeType"));
            if (modelProvider != null) {
                String value = ((DvtCoreProvider)modelProvider).getValueExpression();
                bindingContext.put((Object)"Gauge Value", (Object)value);
                bindingContext.put((Object)"Definition", (Object)((GaugeModelProvider)modelProvider).getDefinition());
            }
            if (properties.get("gaugeType").equals("STATUSMETER_THRESHOLDS")) {
                bindingContext.put((Object)"Gauge Threshold", (Object)new Boolean("true"));
            }
        }
        if (properties.containsKey("quickLayout")) {
            if (modelProvider instanceof AMXGraphModelProvider) {
                ((AMXGraphModelProvider)modelProvider).setQuickLayout((String)properties.get("quickLayout"));
            }
            bindingContext.put((Object)"QuickStartLayout", properties.get("quickLayout"));
        }
        return bindingContext;
    }

    public static void displayBindingUI(final BindingUiContext hBindingUIContext) {
        ADFDesignTimeContext dtContext = (ADFDesignTimeContext)hBindingUIContext.get((Object)"ADFDesignTimeContext");
        PageDefinition pageDefinition = dtContext.findOrCreatePageDefinition();
        Task populateBinding = new Task(){

            public void run() {
                boolean ok = AMXDvtBinderUtils.launchBindingEditor(hBindingUIContext);
                if (!ok) {
                    ADFBindingUtils.cancelCreateOrBind();
                } else {
                    CubicHierEditor editor = (CubicHierEditor)hBindingUIContext.get((Object)"Editor");
                    editor.commit();
                }
            }
        };
        pageDefinition.getTransactionManager().runTaskUnderTransaction("populate dvt binding", populateBinding);
    }

    public static boolean launchBindingEditor(BindingUiContext hBindingUIContext) {
        boolean isGauge;
        boolean bResult = false;
        ControlBinding binding = (ControlBinding)hBindingUIContext.get((Object)"Control_Binding");
        String localName = hBindingUIContext.getRootElement().getLocalName();
        boolean bl = isGauge = localName.equals("ledGauge") || localName.equals("statusMeterGauge");
        Object bindingEditor = isGauge ? new AMXGaugeEditor(binding) : (localName.equals("sparkChart") ? new AMXSparkchartEditor(binding) : new AMXGraphEditor(binding));
        if (bindingEditor == null || !CubicHierEditor.class.isAssignableFrom(bindingEditor.getClass())) {
            return false;
        }
        CubicHierEditor hierEditor = (CubicHierEditor)bindingEditor;
        hierEditor.setBindingUiContext(hBindingUIContext);
        hBindingUIContext.put((Object)"Editor", bindingEditor);
        boolean isEdit = hierEditor.isEditBinding();
        String title = isGauge ? GaugeBindingUtilsAMX.getGaugeTitle(isEdit, hBindingUIContext) : GraphBindingUtilsAMX.getGraphDialogTitle(binding, isEdit, hBindingUIContext);
        bResult = bindingEditor.showEditorInDialog((Component)Ide.getMainWindow(), title);
        return bResult;
    }

    protected static boolean validate(DvtCoreProvider provider) {
        return provider.getCtrlObject().hasCustomDialog();
    }
}

