/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.dvt.datapresdt.binding.binder;

import java.awt.Component;
import java.util.Map;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.PageDefinition;
import oracle.adfdt.transaction.Task;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.binding.binder.DvtBaseBinder;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.BindingUiContext;
import oracle.adfdtinternal.dvt.datapresdt.binding.utils.GraphBindingUtils;
import oracle.adfdtinternal.dvt.datapresdt.dnd.DvtBaseProvider;
import oracle.adfdtinternal.dvt.datapresdt.dnd.DvtCoreProvider;
import oracle.adfdtinternal.model.dvt.ide.objects.editors.CubicHierEditor;
import oracle.adfdtinternal.model.ide.objects.editors.JUDTObjectEditor;
import oracle.ide.Ide;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AMXDvtBinder
extends DvtBaseBinder {
    public void bind(ADFDesignTimeContext dtContext, CreationContext creationContext, ModelProvider modelProvider, Node insertionSubtreeRoot, Element root, Map properties) {
        this.populateBinding(dtContext, creationContext, modelProvider, insertionSubtreeRoot, root, properties);
    }

    public void populateBinding(ADFDesignTimeContext dtContext, CreationContext creationContext, ModelProvider modelProvider, Node insertionSubtreeRoot, Element root, Map properties) {
        DvtBaseProvider baseProvider = (DvtBaseProvider)modelProvider;
        if (!AMXDvtBinder.validate((DvtCoreProvider)baseProvider)) {
            return;
        }
        BindingUiContext hBindingUIContext = this.createBindingUiContext(dtContext, creationContext, modelProvider, insertionSubtreeRoot, root, properties);
        if (GraphBindingUtils.isMixedFrequencyGraph((Element)root)) {
            hBindingUIContext.setBindingType(3);
        }
        this.displayBindingUI(hBindingUIContext);
        baseProvider.applyElementProperties(dtContext, creationContext, modelProvider, insertionSubtreeRoot, root, properties);
    }

    public void displayBindingUI(final BindingUiContext hBindingUIContext) {
        ADFDesignTimeContext dtContext = (ADFDesignTimeContext)hBindingUIContext.get((Object)"ADFDesignTimeContext");
        PageDefinition pageDefinition = dtContext.findOrCreatePageDefinition();
        Task populateBinding = new Task(){

            public void run() {
                boolean ok = AMXDvtBinder.this.launchBindingEditor(hBindingUIContext);
                if (!ok) {
                    ADFBindingUtils.cancelCreateOrBind();
                } else {
                    CubicHierEditor editor = (CubicHierEditor)hBindingUIContext.get((Object)"Editor");
                    editor.commit();
                }
            }
        };
        pageDefinition.getTransactionManager().runTaskUnderTransaction("populate dvt binding", populateBinding);
    }

    public boolean launchBindingEditor(BindingUiContext hBindingUIContext) {
        boolean bResult = false;
        JUDTObjectEditor bindingEditor = this.getEditor(hBindingUIContext);
        if (bindingEditor == null || !CubicHierEditor.class.isAssignableFrom(bindingEditor.getClass())) {
            return false;
        }
        CubicHierEditor hierEditor = (CubicHierEditor)bindingEditor;
        hierEditor.setBindingUiContext(hBindingUIContext);
        hBindingUIContext.put((Object)"Editor", (Object)bindingEditor);
        boolean isEdit = hierEditor.isEditBinding();
        String title = this.getTitle(isEdit, hBindingUIContext);
        bResult = bindingEditor.showEditorInDialog((Component)Ide.getMainWindow(), title);
        return bResult;
    }

    protected abstract String getTitle(boolean var1, BindingUiContext var2);

    protected abstract JUDTObjectEditor getEditor(BindingUiContext var1);
}

