/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class ListELResolver
extends ELResolver {
    private final boolean readOnly;

    public ListELResolver() {
        this(false);
    }

    public ListELResolver(boolean bl) {
        this.readOnly = bl;
    }

    public Class getCommonPropertyType(ELContext eLContext, Object object) {
        Class clazz = ListELResolver.isResolvable(object) ? Integer.class : null;
        return clazz;
    }

    public Class getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        Class clazz = null;
        if (ListELResolver.isResolvable(object)) {
            ListELResolver.toIndex((List)object, object2);
            clazz = Object.class;
            eLContext.setPropertyResolved(true);
        }
        return clazz;
    }

    public Object getValue(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        Object var4_4 = null;
        if (ListELResolver.isResolvable(object)) {
            int n = ListELResolver.toIndex(null, object2);
            List list = (List)object;
            var4_4 = n < 0 || n >= list.size() ? null : list.get(n);
            eLContext.setPropertyResolved(true);
        }
        return var4_4;
    }

    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        if (ListELResolver.isResolvable(object)) {
            ListELResolver.toIndex((List)object, object2);
            eLContext.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException("context is null");
        }
        if (ListELResolver.isResolvable(object)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            List list = (List)object;
            int n = ListELResolver.toIndex(list, object2);
            try {
                list.set(n, object3);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new PropertyNotWritableException(unsupportedOperationException);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException(arrayStoreException.getMessage());
            }
            eLContext.setPropertyResolved(true);
        }
    }

    private static final boolean isResolvable(Object object) {
        return object instanceof List;
    }

    private static final int toIndex(List list, Object object) {
        int n = 0;
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (object instanceof String) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Cannot parse list index: " + object);
            }
        } else if (object instanceof Character) {
            n = ((Character)object).charValue();
        } else if (object instanceof Boolean) {
            n = (Boolean)object != false ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Cannot coerce property to list index: " + object);
        }
        if (list != null && (n < 0 || n >= list.size())) {
            throw new PropertyNotFoundException("List index out of bounds: " + n);
        }
        return n;
    }
}

