/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import oracle.adfmf.beans.IntrospectionException;
import oracle.adfmf.beans.Introspector;
import oracle.adfmf.beans.PropertyDescriptor;

public class BeanELResolver
extends ELResolver {
    private final boolean readOnly;
    private final HashMap cache;
    private ExpressionFactory defaultFactory;

    private static Method findAccessibleMethod(Method method) {
        if (method == null || method.isAccessible()) {
            return method;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            GenericDeclaration genericDeclaration;
            Class<?>[] classArray = method.getDeclaringClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                genericDeclaration = classArray[i];
                Method method2 = null;
                try {
                    method2 = genericDeclaration.getMethod(method.getName(), method.getParameterTypes());
                    method2 = BeanELResolver.findAccessibleMethod(method2);
                    if (method2 == null) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            Class<?> clazz = method.getDeclaringClass().getSuperclass();
            if (clazz != null) {
                genericDeclaration = null;
                try {
                    genericDeclaration = clazz.getMethod(method.getName(), method.getParameterTypes());
                    genericDeclaration = BeanELResolver.findAccessibleMethod(genericDeclaration);
                    if (genericDeclaration != null) {
                        return genericDeclaration;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }
        return method;
    }

    public BeanELResolver() {
        this(false);
    }

    public BeanELResolver(boolean bl) {
        this.readOnly = bl;
        this.cache = new HashMap();
    }

    public Class getCommonPropertyType(ELContext eLContext, Object object) {
        Class clazz = this.isResolvable(object) ? Object.class : null;
        return clazz;
    }

    public Class getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        Class clazz = null;
        if (this.isResolvable(object)) {
            clazz = this.toBeanProperty(object, object2).getPropertyType();
            eLContext.setPropertyResolved(true);
        }
        return clazz;
    }

    public Object getValue(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        Object object3 = null;
        if (this.isResolvable(object)) {
            Method method = this.toBeanProperty(object, object2).getReadMethod();
            if (method == null) {
                throw new PropertyNotFoundException("Cannot read property " + object2);
            }
            try {
                object3 = method.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ELException(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new ELException(exception);
            }
            eLContext.setPropertyResolved(true);
        }
        return object3;
    }

    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        boolean bl = this.readOnly;
        if (this.isResolvable(object)) {
            bl |= this.toBeanProperty(object, object2).isReadOnly();
            eLContext.setPropertyResolved(true);
        }
        return bl;
    }

    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (this.isResolvable(object)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            Method method = this.toBeanProperty(object, object2).getWriteMethod();
            if (method == null) {
                throw new PropertyNotWritableException("Cannot write property: " + object2);
            }
            try {
                Class<?>[] classArray = method.getParameterTypes();
                Class<?> clazz = classArray[0];
                ExpressionFactory expressionFactory = this.getExpressionFactory(eLContext);
                Object object4 = expressionFactory.coerceToType(object3, clazz);
                method.invoke(object, object4);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ELException("Cannot write property: " + object2, invocationTargetException.getCause());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PropertyNotWritableException("Cannot write property: " + object2, illegalAccessException);
            }
            eLContext.setPropertyResolved(true);
        }
    }

    public Object invoke(ELContext eLContext, Object object, Object object2, Class[] classArray, Object[] objectArray) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        Object object3 = null;
        if (this.isResolvable(object)) {
            String string;
            Method method;
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if ((method = this.findMethod(object, string = object2.toString(), classArray, objectArray.length)) == null) {
                throw new MethodNotFoundException("Cannot find method " + string + " with " + objectArray.length + " parameters in " + object.getClass());
            }
            try {
                object3 = method.invoke(object, this.coerceParams(this.getExpressionFactory(eLContext), method, objectArray));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ELException(invocationTargetException.getCause());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ELException(illegalAccessException);
            }
            eLContext.setPropertyResolved(true);
        }
        return object3;
    }

    private Method findMethod(Object object, String string, Class[] classArray, int n) {
        if (classArray != null) {
            try {
                return BeanELResolver.findAccessibleMethod(object.getClass().getMethod(string, classArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        Method method = null;
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n2;
            Method method2 = methodArray[i];
            if (!method2.getName().equals(string) || n != (n2 = method2.getParameterTypes().length)) continue;
            return BeanELResolver.findAccessibleMethod(method2);
        }
        return method == null ? null : BeanELResolver.findAccessibleMethod(method);
    }

    private ExpressionFactory getExpressionFactory(ELContext eLContext) {
        Object object = eLContext.getContext(ExpressionFactory.class);
        if (object instanceof ExpressionFactory) {
            return (ExpressionFactory)object;
        }
        if (this.defaultFactory == null) {
            this.defaultFactory = ExpressionFactory.newInstance();
        }
        return this.defaultFactory;
    }

    private Object[] coerceParams(ExpressionFactory expressionFactory, Method method, Object[] objectArray) {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray2 = new Object[classArray.length];
        if (objectArray.length != objectArray2.length) {
            throw new ELException("Bad argument count");
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            this.coerceValue(objectArray2, i, expressionFactory, objectArray[i], classArray[i]);
        }
        return objectArray2;
    }

    private void coerceValue(Object object, int n, ExpressionFactory expressionFactory, Object object2, Class clazz) {
        if (object2 != null || clazz.isPrimitive()) {
            Array.set(object, n, expressionFactory.coerceToType(object2, clazz));
        }
    }

    private final boolean isResolvable(Object object) {
        return object != null;
    }

    private final BeanProperty toBeanProperty(Object object, Object object2) {
        BeanProperties beanProperties;
        BeanProperties beanProperties2 = (BeanProperties)this.cache.get(object.getClass());
        if (beanProperties2 == null) {
            beanProperties = new BeanProperties(object.getClass());
            if (!this.cache.containsKey(object.getClass())) {
                this.cache.put(object.getClass(), beanProperties);
                beanProperties2 = beanProperties;
            }
        }
        BeanProperties beanProperties3 = beanProperties = object2 == null ? null : beanProperties2.getBeanProperty(object2.toString());
        if (beanProperties == null) {
            throw new PropertyNotFoundException("Could not find property " + object2 + " in " + object.getClass());
        }
        return beanProperties;
    }

    private final void purgeBeanClasses(ClassLoader classLoader) {
        Iterator iterator = this.cache.keySet().iterator();
        while (iterator.hasNext()) {
            if (classLoader != ((Class)iterator.next()).getClassLoader()) continue;
            iterator.remove();
        }
    }

    protected static final class BeanProperty {
        private final PropertyDescriptor descriptor;

        public BeanProperty(PropertyDescriptor propertyDescriptor) {
            this.descriptor = propertyDescriptor;
        }

        public Class getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public Method getReadMethod() {
            return BeanELResolver.findAccessibleMethod(this.descriptor.getReadMethod());
        }

        public Method getWriteMethod() {
            return BeanELResolver.findAccessibleMethod(this.descriptor.getWriteMethod());
        }

        public boolean isReadOnly() {
            return BeanELResolver.findAccessibleMethod(this.descriptor.getWriteMethod()) == null;
        }
    }

    protected static final class BeanProperties {
        private final Map map = new HashMap();

        public BeanProperties(Class clazz) {
            PropertyDescriptor[] propertyDescriptorArray;
            try {
                propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                throw new ELException(introspectionException);
            }
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                this.map.put(propertyDescriptor.getName(), new BeanProperty(propertyDescriptor));
            }
        }

        public BeanProperty getBeanProperty(String string) {
            return (BeanProperty)this.map.get(string);
        }
    }
}

