/*
 * Decompiled with CFR 0.152.
 */
package oracle.ksoap2.transport;

import com.sun.util.logging.Level;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import javax.microedition.io.HttpsConnection;
import oracle.adfmf.dc.ws.WebServiceTransportLayer;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.CredentialStoreUtil;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;
import oracle.ksoap2.serialization.SoapSerializationEnvelope;
import oracle.ksoap2.transport.HttpServiceConnection;
import oracle.wsm.agent.ksoap2.kSOAPAgent;
import oracle.wsm.resource.subject.AbstractPolicyFeature;
import oracle.wsm.resource.subject.PolicyReferenceFeature;
import oracle.wsm.resource.subject.PolicySubjectDefinition;
import oracle.wsm.resource.subject.PropertyFeature;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.transport.ServiceConnection;
import org.kxml2.kdom.Element;
import org.xmlpull.v1.XmlPullParserException;

public class HttpTransport
extends org.ksoap2.transport.HttpTransport {
    private int responseCode = 409;
    private String responseMsg = null;
    private String responseContentType = null;
    private HttpServiceConnection httpSvcConn = null;
    private kSOAPAgent agent = null;
    private final transient ThreadLocal callContext = new ThreadLocal();
    private String _credentialStoreKey;
    private boolean _isSecureConnection;
    private static String lastRequest;

    public static String getLastRequest() {
        if (Utility.isRunningInTestMode()) {
            return lastRequest;
        }
        return null;
    }

    public HttpTransport(String string, String string2, String string3, String string4, String string5) {
        super(string);
        this._credentialStoreKey = string4;
        boolean bl = this._isSecureConnection = string4 != null;
        if (this._isSecureConnection) {
            String string6 = CredentialStoreUtil.getUsernameForAuthUrl(this._credentialStoreKey);
            String string7 = CredentialStoreUtil.getPasswordForAuthUrl(this._credentialStoreKey);
            Properties properties = new Properties();
            properties.setProperty("javax.xml.ws.security.auth.username", string6);
            properties.setProperty("javax.xml.ws.security.auth.password", string7);
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "HttpTransport", "Creating {0}({1}, password)", new Object[]{((Object)((Object)this)).getClass().getName(), string6});
            }
            if (string5 != null && string5.length() > 0) {
                PolicyReferenceFeature[] policyReferenceFeatureArray = new PolicyReferenceFeature[]{new PolicyReferenceFeature(string5)};
                PolicySubjectDefinition policySubjectDefinition = new PolicySubjectDefinition(kSOAPAgent.createResourceIdentifier((String)"GenericPlatform", (String)"ADFMFApplication", (String)string2, (String)string3), (AbstractPolicyFeature[])policyReferenceFeatureArray);
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "HttpTransport", "Creating {0}({1}, password)", new Object[]{((Object)((Object)this)).getClass().getName(), CredentialStoreUtil.getUsernameForAuthUrl(this._credentialStoreKey)});
                }
                this.agent = new kSOAPAgent(policySubjectDefinition, properties);
            } else {
                PolicyReferenceFeature[] policyReferenceFeatureArray = new PolicyReferenceFeature[]{};
                PolicySubjectDefinition policySubjectDefinition = new PolicySubjectDefinition(kSOAPAgent.createResourceIdentifier((String)"GenericPlatform", (String)"ADFMFApplication", (String)string2, (String)string3), (AbstractPolicyFeature[])policyReferenceFeatureArray);
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "HttpTransport", "Creating {0}({1}, password)", new Object[]{((Object)((Object)this)).getClass().getName(), CredentialStoreUtil.getUsernameForAuthUrl(this._credentialStoreKey)});
                }
                this.agent = new kSOAPAgent(policySubjectDefinition, properties);
            }
        }
    }

    public void call(String string, SoapEnvelope soapEnvelope) throws IOException {
        if (this._isSecureConnection) {
            this.callSecured(string, soapEnvelope);
        } else {
            this.callUnsecured(string, soapEnvelope);
        }
    }

    private byte[] getRequest(SoapEnvelope soapEnvelope) throws IOException {
        byte[] byArray = this.createRequestData(soapEnvelope);
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            String string = Utility.bytesToString(byArray);
            Trace.log(Utility.FrameworkLogger, Level.FINER, HttpTransport.class, "getRequest", "Request:\n Length: {0};\n XML Stream: {1}", new Object[]{new Integer(string.length()), string});
        }
        if (Utility.isRunningInTestMode()) {
            lastRequest = Utility.bytesToString(byArray);
        }
        return byArray;
    }

    public void callUnsecured(String string, SoapEnvelope soapEnvelope) throws IOException {
        byte[] byArray = this.getRequest(soapEnvelope);
        ServiceConnection serviceConnection = this.getServiceConnection();
        this.doCall(string, soapEnvelope, serviceConnection, soapEnvelope, byArray, 0);
    }

    private SoapEnvelope prepareEnvelopeForSecurity(SoapEnvelope soapEnvelope) {
        if (soapEnvelope.headerOut == null) {
            return soapEnvelope;
        }
        Element[] elementArray = soapEnvelope.headerOut;
        int n = elementArray.length;
        soapEnvelope.headerOut = new Element[n + 1];
        soapEnvelope.headerOut[0] = new Element().createElement("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        soapEnvelope.headerOut[0].setAttribute(null, "mustUnderstand", "1");
        for (int i = 0; i < n; ++i) {
            soapEnvelope.headerOut[i + 1] = elementArray[i];
        }
        return soapEnvelope;
    }

    public void callSecured(String string, SoapEnvelope soapEnvelope) throws IOException {
        String string2;
        String string3;
        PropertyFeature[] propertyFeatureArray = new PropertyFeature[]{};
        kSOAPAgent.kSOAPEnforcementContext kSOAPEnforcementContext2 = this.agent.createEnforcementContext(null == this.url ? null : new URL(this.url), string, propertyFeatureArray);
        if (CredentialStoreUtil.isConnectionMultiTenantAware()) {
            string3 = CredentialStoreUtil.getTenantName();
            string2 = CredentialStoreUtil.getTenantHeaderName();
            kSOAPEnforcementContext2.setTransportHeader(string2, string3);
        }
        this.callContext.set(kSOAPEnforcementContext2);
        string3 = this.getServiceConnection();
        string2 = kSOAPEnforcementContext2.createProxy(this.prepareEnvelopeForSecurity(soapEnvelope));
        byte[] byArray = this.getRequest((SoapEnvelope)string2);
        int n = 0;
        while (401 == this.doCall(string, soapEnvelope, (ServiceConnection)string3, (SoapEnvelope)string2, byArray, n)) {
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCall(String string, SoapEnvelope soapEnvelope, ServiceConnection serviceConnection, SoapEnvelope soapEnvelope2, byte[] byArray, int n) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String string2 = "text/xml";
        String string3 = "http-transport:POST" + string;
        MonitorFactory monitorFactory = MonitorFactory.getInstance();
        Monitor monitor = monitorFactory.getMonitor(string3 + "-wire", "invoke " + string3);
        if (soapEnvelope instanceof SoapSerializationEnvelope) {
            string2 = ((SoapSerializationEnvelope)soapEnvelope).getContentType();
        }
        if (string == null) {
            string = "\"\"";
        }
        monitor.start();
        serviceConnection.setRequestProperty("User-Agent", "kSOAP 2.0 + ORACLE Extensions");
        serviceConnection.setRequestProperty("SOAPAction", string);
        serviceConnection.setRequestProperty("Content-Type", string2);
        serviceConnection.setRequestProperty("Connection", "close");
        serviceConnection.setRequestProperty("Content-Length", "" + byArray.length);
        serviceConnection.setRequestMethod("POST");
        if (n == 0) {
            serviceConnection.connect();
        }
        try {
            try {
                block14: {
                    outputStream = serviceConnection.openOutputStream();
                    outputStream.write(byArray, 0, byArray.length);
                    outputStream.flush();
                    outputStream.close();
                    byArray = null;
                    try {
                        serviceConnection.connect();
                    }
                    catch (Throwable throwable) {
                        if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block14;
                        Trace.log(Utility.FrameworkLogger, Level.WARNING, HttpTransport.class, "doCall", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40025", new Object[]{throwable});
                    }
                }
                inputStream = serviceConnection.openInputStream();
            }
            catch (IOException iOException) {
                inputStream = serviceConnection.getErrorStream();
                if (inputStream == null) {
                    serviceConnection.disconnect();
                    throw iOException;
                }
                Object var15_18 = null;
                monitor.addObservation();
            }
            Object var15_17 = null;
            monitor.addObservation();
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            monitor.addObservation();
            throw throwable;
        }
        try {
            try {
                monitor = monitorFactory.getMonitor(string3 + "-parse-response", "invoke " + string3);
                monitor.start();
                this.parseResponse(soapEnvelope2, inputStream);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new AdfException(xmlPullParserException);
            }
            Object var17_21 = null;
            monitor.addObservation();
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            monitor.addObservation();
            throw throwable;
        }
        return this.httpSvcConn.getResponseCode();
    }

    public int getResponseCode() throws IOException {
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        return this.responseMsg;
    }

    public String getResponseContentType() throws IOException {
        return this.responseContentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ServiceConnection getServiceConnection() throws IOException {
        block8: {
            if (!this._isSecureConnection) {
                try {
                    try {
                        this.httpSvcConn = new HttpServiceConnection(this.url);
                    }
                    catch (Throwable throwable) {
                        if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) throw new AdfException(throwable.getMessage(), "ERROR");
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, HttpTransport.class, "getServiceConnection", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11023", new Object[]{throwable.getMessage()});
                        throw new AdfException(throwable.getMessage(), "ERROR");
                    }
                    Object var3_1 = null;
                    if (this.httpSvcConn != null) break block8;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    if (this.httpSvcConn != null) {
                        throw throwable;
                    }
                    if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
                    Trace.log(Utility.FrameworkLogger, Level.SEVERE, HttpTransport.class, "getServiceConnection", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
                    throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
                }
                if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, HttpTransport.class, "getServiceConnection", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11024", null);
            }
            kSOAPAgent.kSOAPEnforcementContext kSOAPEnforcementContext2 = (kSOAPAgent.kSOAPEnforcementContext)this.callContext.get();
            try {
                this.httpSvcConn = new HttpServiceConnection(this.url);
                return kSOAPEnforcementContext2.createProxy((ServiceConnection)this.httpSvcConn);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return kSOAPEnforcementContext2.createProxy((ServiceConnection)this.httpSvcConn);
        }
        if (!Utility.FrameworkLogger.isLoggable(Level.FINEST)) return this.httpSvcConn;
        Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "getServiceConnection", "Connection type: HTTP{0}", new Object[]{this.httpSvcConn instanceof HttpsConnection ? "S" : ""});
        return this.httpSvcConn;
    }

    protected void parseResponse(SoapEnvelope soapEnvelope, InputStream inputStream) throws XmlPullParserException, IOException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        int n = 0;
        int n2 = 0;
        this.responseCode = this.httpSvcConn.getResponseCode();
        this.responseMsg = WebServiceTransportLayer.getCustomHttpStatusMessage(this.responseCode);
        this.responseContentType = this.httpSvcConn.getResponseContentType();
        while ((n = inputStream.read()) != -1) {
            ++n2;
            byteArrayOutputStream.write(n);
        }
        try {
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "parseResponse", (Throwable)unsupportedEncodingException);
                Trace.log(Utility.FrameworkLogger, Level.FINEST, HttpTransport.class, "parseResponse", (Object)"UTF-8 was unsupported, so falling back to platform-default character set");
            }
            string = byteArrayOutputStream.toString();
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, HttpTransport.class, "parseResponse", "Response:\n  Code: {0};\n  Message: {1};\n  Dump: {2};\n  Number of bytes read: {3};\n XML Stream: {4}", new Object[]{new Integer(this.responseCode), this.responseMsg, this.responseDump, new Integer(n2), string});
        }
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        if (this.responseCode == 200) {
            super.parseResponse(soapEnvelope, (InputStream)byteArrayInputStream);
        } else if (n2 == 0 && this.responseCode == 202) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, HttpTransport.class, "parseResponse", (Object)"Server accepted the request, but no reply was given");
            }
            soapEnvelope.bodyIn = null;
        } else if (this.responseCode == 401) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, HttpTransport.class, "parseResponse", (Object)"Unauthorized response.");
            }
        } else {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, HttpTransport.class, "parseResponse", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11062", new Object[]{new Integer(this.responseCode), string});
            }
            throw new AdfException(this.responseMsg, "ERROR");
        }
    }
}

