/*
 * Decompiled with CFR 0.152.
 */
package oracle.ksoap2.serialization;

import java.io.IOException;
import oracle.adfmf.util.GenericType;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.PropertyInfo;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SoapSerializationEnvelope
extends org.ksoap2.serialization.SoapSerializationEnvelope {
    private boolean bareMode = false;
    private String contentType = "text/xml";

    public SoapSerializationEnvelope(int n, boolean bl) {
        super(n);
        this.bareMode = bl;
        this.implicitTypes = true;
        switch (n) {
            case 110: {
                this.version = 110;
                this.enc = "http://schemas.xmlsoap.org/soap/encoding/";
                this.env = "http://schemas.xmlsoap.org/soap/envelope/";
                this.xsi = "http://www.w3.org/2001/XMLSchema-instance";
                this.xsd = "http://www.w3.org/2001/XMLSchema";
                this.contentType = "text/xml";
                break;
            }
            case 120: {
                this.version = 120;
                this.enc = "http://www.w3.org/2001/12/soap-encoding";
                this.env = "http://www.w3.org/2003/05/soap-envelope";
                this.xsi = "http://www.w3.org/2001/XMLSchema-instance";
                this.xsd = "http://www.w3.org/2001/XMLSchema";
                this.contentType = "application/soap+xml";
                break;
            }
            default: {
                this.version = 100;
                this.enc = "http://schemas.xmlsoap.org/soap/encoding/";
                this.env = "http://schemas.xmlsoap.org/soap/envelope/";
                this.xsi = "http://www.w3.org/1999/XMLSchema-instance";
                this.xsd = "http://www.w3.org/1999/XMLSchema";
                this.contentType = "text/xml";
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void writeObjectBody(XmlSerializer xmlSerializer, KvmSerializable kvmSerializable) throws IOException {
        PropertyInfo propertyInfo = new PropertyInfo();
        int n = kvmSerializable.getPropertyCount();
        if (this.bareMode && n == 1 && !(kvmSerializable.getProperty(0) instanceof GenericType)) {
            this.writeProperty(xmlSerializer, kvmSerializable.getProperty(0), propertyInfo);
        } else {
            super.writeObjectBody(xmlSerializer, kvmSerializable);
        }
    }

    protected Object readUnknown(XmlPullParser xmlPullParser, String string, String string2) throws IOException, XmlPullParserException {
        String string3 = string2;
        String string4 = string;
        if (null != xmlPullParser) {
            string3 = xmlPullParser.getName();
            string4 = xmlPullParser.getNamespace();
        }
        return super.readUnknown(xmlPullParser, string4, string3);
    }

    public void writeBody(XmlSerializer xmlSerializer) throws IOException {
        if (this.bodyOut == null) {
            return;
        }
        super.writeBody(xmlSerializer);
    }
}

