/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.logging;

import com.sun.util.logging.ErrorManager;
import com.sun.util.logging.Filter;
import com.sun.util.logging.Formatter;
import com.sun.util.logging.Level;
import com.sun.util.logging.LogRecord;
import com.sun.util.logging.StreamHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.LoggingUtility;

public class FileHandler
extends StreamHandler {
    private com.sun.util.logging.FileHandler fileHandler;
    private String pattern;
    private int limit;
    private int count;
    private boolean append;

    public FileHandler() throws IOException, SecurityException {
        this.configure();
        this.openFileHandler();
    }

    public FileHandler(String string) throws IOException, SecurityException {
        this.configure();
        this.pattern = string;
        this.openFileHandler();
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        this.configure();
        this.pattern = string;
        this.append = bl;
        this.openFileHandler();
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.openFileHandler();
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        this.configure();
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        this.openFileHandler();
    }

    private void configure() {
        String string = ((Object)((Object)this)).getClass().getName();
        this.pattern = LoggingUtility.getStringProperty(string + ".pattern", "%h/java%u.log");
        this.limit = LoggingUtility.getIntegerProperty(string + ".limit", 0);
        this.count = LoggingUtility.getIntegerProperty(string + ".count", 1);
        this.append = LoggingUtility.getBooleanProperty(string + ".append", false);
        byte by = Utility.getOSFamily();
        if (by != -1) {
            String string2;
            switch (by) {
                default: {
                    string2 = "ios";
                    break;
                }
                case 1: {
                    string2 = "and";
                    break;
                }
                case 2: {
                    string2 = "mac";
                    break;
                }
                case 3: {
                    string2 = "win";
                }
            }
            this.pattern = LoggingUtility.getStringProperty(string + "." + string2 + ".pattern", this.pattern);
            this.limit = LoggingUtility.getIntegerProperty(string + "." + string2 + ".limit", this.limit);
            this.count = LoggingUtility.getIntegerProperty(string + "." + string2 + ".count", this.count);
            this.append = LoggingUtility.getBooleanProperty(string + "." + string2 + ".append", this.append);
        }
    }

    private void openFileHandler() throws IOException, SecurityException {
        this.fileHandler = new com.sun.util.logging.FileHandler(this.pattern, this.limit, this.count, this.append);
        this.fileHandler.setLevel(this.getLevel());
        this.fileHandler.setFilter(this.getFilter());
        this.fileHandler.setFormatter(this.getFormatter());
        this.fileHandler.setEncoding(this.getEncoding());
        this.fileHandler.setErrorManager(this.getErrorManager());
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(level);
        }
    }

    public void setFilter(Filter filter) {
        super.setFilter(filter);
        if (this.fileHandler != null) {
            this.fileHandler.setFilter(filter);
        }
    }

    public void setFormatter(Formatter formatter) {
        super.setFormatter(formatter);
        if (this.fileHandler != null) {
            this.fileHandler.setFormatter(formatter);
        }
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        super.setEncoding(string);
        if (this.fileHandler != null) {
            this.fileHandler.setEncoding(string);
        }
    }

    public void setErrorManager(ErrorManager errorManager) {
        super.setErrorManager(errorManager);
        if (this.fileHandler != null) {
            this.fileHandler.setErrorManager(errorManager);
        }
    }

    public void close() {
        this.fileHandler.close();
    }

    public void flush() {
        this.fileHandler.flush();
    }

    public void publish(LogRecord logRecord) {
        this.fileHandler.publish(logRecord);
    }
}

