/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XliffResourceBundle
extends ResourceBundle {
    private static final String XLF_EXT = ".xlf";
    private static final String XLIFF = "xliff";
    private static final String ID = "id";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String TRANS_UNIT = "trans-unit";
    private static final String EMPTY_STR = "";
    private Locale locale;
    private Hashtable properties = new Hashtable();
    private static Hashtable cache = new Hashtable();

    protected XliffResourceBundle() {
    }

    protected Object handleGetObject(String string) {
        if (this.properties.containsKey(string)) {
            return this.properties.get(string);
        }
        return null;
    }

    public Enumeration getKeys() {
        return this.properties.keys();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static XliffResourceBundle getXliffResourceBundle(String string) {
        return XliffResourceBundle.getXliffResourceBundle(string, Locale.getDefault());
    }

    public static XliffResourceBundle getXliffResourceBundle(String string, Locale locale) {
        return XliffResourceBundle.getXliffResourceBundle(string, locale, Thread.currentThread().getContextClassLoader());
    }

    public static XliffResourceBundle getXliffResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        InstantiateResult instantiateResult;
        XliffResourceBundle xliffResourceBundle = null;
        String[] stringArray = XliffResourceBundle.getCandidateBundleNames(string, locale);
        if (stringArray.length != 0) {
            xliffResourceBundle = XliffResourceBundle.getXliffResourceBundle(string, stringArray, locale, classLoader);
            if (xliffResourceBundle != null) {
                return xliffResourceBundle;
            }
            stringArray = XliffResourceBundle.getCandidateBundleNames(string, Locale.getDefault());
            xliffResourceBundle = XliffResourceBundle.getXliffResourceBundle(string, stringArray, Locale.getDefault(), classLoader);
            if (xliffResourceBundle != null) {
                return xliffResourceBundle;
            }
        }
        if ((instantiateResult = XliffResourceBundle.instantiateXliffBundle(string, string, locale, classLoader)) != null) {
            if (!instantiateResult.inCache) {
                cache.put(string, instantiateResult.resourceBundle);
            }
            return instantiateResult.resourceBundle;
        }
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, EMPTY_STR);
    }

    private static XliffResourceBundle getXliffResourceBundle(String string, String[] stringArray, Locale locale, ClassLoader classLoader) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            InstantiateResult instantiateResult = XliffResourceBundle.instantiateXliffBundle(string, string2, locale, classLoader);
            if (instantiateResult == null) continue;
            if (!instantiateResult.inCache) {
                for (int j = 0; j <= i; ++j) {
                    cache.put(stringArray[j], instantiateResult.resourceBundle);
                }
                XliffResourceBundle xliffResourceBundle = instantiateResult.resourceBundle;
                for (int j = i + 1; j <= stringArray.length && xliffResourceBundle.parent == null; ++j) {
                    String string3 = j == stringArray.length ? string : stringArray[j];
                    InstantiateResult instantiateResult2 = XliffResourceBundle.instantiateXliffBundle(string, string3, locale, classLoader);
                    if (instantiateResult2 == null) continue;
                    if (!instantiateResult.inCache) {
                        cache.put(string3, instantiateResult2.resourceBundle);
                    }
                    xliffResourceBundle.setParent(instantiateResult2.resourceBundle);
                    xliffResourceBundle = instantiateResult2.resourceBundle;
                }
            }
            return instantiateResult.resourceBundle;
        }
        return null;
    }

    private static InstantiateResult instantiateXliffBundle(String string, String string2, Locale locale, ClassLoader classLoader) {
        XliffResourceBundle xliffResourceBundle = (XliffResourceBundle)cache.get(string2);
        if (xliffResourceBundle != null) {
            return new InstantiateResult(xliffResourceBundle, true);
        }
        xliffResourceBundle = XliffResourceBundle.createXliffBundle(string, string2, locale, classLoader);
        if (xliffResourceBundle != null) {
            return new InstantiateResult(xliffResourceBundle, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XliffResourceBundle createXliffBundle(String string, String string2, Locale locale, ClassLoader classLoader) {
        InputStream inputStream;
        block3: {
            XliffResourceBundle xliffResourceBundle;
            String string3 = XliffResourceBundle.fullNameToXliffFileName(string2);
            inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(string3);
                if (inputStream == null) break block3;
                XliffResourceBundle xliffResourceBundle2 = new XliffResourceBundle();
                xliffResourceBundle2.locale = locale;
                xliffResourceBundle2.load(inputStream);
                xliffResourceBundle = xliffResourceBundle2;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Utility.closeSilently(inputStream);
                throw throwable;
            }
            Utility.closeSilently(inputStream);
            return xliffResourceBundle;
        }
        Object var9_9 = null;
        Utility.closeSilently(inputStream);
        return null;
    }

    protected void load(InputStream inputStream) {
        try {
            int n;
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setInput(inputStream, null);
            String string = EMPTY_STR;
            String string2 = EMPTY_STR;
            boolean bl = false;
            while ((n = xmlPullParser.nextTag()) != 1) {
                if (xmlPullParser.getName() == null) continue;
                if (!xmlPullParser.getName().equals(XLIFF) || n != 3) {
                    if (xmlPullParser.getName().equals(TRANS_UNIT)) {
                        if (n == 2) {
                            string2 = EMPTY_STR;
                            string = EMPTY_STR;
                            if (xmlPullParser.getAttributeCount() > 0 && xmlPullParser.getAttributeName(0).equals(ID)) {
                                string = xmlPullParser.getAttributeValue(null, ID);
                            }
                            bl = true;
                            continue;
                        }
                        if (n != 3) continue;
                        this.properties.put(string, string2);
                        bl = false;
                        continue;
                    }
                    if (n != 2 || !bl) continue;
                    String string3 = xmlPullParser.nextText();
                    if (!xmlPullParser.getName().equals(SOURCE) && !xmlPullParser.getName().equals(TARGET) || string3.equals(EMPTY_STR)) continue;
                    string2 = string3;
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new AdfException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new AdfException(iOException);
        }
    }

    private static String[] getCandidateBundleNames(String string, Locale locale) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        StringBuffer stringBuffer = new StringBuffer(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        stringBuffer.append("_");
        if (string2.length() > 0) {
            stringBuffer.append(string2);
            linkedList.addFirst(stringBuffer.toString());
        }
        stringBuffer.append("_");
        if (string3.length() > 0) {
            stringBuffer.append(string3);
            linkedList.addFirst(stringBuffer.toString());
        }
        if (string4.length() > 0) {
            stringBuffer.append("_").append(string4);
            linkedList.addFirst(stringBuffer.toString());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private static final String fullNameToXliffFileName(String string) {
        return XliffResourceBundle.fullNameToPathName(string) + XLF_EXT;
    }

    private static final String fullNameToPathName(String string) {
        return string.replace('.', '/');
    }

    private static class InstantiateResult {
        public XliffResourceBundle resourceBundle;
        public boolean inCache;

        public InstantiateResult(XliffResourceBundle xliffResourceBundle, boolean bl) {
            this.resourceBundle = xliffResourceBundle;
            this.inCache = bl;
        }
    }
}

