/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.bindings.BindingContainer;
import oracle.adfmf.bindings.DataControl;
import oracle.adfmf.bindings.dbf.AmxControlBinding;
import oracle.adfmf.bindings.dbf.AmxExecutableBinding;
import oracle.adfmf.bindings.iterator.BasicIterator;
import oracle.adfmf.dc.DataProviderManager;
import oracle.adfmf.dc.GenericJavaBeanDataControlAdapter;
import oracle.adfmf.dc.bean.ConcreteJavaBeanDataControlAdapter;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObject;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObjectBase;
import oracle.adfmf.dc.bean.ConcreteJavaCollectionObject;
import oracle.adfmf.dc.ws.WebServiceDataControlAdapter;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.event.DataChangeFilter;
import oracle.adfmf.framework.event.DataChangeFilterable;
import oracle.adfmf.framework.event.DataChangeListener;
import oracle.adfmf.framework.event.DataChangeProvider;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.ProviderChangeEvent;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.page.BeanBindingIteratorBaseDefinition;
import oracle.adfmf.util.AttributeInfo;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class GenericTypeIteratorAdapter
implements BasicIterator,
DataChangeListener,
DataChangeFilterable {
    private static final boolean ENABLE_CHANGE_NOTIFICATION = true;
    private static final String DEFAULT_KEY_ATTRIBUTE = "key";
    private static final String PDEF_ATTRIBUTE = "PDefAttribute";
    private static final String PDEF_NAME_ATTRIBUTE = "Name";
    private static final String PDEF_PRIMARYKEY_ATTRIBUTE = "PrimaryKey";
    private XmlAnyDefinition metadataDef = null;
    protected int index = -1;
    protected int rangeSize = 1;
    protected String name = null;
    protected String id = null;
    protected String masterId = null;
    private String keyAttribute = null;
    private Object currentKey = null;
    protected DataControl dc = null;
    protected GenericTypeIteratorAdapter master = null;
    protected List detailIterators = null;
    protected BindingContainer bc = null;
    private Map eventFilters = new HashMap();
    private Map keysToIndices = new HashMap();

    public GenericTypeIteratorAdapter() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "GenericTypeIteratorAdapter", "Creating a {0} iterator.", new Object[]{this.getClass().getName()});
        }
    }

    public GenericTypeIteratorAdapter(DataControl dataControl, XmlAnyDefinition xmlAnyDefinition, BindingContainer bindingContainer, GenericType genericType) {
        this();
        AmxExecutableBinding amxExecutableBinding;
        BasicIterator basicIterator;
        BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition = GenericJavaBeanDataControlAdapter.testIncomingIteratorMetadataDef(xmlAnyDefinition);
        String string = null;
        String string2 = null;
        if (beanBindingIteratorBaseDefinition != null) {
            string = beanBindingIteratorBaseDefinition.getId();
            string2 = beanBindingIteratorBaseDefinition.getMasterBinding();
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "GenericTypeIteratorAdapter", "Creating {0} for {1} / {2}", new Object[]{this.getClass().getName(), string2, string});
        }
        this.metadataDef = beanBindingIteratorBaseDefinition;
        this.dc = dataControl;
        this.id = string;
        this.bc = bindingContainer;
        this.masterId = string2;
        this.registerDataChangeListener();
        String string3 = beanBindingIteratorBaseDefinition.getBinds();
        int n = string3.indexOf(".");
        String string4 = this.name = n < 0 ? string3 : string3.substring(0, n);
        if (string2 != null && (basicIterator = (amxExecutableBinding = (AmxExecutableBinding)bindingContainer.get(string2)).getIterator()) instanceof GenericTypeIteratorAdapter) {
            this.master = (GenericTypeIteratorAdapter)basicIterator;
            this.master.addDetailIterator(this);
        }
        this.keyAttribute = this.findKeyAttribute();
        this.setCurrentIndex(this.findPosition(genericType));
    }

    public String toString() {
        return "GTIA: [mst:" + this.masterId + "/id:" + this.id + "] : " + this.getTotalRowCount();
    }

    protected int findPosition(GenericType genericType) {
        List list;
        GenericType genericType2 = genericType != null ? genericType.getParent() : null;
        int n = 0;
        if (genericType2 != null && genericType2 instanceof GenericVirtualType && (list = ((GenericVirtualType)genericType2).getAttributeCollection(genericType.getName())) != null && list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != genericType) continue;
                n = i;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "findPosition", "Currently at sibling #{0} of {1}", new Object[]{new Integer(n), new Integer(list.size())});
            }
        }
        return n;
    }

    protected int findPosition(Object object) {
        return 0;
    }

    protected void log(Level level, String string, String string2) {
        this.log(level, string, string2, null);
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, objectArray);
    }

    public XmlAnyDefinition getMetadataDefinition() {
        return this.metadataDef;
    }

    public void setMetadataDefinition(XmlAnyDefinition xmlAnyDefinition) {
    }

    private void registerDataChangeListener() {
        DataProviderManager dataProviderManager = ((GenericJavaBeanDataControlAdapter)this.dc).getDataProviderManager();
        dataProviderManager.registerIteratorPropertyChangeListener(this.bc.getName(), this.id, this);
        dataProviderManager.registerIteratorProviderChangeListener(this.bc.getName(), this.id, this);
    }

    protected void addDetailIterator(GenericTypeIteratorAdapter genericTypeIteratorAdapter) {
        if (this.detailIterators == null) {
            this.detailIterators = new ArrayList();
        }
        this.detailIterators.add(genericTypeIteratorAdapter);
    }

    protected GenericTypeIteratorAdapter getDetailIterator(String string) {
        String string2 = string + "Iterator";
        if (this.detailIterators != null) {
            Iterator iterator = this.detailIterators.iterator();
            while (iterator.hasNext()) {
                GenericTypeIteratorAdapter genericTypeIteratorAdapter = (GenericTypeIteratorAdapter)iterator.next();
                if (string2.compareTo(genericTypeIteratorAdapter.id) != 0) continue;
                return genericTypeIteratorAdapter;
            }
        }
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block4: {
            if (this.getWrappedDataProvider() != propertyChangeEvent.getSource()) {
                return;
            }
            try {
                Iterator iterator = this.eventFilters.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    DataChangeFilter dataChangeFilter = (DataChangeFilter)this.eventFilters.get(string);
                    Object object = dataChangeFilter.filterEvent(propertyChangeEvent);
                    if (!(object instanceof PropertyChangeEvent)) continue;
                    ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager().enqueue(this.bc.getName(), object);
                }
            }
            catch (Throwable throwable) {
                if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) break block4;
                this.log(Level.FINE, "GenericTypeIteratorAdapter", "Encountered a problem when processing a property change event {0}", new Object[]{throwable.toString()});
            }
        }
    }

    public synchronized void providerChange(ProviderChangeEvent providerChangeEvent) {
        Object object;
        Iterator iterator;
        Object[] objectArray;
        HashMap<String, Object[]> hashMap;
        ProviderChangeEvent providerChangeEvent2 = providerChangeEvent;
        if (providerChangeEvent.getOperation() == "propagated update") {
            try {
                hashMap = (ConcreteJavaBeanObject)providerChangeEvent.getNewValue();
                objectArray = null;
                iterator = this.keyAttribute;
                if (Utility.isEmpty((String)((Object)iterator)) && (object = this.getDetailIterator(providerChangeEvent.getProviderKey())) != null) {
                    iterator = ((GenericTypeIteratorAdapter)object).findKeyAttribute();
                }
                objectArray = ((ConcreteJavaBeanObjectBase)((Object)hashMap)).getProviderKeyValue((String)(!Utility.isEmpty((String)((Object)iterator)) ? iterator : DEFAULT_KEY_ATTRIBUTE));
                providerChangeEvent2 = new ProviderChangeEvent("update", providerChangeEvent.getProviderKey(), objectArray, hashMap);
            }
            catch (Throwable throwable) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "providerChange", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40068", new Object[]{throwable.getMessage()});
                }
                return;
            }
        }
        hashMap = this.eventFilters.keySet().iterator();
        while (hashMap.hasNext()) {
            objectArray = (String)hashMap.next();
            iterator = (DataChangeFilter)this.eventFilters.get(objectArray);
            object = null;
            try {
                object = iterator.filterEvent(providerChangeEvent2);
                if (object == null) continue;
                ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager().enqueue(this.bc.getName(), object);
            }
            catch (Throwable throwable) {}
        }
        if ("create".equals(providerChangeEvent2.getOperation()) || "remove".equals(providerChangeEvent2.getOperation())) {
            hashMap = new HashMap<String, Object[]>();
            objectArray = null;
            iterator = this.eventFilters.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!this.bc.containsKey(object)) continue;
                AmxControlBinding amxControlBinding = (AmxControlBinding)this.bc.get(object);
                AmxExecutableBinding amxExecutableBinding = amxControlBinding.getExecutable();
                if (hashMap.containsKey(amxExecutableBinding.getName())) {
                    objectArray = (Object[])hashMap.get(amxExecutableBinding.getName());
                } else {
                    objectArray = amxExecutableBinding.getIterator().getKeys();
                    hashMap.put(amxExecutableBinding.getName(), objectArray);
                }
                String string = providerChangeEvent2.getProviderKey() + "_keys";
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)providerChangeEvent2.getProviderKey(), string, null, objectArray);
                DataChangeFilter dataChangeFilter = (DataChangeFilter)this.eventFilters.get(object);
                Object object2 = dataChangeFilter.filterEvent(propertyChangeEvent);
                if (!(object2 instanceof PropertyChangeEvent) || object2 == propertyChangeEvent) continue;
                ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager().enqueue(this.bc.getName(), object2);
            }
        }
    }

    public boolean hasDataChangeEventFilter(String string) {
        return this.eventFilters.containsKey(string);
    }

    public void addDataChangeEventFilter(String string, DataChangeFilter dataChangeFilter) {
        this.eventFilters.put(string, dataChangeFilter);
    }

    public void removeDataChangeEventFilter(String string) {
        this.eventFilters.remove(string);
    }

    public String getMasterId() {
        return this.masterId;
    }

    public String getId() {
        return this.id;
    }

    public BindingContainer getBindingContainer() {
        return this.bc;
    }

    public DataControl getDataControl() {
        return this.dc;
    }

    private GenericType getBaseProviderFromManager() {
        DataProviderManager dataProviderManager = ((GenericJavaBeanDataControlAdapter)this.dc).getDataProviderManager();
        Object object = dataProviderManager.getDataProvider(this.bc.getName(), this.getId());
        return (GenericType)object;
    }

    public Object getDataProvider() {
        Object object = this.getWrappedDataProvider();
        if (object instanceof ConcreteJavaBeanObject) {
            ConcreteJavaBeanObject concreteJavaBeanObject = (ConcreteJavaBeanObject)object;
            object = concreteJavaBeanObject.getInstance();
        }
        return object;
    }

    public Object getWrappedDataProvider() {
        return this.getChildProvider(this.index, this.getBaseProviderFromManager());
    }

    public void setDataProvider(Object object) {
        if (object == null || object instanceof GenericType) {
            String string;
            this.index = 0;
            DataProviderManager dataProviderManager = ((GenericJavaBeanDataControlAdapter)this.dc).getDataProviderManager();
            Object object2 = dataProviderManager.getDataProvider(string = dataProviderManager.getProviderKey(this.bc.getName(), this.id));
            if (object2 != object) {
                dataProviderManager.setDataProviderInstance(string, object != null ? object : GenericVirtualType.PLACEHOLDER_INSTANCE);
                if (this.getMasterId() != null) {
                    GenericType genericType;
                    GenericType genericType2 = (GenericType)(object != null ? object : object2);
                    GenericType genericType3 = genericType = genericType2 != null ? genericType2.getParent() : null;
                    if (genericType != null && genericType instanceof DataChangeProvider) {
                        ((DataChangeProvider)((Object)genericType)).fireProviderChange(new ProviderChangeEvent("update", this.getBinds(), null, dataProviderManager.getDataProvider(string)));
                    }
                }
                if (Utility.isEmpty(this.keyAttribute) && (object2 == null || object2 == GenericVirtualType.PLACEHOLDER_INSTANCE)) {
                    this.keyAttribute = this.findKeyAttribute();
                }
                this.providerChange(new ProviderChangeEvent("update", this.getBinds(), this.getProviderKey(object, this.getCurrentIndex()), object));
                this.refreshDetailIterators();
            }
        }
    }

    protected Object getWrappedDataProvider(String string) {
        GenericType genericType = (GenericType)this.getWrappedDataProvider();
        Object object = null;
        if (genericType != null) {
            Object object2 = object = genericType.isComplexType() ? genericType.getAttribute(string) : null;
            if (object instanceof ConcreteJavaBeanObject) {
                ((ConcreteJavaBeanObject)object).setProviderKey(string);
            }
        }
        return object;
    }

    protected Object getWrappedDataProvider(String string, String string2) {
        GenericType genericType = (GenericType)this.getWrappedDataProvider();
        if (genericType == null) {
            return null;
        }
        return genericType.isComplexType() ? genericType.getAttribute(string, string2) : null;
    }

    public Object getDataProvider(XmlAnyDefinition xmlAnyDefinition) {
        BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition = GenericJavaBeanDataControlAdapter.testIncomingIteratorMetadataDef(xmlAnyDefinition);
        if (beanBindingIteratorBaseDefinition == null) {
            return null;
        }
        return this.getWrappedDataProvider(beanBindingIteratorBaseDefinition.getBinds());
    }

    protected void refreshDetailIterators() {
        if (this.detailIterators != null) {
            Iterator iterator = this.detailIterators.iterator();
            while (iterator.hasNext()) {
                GenericTypeIteratorAdapter genericTypeIteratorAdapter = (GenericTypeIteratorAdapter)iterator.next();
                genericTypeIteratorAdapter.refresh();
            }
        }
    }

    public void refresh() {
        Object object;
        if (this.master != null && (object = this.master.getWrappedDataProvider(this.getBinds())) != this.getBaseProviderFromManager()) {
            this.setDataProvider(object);
        }
    }

    public void refresh(boolean bl) {
        Object object;
        int n = this.getCurrentIndex();
        if (this.master != null) {
            object = this.master.getWrappedDataProvider(this.getBinds());
            this.setDataProvider(object);
        }
        if (bl) {
            object = this.getChildProvider(n);
            Object object2 = this.getProviderKey(object, n);
            this.setCurrentIndexWithKey(object2);
            this.providerChange(new ProviderChangeEvent("update", this.getBinds(), object2, object));
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "refresh", "just forced a " + this.getBinds() + " with key = " + object2 + " provider change.");
            }
            this.refreshDetailIterators();
        }
    }

    public boolean hasNext() {
        boolean bl;
        int n = this.getTotalRowCount();
        boolean bl2 = bl = this.index + 1 < n;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "hasNext", "There are {0} rows after this one.", new Object[]{bl ? "" : "no "});
        }
        return bl;
    }

    public boolean hasPrevious() {
        boolean bl;
        boolean bl2 = bl = this.index > 0;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "hasPrevious", "There are {0} rows prior to this one.", new Object[]{bl ? "" : "no "});
        }
        return bl;
    }

    public void positionChanged(int n) {
    }

    public void rowInserted(Object object) {
    }

    public void rowRemoved(Object object) {
    }

    public void rangeRefreshed() {
    }

    public Object first() {
        if (this.index != 0) {
            this.setCurrentIndex(0);
        }
        return this.getDataProvider();
    }

    public Object previous() {
        if (this.hasPrevious()) {
            this.setCurrentIndex(this.index - 1);
        }
        return this.getDataProvider();
    }

    public Object[] previousSet() {
        int n;
        int n2 = n = this.getRangeSizeInternal();
        if (this.index - n < 0) {
            n2 = this.index;
        }
        this.setCurrentIndex(this.index - n2);
        return this.getChildProviders(this.index, n2);
    }

    public Object next() {
        if (this.hasNext()) {
            this.setCurrentIndex(this.index + 1);
        }
        return this.getDataProvider();
    }

    public Object[] nextSet() {
        int n;
        int n2 = this.getRangeSizeInternal();
        if (this.index + n2 >= (n = this.getTotalRowCount())) {
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "nextSet", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40065", new Object[]{new Integer(n2), new Integer(this.index), new Integer(n)});
            }
        } else {
            this.setCurrentIndex(this.index + n2);
        }
        return this.getChildProviders(this.index, n2);
    }

    public Object last() {
        this.setCurrentIndex(this.getTotalRowCount() - 1);
        return this.getDataProvider();
    }

    public Object[] currentSet() {
        return this.getChildProviders(this.index, this.getRangeSizeInternal());
    }

    public Object[] getSetAt(Object object, boolean bl) {
        int n;
        int n2 = this.getIndexFromKey(object);
        int n3 = this.getRangeSizeInternal();
        Object[] objectArray = null;
        if (bl) {
            n = n3;
            if (n2 - n3 < 0) {
                n = n2;
            }
            objectArray = this.getChildProviders(n2 - n, n);
        } else {
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                this.log(Level.FINER, "getSetAt", "getSetAt(" + object + ")  or from index=" + n2 + " to " + n3);
            }
            objectArray = this.getChildProviders(n2, n3);
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "getSetAt", "getSetAt() returning " + (objectArray == null ? 0 : objectArray.length) + " providers.");
            for (n = 0; n < objectArray.length; ++n) {
                String string;
                Object object2 = this.getProviderKey(objectArray[n], n2 + n);
                String string2 = string = object2 != null ? object2.toString() : "null";
                if (string.compareTo(this.getKey(n2 + n)) == 0) continue;
                this.log(Level.FINER, "getSetAt", "Possible error key[" + n + "]='" + this.getKey(n2 + n) + " but provider's key is " + string);
            }
        }
        return objectArray;
    }

    public int getCurrentIndex() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "getCurrentIndex", "getCurrentIndex() return {0}", new Object[]{new Integer(this.index)});
        }
        return this.index;
    }

    public GenericType getChildProvider(int n) {
        GenericType genericType = this.getBaseProviderFromManager();
        return this.getChildProvider(n, genericType);
    }

    private GenericType getChildProvider(int n, GenericType genericType) {
        Object object;
        int n2 = this.getTotalRowCount(genericType);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "getChildProvider", "Getting the child provider at index {0} of {1}", new Object[]{new Integer(n), new Integer(n2)});
        }
        if (genericType != null && genericType.getParent() != null && n2 > 0 && (object = genericType.getParent().getAttribute(this.name, n)) instanceof GenericType) {
            genericType = (GenericType)object;
        }
        return genericType;
    }

    public Map getProviderMap() {
        Object[] objectArray = this.getChildProviders(0, this.getTotalRowCount());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = ((GenericType)objectArray[i]).getDataProvider();
            hashMap.put("" + this.getProviderKey(objectArray[i], i), object instanceof ConcreteJavaBeanObject ? ((ConcreteJavaBeanObject)object).getInstance() : object);
        }
        return hashMap;
    }

    private Object[] getChildProviders(int n, int n2) {
        int n3;
        GenericType genericType = this.getBaseProviderFromManager();
        int n4 = this.getTotalRowCount(genericType);
        Object[] objectArray = null;
        int n5 = n + n2;
        int n6 = n3 = n > n4 ? 0 : n;
        if (n5 < 0 || n5 > n4) {
            n5 = n4 - n3;
        }
        objectArray = new Object[n5];
        for (int i = 0; i < n5; ++i) {
            objectArray[i] = this.getChildProvider(n3 + i, genericType);
        }
        return objectArray;
    }

    public void setCurrentIndex(int n) {
        GenericType genericType = this.getChildProvider(n);
        Object object = this.getProviderKey(genericType, n);
        if (this.index != n || this.currentKey != object) {
            this.index = n;
            this.currentKey = object;
            this.providerChange(new ProviderChangeEvent("update", this.getBinds(), object, (Object)genericType));
            this.refreshDetailIterators();
        }
    }

    public void setCurrentIndexWithKey(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : null;
        if (object == null) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11095", new Object[]{"GenericTypeIteratorAdapter:setCurrentIndexWithKey()"}));
        }
        if (this.keysToIndices.isEmpty()) {
            this.getKeys();
        }
        if (!this.keysToIndices.containsKey(string)) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11096", new Object[]{object.toString(), this.name}));
        }
        Integer n = (Integer)this.keysToIndices.get(string);
        this.setCurrentIndex(n);
    }

    public void setCurrentRowWithKey(String string) {
        this.setCurrentIndexWithKey(string);
    }

    public void setCurrentRowWithKeyValue(String string) {
        this.setCurrentIndexWithKey(string);
    }

    public int getTotalRowCount() {
        return this.getTotalRowCount((GenericType)this.getWrappedDataProvider());
    }

    private int getTotalRowCount(GenericType genericType) {
        int n = 0;
        if (genericType != null && genericType.getParent() != null) {
            n = genericType.getParent().getAttributeCount(this.name);
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "getTotalRowCount", "GTIA:: Currently on row {0} of {1} {2} rows.", new Object[]{new Integer(this.index), new Integer(n), this.name});
        }
        return n;
    }

    private int getRangeSizeInternal() {
        int n = this.getRangeSize();
        if (n < 0) {
            n = this.getTotalRowCount();
        } else if (n == 0) {
            n = 25;
        }
        return n;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public void setRangeSize(int n) {
        this.rangeSize = n;
    }

    public Object getCurrentRow() {
        return this.getWrappedDataProvider();
    }

    public Object getCurrentRowKey() {
        return this.getProviderKey(this.getWrappedDataProvider(), this.getCurrentIndex());
    }

    private String getKeyAttributeFromMetadata() {
        String string = (String)this.metadataDef.getAttributeValue("BeanClass");
        String string2 = MetaDataFrameworkManager.getInstance().getLocationFromFullyQualifiedName("persdef." + string, ".xml");
        XmlAnyDefinition xmlAnyDefinition = null;
        try {
            xmlAnyDefinition = MetaDataFrameworkManager.getInstance().getPersdefDefinitionByLocation(string2);
        }
        catch (AdfException adfException) {
            return null;
        }
        List list = xmlAnyDefinition.getChildDefinitions(PDEF_ATTRIBUTE);
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
            String string3 = (String)xmlAnyDefinition2.getAttributeValue(PDEF_NAME_ATTRIBUTE);
            if (Utility.isEmpty(string3) || null == (object = xmlAnyDefinition2.getAttributeValue(PDEF_PRIMARYKEY_ATTRIBUTE)) || !"true".equals(object)) continue;
            return string3;
        }
        return null;
    }

    private String findKeyAttribute() {
        String string = this.getKeyAttributeFromMetadata();
        if (string == null) {
            string = DEFAULT_KEY_ATTRIBUTE;
        }
        try {
            Object object;
            GenericType genericType = this.getBaseProviderFromManager();
            Object object2 = object = genericType != null ? genericType.getAttribute(string) : null;
            if (object == null) {
                AttributeInfo attributeInfo;
                AttributeInfo attributeInfo2 = attributeInfo = genericType != null ? genericType.getAttributeInfo(string) : null;
                if (attributeInfo == null) {
                    if (genericType == GenericVirtualType.PLACEHOLDER_INSTANCE) {
                        return null;
                    }
                    if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                        Trace.log(Utility.FrameworkLogger, Level.INFO, this.getClass(), "findKeyAttribute", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40064");
                    }
                    return "";
                }
            }
        }
        catch (Throwable throwable) {
            if (this.getBaseProviderFromManager() == GenericVirtualType.PLACEHOLDER_INSTANCE) {
                return null;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, this.getClass(), "findKeyAttribute", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40064");
            }
            return "";
        }
        return string;
    }

    public Object getProviderKey(Object object, int n) {
        if (this.keyAttribute == null) {
            this.keyAttribute = this.findKeyAttribute();
            if (this.keyAttribute != null) {
                return this.getProviderKey(object, n);
            }
        }
        if (!Utility.isEmpty(this.keyAttribute) && object != null) {
            return ((GenericType)object).getAttribute(this.keyAttribute);
        }
        return Integer.toString(n);
    }

    public int getIndexFromKey(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : null;
        if (object == null) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11095", new Object[]{"GenericTypeIteratorAdapter:getIndexFromKey()"}));
        }
        if (this.keysToIndices.isEmpty()) {
            this.getKeys();
        }
        if (this.keysToIndices.containsKey(string)) {
            return (Integer)this.keysToIndices.get(string);
        }
        throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11096", new Object[]{string, this.name}));
    }

    public Object getKey(int n) {
        Object[] objectArray = this.getKeys();
        return objectArray != null && n < objectArray.length ? objectArray[n] : null;
    }

    public Object[] getKeys() {
        this.keysToIndices.clear();
        Object[] objectArray = new Object[this.getTotalRowCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            GenericType genericType = this.getChildProvider(i);
            objectArray[i] = object = this.getProviderKey(genericType, i);
            this.keysToIndices.put(object.toString(), new Integer(i));
        }
        return objectArray;
    }

    private String getBinds() {
        return ((BeanBindingIteratorBaseDefinition)this.metadataDef).getBinds();
    }

    public Object createInsertRow() {
        return this.createRowWithData(null, true);
    }

    public Object createRow(boolean bl) {
        return this.createRowWithData(null, bl);
    }

    public Object createRow() {
        boolean bl = false;
        if (this.dc instanceof ConcreteJavaBeanDataControlAdapter || this.dc instanceof WebServiceDataControlAdapter) {
            bl = true;
        }
        return this.createRowWithData(null, bl);
    }

    public Object createRowWithData(Object object, boolean bl) {
        return this.createRowWithDataInternal(object, bl);
    }

    private synchronized Object createRowWithDataInternal(Object object, boolean bl) {
        Object object2;
        Object object3;
        GenericType genericType = null;
        try {
            genericType = (GenericType)this.dc.createDataProvider(this.metadataDef);
        }
        catch (AdfException adfException) {
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "createRowWithData", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40120", new Object[]{this.dc.getName()});
            }
            throw adfException;
        }
        if (object instanceof Map) {
            object3 = ((Map)object).keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                Object v = ((Map)object).get(object2);
                if (!this.isUpdateable((String)object2)) continue;
                genericType.setAttribute((String)object2, v);
            }
        } else if (object != null) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11097", new Object[]{"GenericTypeIteratorAdapter:createRowWithData()"}));
        }
        object3 = null;
        if (bl) {
            object2 = this.getBaseProviderFromManager().getParent();
            object3 = object2.insertChild(this.getBinds(), this.index, genericType);
            if (object3 != null) {
                if (object2 instanceof ConcreteJavaCollectionObject) {
                    object2 = object2.getParent();
                }
                if (object2 instanceof DataChangeProvider) {
                    ((DataChangeProvider)object2).fireProviderChange(new ProviderChangeEvent("create", this.getBinds(), this.getProviderKey(object3, this.index), object3));
                }
            } else {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "createRowWithData", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40121", new Object[]{this.dc.getName()});
                }
                object3 = genericType;
            }
        } else {
            object3 = genericType;
        }
        if (object3 instanceof ConcreteJavaBeanObject) {
            object2 = (ConcreteJavaBeanObject)object3;
            object3 = ((ConcreteJavaBeanObject)object2).getInstance();
        }
        return object3;
    }

    private synchronized Object removeRow(int n) {
        if (this.getTotalRowCount() == 0) {
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, this.getClass(), "removeRow", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40123", new Object[]{this.dc.getName()});
            }
            return null;
        }
        GenericType genericType = this.getBaseProviderFromManager().getParent();
        Object object = genericType.removeChild(this.getBinds(), n);
        if (object != null) {
            if (genericType instanceof ConcreteJavaCollectionObject) {
                genericType = genericType.getParent();
            }
            if (genericType instanceof DataChangeProvider) {
                ((DataChangeProvider)((Object)genericType)).fireProviderChange(new ProviderChangeEvent("remove", this.getBinds(), this.getProviderKey(object, n), object));
            }
            if (n == this.getTotalRowCount() && n != 0) {
                this.setCurrentIndex(n - 1);
            }
        } else if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, this.getClass(), "removeRow", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40122", new Object[]{this.dc.getName()});
        }
        if (object instanceof ConcreteJavaBeanObject) {
            ConcreteJavaBeanObject concreteJavaBeanObject = (ConcreteJavaBeanObject)object;
            object = concreteJavaBeanObject.getInstance();
        }
        return object;
    }

    public Object removeCurrentRow() {
        return this.removeRow(this.index);
    }

    public Object removeRowWithKey(String string) {
        int n = this.getIndexFromKey(string);
        return this.removeRow(n);
    }

    public Class getAttributeType(String string) {
        return this.getBaseProviderFromManager().getAttributeType(string);
    }

    public boolean isUpdateable(String string) {
        return this.getBaseProviderFromManager().isUpdateable(string);
    }

    public Object getExtendedAttributeInfo(Object object, String string) {
        return null;
    }

    public Object getAttributeValue(String string) {
        GenericType genericType;
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            this.log(Level.FINER, "getAttributeValue", "getAttribute({0})", new Object[]{string});
        }
        return (genericType = (GenericType)this.getWrappedDataProvider()) != null ? genericType.getAttribute(string) : null;
    }

    public void setAttributeValue(String string, Object object) {
        GenericType genericType = (GenericType)this.getWrappedDataProvider();
        if (genericType != null) {
            genericType.setAttribute(string, object);
            this.providerChange(new ProviderChangeEvent("update", string, this.getProviderKey(genericType, this.getCurrentIndex()), this.getAttributeValue(string)));
        } else {
            this.log(Level.INFO, "setAttributeValue", "Attribute {0} was not set, current provider is null", new Object[]{string});
        }
    }

    public Object getAttributeValueAtIndex(int n, String string) {
        GenericType genericType = this.getChildProvider(n);
        return genericType != null ? genericType.getAttribute(string) : null;
    }

    public Object[] getCurrentValues() {
        return new Object[0];
    }
}

