/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import com.sun.util.logging.Level;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.DateParseException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class DateParser {
    public static final Class CLASS_INSTANCE = DateParser.class;
    private static Hashtable HASH_LONG_MONTHS = new Hashtable();
    private static Hashtable HASH_LONG_DAYSOFWEEK;
    private static Hashtable HASH_STANDARD_FORMATS;
    private static Hashtable HASH_SHORT_DAYSOFWEEK;
    private static Hashtable HASH_SHORT_MONTHS;
    private static Hashtable HASH_TIMEZONE_FORMATS;
    private static final String STR_LONG_DATE_FORMAT = "dddd, MMMM dd, yyyy";
    private static final String STR_SHORT_DATE_FORMAT = "M/d/yyyy";
    private static final String STR_SHORT_TIME_FORMAT = "h:mm tt";
    private static final String STR_LONG_TIME_FORMAT = "h:mm:ss tt";
    private static final int DEFAULT_YEAR = 1970;
    private static final int DEFAULT_MONTH = 1;
    private static final int DEFAULT_DAY = 1;
    private static final int ARG_YEAR = 0;
    private static final int ARG_MONTH = 1;
    private static final int ARG_DAY = 2;
    private static final int ARG_HOUR = 3;
    private static final int ARG_MINUTE = 4;
    private static final int ARG_SECOND = 5;
    private static final int ARG_MILLISECOND = 6;
    private static final int ARG_TOTAL = 7;
    private static final long MILLISECONDS_PER_HOUR = 3600000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;

    private static boolean handleOverflow(int[] nArray, int n, int n2, int n3) {
        boolean bl = false;
        while (nArray[n2] >= n) {
            int n4 = n2;
            nArray[n4] = nArray[n4] - n;
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
            bl = true;
        }
        return bl;
    }

    private static void makeValidDateTime(int[] nArray) {
        DateParser.handleOverflow(nArray, 1000, 6, 5);
        DateParser.handleOverflow(nArray, 60, 5, 4);
        DateParser.handleOverflow(nArray, 60, 4, 3);
        DateParser.handleOverflow(nArray, 24, 3, 2);
        boolean bl = true;
        while (bl) {
            bl = DateParser.handleOverflow(nArray, 12, 1, 0);
            int n = DateParser.DaysInMonth(nArray[0], nArray[1] + 1);
            if (nArray[2] <= n) continue;
            nArray[2] = nArray[2] - n;
            nArray[1] = nArray[1] + 1;
            bl = true;
        }
    }

    private static void makeFirstDoW(int[] nArray, int n, boolean bl) {
        Calendar calendar = DateParser.makeCalendar(nArray[0], nArray[1] + 1, nArray[2]);
        int n2 = calendar.get(7);
        if (n2 == n) {
            return;
        }
        int n3 = n2 - n;
        int n4 = nArray[1];
        nArray[2] = nArray[2] - n3;
        if (nArray[2] < 1) {
            nArray[1] = nArray[1] - 1;
            if (nArray[1] < 0) {
                nArray[1] = 11;
                nArray[0] = nArray[0] - 1;
            }
            int n5 = DateParser.DaysInMonth(nArray[0], nArray[1] + 1);
            nArray[2] = nArray[2] + n5;
        }
        if (bl && n4 != nArray[1]) {
            nArray[2] = nArray[2] + 7;
        }
    }

    private static void makeDayOfWeek(int[] nArray, int n) {
        DateParser.makeFirstDoW(nArray, n, true);
    }

    private static void makeWeekInYear(int[] nArray, int n, boolean bl) {
        DateParser.makeFirstDoW(nArray, 1, bl);
        if (n > 0) {
            nArray[2] = nArray[2] + (n - 1) * 7;
        }
    }

    private static boolean is_valid_datetime(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        if (n < 1 || n > 9999 || n2 < 1 || n2 > 12 || n3 < 1 || n3 > DateParser.DaysInMonth(n, n2) || n4 < 0 || n4 > 23 || n5 < 0 || n5 > 59 || n6 < 0 || n6 > 59) {
            bl = false;
        }
        return bl;
    }

    private static boolean IsLeapYear(int n) {
        if (n % 4 != 0) {
            return false;
        }
        if (n % 100 == 0) {
            return n % 400 == 0;
        }
        return true;
    }

    private static int[] reset_mdays(int n) {
        int n2 = 28;
        if (DateParser.IsLeapYear(n)) {
            // empty if block
        }
        int[] nArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        nArray[1] = ++n2;
        return nArray;
    }

    private static int DaysInMonth(int n, int n2) {
        if (n2 < 1 || n2 > 12) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "DaysInMonth", "month not valid: month {0}; year {1}", new Object[]{new Integer(n2), new Integer(n)});
            }
            throw new DateParseException();
        }
        int[] nArray = DateParser.reset_mdays(n);
        return nArray[n2 - 1];
    }

    private static void validate_date(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!DateParser.is_valid_datetime(n, n2, n3, n4, n5, n6) || n7 < 0 || n7 > 9999) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "validate_date", "new Object[] { new Integer(xmonth), new Integer(xyear) }", new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
            }
            throw new DateParseException();
        }
    }

    private static Calendar InitCal(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        Calendar calendar = Utility.isEmpty(string) ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string));
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, n7);
        return calendar;
    }

    private static Calendar makeCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        DateParser.validate_date(n, n2, n3, n4, n5, n6, n7);
        return DateParser.InitCal(n, n2, n3, n4, n5, n6, n7, string);
    }

    private static Calendar makeCalendar(int n, int n2, int n3) {
        DateParser.validate_date(n, n2, n3, 0, 0, 0, 0);
        return DateParser.InitCal(n, n2, n3, 0, 0, 0, 0, null);
    }

    private static Calendar subtract(Calendar calendar, long l) {
        Date date = calendar.getTime();
        long l2 = date.getTime();
        date.setTime(l2 - l);
        calendar.setTime(date);
        return calendar;
    }

    private static Calendar getNow() {
        return Calendar.getInstance();
    }

    private static int getDay(Calendar calendar) {
        return calendar.get(5);
    }

    private static int getMonth(Calendar calendar) {
        return calendar.get(2) + 1;
    }

    private static int getYear(Calendar calendar) {
        return calendar.get(1);
    }

    private static boolean startsWithToken(String string, String string2) {
        return string != null && string.startsWith(string2);
    }

    public static boolean isDateToken(char c) {
        switch (c) {
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'M': 
            case 'W': 
            case 'd': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeToken(char c) {
        switch (c) {
            case 'H': 
            case 'K': 
            case 'N': 
            case 'S': 
            case 'Z': 
            case 'a': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeToken(char c) {
        return DateParser.isDateToken(c) || DateParser.isTimeToken(c);
    }

    public static boolean hasDateTokens(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!DateParser.isDateToken(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasTimeTokens(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!DateParser.isTimeToken(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static void validateToken(char c) {
        switch (c) {
            case 'A': 
            case 'B': 
            case 'C': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'U': 
            case 'V': 
            case 'X': 
            case 'Y': 
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'i': 
            case 'j': 
            case 'l': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'x': {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "validateToken", "Invalid format token: {0}", new Object[]{new Character(c)});
                }
                throw new DateParseException();
            }
        }
    }

    private static int safeParseInt(String string) {
        if (!DateParser.isStringNumeric(string)) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseInt", "value not numeric: {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseInt", "value not numeric: {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
        catch (Error error) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseInt", "value not numeric: {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
    }

    private static int safeParseInt(String string, int n, int n2) {
        return DateParser.safeParseInt(string);
    }

    private static int parseNamedMonth(String string) {
        if (string == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseNamedMonth", (Object)"value must not be null");
            }
            throw new DateParseException();
        }
        if (HASH_SHORT_MONTHS.containsKey(string.toLowerCase())) {
            return (Integer)HASH_SHORT_MONTHS.get(string.toLowerCase());
        }
        if (HASH_LONG_MONTHS.containsKey(string.toLowerCase())) {
            return (Integer)HASH_LONG_MONTHS.get(string.toLowerCase());
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseNamedMonth", "value not found: {0}", new Object[]{string});
        }
        throw new DateParseException();
    }

    private static int parseNamedDayOfWeek(String string) {
        if (string == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseNamedDayOfWeek", (Object)"value must not be null");
            }
            throw new DateParseException();
        }
        if (HASH_SHORT_DAYSOFWEEK.containsKey(string.toLowerCase())) {
            return (Integer)HASH_SHORT_DAYSOFWEEK.get(string.toLowerCase());
        }
        if (HASH_LONG_DAYSOFWEEK.containsKey(string.toLowerCase())) {
            return (Integer)HASH_LONG_DAYSOFWEEK.get(string.toLowerCase());
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseNamedDayOfWeek", "value not found: {0}", new Object[]{string});
        }
        throw new DateParseException();
    }

    private static void validateEra(String string) {
        if (string == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "validateEra", (Object)"value must not be null");
            }
            throw new DateParseException();
        }
        if (string.equalsIgnoreCase("ad")) {
            return;
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "validateEra", "value not found: {0}", new Object[]{string});
        }
        throw new DateParseException();
    }

    private static int adjustHourForAMPM(int n, String string) {
        if (n > 12 || string == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "adjustHourForAMPM", "Invalid state: hour {0}; ampm {1}", new Object[]{new Integer(n), string});
            }
            throw new DateParseException();
        }
        if (string.equalsIgnoreCase("am") || string.equalsIgnoreCase("a")) {
            if (n == 12) {
                n = 0;
            }
        } else if (string.equalsIgnoreCase("pm") || string.equalsIgnoreCase("p")) {
            if (n < 12 && n >= 0) {
                n += 12;
            }
        } else {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "adjustHourForAMPM", "Invalid state: hour {0}; ampm {1}", new Object[]{new Integer(n), string});
            }
            throw new DateParseException();
        }
        return n;
    }

    private static boolean validDayOfWeek(int n, int n2, int n3, int n4) {
        Calendar calendar = DateParser.makeCalendar(n2, n3, n4);
        int n5 = calendar.get(7) - 1;
        return n5 == n;
    }

    private static void parseSpecString(String string, Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecString", "specTokens and specDelimiters must not be null: specTokens={0}; specDelimiters={1}", new Object[]{vector, vector2});
            }
            throw new DateParseException();
        }
        vector.removeAllElements();
        vector2.removeAllElements();
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = Character.isLowerCase(cArray[0]) || Character.isUpperCase(cArray[0]) ? 97 : (Character.isDigit(cArray[0]) || cArray[0] == '-' ? 110 : 100);
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isLowerCase(cArray[i]) || Character.isUpperCase(cArray[i])) {
                if (n != 97 && stringBuffer.length() > 0) {
                    if (n == 100) {
                        vector2.addElement(stringBuffer.toString());
                    } else if (n == 110) {
                        vector.addElement(stringBuffer.toString());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n = 97;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (Character.isDigit(cArray[i])) {
                if (stringBuffer.length() > 0 && n != 110) {
                    if (n == 100 || stringBuffer.toString().equals("T")) {
                        vector2.addElement(stringBuffer.toString());
                    } else if (n == 97) {
                        vector.addElement(stringBuffer.toString());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n = 110;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '/' || cArray[i] == ':' || cArray[i] == ' ' || cArray[i] == ',' || cArray[i] == '.') {
                if (stringBuffer.length() > 0 && n != 100) {
                    if (n == 110 || n == 97) {
                        vector.addElement(stringBuffer.toString());
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n = 100;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (cArray[i] == '-' || cArray[i] == '+') {
                if (n == 100) {
                    if (stringBuffer.length() > 0) {
                        vector2.addElement(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    n = 110;
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                if (n != 110 && n != 97) continue;
                if (stringBuffer.length() > 0) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                }
                n = 100;
                if (i <= 0) continue;
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (n != 100 && stringBuffer.length() > 0) {
                vector.addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            n = 100;
        }
        if (stringBuffer.length() > 0) {
            if (n == 100) {
                vector2.addElement(stringBuffer.toString());
            } else if (n == 97 || n == 110) {
                vector.addElement(stringBuffer.toString());
            }
        }
    }

    private static boolean isStringNumeric(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '-' || Character.isDigit(cArray[i])) continue;
            return false;
        }
        return true;
    }

    private static void parseFormatString(String string, Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseFormatString", "formatTokens and formatDelimiters must not be null: formatTokens={0}; formatDelimiters={1}", new Object[]{vector, vector2});
            }
            throw new DateParseException();
        }
        vector.removeAllElements();
        vector2.removeAllElements();
        if (string == null || string.length() < 1) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = Character.isLowerCase(cArray[0]) || Character.isUpperCase(cArray[0]) ? 116 : (cArray[0] == '\\' ? 101 : 100);
        StringBuffer stringBuffer = new StringBuffer(50);
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case 'H': 
                case 'M': 
                case 'd': 
                case 'h': 
                case 'm': 
                case 's': 
                case 't': 
                case 'y': {
                    if (n == 100) {
                        vector2.addElement(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        n = 116;
                    } else if (n == 101) {
                        n = 100;
                    }
                    stringBuffer.append(cArray[i]);
                    continue block4;
                }
                case '\\': {
                    if (n == 116) {
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    n = 101;
                    continue block4;
                }
                default: {
                    if (n == 116) {
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    n = 100;
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (n == 100) {
            vector2.addElement(stringBuffer.toString());
        } else if (n == 116) {
            vector.addElement(stringBuffer.toString());
        }
    }

    private static boolean areCharsInOrder(String string, String string2) {
        if (string2 == null || string2.length() < 1) {
            return true;
        }
        if (string == null || string.length() < 1) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < string2.length(); ++i) {
            n = string.indexOf(string2.charAt(i), n);
            if (n < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static String determineClosestMatchingFormat(String string) {
        int n;
        if (string == null || string.length() < 1) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        boolean bl = false;
        if ((string = string.trim()).endsWith("GMT")) {
            return (String)HASH_STANDARD_FORMATS.get(new Character('R'));
        }
        DateParser.parseSpecString(string, vector, vector2);
        if (string.endsWith("Z")) {
            if (vector.size() >= 2 && DateParser.isStringNumeric((String)vector.elementAt(0)) && ((String)vector.elementAt(0)).length() == 2) {
                if (((String)vector.elementAt(1)).length() < 3) {
                    return "MM-dd-yyyy HH:mm:ssZ";
                }
                return "MM-yyyy-dd HH:mm:ssZ";
            }
            return (String)HASH_STANDARD_FORMATS.get(new Character('u'));
        }
        Object object = HASH_STANDARD_FORMATS.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            DateParser.parseFormatString(string2, vector3, vector4);
            if (vector4.size() != vector2.size()) continue;
            bl = false;
            for (n = 0; n < vector4.size(); ++n) {
                String string3;
                String string4 = (String)vector4.elementAt(n);
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if ((string3 = (String)vector2.elementAt(n)) != null) {
                    string3 = string3.trim();
                }
                if (!string4.equalsIgnoreCase(string3)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            return string2;
        }
        object = new StringBuffer();
        for (n = 0; n < vector2.size(); ++n) {
            ((StringBuffer)object).append((String)vector2.elementAt(n));
        }
        String string5 = ((StringBuffer)object).toString();
        if (DateParser.areCharsInOrder(string5, "--T::.-:") || DateParser.areCharsInOrder(string5, "--T::.+:")) {
            return "yyyy-MM-ddTHH:mm:ss.fzzz";
        }
        if (DateParser.areCharsInOrder(string5, "--T::.")) {
            return "yyyy-MM-ddTHH:mm:ss.f";
        }
        if (DateParser.areCharsInOrder(string5, "--T::")) {
            return "yyyy-MM-ddTHH:mm:ss";
        }
        if (DateParser.areCharsInOrder(string5, "::")) {
            return "HH:mm:ss";
        }
        return null;
    }

    private static String extractSpecToken(String string, String string2, int n, int[] nArray, boolean bl) {
        nArray[0] = n;
        if (string == null || string2 == null || n >= string.length() || n < 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        if ("int".equals(string2)) {
            for (n2 = n; n2 < string.length(); ++n2) {
                char c = cArray[n2];
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                if (bl && ('-' == c || '+' == c || ' ' == c)) {
                    continue;
                }
                break;
            }
        } else if ("float".equals(string2) || "double".equals(string2)) {
            char c;
            for (n2 = n; n2 < string.length() && (Character.isDigit(c = cArray[n2]) || '.' == c); ++n2) {
                stringBuffer.append(c);
            }
        } else if ("string".equals(string2)) {
            for (n2 = n; n2 < string.length(); ++n2) {
                char c = cArray[n2];
                if (Character.isUpperCase(c) || Character.isLowerCase(c)) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                if (' ' == c && bl) {
                    continue;
                }
                break;
            }
        } else if ("tz".equals(string2)) {
            for (n2 = n; n2 < string.length(); ++n2) {
                char c = cArray[n2];
                if ('-' == c || '+' == c || ':' == c || Character.isDigit(c) || Character.isUpperCase(c) || Character.isLowerCase(c)) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                if (' ' == c && bl) {
                    continue;
                }
                break;
            }
        } else if (bl) {
            int n3 = string.indexOf(string2, n);
            if (n3 >= 0) {
                stringBuffer.append(string.substring(n3, n3 + string2.length()));
                n2 = n3 + string2.length();
            } else {
                stringBuffer.setLength(0);
            }
        } else if (string2.length() <= string.length() - n) {
            stringBuffer.append(string.substring(n, n + string2.length()));
            n2 = n + string2.length();
            if (!stringBuffer.toString().equals(string2)) {
                stringBuffer.delete(0, stringBuffer.length());
            }
        }
        nArray[0] = n2;
        if (stringBuffer.length() < 1) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static String extractParallelSpecToken(String string, String string2, int n, int[] nArray, boolean bl, boolean bl2) {
        if (bl) {
            return DateParser.extractSpecToken(string, string2, n, nArray, bl2);
        }
        if (DateParser.startsWithToken(string2, "y")) {
            String string3 = DateParser.extractSpecToken(string, "int", n, nArray, bl2);
            if (bl2 && (string3 == null || string3.length() < 1)) {
                string3 = Integer.toString(DateParser.getYear(DateParser.getNow()));
            }
            return string3;
        }
        if ("M".equals(string2) || "MM".equals(string2)) {
            String string4 = DateParser.extractSpecToken(string, "int", n, nArray, bl2);
            if (bl2 && (string4 == null || string4.length() < 1)) {
                string4 = Integer.toString(DateParser.getMonth(DateParser.getNow()));
            }
            return string4;
        }
        if (DateParser.startsWithToken(string2, "d") || DateParser.startsWithToken(string2, "D")) {
            String string5 = DateParser.extractSpecToken(string, "int", n, nArray, bl2);
            if (bl2 && (string5 == null || string5.length() < 1)) {
                string5 = Integer.toString(DateParser.getDay(DateParser.getNow()));
            }
            return string5;
        }
        if (DateParser.startsWithToken(string2, "m") || DateParser.startsWithToken(string2, "H") || DateParser.startsWithToken(string2, "s") || DateParser.startsWithToken(string2, "h") || DateParser.startsWithToken(string2, "K") || DateParser.startsWithToken(string2, "k") || DateParser.startsWithToken(string2, "S") || DateParser.startsWithToken(string2, "w") || DateParser.startsWithToken(string2, "W") || DateParser.startsWithToken(string2, "F") || DateParser.startsWithToken(string2, "N")) {
            return DateParser.extractSpecToken(string, "int", n, nArray, bl2);
        }
        if (DateParser.startsWithToken(string2, "MMM") || DateParser.startsWithToken(string2, "a") || DateParser.startsWithToken(string2, "E") || DateParser.startsWithToken(string2, "G") || "g".equals(string2) || "gg".equals(string2)) {
            return DateParser.extractSpecToken(string, "string", n, nArray, bl2);
        }
        if (DateParser.startsWithToken(string2, "Z") || DateParser.startsWithToken(string2, "z")) {
            return DateParser.extractSpecToken(string, "tz", n, nArray, bl2);
        }
        return DateParser.extractSpecToken(string, string2, n, nArray, bl2);
    }

    private static Calendar parseSpecViaFormat(String[] stringArray, String[] stringArray2, boolean bl) {
        if (stringArray.length != stringArray2.length && Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "token array lengths not equal: specTokenArray.length {0}; formatTokenArray.length {1}", new Object[]{new Integer(stringArray.length), new Integer(stringArray2.length)});
            throw new DateParseException();
        }
        int n = 1970;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        int n13 = 0;
        int n14 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            String string4 = stringArray[i];
            if (DateParser.startsWithToken(string3, "y")) {
                n = DateParser.safeParseInt(string4, string3.length(), 2);
                n9 = string4.length();
                n10 = string3.length();
                continue;
            }
            if (DateParser.startsWithToken(string3, "d") || DateParser.startsWithToken(string3, "D")) {
                n3 = DateParser.safeParseInt(string4, string3.length(), 2);
                n12 = string4.length();
                bl2 = DateParser.startsWithToken(string3, "D");
                continue;
            }
            if (DateParser.startsWithToken(string3, "w") || DateParser.startsWithToken(string3, "W") || DateParser.startsWithToken(string3, "F")) {
                n13 = DateParser.safeParseInt(string4, string3.length(), 2);
                n14 = string4.length();
                bl3 = DateParser.startsWithToken(string3, "W");
                bl4 = DateParser.startsWithToken(string3, "F");
                continue;
            }
            if (DateParser.startsWithToken(string3, "G")) {
                DateParser.validateEra(string4);
                continue;
            }
            if (DateParser.startsWithToken(string3, "E")) {
                n8 = DateParser.parseNamedDayOfWeek(string4);
                continue;
            }
            if (DateParser.startsWithToken(string3, "m")) {
                n5 = DateParser.safeParseInt(string4, string3.length(), 2);
                continue;
            }
            if (DateParser.startsWithToken(string3, "a")) {
                string = string4;
                continue;
            }
            if (DateParser.startsWithToken(string3, "s")) {
                n6 = DateParser.safeParseInt(string4, string3.length(), 2);
                continue;
            }
            if (DateParser.startsWithToken(string3, "h") || DateParser.startsWithToken(string3, "H") || DateParser.startsWithToken(string3, "k") || DateParser.startsWithToken(string3, "K")) {
                n4 = DateParser.safeParseInt(string4, string3.length(), 2);
                continue;
            }
            if ("M".equals(string3) || "MM".equals(string3)) {
                n2 = DateParser.safeParseInt(string4, string3.length(), 2) - 1;
                n11 = string4.length();
                continue;
            }
            if (DateParser.startsWithToken(string3, "MMM")) {
                n2 = DateParser.parseNamedMonth(string4);
                n11 = string4.length();
                continue;
            }
            if (DateParser.startsWithToken(string3, "S")) {
                n7 = (int)DateParser.safeParseMillisecond(string4);
                continue;
            }
            if (DateParser.startsWithToken(string3, "N")) {
                n7 = (int)DateParser.safeParseNanosecondAsMillisecond(string4);
                continue;
            }
            if (DateParser.startsWithToken(string3, "Z") || DateParser.startsWithToken(string3, "z")) {
                string2 = DateParser.parseTimeZoneIdentifier(string4);
                continue;
            }
            if (bl) continue;
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10023", new Object[]{string3});
        }
        if ((n10 == 1 || n10 == 2) && n9 == 2) {
            n = DateParser.prependCentury(n);
        }
        if (n11 > 0 && n12 < 1) {
            n3 = 1;
        }
        if (bl2) {
            n2 = 0;
        }
        if (string != null) {
            n4 = DateParser.adjustHourForAMPM(n4, string);
        }
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6, n7};
        if (n12 == 0) {
            if (n14 > 0) {
                if (bl3 || bl4 || n11 == 0) {
                    DateParser.makeValidDateTime(nArray);
                    DateParser.makeWeekInYear(nArray, n13, bl4);
                }
            } else if (n8 > 0) {
                DateParser.makeValidDateTime(nArray);
                DateParser.makeDayOfWeek(nArray, n8);
            }
        }
        DateParser.makeValidDateTime(nArray);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        n5 = nArray[4];
        n6 = nArray[5];
        n7 = nArray[6];
        if (!DateParser.is_valid_datetime(n, n2 + 1, n3, n4, n5, n6)) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format exception, invalid date: year {0}, month {1}; day {2}; hour {3}; minute {4}; second {5}", new Object[]{new Integer(n), new Integer(n2 + 1), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
            }
            throw new DateParseException();
        }
        Calendar calendar = DateParser.makeCalendar(n, n2 + 1, n3, n4, n5, n6, n7, string2);
        return calendar;
    }

    public static String parseTimeZoneIdentifier(String string) {
        if (Utility.isEmpty(string)) {
            return "";
        }
        String string2 = string.toLowerCase();
        if (HASH_TIMEZONE_FORMATS.containsKey(string2)) {
            return (String)HASH_TIMEZONE_FORMATS.get(string2);
        }
        if (string.startsWith("GMT")) {
            int n;
            int n2;
            int n3;
            if (string.length() == 3) {
                return string;
            }
            char[] cArray = string.toCharArray();
            int n4 = string.indexOf(58);
            boolean bl = false;
            String string3 = null;
            String string4 = null;
            boolean bl2 = true;
            int n5 = 3;
            if (n5 < cArray.length) {
                if (cArray[n5] == '+') {
                    ++n5;
                } else if (cArray[n5] == '-') {
                    bl = true;
                    ++n5;
                } else {
                    bl2 = false;
                }
            }
            if (bl2 && n5 < cArray.length) {
                n3 = -1;
                n2 = 2;
                if (n4 != -1) {
                    n = n4 - n5;
                    int n6 = cArray.length - n5;
                    if (n == 2 && n6 == 5 && Character.isDigit(cArray[n5]) && Character.isDigit(cArray[n5 + 1])) {
                        n3 = n5;
                        n5 += 3;
                    } else if (n == 1 && n6 == 4 && Character.isDigit(cArray[n5])) {
                        n3 = n5;
                        n2 = 1;
                        n5 += 2;
                    }
                }
                if (n3 != -1) {
                    string3 = string.substring(n3, n3 + n2);
                    n = DateParser.safeParseInt(string3);
                    if (n < 0 || n > 23) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (bl2 && n5 < cArray.length) {
                n3 = -1;
                n2 = cArray.length - n5;
                if (n2 == 2 && Character.isDigit(cArray[n5]) && Character.isDigit(cArray[n5 + 1])) {
                    n3 = n5;
                }
                if (n3 != -1) {
                    string4 = string.substring(n3, n3 + 2);
                    n = DateParser.safeParseInt(string4);
                    if (n < 0 || n > 59) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (bl2) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("GMT");
                if (string3 != null) {
                    stringBuffer.append(bl ? (char)'-' : '+');
                    if (string3.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string3);
                    if (string4 != null) {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append("00");
                    }
                }
                return stringBuffer.toString();
            }
        } else {
            char[] cArray = string.toCharArray();
            if (cArray.length == 5 && (cArray[0] == '-' || cArray[0] == '+') && Character.isDigit(cArray[1]) && Character.isDigit(cArray[2]) && Character.isDigit(cArray[3]) && Character.isDigit(cArray[4])) {
                return "GMT" + string;
            }
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseTimeZoneIdentifier", "Format exception, invalid offset {0}", new Object[]{string});
        }
        throw new DateParseException();
    }

    private static double safeParseFractionalSecond(String string) {
        try {
            string = "0." + string;
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseFractionalSecond", "Error parsing double: value {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
    }

    private static double safeParseNanosecondAsMillisecond(String string) {
        try {
            return Double.valueOf(string) / 1000000.0;
        }
        catch (NumberFormatException numberFormatException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseNanosecondAsMillisecond", "Error parsing double: value {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
    }

    private static double safeParseMillisecond(String string) {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "safeParseMillisecond", "Error parsing double: value {0}", new Object[]{string});
            }
            throw new DateParseException();
        }
    }

    private static int prependCentury(int n) {
        int n2;
        int n3 = DateParser.getYear(DateParser.getNow());
        int n4 = n3 - (n2 = n3 / 100 * 100);
        n = n < n4 + 20 ? (n += n2) : (n += n2 - 100);
        return n;
    }

    private static Calendar parseSpecViaLooseFormat(String[] stringArray, String[] stringArray2) {
        int n = 1970;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        int n13 = 0;
        int n14 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray2.length && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            if (DateParser.startsWithToken(string4, "y")) {
                n = DateParser.safeParseInt(string3);
                n9 = string3.length();
                n10 = string4.length();
                continue;
            }
            if (DateParser.startsWithToken(string4, "d") || DateParser.startsWithToken(string4, "D")) {
                n3 = DateParser.safeParseInt(string3, string4.length(), 2);
                n12 = string3.length();
                bl = DateParser.startsWithToken(string4, "D");
                continue;
            }
            if (DateParser.startsWithToken(string4, "w") || DateParser.startsWithToken(string4, "W") || DateParser.startsWithToken(string4, "F")) {
                n13 = DateParser.safeParseInt(string3, string4.length(), 2);
                n14 = string3.length();
                bl2 = DateParser.startsWithToken(string4, "W");
                bl3 = DateParser.startsWithToken(string4, "F");
                continue;
            }
            if (DateParser.startsWithToken(string4, "G")) {
                DateParser.validateEra(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "E")) {
                n8 = DateParser.parseNamedDayOfWeek(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "m")) {
                n5 = DateParser.safeParseInt(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "a")) {
                string = string3;
                continue;
            }
            if (DateParser.startsWithToken(string4, "s")) {
                int n15 = string3.indexOf(46);
                if (n15 >= 0) {
                    n6 = DateParser.safeParseInt(string3.substring(0, n15));
                    n7 += (int)(DateParser.safeParseFractionalSecond(string3.substring(n15 + 1)) * 1000.0);
                    continue;
                }
                n6 = DateParser.safeParseInt(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "S")) {
                n7 += (int)DateParser.safeParseMillisecond(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "S")) {
                n7 += (int)DateParser.safeParseNanosecondAsMillisecond(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "Z") || DateParser.startsWithToken(string4, "z")) {
                string2 = DateParser.parseTimeZoneIdentifier(string3);
                continue;
            }
            if (DateParser.startsWithToken(string4, "h") || DateParser.startsWithToken(string4, "H") || DateParser.startsWithToken(string4, "k") || DateParser.startsWithToken(string4, "K")) {
                n4 = DateParser.safeParseInt(string3);
                continue;
            }
            if ("M".equals(string4) || "MM".equals(string4)) {
                n2 = DateParser.safeParseInt(string3) - 1;
                n11 = string3.length();
                continue;
            }
            if (DateParser.startsWithToken(string4, "MMM")) {
                n2 = DateParser.parseNamedMonth(string3);
                n11 = string3.length();
                continue;
            }
            if (string4.equals(string3)) continue;
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaLooseFormat", "Format exception, tokens are not equal: fToken {0}; sToken {1}", new Object[]{string4, string3});
            }
            throw new DateParseException();
        }
        if ((n10 == 1 || n10 == 2) && n9 == 2) {
            n = DateParser.prependCentury(n);
        }
        if (n9 > 0 && n11 > 0 && n12 == 0) {
            n3 = 1;
        }
        if (bl) {
            n2 = 0;
        }
        if (string != null) {
            n4 = DateParser.adjustHourForAMPM(n4, string);
        }
        if (n11 > 2 || n12 > 2) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaLooseFormat", "Format exception, month and/or day length &gt; 2: monthLength {0}; dayLength {1}", new Object[]{new Integer(n11), new Integer(n12)});
            }
            throw new DateParseException();
        }
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6, n7};
        if (n12 == 0) {
            if (n14 > 0) {
                if (bl2 || bl3 || n11 == 0) {
                    DateParser.makeValidDateTime(nArray);
                    DateParser.makeWeekInYear(nArray, n13, bl3);
                }
            } else if (n8 > 0) {
                DateParser.makeValidDateTime(nArray);
                DateParser.makeDayOfWeek(nArray, n8);
            }
        }
        DateParser.makeValidDateTime(nArray);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        n5 = nArray[4];
        n6 = nArray[5];
        n7 = nArray[6];
        if (!DateParser.is_valid_datetime(n, n2 + 1, n3, n4, n5, n6)) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaLooseFormat", "Format exception, invalid date: year {0}, month {1}; day {2}; hour {3}; minute {4}; second {5}", new Object[]{new Integer(n), new Integer(n2 + 1), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
            }
            throw new DateParseException();
        }
        Calendar calendar = DateParser.makeCalendar(n, n2 + 1, n3, n4, n5, n6, n7, string2);
        return calendar;
    }

    private static Calendar parseSpecViaFormat(String string, String string2, boolean bl) {
        Object[] objectArray;
        String string3;
        Object[] objectArray2;
        if (Utility.isEmpty(string2) || Utility.isEmpty(string)) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "formatString and specString must not be empty: formatString={0}; specString={1}", new Object[]{string2, string});
            }
            throw new DateParseException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        char[] cArray = string2.toCharArray();
        boolean bl3 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (bl3) {
                if (n >= string.length()) {
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                    }
                    throw new DateParseException();
                }
                objectArray2 = new int[]{n2};
                string3 = DateParser.extractParallelSpecToken(string, stringBuffer.toString(), n, objectArray2, true, !bl);
                if (string3 == null) {
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                    }
                    throw new DateParseException();
                }
                n = n2 = objectArray2[0];
                stringBuffer.delete(0, stringBuffer.length());
                bl3 = false;
            }
            char c = cArray[i];
            if (!bl2) {
                DateParser.validateToken(c);
            }
            if (c == '\\') {
                if (bl2) {
                    stringBuffer.append(c);
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (stringBuffer.length() > 0 && c != stringBuffer.charAt(stringBuffer.length() - 1)) {
                vector2.addElement(stringBuffer.toString());
                if (n >= string.length()) {
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                    }
                    throw new DateParseException();
                }
                objectArray2 = new int[]{n2};
                string3 = DateParser.extractParallelSpecToken(string, stringBuffer.toString(), n, objectArray2, false, !bl);
                n2 = objectArray2[0];
                vector.addElement(string3);
                n = n2;
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(c);
                if (bl2) {
                    bl3 = true;
                }
                bl2 = false;
                continue;
            }
            stringBuffer.append(c);
            bl2 = false;
        }
        if (bl3) {
            if (n >= string.length()) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                }
                throw new DateParseException();
            }
            objectArray = new int[]{n2};
            string3 = DateParser.extractParallelSpecToken(string, stringBuffer.toString(), n, objectArray, true, !bl);
            if (string3 == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                }
                throw new DateParseException();
            }
            n = n2 = objectArray[0];
            stringBuffer.delete(0, stringBuffer.length());
            bl3 = false;
        } else {
            vector2.addElement(stringBuffer.toString());
            objectArray = new int[]{n2};
            string3 = DateParser.extractParallelSpecToken(string, stringBuffer.toString(), n, objectArray, false, !bl);
            n2 = objectArray[0];
            if (n2 < string.length() && bl) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseSpecViaFormat", "Format Exception: formatString={0}; specString={1}", new Object[]{string2, string});
                }
                throw new DateParseException();
            }
            vector.addElement(string3);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        if (bl) {
            return DateParser.parseSpecViaFormat((String[])objectArray, (String[])objectArray2, true);
        }
        return DateParser.parseSpecViaLooseFormat((String[])objectArray, (String[])objectArray2);
    }

    public static Date parseDate(String string, String string2) {
        try {
            if (string2 == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseDate", "Unable to determine format for date string {0}", new Object[]{string});
                }
                throw new DateParseException();
            }
            Calendar calendar = DateParser.parseSpecViaFormat(string, string2, true);
            if (string2.endsWith("G\\MT")) {
                // empty if block
            }
            return calendar.getTime();
        }
        catch (DateParseException dateParseException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10022", new Object[]{string, string2});
        }
    }

    public static Date parseDate(String string) {
        try {
            String string2 = DateParser.determineClosestMatchingFormat(string);
            if (string2 == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, DateParser.class, "parseDate", "Unable to determine format for date string {0}", new Object[]{string});
                }
                throw new DateParseException();
            }
            Calendar calendar = DateParser.parseSpecViaFormat(string, string2, false);
            if (string2.endsWith("G\\MT")) {
                // empty if block
            }
            return calendar.getTime();
        }
        catch (DateParseException dateParseException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10021", new Object[]{string});
        }
    }

    static {
        HASH_LONG_MONTHS.put("january", new Integer(0));
        HASH_LONG_MONTHS.put("februrary", new Integer(1));
        HASH_LONG_MONTHS.put("march", new Integer(2));
        HASH_LONG_MONTHS.put("april", new Integer(3));
        HASH_LONG_MONTHS.put("may", new Integer(4));
        HASH_LONG_MONTHS.put("june", new Integer(5));
        HASH_LONG_MONTHS.put("july", new Integer(6));
        HASH_LONG_MONTHS.put("august", new Integer(7));
        HASH_LONG_MONTHS.put("september", new Integer(8));
        HASH_LONG_MONTHS.put("october", new Integer(9));
        HASH_LONG_MONTHS.put("november", new Integer(10));
        HASH_LONG_MONTHS.put("december", new Integer(11));
        HASH_SHORT_MONTHS = new Hashtable();
        HASH_SHORT_MONTHS.put("jan", new Integer(0));
        HASH_SHORT_MONTHS.put("feb", new Integer(1));
        HASH_SHORT_MONTHS.put("mar", new Integer(2));
        HASH_SHORT_MONTHS.put("apr", new Integer(3));
        HASH_SHORT_MONTHS.put("may", new Integer(4));
        HASH_SHORT_MONTHS.put("jun", new Integer(5));
        HASH_SHORT_MONTHS.put("jul", new Integer(6));
        HASH_SHORT_MONTHS.put("aug", new Integer(7));
        HASH_SHORT_MONTHS.put("sep", new Integer(8));
        HASH_SHORT_MONTHS.put("oct", new Integer(9));
        HASH_SHORT_MONTHS.put("nov", new Integer(10));
        HASH_SHORT_MONTHS.put("dec", new Integer(11));
        HASH_LONG_DAYSOFWEEK = new Hashtable();
        HASH_LONG_DAYSOFWEEK.put("sunday", new Integer(1));
        HASH_LONG_DAYSOFWEEK.put("monday", new Integer(2));
        HASH_LONG_DAYSOFWEEK.put("tuesday", new Integer(3));
        HASH_LONG_DAYSOFWEEK.put("wednesday", new Integer(4));
        HASH_LONG_DAYSOFWEEK.put("thursday", new Integer(5));
        HASH_LONG_DAYSOFWEEK.put("friday", new Integer(6));
        HASH_LONG_DAYSOFWEEK.put("saturday", new Integer(7));
        HASH_SHORT_DAYSOFWEEK = new Hashtable();
        HASH_SHORT_DAYSOFWEEK.put("sun", new Integer(1));
        HASH_SHORT_DAYSOFWEEK.put("mon", new Integer(2));
        HASH_SHORT_DAYSOFWEEK.put("tue", new Integer(3));
        HASH_SHORT_DAYSOFWEEK.put("wed", new Integer(4));
        HASH_SHORT_DAYSOFWEEK.put("thu", new Integer(5));
        HASH_SHORT_DAYSOFWEEK.put("fri", new Integer(6));
        HASH_SHORT_DAYSOFWEEK.put("sat", new Integer(7));
        HASH_STANDARD_FORMATS = new Hashtable();
        HASH_STANDARD_FORMATS.put(new Character('d'), STR_SHORT_DATE_FORMAT);
        HASH_STANDARD_FORMATS.put(new Character('D'), STR_LONG_DATE_FORMAT);
        HASH_STANDARD_FORMATS.put(new Character('t'), STR_SHORT_TIME_FORMAT);
        HASH_STANDARD_FORMATS.put(new Character('T'), STR_LONG_TIME_FORMAT);
        HASH_STANDARD_FORMATS.put(new Character('f'), "dddd, MMMM dd, yyyy h:mm tt");
        HASH_STANDARD_FORMATS.put(new Character('F'), "dddd, MMMM dd, yyyy h:mm:ss tt");
        HASH_STANDARD_FORMATS.put(new Character('g'), "M/d/yyyy h:mm tt");
        HASH_STANDARD_FORMATS.put(new Character('G'), "M/d/yyyy h:mm:ss tt");
        HASH_STANDARD_FORMATS.put(new Character('m'), "MMMM dd");
        HASH_STANDARD_FORMATS.put(new Character('M'), "MMMM dd");
        HASH_STANDARD_FORMATS.put(new Character('R'), "ddd, dd MMM yyyy HH:mm:ss G\\MT");
        HASH_STANDARD_FORMATS.put(new Character('r'), "ddd, dd MMM yyyy HH:mm:ss G\\MT");
        HASH_STANDARD_FORMATS.put(new Character('s'), "yyyy-MM-ddTHH:mm:ss");
        HASH_STANDARD_FORMATS.put(new Character('u'), "yyyy-MM-dd HH:mm:ssZ");
        HASH_STANDARD_FORMATS.put(new Character('U'), "dddd, MMMM dd, yyyy h:mm:ss tt");
        HASH_STANDARD_FORMATS.put(new Character('Y'), "MMMM, yyyy");
        HASH_STANDARD_FORMATS.put(new Character('y'), "MMMM, yyyy");
        HASH_TIMEZONE_FORMATS = new Hashtable();
        HASH_TIMEZONE_FORMATS.put("gmt", "GMT");
        HASH_TIMEZONE_FORMATS.put("nst", "GMT-0330");
        HASH_TIMEZONE_FORMATS.put("ndt", "GMT-0230");
        HASH_TIMEZONE_FORMATS.put("ast", "GMT-0400");
        HASH_TIMEZONE_FORMATS.put("adt", "GMT-0300");
        HASH_TIMEZONE_FORMATS.put("est", "GMT-0500");
        HASH_TIMEZONE_FORMATS.put("edt", "GMT-0400");
        HASH_TIMEZONE_FORMATS.put("cst", "GMT-0600");
        HASH_TIMEZONE_FORMATS.put("cdt", "GMT-0500");
        HASH_TIMEZONE_FORMATS.put("mst", "GMT-0700");
        HASH_TIMEZONE_FORMATS.put("mdt", "GMT-0600");
        HASH_TIMEZONE_FORMATS.put("pst", "GMT-0800");
        HASH_TIMEZONE_FORMATS.put("pdt", "GMT-0700");
        HASH_TIMEZONE_FORMATS.put("akst", "GMT-0900");
        HASH_TIMEZONE_FORMATS.put("akdt", "GMT-0800");
        HASH_TIMEZONE_FORMATS.put("hst", "GMT-1000");
        HASH_TIMEZONE_FORMATS.put("hdt", "GMT-0900");
        HASH_TIMEZONE_FORMATS.put("hast", "GMT-1000");
        HASH_TIMEZONE_FORMATS.put("hadt", "GMT-0900");
    }
}

