/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.performance;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class MonitorFactory {
    private static final String MONITOR_REPORT_INTERVAL_PROPERTY = "monitor.statistic.report.interval";
    private static MonitorFactory s_instance = null;
    private static long s_dumpInterval = -1L;
    private Hashtable monitors = new Hashtable();

    private MonitorFactory() {
        if (Utility.PerformanceLogger.isLoggable(Level.FINE)) {
            this.configureMonitorThread();
        } else {
            Trace.log(Utility.FrameworkLogger, Level.FINE, MonitorFactory.class, "MonitorFactory", (Object)"Performance logging is not configured");
        }
    }

    public static MonitorFactory getInstance() {
        if (s_instance == null) {
            s_instance = new MonitorFactory();
        }
        return s_instance;
    }

    public Monitor getMonitor(String string) {
        return this.getMonitor(string, "no description available");
    }

    public Monitor getMonitor(String string, String string2) {
        Monitor monitor = (Monitor)this.monitors.get(string);
        monitor = (Monitor)this.monitors.get(string);
        if (monitor == null) {
            monitor = new Monitor(string, string2);
            this.monitors.put(string, monitor);
        }
        return monitor;
    }

    public List getMonitorList() throws Exception {
        return new ArrayList(this.monitors.values());
    }

    public static void stopReportingStatistics() {
        MonitorFactory monitorFactory = MonitorFactory.getInstance();
        s_dumpInterval = 0L;
        if (monitorFactory != null) {
            monitorFactory.dumpStatistics();
        }
    }

    private void configureMonitorThread() {
        try {
            String string = System.getProperty(MONITOR_REPORT_INTERVAL_PROPERTY, "0");
            s_dumpInterval = 1000 * Integer.parseInt(string);
            if (s_dumpInterval > 0L) {
                Utility.PerformanceLogger.fine("PERFMON-JAVA STATS: Monitor statistics will be dumped every " + string + " seconds.");
                Thread thread = new Thread(){

                    public void run() {
                        MonitorFactory monitorFactory = MonitorFactory.getInstance();
                        while (s_dumpInterval > 0L) {
                            try {
                                Thread.sleep(s_dumpInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (monitorFactory == null) continue;
                            monitorFactory.dumpStatistics();
                        }
                    }
                };
                thread.start();
            } else {
                Utility.PerformanceLogger.fine("PERFMON-JAVA STATS: Monitor statistics interval is not configured");
            }
        }
        catch (Throwable throwable) {
            Utility.PerformanceLogger.fine("PERFMON-JAVA STATS: Monitor statistics interval could not be configured  - " + throwable.getLocalizedMessage());
        }
    }

    public void dumpStatistics() {
        try {
            List list = this.getMonitorList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Monitor monitor = (Monitor)iterator.next();
                monitor.dumpStatistics();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

