/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.HashMap;
import oracle.adfmf.metadata.bean.AccessorAttributeDefinition;
import oracle.adfmf.metadata.bean.AttributeDefinition;
import oracle.adfmf.metadata.bean.PropertiesDefinition;
import oracle.adfmf.metadata.bean.PropertyDefinition;
import oracle.adfmf.metadata.bean.transform.LocalPartInfo;
import oracle.adfmf.metadata.bean.transform.ManualXmlAny;
import oracle.adfmf.metadata.bean.transform.TransformCacheProvider;
import oracle.adfmf.metadata.bean.transform.TransformUtil;
import oracle.adfmf.util.XmlAnyDefinition;

class DynamicTransformUtil {
    private static final HashMap s_typeMap = new HashMap();

    private DynamicTransformUtil() {
    }

    protected static String transformType(String string) {
        Object v = s_typeMap.get(string);
        if (v != null) {
            string = (String)v;
        }
        return string;
    }

    protected static boolean classNeedsCreation(TransformCacheProvider transformCacheProvider, String string) {
        if (string == null) {
            return false;
        }
        return !transformCacheProvider.classExists(string);
    }

    protected static String getIdFromClassName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    protected static String getPackageFromClassName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    protected static ManualXmlAny createXmlAny(String string) {
        ManualXmlAny manualXmlAny = new ManualXmlAny("JavaBean");
        String string2 = DynamicTransformUtil.getPackageFromClassName(string);
        String string3 = DynamicTransformUtil.getIdFromClassName(string);
        TransformUtil.setAttribute(manualXmlAny, "xmlns", "http://xmlns.oracle.com/adfm/beanmodel");
        TransformUtil.setAttribute(manualXmlAny, "id", string3);
        TransformUtil.setAttribute(manualXmlAny, "Package", string2);
        TransformUtil.setAttribute(manualXmlAny, "BeanClass", string);
        TransformUtil.setAttribute(manualXmlAny, "isJavaBased", "false");
        return manualXmlAny;
    }

    protected static AccessorAttributeDefinition createAccessorAttribute(String string, String string2, String string3, String string4) {
        return DynamicTransformUtil.createAccessorAttribute(string, string2, string3, string4, null);
    }

    protected static AccessorAttributeDefinition createAccessorAttribute(String string, String string2, String string3, String string4, PropertiesDefinition propertiesDefinition) {
        String string5;
        ManualXmlAny manualXmlAny = new ManualXmlAny("AccessorAttribute");
        String string6 = DynamicTransformUtil.getIdFromClassName(string);
        if (string2.equalsIgnoreCase(string6)) {
            string5 = string2;
            string2 = string2 + "0";
        } else {
            string5 = null;
        }
        TransformUtil.setAttribute(manualXmlAny, "id", string2);
        TransformUtil.setAttribute(manualXmlAny, "SourceName", string5);
        TransformUtil.setAttribute(manualXmlAny, "BeanClass", string3);
        TransformUtil.setAttribute(manualXmlAny, "IsCollection", Boolean.toString(string4 != null));
        TransformUtil.setAttribute(manualXmlAny, "CollectionBeanClass", string4);
        if (propertiesDefinition != null) {
            manualXmlAny.addChild(propertiesDefinition);
        }
        return new AccessorAttributeDefinition(manualXmlAny);
    }

    protected static AttributeDefinition createAttribute(String string, String string2, String string3, String string4) {
        return DynamicTransformUtil.createAttribute(string, string2, string3, string4, null);
    }

    protected static AttributeDefinition createAttribute(String string, String string2, String string3, String string4, PropertiesDefinition propertiesDefinition) {
        ManualXmlAny manualXmlAny = new ManualXmlAny("Attribute");
        TransformUtil.setAttribute(manualXmlAny, "Name", string);
        TransformUtil.setAttribute(manualXmlAny, "IsUpdateable", string2);
        TransformUtil.setAttribute(manualXmlAny, "IsNotNull", string3);
        TransformUtil.setAttribute(manualXmlAny, "Type", string4);
        if (propertiesDefinition != null) {
            manualXmlAny.addChild(propertiesDefinition);
        }
        return new AttributeDefinition(manualXmlAny);
    }

    protected static void addAccessorAttribute(String string, ManualXmlAny manualXmlAny, String string2, boolean bl, String string3) {
        DynamicTransformUtil.addAccessorAttribute(string, manualXmlAny, string2, string2, bl, string3);
    }

    protected static void addAccessorAttribute(String string, ManualXmlAny manualXmlAny, String string2, String string3, boolean bl, String string4) {
        DynamicTransformUtil.addAccessorAttribute(string, manualXmlAny, string2, string3, bl, string4, false);
    }

    protected static void addAccessorAttribute(String string, ManualXmlAny manualXmlAny, String string2, String string3, boolean bl, String string4, boolean bl2) {
        String string5 = bl ? (bl2 ? LocalPartInfo.makeCollectionBeanClassName(string4 + "." + string3) : LocalPartInfo.makeCollectionBeanClassName(string4)) : null;
        manualXmlAny.addChild(DynamicTransformUtil.createAccessorAttribute(string, string2, string4 + "." + string3, string5));
    }

    protected static XmlAnyDefinition createBuiltInOperation(String string) {
        ManualXmlAny manualXmlAny = new ManualXmlAny("BuiltinOperation");
        TransformUtil.setAttribute(manualXmlAny, "id", string);
        return manualXmlAny;
    }

    protected static PropertyDefinition createPropertyDefinition(String string, String string2) {
        ManualXmlAny manualXmlAny = new ManualXmlAny("Property");
        manualXmlAny.setAttribute("Name", string);
        manualXmlAny.setAttribute("Value", string2);
        return new PropertyDefinition(manualXmlAny);
    }

    static {
        s_typeMap.put("anyType", "java.lang.Object");
        s_typeMap.put("base64Binary", "java.lang.Object");
        s_typeMap.put("boolean", "java.lang.Boolean");
        s_typeMap.put("byte", "java.lang.Byte");
        s_typeMap.put("char", "java.lang.Character");
        s_typeMap.put("double", "java.lang.Double");
        s_typeMap.put("float", "java.lang.Float");
        s_typeMap.put("int", "java.lang.Integer");
        s_typeMap.put("long", "java.lang.Long");
        s_typeMap.put("short", "java.lang.Short");
        s_typeMap.put("string", "java.lang.String");
        s_typeMap.put("unsignedShort", "java.lang.Object");
        s_typeMap.put("dateTime", "java.sql.Date");
        s_typeMap.put("decimal", "java.math.BigDecimal");
        s_typeMap.put("anySimpleType", "java.lang.String");
    }
}

