/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.cache;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfmf.dc.ws.soap.SoapWebServiceOperation;
import oracle.adfmf.metadata.bean.cache.SchemaAny;
import oracle.adfmf.metadata.bean.cache.SchemaAnyCache;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class NamespaceCache {
    private static final String ID_COMPONENT_SEPARATOR = "^";
    private static final List s_simpleTypes = new ArrayList();
    private static final String INDENT = "  ";
    private static final NamespaceCache instance;
    private CacheEntry hierarchicalNamespaceTable = new CacheEntry(new HashMap(), null, null, null, null, null, null);
    private HashMap linearNamespaceTable = new HashMap();
    private static final List WSDL_NS_LIST;
    private static final List SCHEMA_NS_LIST;
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String WSDL_NS = "http://www.w3.org/ns/wsdl";
    private static final String WSDL11_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String[] SCHEMA_TYPE_MARKER_NAMES;
    private static final List SCHEMA_TYPE_MARKERS_LIST;

    private NamespaceCache() {
    }

    public static final NamespaceCache getInstance() {
        return instance;
    }

    private SchemaAny getSchemaFragmentFromWsdl(SchemaAny schemaAny, String string) {
        if (Utility.isEmpty(string)) {
            return null;
        }
        List list = SchemaAny.getSchemaChildren(schemaAny, SCHEMA_NS_LIST, "schema", null, null, false, false, true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SchemaAny schemaAny2 = (SchemaAny)iterator.next();
            if (string.equals(schemaAny2.getAttributeValue("targetNamespace"))) {
                return schemaAny2;
            }
            List list2 = SchemaAny.getSchemaChildren(schemaAny2, SCHEMA_NS_LIST, "import", null, null, false, false, true);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                SchemaAny schemaAny3 = (SchemaAny)iterator2.next();
                if (schemaAny3 == null || !string.equals(schemaAny3.getAttributeValue("namespace"))) continue;
                return schemaAny2;
            }
        }
        return null;
    }

    private void processWsdlFragmentDepthFirst(SchemaAny schemaAny) {
        Object object;
        Object object2;
        if (schemaAny == null) {
            return;
        }
        if ("part".equals(schemaAny.getLocalName()) && (WSDL_NS.equals(schemaAny.getCurrentNamespace()) || WSDL11_NS.equals(schemaAny.getCurrentNamespace()))) {
            object2 = NamespaceCache.determineTypeQName(schemaAny);
            object = this.getOrCreateNamespaceEntry((String)object2[0], this.hierarchicalNamespaceTable);
            SchemaAny schemaAny2 = this.getSchemaFragmentFromWsdl(schemaAny.getDocumentAny(), (String)object2[0]);
            CacheEntry cacheEntry = (CacheEntry)((CacheEntry)object).children.get(object2[1]);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(new HashMap(), (String)object2[0], (String)object2[1], (CacheEntry)object, schemaAny, null, NamespaceCache.determineTypeQName(schemaAny)[0]);
                ((CacheEntry)object).children.put(object2[1], cacheEntry);
                this.processSchema(schemaAny2, cacheEntry);
            }
        } else if ("import".equals(schemaAny.getLocalName()) && (WSDL_NS.equals(schemaAny.getCurrentNamespace()) || WSDL11_NS.equals(schemaAny.getCurrentNamespace())) && !Utility.isEmpty((String)(object2 = (String)schemaAny.getAttributeValue("location")))) {
            object2 = SchemaAny.fixupLocation(schemaAny.getDocumentAny().getLocation(), (String)object2);
            object = SchemaAnyCache.getInstance().fetch((String)object2, "definitions");
            this.processWsdlFragmentDepthFirst((SchemaAny)object);
        }
        object2 = schemaAny.getChildren().iterator();
        while (object2.hasNext()) {
            this.processWsdlFragmentDepthFirst((SchemaAny)object2.next());
        }
    }

    public void processWsdlFragment(SchemaAny schemaAny) {
        this.processWsdlFragmentDepthFirst(schemaAny);
    }

    public static boolean isQNameEmpty(String[] stringArray) {
        if (stringArray == null || stringArray.length != 2) {
            return true;
        }
        return Utility.isEmpty(stringArray[0]) && Utility.isEmpty(stringArray[1]);
    }

    public static String[] determineTypeQName(SchemaAny schemaAny) {
        String[] stringArray = new String[2];
        if (schemaAny == null) {
            return stringArray;
        }
        String string = (String)schemaAny.getAttributeValue("element");
        if (string == null) {
            string = (String)schemaAny.getAttributeValue("type");
        }
        if (string == null) {
            string = (String)schemaAny.getAttributeValue("ref");
        }
        if (string == null) {
            return stringArray;
        }
        stringArray = SchemaAny.breakupName(string);
        stringArray[0] = Utility.isEmpty(schemaAny.getPrefix()) ? (stringArray[0] == null ? schemaAny.getCurrentNamespace() : schemaAny.getNamespace(stringArray[0])) : (stringArray[0] == null ? schemaAny.getTargetNamespace() : schemaAny.getNamespace(stringArray[0]));
        return stringArray;
    }

    private void processSchema(SchemaAny schemaAny, CacheEntry cacheEntry) {
        if (schemaAny == null || cacheEntry == null) {
            return;
        }
        SchemaAny schemaAny2 = NamespaceCache.findTypeNode(cacheEntry.typeNamespace, cacheEntry.localName, schemaAny);
        if (schemaAny2 != null) {
            cacheEntry.schemaFragment = schemaAny2;
            this.processTypeNodeChildren(schemaAny2, cacheEntry);
        }
    }

    private static boolean isSchemaElementFormDefaultQualified(SchemaAny schemaAny) {
        if (schemaAny == null) {
            return false;
        }
        String string = schemaAny.getDocumentAny().getLocalName();
        SchemaAny schemaAny2 = schemaAny.getDocumentAny();
        if (!"schema".equals(string) && (schemaAny2 = SchemaAny.getSchemaChild(schemaAny2, SCHEMA_NS_LIST, "schema", "targetNamespace", schemaAny.getTargetNamespace(), false, true)) == null) {
            return false;
        }
        String string2 = (String)schemaAny2.getAttributeValue("elementFormDefault");
        if (string2 == null) {
            return false;
        }
        return "qualified".equalsIgnoreCase(string2);
    }

    private void processTypeNodeChildren(SchemaAny schemaAny, CacheEntry cacheEntry) {
        if (schemaAny == null || cacheEntry == null) {
            return;
        }
        if (!Utility.isEmpty((String)schemaAny.getAttributeValue("type"))) {
            SchemaAny schemaAny2;
            String[] stringArray = NamespaceCache.determineTypeQName(schemaAny);
            CacheEntry cacheEntry2 = new CacheEntry(new HashMap(), stringArray[0], stringArray[1], cacheEntry, schemaAny2 = NamespaceCache.findTypeNode(stringArray[0], stringArray[1], schemaAny.getDocumentAny()), stringArray[1], stringArray[0]);
            if (this.addTypeEntryToNamespace(cacheEntry2) == null) {
                this.processTypeNodeChildren(schemaAny2, cacheEntry2);
            }
        } else {
            List list = schemaAny.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SchemaAny schemaAny3 = (SchemaAny)iterator.next();
                if (SCHEMA_TYPE_MARKERS_LIST.contains(schemaAny3.getLocalName()) && SCHEMA_NS.equals(schemaAny3.getCurrentNamespace())) {
                    Object object;
                    Object object2;
                    Object object3;
                    String string = (String)schemaAny3.getAttributeValue("name");
                    if (string == null) {
                        String string2 = (String)schemaAny3.getAttributeValue("ref");
                        if (string2 != null) {
                            object3 = NamespaceCache.determineTypeQName(schemaAny3);
                            object2 = new CacheEntry(new HashMap(), object3[0], object3[1], cacheEntry, schemaAny3, null, null);
                            object = NamespaceCache.findTypeNode(((CacheEntry)object2).elementNamespace, ((CacheEntry)object2).localName, schemaAny3.getDocumentAny());
                            cacheEntry.children.put(string2, object2);
                            this.processTypeNodeChildren((SchemaAny)object, (CacheEntry)object2);
                            continue;
                        }
                        this.processTypeNodeChildren(schemaAny3, cacheEntry);
                        continue;
                    }
                    boolean bl = NamespaceCache.isSchemaElementFormDefaultQualified(schemaAny) || "qualified".equals(schemaAny3.getAttributeValue("form"));
                    object3 = bl ? schemaAny3.getTargetNamespace() : null;
                    object2 = schemaAny3.getAttributeValue("type") == null ? null : SchemaAny.breakupName((String)schemaAny3.getAttributeValue("type"))[1];
                    object = NamespaceCache.determineTypeQName(schemaAny3)[0];
                    CacheEntry cacheEntry3 = new CacheEntry(new HashMap(), (String)object3, string, cacheEntry, schemaAny3, (String)object2, (String)object);
                    cacheEntry.children.put(string, cacheEntry3);
                    if (Utility.isEmpty((String)object)) {
                        this.processTypeNodeChildren(schemaAny3, cacheEntry3);
                        continue;
                    }
                    if (this.addTypeEntryToNamespace(cacheEntry3) != null) continue;
                    SchemaAny schemaAny4 = NamespaceCache.findTypeNode(cacheEntry3.typeNamespace, cacheEntry3.typeName, schemaAny3.getDocumentAny());
                    this.processTypeNodeChildren(schemaAny4, cacheEntry3);
                    continue;
                }
                this.processTypeNodeChildren(schemaAny3, cacheEntry);
            }
        }
    }

    private CacheEntry addTypeEntryToNamespace(CacheEntry cacheEntry) {
        if (cacheEntry == null || cacheEntry.typeNamespace == null) {
            return null;
        }
        CacheEntry cacheEntry2 = this.getOrCreateNamespaceEntry(cacheEntry.typeNamespace, this.hierarchicalNamespaceTable);
        if (!cacheEntry2.children.containsKey(cacheEntry.typeName)) {
            CacheEntry cacheEntry3 = new CacheEntry(cacheEntry.children, null, cacheEntry.typeName, this.hierarchicalNamespaceTable, cacheEntry.schemaFragment, null, cacheEntry.typeNamespace);
            cacheEntry2.children.put(cacheEntry3.localName, cacheEntry3);
            return null;
        }
        return (CacheEntry)cacheEntry2.children.get(cacheEntry.typeName);
    }

    private CacheEntry getOrCreateNamespaceEntry(String string, CacheEntry cacheEntry) {
        CacheEntry cacheEntry2 = (CacheEntry)cacheEntry.children.get(string);
        if (cacheEntry2 == null) {
            cacheEntry2 = new CacheEntry(new HashMap(), null, string, cacheEntry, null, null, null);
            cacheEntry.children.put(string, cacheEntry2);
        }
        return cacheEntry2;
    }

    private static SchemaAny findTypeNode(String string, String string2, SchemaAny schemaAny) {
        Object object;
        for (int i = 0; i < SCHEMA_TYPE_MARKER_NAMES.length; ++i) {
            object = SchemaAny.getSchemaChild(schemaAny, SCHEMA_NS_LIST, SCHEMA_TYPE_MARKER_NAMES[i], "name", string2, false, true);
            if (object == null || !string.equals(((SchemaAny)object).getTargetNamespace())) continue;
            return object;
        }
        List list = SchemaAny.getSchemaChildren(schemaAny, SCHEMA_NS_LIST, "import", "namespace", string, false, false, false);
        object = SchemaAny.getSchemaChildren(schemaAny, SCHEMA_NS_LIST, "include", null, null, false, false, false);
        list.addAll(object);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SchemaAny schemaAny2;
            SchemaAny schemaAny3 = (SchemaAny)iterator.next();
            String string3 = (String)schemaAny3.getAttributeValue("schemaLocation");
            if (Utility.isEmpty(string3)) continue;
            string3 = SchemaAny.fixupLocation(schemaAny.getDocumentAny().getLocation(), string3);
            SchemaAny schemaAny4 = SchemaAnyCache.getInstance().fetch(string3, "schema");
            if (schemaAny4 == null || (schemaAny2 = NamespaceCache.findTypeNode(string, string2, schemaAny4)) == null) continue;
            return schemaAny2;
        }
        return null;
    }

    private CacheEntry findCacheEntryForIdKernel(String string, CacheEntry cacheEntry, boolean bl, boolean bl2) {
        if (Utility.isEmpty(string) || cacheEntry == null) {
            return null;
        }
        if (!bl2 && (bl ? string.equals(cacheEntry.localName) : string.equalsIgnoreCase(cacheEntry.localName))) {
            return cacheEntry;
        }
        if (bl) {
            return (CacheEntry)cacheEntry.children.get(string);
        }
        Set set = cacheEntry.children.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equalsIgnoreCase(string2)) continue;
            return (CacheEntry)cacheEntry.children.get(string2);
        }
        return null;
    }

    private CacheEntry findCacheEntryForId(String string, CacheEntry cacheEntry, boolean bl) {
        CacheEntry cacheEntry2;
        if (Utility.isEmpty(string) || cacheEntry == null) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(ID_COMPONENT_SEPARATOR);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        boolean bl2 = false;
        if (cacheEntry != null && string2.equals(cacheEntry.localName)) {
            bl2 = true;
        }
        if ((cacheEntry2 = this.findCacheEntryForIdKernel(string2, cacheEntry, bl, bl2)) == null && !bl2) {
            cacheEntry2 = this.findCacheEntryForIdKernel(cacheEntry.typeNamespace, this.hierarchicalNamespaceTable, bl, false);
            StringBuffer stringBuffer = new StringBuffer();
            if (!Utility.isEmpty(cacheEntry.typeName)) {
                stringBuffer.append(cacheEntry.typeName);
            }
            if (!string2.equals(cacheEntry.typeName)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(ID_COMPONENT_SEPARATOR);
                }
                stringBuffer.append(string2);
            }
            if (!Utility.isEmpty(string3)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(ID_COMPONENT_SEPARATOR);
                }
                stringBuffer.append(string3);
            }
            string3 = stringBuffer.toString();
        }
        if (string3 == null) {
            return cacheEntry2;
        }
        return this.findCacheEntryForId(string3, cacheEntry2, bl);
    }

    public CacheEntry getCacheEntryForId(String string) {
        if (!this.linearNamespaceTable.containsKey(string)) {
            CacheEntry cacheEntry = this.findCacheEntryForId(string, this.hierarchicalNamespaceTable, true);
            if (cacheEntry == null) {
                cacheEntry = this.findCacheEntryForId(string, this.hierarchicalNamespaceTable, false);
            }
            this.linearNamespaceTable.put(string, cacheEntry);
        }
        return (CacheEntry)this.linearNamespaceTable.get(string);
    }

    public boolean namespaceEntryExistsForId(String string) {
        return this.getCacheEntryForId(string) != null;
    }

    public String getElementNamespaceForId(String string) {
        CacheEntry cacheEntry = this.getCacheEntryForId(string);
        if (cacheEntry == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, NamespaceCache.class, "getElementNamespaceForId", "No CacheEntry found for id={0}", new Object[]{string});
            }
            return null;
        }
        return cacheEntry.elementNamespace;
    }

    public int getMinOccurs(String string) {
        CacheEntry cacheEntry = this.getCacheEntryForId(string);
        if (cacheEntry == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, NamespaceCache.class, "getMinOccurs", "No CacheEntry found for id={0}", new Object[]{string});
            }
            return -1;
        }
        if (cacheEntry.schemaFragment == null) {
            return -1;
        }
        if ("element".equals(cacheEntry.schemaFragment.getLocalName()) && SCHEMA_NS.equals(cacheEntry.schemaFragment.getCurrentNamespace())) {
            String string2 = (String)cacheEntry.schemaFragment.getAttributeValue("minOccurs");
            if (string2 == null) {
                return 1;
            }
            return Integer.parseInt(string2);
        }
        return -1;
    }

    public boolean isNillable(String string) {
        CacheEntry cacheEntry = this.getCacheEntryForId(string);
        if (cacheEntry == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, NamespaceCache.class, "isNillable", "No CacheEntry found for id={0}", new Object[]{string});
            }
            return false;
        }
        if (cacheEntry.schemaFragment == null) {
            return false;
        }
        if ("element".equals(cacheEntry.schemaFragment.getLocalName()) && SCHEMA_NS.equals(cacheEntry.schemaFragment.getCurrentNamespace())) {
            return cacheEntry.schemaFragment.getAttributeBooleanValue("nillable");
        }
        return false;
    }

    public boolean isComplexType(String string) {
        CacheEntry cacheEntry = this.getCacheEntryForId(string);
        if (cacheEntry == null) {
            return false;
        }
        String[] stringArray = NamespaceCache.determineTypeQName(cacheEntry.schemaFragment);
        return !SCHEMA_NS.equalsIgnoreCase(stringArray[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Namespace Table\n");
        Iterator iterator = this.hierarchicalNamespaceTable.children.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey()).append('\n');
            CacheEntry cacheEntry = (CacheEntry)entry.getValue();
            Iterator iterator2 = cacheEntry.children.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                CacheEntry cacheEntry2 = (CacheEntry)entry2.getValue();
                stringBuffer.append(INDENT).append(entry2.getKey()).append(" => ").append(cacheEntry2.dumpCacheEntry(INDENT));
            }
        }
        return stringBuffer.toString();
    }

    public static String createNamespaceCacheId(String[] stringArray) {
        return Utility.joinStrings(stringArray, ID_COMPONENT_SEPARATOR);
    }

    public static String[] splitNamespaceCacheId(String string) {
        return Utility.tokenize(string, ID_COMPONENT_SEPARATOR);
    }

    public static boolean isSimpleType(String string) {
        return s_simpleTypes.contains(string);
    }

    static {
        s_simpleTypes.add("anySimpleType");
        s_simpleTypes.add("string");
        s_simpleTypes.add("boolean");
        s_simpleTypes.add("decimal");
        s_simpleTypes.add("float");
        s_simpleTypes.add("double");
        s_simpleTypes.add("duration");
        s_simpleTypes.add("dateTime");
        s_simpleTypes.add("time");
        s_simpleTypes.add("date");
        s_simpleTypes.add("gYearMonth");
        s_simpleTypes.add("gYear");
        s_simpleTypes.add("gMonthDay");
        s_simpleTypes.add("gDay");
        s_simpleTypes.add("gMonth");
        s_simpleTypes.add("hexBinary");
        s_simpleTypes.add("base64Binary");
        s_simpleTypes.add("anyURI");
        s_simpleTypes.add("QName");
        s_simpleTypes.add("NOTATION");
        s_simpleTypes.add("normalizedString");
        s_simpleTypes.add("token");
        s_simpleTypes.add("language");
        s_simpleTypes.add("NMTOKEN");
        s_simpleTypes.add("NMTOKENS");
        s_simpleTypes.add("Name");
        s_simpleTypes.add("NCName");
        s_simpleTypes.add("ID");
        s_simpleTypes.add("IDREF");
        s_simpleTypes.add("IDREFS");
        s_simpleTypes.add("ENTITY");
        s_simpleTypes.add("ENTITIES");
        s_simpleTypes.add("integer");
        s_simpleTypes.add("nonPositiveInteger");
        s_simpleTypes.add("negativeInteger");
        s_simpleTypes.add("long");
        s_simpleTypes.add("int");
        s_simpleTypes.add("short");
        s_simpleTypes.add("byte");
        s_simpleTypes.add("nonNegativeInteger");
        s_simpleTypes.add("unsignedLong");
        s_simpleTypes.add("unsignedInt");
        s_simpleTypes.add("unsignedShort");
        s_simpleTypes.add("unsignedByte");
        s_simpleTypes.add("positiveInteger");
        instance = new NamespaceCache();
        WSDL_NS_LIST = SoapWebServiceOperation.WSDL_NS_LIST;
        SCHEMA_NS_LIST = SoapWebServiceOperation.SCHEMA_NS_LIST;
        SCHEMA_TYPE_MARKER_NAMES = new String[]{"complexType", "simpleType", "element"};
        SCHEMA_TYPE_MARKERS_LIST = new ArrayList(3);
        for (int i = 0; i < SCHEMA_TYPE_MARKER_NAMES.length; ++i) {
            SCHEMA_TYPE_MARKERS_LIST.add(SCHEMA_TYPE_MARKER_NAMES[i]);
        }
    }

    public static class CacheEntry {
        static final byte TYPE_UNKNOWN = -1;
        static final byte TYPE_NAMESPACE = 0;
        static final byte TYPE_TYPE = 1;
        static final byte TYPE_ELEMENT = 2;
        final String typeNamespace;
        final Map children;
        public SchemaAny schemaFragment;
        final String localName;
        public final String typeName;
        final CacheEntry parentEntry;
        final String elementNamespace;

        private CacheEntry(Map map, String string, String string2, CacheEntry cacheEntry, SchemaAny schemaAny, String string3, String string4) {
            this.children = map;
            this.schemaFragment = schemaAny;
            this.typeNamespace = string4;
            this.typeName = string3;
            this.localName = string2;
            this.parentEntry = cacheEntry;
            this.elementNamespace = string;
        }

        private String dumpCacheEntry(String string) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("(").append(this.elementNamespace).append(") [").append(this.typeName).append(" (").append(this.typeNamespace).append(")]\n");
            String string2 = string + NamespaceCache.INDENT;
            Iterator iterator = this.children.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                stringBuffer.append(string2).append(entry.getKey()).append(" => ").append(cacheEntry.dumpCacheEntry(string2));
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return this.dumpCacheEntry(NamespaceCache.INDENT);
        }

        byte determineType() {
            if (Utility.isEmpty(this.typeName) && Utility.isEmpty(this.typeNamespace) && Utility.isEmpty(this.elementNamespace)) {
                return 0;
            }
            if (Utility.isEmpty(this.typeName) && this.parentEntry.determineType() == 0) {
                return 1;
            }
            if (!Utility.isEmpty(this.typeName) && !Utility.isEmpty(this.typeNamespace)) {
                return 2;
            }
            return -1;
        }
    }
}

