/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.java.beans;

import java.util.ArrayList;
import java.util.Vector;
import oracle.adfmf.java.beans.ProviderChangeEvent;
import oracle.adfmf.java.beans.ProviderChangeListener;

public class ProviderChangeSupport {
    protected transient Vector listeners;
    protected Object source;

    public ProviderChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized ProviderChangeListener[] accessDataChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        return arrayList.toArray(new ProviderChangeListener[0]);
    }

    public synchronized void addProviderChangeListener(ProviderChangeListener providerChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(providerChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProviderChange(ProviderChangeEvent providerChangeEvent) {
        Vector vector = null;
        ProviderChangeSupport providerChangeSupport = this;
        synchronized (providerChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ProviderChangeListener providerChangeListener = (ProviderChangeListener)vector.elementAt(i);
                providerChangeListener.providerChange(providerChangeEvent);
            }
        }
    }

    public void fireProviderChange(String string, byte by, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, by, object));
    }

    public void fireProviderChange(String string, char c, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, c, object));
    }

    public void fireProviderChange(String string, int n, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, n, object));
    }

    public void fireProviderChange(String string, long l, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, l, object));
    }

    public void fireProviderChange(String string, Object object, Object object2) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, object, object2, System.currentTimeMillis()));
    }

    public void fireProviderChange(String string, short s, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, s, object));
    }

    public void fireProviderChange(String string, String string2, Object object, Object object2) {
        this.fireProviderChange(new ProviderChangeEvent(string, string2, object, object2, System.currentTimeMillis()));
    }

    public void fireProviderChange(String string, String string2, Object object, Object object2, long l) {
        this.fireProviderChange(new ProviderChangeEvent(string, string2, object, object2, l));
    }

    public void fireProviderChange(String string, String string2, String string3, String string4, Object object) {
        this.fireProviderChange(new ProviderChangeEvent(string, string2, string3, string4, object, System.currentTimeMillis()));
    }

    public void fireProviderChange(String string, String string2, String string3, String string4, Object object, long l) {
        this.fireProviderChange(new ProviderChangeEvent(string, string2, string3, string4, object, l));
    }

    public void fireProviderCreate(String string, byte by, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, by, object));
    }

    public void fireProviderCreate(String string, char c, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, c, object));
    }

    public void fireProviderCreate(String string, int n, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, n, object));
    }

    public void fireProviderCreate(String string, long l, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, l, object));
    }

    public void fireProviderCreate(String string, Object object, Object object2) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, object, object2, System.currentTimeMillis()));
    }

    public void fireProviderCreate(String string, short s, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("create", string, s, object));
    }

    public void fireProviderDelete(String string, byte by) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, by, (Object)null));
    }

    public void fireProviderDelete(String string, char c) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, c, (Object)null));
    }

    public void fireProviderDelete(String string, int n) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, n, (Object)null));
    }

    public void fireProviderDelete(String string, long l) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, l, (Object)null));
    }

    public void fireProviderDelete(String string, Object object) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, object, null));
    }

    public void fireProviderDelete(String string, short s) {
        this.fireProviderChange(new ProviderChangeEvent("remove", string, s, (Object)null));
    }

    public void fireProviderRefresh(String string) {
        this.fireProviderChange(new ProviderChangeEvent("update", string, (Object)null, (Object)null, System.currentTimeMillis()));
    }

    public synchronized ProviderChangeListener[] getProviderChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        return arrayList.toArray(new ProviderChangeListener[0]);
    }

    public boolean hasListeners() {
        return this.listeners != null && this.listeners.size() != 0;
    }

    public synchronized void removeProviderChangeListener(ProviderChangeListener providerChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(providerChangeListener);
    }
}

