/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.message;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import oracle.adfmf.framework.exception.MalformedMessageException;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.json.JSONString;

public class AdfType
extends JSONObject {
    protected JSONObject data = this;

    public AdfType() {
    }

    public AdfType(String string) throws JSONException {
        super(string);
    }

    public AdfType(Object object) {
        this.populateMap(object);
    }

    private void populateMap(Object object) {
        Class<?> clazz = object.getClass();
        boolean bl = clazz.getClassLoader() != null;
        Method[] methodArray = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String string = method.getName();
                String string2 = "";
                if (string.startsWith("get")) {
                    string2 = string.equals("getClass") || string.equals("getDeclaringClass") ? "" : string.substring(3);
                } else if (string.startsWith("is")) {
                    string2 = string.substring(2);
                }
                if (string2.length() <= 0 || !Character.isUpperCase(string2.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                }
                Object object2 = method.invoke(object, (Object[])null);
                if (object2 == null) continue;
                super.put(string2, AdfType.wrap(object2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object wrap(Object object) {
        try {
            String string;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Package package_ = object.getClass().getPackage();
            String string2 = string = package_ != null ? package_.getName() : "";
            if (string.startsWith("java.") || string.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JSONObject getJSONObject() {
        return this;
    }

    public Object get(String string) throws JSONException {
        try {
            return super.get(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public void setValue(String string, AdfType adfType) throws MalformedMessageException {
        try {
            super.put(string, adfType);
        }
        catch (JSONException jSONException) {
            throw new MalformedMessageException(jSONException);
        }
    }

    public void setValue(String string, Object object) throws MalformedMessageException {
        try {
            super.put(string, object);
        }
        catch (JSONException jSONException) {
            throw new MalformedMessageException(jSONException);
        }
    }
}

