/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.internal;

import com.sun.util.logging.Level;
import java.util.HashMap;
import oracle.adf.model.datacontrols.device.BaseProxy;
import oracle.adfmf.framework.PendingContainerRequest;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class AdfmfContainerUtilitiesInternal
extends BaseProxy {
    private static final long DEFAULT_ASYNC_JS_TIMEOUT = 60000L;
    private static HashMap s_pendingRequests = new HashMap();

    public static void invokeContainerUtilitiesMethodInBackground(String string, String string2, Object[] objectArray) throws AdfException {
        new Thread(new InvokeBackgroundRunnable(string, string2, objectArray)).start();
    }

    public static Object invokeContainerUtilitiesMethod(String string, String string2, Object[] objectArray) throws AdfException {
        AdfmfContainerUtilitiesInternal adfmfContainerUtilitiesInternal = new AdfmfContainerUtilitiesInternal();
        Object object = null;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, AdfmfContainerUtilitiesInternal.class, "invokeContainerUtilitiesMethod", (Object)("## Java: invokeContainerUtilitiesMethod " + string2 + " with " + (objectArray != null ? objectArray.length : 0) + " arguments.... started"));
        }
        try {
            object = adfmfContainerUtilitiesInternal.invokeContainerHandlerMethod(string, string2, objectArray);
        }
        catch (Throwable throwable) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfmfContainerUtilitiesInternal.class, "invokeContainerUtilitiesMethod", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11121", new Object[]{string2, throwable});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11121", new Object[]{string2, throwable});
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, AdfmfContainerUtilitiesInternal.class, "invokeContainerUtilitiesMethod", (Object)("## Java: invokeContainerUtilitiesMethod " + string2 + " with " + (objectArray != null ? objectArray.length : 0) + " arguments..... complete"));
        }
        return object;
    }

    private static void performAsyncContainerJavaScriptFunctionResponseSuccess(String string, Object object) {
        try {
            PendingContainerRequest pendingContainerRequest;
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseSuccess", (Object)"invoked");
            }
            if ((pendingContainerRequest = AdfmfContainerUtilitiesInternal.getPendingRequest(string)) == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseSuccess", (Object)"but could not find the pending request");
                }
                return;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseSuccess", "pending request - ID: {0}, Class: {1}, Args: {2}", new Object[]{pendingContainerRequest.getId(), pendingContainerRequest.getReturnClass().getName(), object});
            }
            if (object instanceof JSONObject || object instanceof JSONArray) {
                pendingContainerRequest.setData(JSONBeanSerializationHelper.fromJSON(pendingContainerRequest.getReturnClass(), object));
            } else {
                pendingContainerRequest.setData(object);
            }
            pendingContainerRequest.unblockThread();
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseSuccess", "complete - {0}", new Object[]{pendingContainerRequest.getData()});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void asyncContainerJavaScriptFunctionResponseSuccess(String string, JSONObject jSONObject) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseSuccess(string, jSONObject);
    }

    public static void asyncContainerJavaScriptFunctionResponseSuccess(String string, JSONArray jSONArray) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseSuccess(string, jSONArray);
    }

    public static void asyncContainerJavaScriptFunctionResponseSuccess(String string, String string2) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseSuccess(string, string2);
    }

    private static void performAsyncContainerJavaScriptFunctionResponseFailed(String string, Object object) {
        try {
            PendingContainerRequest pendingContainerRequest;
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseFailed", (Object)"invoked");
            }
            if ((pendingContainerRequest = AdfmfContainerUtilitiesInternal.getPendingRequest(string)) == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseFailed", (Object)"but could not find the pending request");
                }
                return;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseFailed", "pending request - {0}", new Object[]{pendingContainerRequest.getId()});
            }
            if (object instanceof JSONObject) {
                pendingContainerRequest.setData(JSONBeanSerializationHelper.fromJSON(pendingContainerRequest.getReturnClass(), object));
            } else if (object instanceof String) {
                pendingContainerRequest.setData(new AdfException((String)object, "ERROR"));
            } else if (object instanceof Integer) {
                pendingContainerRequest.setData(new AdfException("Error code: " + object, "ERROR"));
            }
            pendingContainerRequest.unblockThread();
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "asyncContainerJavaScriptFunctionResponseFailed", (Object)"complete");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void asyncContainerJavaScriptFunctionResponseFailed(String string, String string2) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseFailed(string, string2);
    }

    public static void asyncContainerJavaScriptFunctionResponseFailed(String string, int n) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseFailed(string, new Integer(n));
    }

    public static void asyncContainerJavaScriptFunctionResponseFailed(String string, JSONObject jSONObject) {
        AdfmfContainerUtilitiesInternal.performAsyncContainerJavaScriptFunctionResponseFailed(string, jSONObject);
    }

    public static Object invokeAsyncContainerJavaScriptFunction(String string, String string2, String string3, Object[] objectArray, Class clazz) throws AdfException {
        return AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction(string, string2, string3, objectArray, clazz, 60000L);
    }

    public static Object invokeAsyncContainerJavaScriptFunction(String string, String string2, String string3, Object[] objectArray, Class clazz, long l) throws AdfException {
        String string4 = AdfmfJavaUtilities.getFeatureName();
        if (!string.equals(string4) && !string.equals("_Back_Communication_Channel_") || !string2.equals(string4) && !string2.equals("_Back_Communication_Channel_")) {
            Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfmfContainerUtilities.class, "invokeAsyncContainerJavaScriptFunction", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11148", new Object[]{string, string2});
            throw new AdfException("Access violation", "ERROR");
        }
        PendingContainerRequest pendingContainerRequest = new PendingContainerRequest();
        Object[] objectArray2 = AdfmfContainerUtilitiesInternal.prepend(new Object[]{string, pendingContainerRequest.getId()}, objectArray);
        Object object = null;
        pendingContainerRequest.setReturnClass(clazz);
        AdfmfContainerUtilitiesInternal.addPendingRequest(pendingContainerRequest);
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "invokeAsyncContainerJavaScriptFunction", "Invoked for {0}, waiting max of {1} ms", new Object[]{string3, new Long(l)});
        }
        AdfmfContainerUtilities.invokeContainerJavaScriptFunction(string2, string3, objectArray2);
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "invokeAsyncContainerJavaScriptFunction", (Object)"is back");
        }
        pendingContainerRequest.blockThread(l);
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfmfContainerUtilities.class, "invokeAsyncContainerJavaScriptFunction", (Object)"has a response");
        }
        AdfmfContainerUtilitiesInternal.removePendingRequest(pendingContainerRequest);
        if (!pendingContainerRequest.isComplete() && pendingContainerRequest.getData() == null) {
            throw new AdfException("Request timed out", "ERROR");
        }
        if (pendingContainerRequest.getData() instanceof AdfException) {
            throw (AdfException)pendingContainerRequest.getData();
        }
        object = pendingContainerRequest.getData();
        pendingContainerRequest = null;
        return object;
    }

    private static Object[] prepend(Object[] objectArray, Object[] objectArray2) {
        int n;
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray3[n] = objectArray[n];
        }
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray3[objectArray.length + n] = objectArray2[n];
        }
        return objectArray3;
    }

    protected static synchronized void addPendingRequest(PendingContainerRequest pendingContainerRequest) {
        s_pendingRequests.put(pendingContainerRequest.getId(), pendingContainerRequest);
    }

    protected static synchronized PendingContainerRequest getPendingRequest(String string) {
        return (PendingContainerRequest)s_pendingRequests.get(string);
    }

    protected static synchronized void removePendingRequest(PendingContainerRequest pendingContainerRequest) {
        s_pendingRequests.remove(pendingContainerRequest.getId());
    }

    private static class InvokeBackgroundRunnable
    implements Runnable {
        private String className;
        private String utilMethodName;
        private Object[] args;

        private InvokeBackgroundRunnable(String string, String string2, Object[] objectArray) {
            this.className = string;
            this.utilMethodName = string2;
            this.args = objectArray;
        }

        public void run() {
            AdfmfContainerUtilitiesInternal.invokeContainerUtilitiesMethod(this.className, this.utilMethodName, this.args);
        }
    }
}

