/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.event;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.framework.event.DataChangeEvent;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.ProviderChangeEvent;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class DataChangeManager {
    private static final String PROCESS_DATA_CHANGE_EVENT_JAVASCRIPT_FUNCTION = "adf.mf.api.processDataChangeEvent";
    protected Map dces = new HashMap();

    public synchronized void enqueue(String string, ProviderChangeEvent providerChangeEvent) {
        this.getDataChangeEventInternal(string).enqueue(providerChangeEvent);
    }

    public synchronized void enqueue(String string, PropertyChangeEvent propertyChangeEvent) {
        this.getDataChangeEventInternal(string).enqueue(propertyChangeEvent);
    }

    public synchronized void enqueue(String string, Object object) {
        this.getDataChangeEventInternal(string).enqueue(object);
    }

    public synchronized boolean hasPendingEvents(String string) {
        return this.dces.containsKey(string) || this.dces.containsKey(EmbeddedFeatureContext.getInstance().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushDataChangeEvents() {
        if (AdfmfJavaUtilities.isBackgroundThread()) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, Model.class, "flushDataChangeEvent", (Object)"Flushing the data change events from the background thread ");
            }
            Iterator iterator = this.dces.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (!this.hasPendingEvents(string)) continue;
                try {
                    DataChangeEvent dataChangeEvent = this.getDataChangeEventInternal(string);
                    if (dataChangeEvent == null) continue;
                    DataChangeEvent dataChangeEvent2 = dataChangeEvent;
                    synchronized (dataChangeEvent2) {
                        block13: {
                            Object object = JSONBeanSerializationHelper.toJSON(dataChangeEvent);
                            try {
                                AdfmfContainerUtilities.invokeContainerJavaScriptFunction(AdfmfJavaUtilities.getFeatureName(), PROCESS_DATA_CHANGE_EVENT_JAVASCRIPT_FUNCTION, new Object[]{object});
                                iterator.remove();
                            }
                            catch (AdfException adfException) {
                                if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) break block13;
                                Trace.log(Utility.FrameworkLogger, Level.SEVERE, class$oracle$adfmf$framework$api$Model == null ? DataChangeManager.class$("oracle.adfmf.framework.api.Model") : class$oracle$adfmf$framework$api$Model, "flushDataChangeEvent", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11124", new Object[]{PROCESS_DATA_CHANGE_EVENT_JAVASCRIPT_FUNCTION});
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, Model.class, "flushDataChangeEvent", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11125");
                    }
                    throw new AdfException(exception);
                }
            }
        } else if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, DataChangeManager.class, "flushDataChangeEvent", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40126");
        }
    }

    public synchronized void clearDataChangeEvents(String string) {
        this.dces.remove(string);
    }

    public synchronized void clearDataChangeEvents() {
        this.dces.clear();
    }

    private DataChangeEvent getDataChangeEventInternal(String string) {
        DataChangeEvent dataChangeEvent = null;
        if (this.dces.containsKey(string)) {
            dataChangeEvent = (DataChangeEvent)this.dces.get(string);
        } else {
            dataChangeEvent = new DataChangeEvent();
            this.dces.put(string, dataChangeEvent);
        }
        return dataChangeEvent;
    }

    public synchronized DataChangeEvent getDataChangeEvent(String string) {
        String string2 = EmbeddedFeatureContext.getInstance().getName();
        DataChangeEvent dataChangeEvent = this.getDataChangeEventInternal(string);
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            Trace.log(Utility.FrameworkLogger, Level.FINER, this.getClass(), "getDataChangeEvent", (Object)("DCE for contextId=" + string + " has " + (dataChangeEvent != null ? dataChangeEvent.getPropertyChangeCount() : 0) + " properties changes."));
        }
        if (this.hasPendingEvents(string2)) {
            DataChangeEvent dataChangeEvent2 = this.getDataChangeEventInternal(EmbeddedFeatureContext.getInstance().getName());
            if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                Trace.log(Utility.FrameworkLogger, Level.FINER, this.getClass(), "getDataChangeEvent", (Object)("DCE for featureId=" + string2 + " has " + (dataChangeEvent2 != null ? dataChangeEvent2.getPropertyChangeCount() : 0) + " properties changes."));
            }
            dataChangeEvent.merge(dataChangeEvent2);
            this.clearDataChangeEvents(string2);
        }
        return dataChangeEvent;
    }
}

