/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.contract.adf;

import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.PostJSONDeserializable;
import oracle.adfmf.framework.api.PostJSONSerializable;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.MalformedMessageException;
import oracle.adfmf.framework.message.AdfType;
import oracle.adfmf.json.JSONException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;

public class NameValuePair
extends AdfType
implements PostJSONSerializable,
PostJSONDeserializable {
    public NameValuePair() {
    }

    public NameValuePair(Object object) {
        super(object);
    }

    public void clearException() throws MalformedMessageException {
        this.setNullValue();
    }

    public String getName() throws MalformedMessageException {
        String string;
        try {
            string = (String)super.get("name");
        }
        catch (Exception exception) {
            throw new MalformedMessageException(exception);
        }
        return string;
    }

    public Object getValue() throws MalformedMessageException {
        Object object;
        try {
            object = super.get("value");
        }
        catch (Exception exception) {
            throw new MalformedMessageException(exception);
        }
        return object;
    }

    public boolean isException() {
        try {
            return this.has(".exception") && (Boolean)this.get(".exception") != false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public boolean isTransient() {
        try {
            return this.has(".transient") && (Boolean)this.get(".transient") != false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public boolean isValueReference() {
        try {
            return this.has(".valueref") && (Boolean)this.get(".valueref") != false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public void setName(String string) throws MalformedMessageException {
        super.setValue("name", string);
    }

    public void setValue(Object object) throws MalformedMessageException {
        if (this.has(".exception")) {
            this.remove(".exception");
        }
        super.setValue("value", object);
    }

    public void setException(AdfException adfException) throws MalformedMessageException {
        super.setValue(".exception", Boolean.TRUE);
        Object object = null;
        try {
            object = JSONBeanSerializationHelper.toJSON(adfException);
        }
        catch (Exception exception) {
            throw new MalformedMessageException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10047"));
        }
        super.setValue("value", object);
    }

    public Exception getException() throws Exception {
        JSONObject jSONObject;
        Exception exception = null;
        if (this.isException() && null != (jSONObject = (JSONObject)this.getValue())) {
            exception = (Exception)JSONBeanSerializationHelper.fromJSON(Object.class, jSONObject);
        }
        return exception;
    }

    public void setNullValue() throws MalformedMessageException {
        try {
            this.remove(".exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.setValue(".null", Boolean.TRUE);
        super.setValue("value", JSONObject.NULL);
    }

    public void setTransient(boolean bl) {
        if (bl) {
            super.setValue(".transient", Boolean.TRUE);
        } else {
            try {
                this.remove(".transient");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setValueReference(boolean bl) {
        if (bl) {
            super.setValue(".valueref", Boolean.TRUE);
        } else {
            try {
                this.remove(".valueref");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public JSONObject modifyJSON(JSONObject jSONObject) {
        if (this.isException()) {
            try {
                jSONObject.remove("exception");
                jSONObject.put(".exception", Boolean.TRUE);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                jSONObject.remove("exception");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isTransient()) {
            try {
                jSONObject.remove("transient");
                jSONObject.put(".transient", Boolean.TRUE);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                jSONObject.remove("transient");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isValueReference()) {
            try {
                jSONObject.remove("valueReference");
                jSONObject.put(".valueref", Boolean.TRUE);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                jSONObject.remove("valueReference");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return jSONObject;
    }

    public Object modifyObject(JSONObject jSONObject) throws Exception {
        this.setValueReference(jSONObject.optBoolean(".valueref", false));
        return this;
    }
}

