/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.contract.adf;

import oracle.adfmf.framework.contract.adf.application.GenericInvokeRequest;
import oracle.adfmf.framework.contract.adf.application.GenericInvokeRequestHandlerFactory;
import oracle.adfmf.framework.contract.adf.application.GenericInvokeResponse;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.UnhandledAdfMessageException;
import oracle.adfmf.framework.exception.UnknownAdfMessageException;
import oracle.adfmf.framework.message.adf.AdfHeader;
import oracle.adfmf.framework.message.adf.AdfMessage;
import oracle.adfmf.framework.message.adf.AdfRequest;
import oracle.adfmf.framework.message.adf.AdfRequestHandler;
import oracle.adfmf.framework.message.adf.AdfResponse;

public class AdfMessageHandlerFactory {
    private static final long serialVersionUID = 131016838340400L;

    public static AdfMessage getAdfMessage(String string) throws AdfException {
        AdfHeader adfHeader = AdfHeader.parse(string);
        if (adfHeader.isAdfRequestMessage()) {
            switch (adfHeader.getType()) {
                case 10000: {
                    return new GenericInvokeRequest(string);
                }
            }
            throw new UnknownAdfMessageException(adfHeader.getReferenceId(), adfHeader.getType());
        }
        switch (adfHeader.getType()) {
            case 10000: {
                return new GenericInvokeResponse(string);
            }
        }
        throw new UnknownAdfMessageException(adfHeader.getReferenceId(), adfHeader.getType());
    }

    public static AdfRequestHandler getAdfRequestHandler(AdfRequest adfRequest, Class clazz) throws AdfException {
        AdfHeader adfHeader = adfRequest.getHeader();
        switch (adfHeader.getType()) {
            case 10000: {
                return GenericInvokeRequestHandlerFactory.createHandler((GenericInvokeRequest)adfRequest, clazz);
            }
        }
        throw new UnhandledAdfMessageException(adfHeader.getReferenceId(), adfHeader.getType());
    }

    public static AdfResponse getErrorResponse(AdfRequest adfRequest, AdfException adfException) {
        AdfResponse adfResponse = adfRequest.createResponse();
        adfResponse.setException(adfException);
        return adfResponse;
    }
}

